-- MySQL dump 10.13  Distrib 5.7.25, for Linux (x86_64)
--
-- Host: localhost    Database: cartonmi_seagull2
-- ------------------------------------------------------
-- Server version	5.7.25

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `web_article`
--

DROP TABLE IF EXISTS `web_article`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_article` (
  `article_id` int(11) NOT NULL,
  `article_type_id` int(2) NOT NULL,
  `date_start` int(11) NOT NULL,
  `date_end` int(11) NOT NULL,
  `article_icon` varchar(255) NOT NULL,
  `skip_default_lang` smallint(1) NOT NULL,
  `publish` smallint(1) NOT NULL,
  `never_expired` smallint(1) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`article_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_article`
--

LOCK TABLES `web_article` WRITE;
/*!40000 ALTER TABLE `web_article` DISABLE KEYS */;
/*!40000 ALTER TABLE `web_article` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_article_images`
--

DROP TABLE IF EXISTS `web_article_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_article_images` (
  `image_id` int(11) NOT NULL,
  `article_id` int(11) NOT NULL,
  `image_name` varchar(255) NOT NULL,
  `image_path` varchar(255) NOT NULL,
  `oldfilename` varchar(255) NOT NULL,
  PRIMARY KEY (`image_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_article_images`
--

LOCK TABLES `web_article_images` WRITE;
/*!40000 ALTER TABLE `web_article_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `web_article_images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_article_message`
--

DROP TABLE IF EXISTS `web_article_message`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_article_message` (
  `article_message_id` int(11) NOT NULL,
  `web_lang_id` int(2) NOT NULL,
  `article_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `message` mediumtext NOT NULL,
  `extra_field1` varchar(255) DEFAULT NULL,
  `extra_field2` varchar(255) DEFAULT NULL,
  `extra_field3` varchar(255) DEFAULT NULL,
  `extra_field4` varchar(255) DEFAULT NULL,
  `extra_field5` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`article_message_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_article_message`
--

LOCK TABLES `web_article_message` WRITE;
/*!40000 ALTER TABLE `web_article_message` DISABLE KEYS */;
/*!40000 ALTER TABLE `web_article_message` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_article_role`
--

DROP TABLE IF EXISTS `web_article_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_article_role` (
  `article_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_article_role`
--

LOCK TABLES `web_article_role` WRITE;
/*!40000 ALTER TABLE `web_article_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `web_article_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_article_type`
--

DROP TABLE IF EXISTS `web_article_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_article_type` (
  `article_type_id` int(2) NOT NULL,
  `type_icon` varchar(255) NOT NULL,
  PRIMARY KEY (`article_type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_article_type`
--

LOCK TABLES `web_article_type` WRITE;
/*!40000 ALTER TABLE `web_article_type` DISABLE KEYS */;
INSERT INTO `web_article_type` (`article_type_id`, `type_icon`) VALUES (2,''),(1,'');
/*!40000 ALTER TABLE `web_article_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_article_type_message`
--

DROP TABLE IF EXISTS `web_article_type_message`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_article_type_message` (
  `article_type_message_id` int(11) NOT NULL,
  `article_type_id` int(2) NOT NULL,
  `web_lang_id` int(2) NOT NULL,
  `type_name` varchar(128) NOT NULL,
  `description` varchar(255) NOT NULL,
  PRIMARY KEY (`article_type_message_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_article_type_message`
--

LOCK TABLES `web_article_type_message` WRITE;
/*!40000 ALTER TABLE `web_article_type_message` DISABLE KEYS */;
INSERT INTO `web_article_type_message` (`article_type_message_id`, `article_type_id`, `web_lang_id`, `type_name`, `description`) VALUES (2,2,1,'NewsAndEvent',''),(1,1,1,'Tips','');
/*!40000 ALTER TABLE `web_article_type_message` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_article_type_role`
--

DROP TABLE IF EXISTS `web_article_type_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_article_type_role` (
  `article_type_id` int(2) NOT NULL,
  `role_id` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_article_type_role`
--

LOCK TABLES `web_article_type_role` WRITE;
/*!40000 ALTER TABLE `web_article_type_role` DISABLE KEYS */;
INSERT INTO `web_article_type_role` (`article_type_id`, `role_id`) VALUES (2,0),(2,1),(2,2),(1,0),(1,1),(1,2);
/*!40000 ALTER TABLE `web_article_type_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_block`
--

DROP TABLE IF EXISTS `web_block`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_block` (
  `block_id` int(11) NOT NULL,
  `name` varchar(64) DEFAULT NULL,
  `title` varchar(32) DEFAULT NULL,
  `title_class` varchar(32) DEFAULT NULL,
  `body_class` varchar(32) DEFAULT NULL,
  `blk_order` smallint(6) DEFAULT NULL,
  `position` varchar(16) DEFAULT NULL,
  `is_enabled` smallint(6) DEFAULT NULL,
  `is_cached` smallint(6) DEFAULT NULL,
  `params` longtext,
  PRIMARY KEY (`block_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_block`
--

LOCK TABLES `web_block` WRITE;
/*!40000 ALTER TABLE `web_block` DISABLE KEYS */;
INSERT INTO `web_block` (`block_id`, `name`, `title`, `title_class`, `body_class`, `blk_order`, `position`, `is_enabled`, `is_cached`, `params`) VALUES (1,'Navigation_Block_Navigation','Admin menu','','',1,'AdminNav',1,0,'a:9:{s:15:\"startParentNode\";s:1:\"4\";s:10:\"startLevel\";s:1:\"0\";s:14:\"levelsToRender\";s:1:\"0\";s:9:\"collapsed\";s:1:\"1\";s:10:\"showAlways\";s:1:\"1\";s:12:\"cacheEnabled\";s:1:\"1\";s:11:\"breadcrumbs\";s:1:\"0\";s:8:\"renderer\";s:14:\"SimpleRenderer\";s:8:\"template\";s:0:\"\";}'),(2,'Navigation_Block_Navigation','User menu','','',1,'MainNav',1,0,'a:9:{s:15:\"startParentNode\";s:1:\"2\";s:10:\"startLevel\";s:1:\"0\";s:14:\"levelsToRender\";s:1:\"0\";s:9:\"collapsed\";s:1:\"1\";s:10:\"showAlways\";s:1:\"1\";s:12:\"cacheEnabled\";s:1:\"1\";s:11:\"breadcrumbs\";s:1:\"0\";s:8:\"renderer\";s:14:\"SimpleRenderer\";s:8:\"template\";s:0:\"\";}');
/*!40000 ALTER TABLE `web_block` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_block_assignment`
--

DROP TABLE IF EXISTS `web_block_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_block_assignment` (
  `block_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  PRIMARY KEY (`block_id`,`section_id`),
  KEY `web_block_assignment_fk` (`block_id`),
  KEY `web_block_assignment_fk2` (`section_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_block_assignment`
--

LOCK TABLES `web_block_assignment` WRITE;
/*!40000 ALTER TABLE `web_block_assignment` DISABLE KEYS */;
INSERT INTO `web_block_assignment` (`block_id`, `section_id`) VALUES (1,0),(2,0);
/*!40000 ALTER TABLE `web_block_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_block_role`
--

DROP TABLE IF EXISTS `web_block_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_block_role` (
  `block_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_block_role`
--

LOCK TABLES `web_block_role` WRITE;
/*!40000 ALTER TABLE `web_block_role` DISABLE KEYS */;
INSERT INTO `web_block_role` (`block_id`, `role_id`) VALUES (1,1),(2,-2);
/*!40000 ALTER TABLE `web_block_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_example`
--

DROP TABLE IF EXISTS `web_example`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_example` (
  `usr_id` int(2) NOT NULL,
  `name` varchar(20) NOT NULL,
  `email` varchar(50) NOT NULL,
  PRIMARY KEY (`usr_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_example`
--

LOCK TABLES `web_example` WRITE;
/*!40000 ALTER TABLE `web_example` DISABLE KEYS */;
/*!40000 ALTER TABLE `web_example` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_formmail_log`
--

DROP TABLE IF EXISTS `web_formmail_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_formmail_log` (
  `mail_id` int(11) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `message` mediumtext NOT NULL,
  `date` int(11) NOT NULL,
  PRIMARY KEY (`mail_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_formmail_log`
--

LOCK TABLES `web_formmail_log` WRITE;
/*!40000 ALTER TABLE `web_formmail_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `web_formmail_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_log_table`
--

DROP TABLE IF EXISTS `web_log_table`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_log_table` (
  `id` int(11) NOT NULL,
  `logtime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ident` char(16) NOT NULL,
  `priority` int(11) NOT NULL,
  `message` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_log_table`
--

LOCK TABLES `web_log_table` WRITE;
/*!40000 ALTER TABLE `web_log_table` DISABLE KEYS */;
/*!40000 ALTER TABLE `web_log_table` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_login`
--

DROP TABLE IF EXISTS `web_login`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_login` (
  `login_id` int(11) NOT NULL,
  `usr_id` int(11) DEFAULT NULL,
  `date_time` datetime DEFAULT NULL,
  `remote_ip` varchar(16) DEFAULT NULL,
  PRIMARY KEY (`login_id`),
  KEY `web_usr_login_fk` (`usr_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_login`
--

LOCK TABLES `web_login` WRITE;
/*!40000 ALTER TABLE `web_login` DISABLE KEYS */;
INSERT INTO `web_login` (`login_id`, `usr_id`, `date_time`, `remote_ip`) VALUES (1,1,'2017-07-19 09:04:54','203.78.98.10'),(2,1,'2017-07-19 09:07:21','203.78.98.10'),(3,1,'2017-07-19 09:08:57','203.78.98.10'),(4,1,'2017-07-19 09:13:08','203.78.98.10'),(5,1,'2017-07-19 09:14:47','203.78.98.10'),(6,1,'2017-07-19 09:15:33','203.78.98.10'),(7,1,'2017-07-19 09:21:01','203.78.98.10'),(8,1,'2017-07-19 09:22:21','203.78.98.10'),(9,1,'2017-07-19 09:29:26','203.78.98.10'),(10,1,'2017-07-19 09:29:38','203.78.98.10'),(11,1,'2017-07-19 09:40:17','203.78.98.10'),(12,1,'2017-07-19 09:41:29','203.78.98.10'),(13,1,'2017-07-19 09:41:58','203.78.98.10'),(14,1,'2017-07-19 09:55:58','182.232.104.122'),(15,1,'2017-07-19 10:08:17','203.78.98.10'),(16,1,'2017-07-19 10:08:20','203.78.98.10'),(17,1,'2017-07-19 10:08:47','203.78.98.10'),(18,1,'2017-07-19 10:08:54','203.78.98.10'),(19,1,'2017-07-19 10:09:27','203.78.98.10'),(20,1,'2017-07-19 10:10:17','203.78.98.10'),(21,1,'2017-07-19 10:10:47','203.78.98.10'),(22,1,'2017-07-19 10:15:26','1.46.171.207'),(23,1,'2017-07-19 10:16:16','1.46.171.207'),(24,1,'2017-07-19 10:16:27','203.78.98.10'),(25,1,'2017-07-19 10:22:18','1.46.171.207'),(26,1,'2017-07-19 10:22:34','203.78.98.10'),(27,1,'2017-07-19 10:23:12','203.78.98.10'),(28,1,'2017-07-19 10:26:33','203.78.98.10'),(29,1,'2017-07-19 10:26:53','203.78.98.10'),(30,1,'2017-07-20 09:34:26','183.89.45.106'),(31,1,'2017-07-20 09:51:38','203.78.98.10'),(32,1,'2017-07-20 09:51:46','1.47.68.251'),(33,1,'2017-07-20 09:51:53','203.78.98.10'),(34,1,'2017-07-20 09:51:53','1.47.68.251'),(35,1,'2017-07-20 09:52:13','203.78.98.10'),(36,1,'2017-07-24 01:06:27','183.89.45.244'),(37,1,'2017-07-24 02:36:38','203.78.98.10'),(38,1,'2017-07-24 02:37:04','203.78.98.10'),(39,1,'2017-07-24 02:37:18','203.78.98.10'),(40,1,'2017-07-24 02:37:48','203.78.98.10'),(41,1,'2017-07-24 03:41:46','203.78.98.10'),(42,1,'2017-07-24 03:41:58','203.78.98.10'),(43,1,'2017-07-24 03:42:28','203.78.98.10'),(44,1,'2017-07-24 03:42:49','183.89.45.244'),(45,1,'2017-07-24 03:43:13','203.78.98.10'),(46,2,'2017-07-24 03:57:46','183.89.45.244'),(47,2,'2017-07-24 03:59:23','183.89.45.244');
/*!40000 ALTER TABLE `web_login` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_module`
--

DROP TABLE IF EXISTS `web_module`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_module` (
  `module_id` int(11) NOT NULL DEFAULT '0',
  `is_configurable` smallint(1) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `admin_uri` varchar(255) DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `maintainers` text,
  `version` varchar(8) DEFAULT NULL,
  `license` varchar(16) DEFAULT NULL,
  `state` varchar(8) DEFAULT NULL,
  PRIMARY KEY (`module_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_module`
--

LOCK TABLES `web_module` WRITE;
/*!40000 ALTER TABLE `web_module` DISABLE KEYS */;
INSERT INTO `web_module` (`module_id`, `is_configurable`, `name`, `title`, `description`, `admin_uri`, `icon`, `maintainers`, `version`, `license`, `state`) VALUES (1,1,'block','Blocks','Use the \'Blocks\' module to configure the contents of the blocks in the left and right hand columns, or anywhere in a page.','block/block','48/module_block.png','Andrey Podshivalov',NULL,'BSD','stable'),(2,1,'default','Default','The \'Default\' module includes functionality that is needed in every install, for example, configuration and interface language manangement, and module management.','default/maintenance','48/module_default.png','Demian Turner',NULL,'BSD','stable'),(3,1,'user','Users and Security','The \'Users and Security\' module allows you to manage all your users, administer the roles they belong to, change their passwords, setup permissions and alter the global default preferences.','user/user','48/module_user.png','Demian Turner',NULL,'BSD','stable'),(4,1,'navigation','Navigation','The \'Navigation\' module is what you use to build your site navigation, it creates menus that you can customise in terms of look and feel, and allows you to link to any site resource.','navigation/page','navigation.png','Andrey Podshivalov',NULL,'BSD','beta'),(5,1,'main','Main','Main Module','','48/module_default.png','RV Global Soft Teams','20070816','RV Global Soft','Stable'),(6,1,'articleweb','Article','Generated by ModuleGenerationMgr','','48/module_default.png','Alouicious Bird',NULL,'NULL','NULL'),(7,1,'newsevent','News and Event','News and Event Module for Carton Web','','48/module_default.png','RV Global Soft Teams','20081001','RV Global Soft','Stable'),(8,1,'tips','Tips','Tips Module for Carton Web','','48/module_default.png','RV Global Soft Teams','20081001','RV Global Soft','Stable'),(9,1,'stereomicroscope','StereoMicroscope','Generated by ModuleGenerationMgr','','48/module_default.png','Alouicious Bird',NULL,'NULL','NULL'),(10,1,'productweb','Product','Generated by ModuleGenerationMgr','','48/module_default.png','Alouicious Bird',NULL,'NULL','NULL');
/*!40000 ALTER TABLE `web_module` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_org_preference`
--

DROP TABLE IF EXISTS `web_org_preference`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_org_preference` (
  `org_preference_id` int(11) NOT NULL DEFAULT '0',
  `organisation_id` int(11) NOT NULL DEFAULT '0',
  `preference_id` int(11) NOT NULL DEFAULT '0',
  `value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`org_preference_id`),
  KEY `web_organisation_org_preference_fk` (`organisation_id`),
  KEY `web_preference_org_preference_fk` (`preference_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_org_preference`
--

LOCK TABLES `web_org_preference` WRITE;
/*!40000 ALTER TABLE `web_org_preference` DISABLE KEYS */;
/*!40000 ALTER TABLE `web_org_preference` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_organisation`
--

DROP TABLE IF EXISTS `web_organisation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_organisation` (
  `organisation_id` int(11) NOT NULL DEFAULT '0',
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `root_id` int(11) NOT NULL DEFAULT '0',
  `left_id` int(11) NOT NULL DEFAULT '0',
  `right_id` int(11) NOT NULL DEFAULT '0',
  `order_id` int(11) NOT NULL DEFAULT '0',
  `level_id` int(11) NOT NULL DEFAULT '0',
  `role_id` int(11) NOT NULL DEFAULT '0',
  `organisation_type_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(128) DEFAULT NULL,
  `description` text,
  `addr_1` varchar(128) NOT NULL DEFAULT '',
  `addr_2` varchar(128) DEFAULT NULL,
  `addr_3` varchar(128) DEFAULT NULL,
  `city` varchar(32) NOT NULL DEFAULT '',
  `region` varchar(32) DEFAULT NULL,
  `country` char(2) DEFAULT NULL,
  `post_code` varchar(16) DEFAULT NULL,
  `telephone` varchar(32) DEFAULT NULL,
  `website` varchar(128) DEFAULT NULL,
  `email` varchar(128) DEFAULT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `last_updated` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`organisation_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_organisation`
--

LOCK TABLES `web_organisation` WRITE;
/*!40000 ALTER TABLE `web_organisation` DISABLE KEYS */;
/*!40000 ALTER TABLE `web_organisation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_organisation_type`
--

DROP TABLE IF EXISTS `web_organisation_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_organisation_type` (
  `organisation_type_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`organisation_type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_organisation_type`
--

LOCK TABLES `web_organisation_type` WRITE;
/*!40000 ALTER TABLE `web_organisation_type` DISABLE KEYS */;
/*!40000 ALTER TABLE `web_organisation_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_permission`
--

DROP TABLE IF EXISTS `web_permission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_permission` (
  `permission_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) DEFAULT NULL,
  `description` text,
  `module_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_permission`
--

LOCK TABLES `web_permission` WRITE;
/*!40000 ALTER TABLE `web_permission` DISABLE KEYS */;
INSERT INTO `web_permission` (`permission_id`, `name`, `description`, `module_id`) VALUES (1,'blockmgr','Permission to use block manager',1),(2,'blockmgr_cmd_add','Permission to add new block',1),(3,'blockmgr_cmd_edit','Permission to edit existing block',1),(4,'blockmgr_cmd_delete','Permission to remove block',1),(5,'blockmgr_cmd_reorder','Permission to reorder blocks',1),(6,'blockmgr_cmd_list','Permission to view block listing',1),(7,'blockmgr_cmd_insert','Permission to view block listing',1),(8,'blockmgr_cmd_update','Permission to view block listing',1),(9,'modulemgr','',2),(10,'modulemgr_cmd_add','',2),(11,'modulemgr_cmd_insert','',2),(12,'modulemgr_cmd_delete','',2),(13,'modulemgr_cmd_list','',2),(14,'modulemgr_cmd_overview','',2),(15,'modulemgr_cmd_edit','',2),(16,'modulemgr_cmd_update','',2),(17,'configmgr','',2),(18,'configmgr_cmd_edit','Permission to view and edit config settings',2),(19,'configmgr_cmd_update','Permission to update config values',2),(20,'defaultmgr','',2),(21,'defaultmgr_cmd_list','',2),(22,'bugmgr','',2),(23,'bugmgr_cmd_list',NULL,2),(24,'bugmgr_cmd_send',NULL,2),(25,'maintenancemgr_cmd_edit','',2),(26,'maintenancemgr_cmd_update','',2),(27,'maintenancemgr_cmd_append','',2),(28,'maintenancemgr_cmd_dbgen','',2),(29,'maintenancemgr_cmd_clearCache','',2),(30,'maintenancemgr_cmd_list','',2),(31,'maintenancemgr','',2),(32,'maintenancemgr_cmd_verify','',2),(33,'maintenancemgr_cmd_checkAllModules','',2),(34,'maintenancemgr_cmd_rebuildSequences','',2),(35,'maintenancemgr_cmd_createModule','',2),(36,'maintenancemgr_cmd_checkLatestVersion','',2),(37,'pearmgr','',2),(38,'pearmgr_cmd_list','',2),(39,'pearmgr_cmd_doRequest','',2),(40,'rolemgr_cmd_duplicate','',3),(41,'activateemailmgr_cmd_view','',3),(42,'activateemailmgr_cmd_activate','',3),(43,'accountmgr_cmd_edit','',3),(44,'accountmgr_cmd_update','',3),(45,'accountmgr_cmd_viewProfile','',3),(46,'accountmgr_cmd_summary','',3),(47,'loginmgr_cmd_login','',3),(48,'loginmgr_cmd_list','',3),(49,'orgmgr_cmd_add','',3),(50,'orgmgr_cmd_insert','',3),(51,'orgmgr_cmd_edit','',3),(52,'orgmgr_cmd_update','',3),(53,'orgmgr_cmd_delete','',3),(54,'orgmgr_cmd_list','',3),(55,'passwordmgr_cmd_retrieve','',3),(56,'passwordmgr_cmd_forgot','',3),(57,'userpasswordmgr','',3),(58,'userpasswordmgr_cmd_edit','',3),(59,'userpasswordmgr_cmd_update','',3),(60,'permissionmgr_cmd_add','',3),(61,'permissionmgr_cmd_insert','',3),(62,'permissionmgr_cmd_edit','',3),(63,'permissionmgr_cmd_update','',3),(64,'permissionmgr_cmd_delete','',3),(65,'permissionmgr_cmd_list','',3),(66,'preferencemgr_cmd_add','',3),(67,'preferencemgr_cmd_insert','',3),(68,'preferencemgr_cmd_edit','',3),(69,'preferencemgr_cmd_update','',3),(70,'preferencemgr_cmd_delete','',3),(71,'preferencemgr_cmd_list','',3),(72,'profilemgr_cmd_view','',3),(73,'registermgr_cmd_add','',3),(74,'registermgr_cmd_insert','',3),(75,'rolemgr_cmd_add','',3),(76,'rolemgr_cmd_insert','',3),(77,'rolemgr_cmd_edit','',3),(78,'rolemgr_cmd_update','',3),(79,'rolemgr_cmd_delete','',3),(80,'rolemgr_cmd_list','',3),(81,'rolemgr_cmd_editPerms','',3),(82,'rolemgr_cmd_updatePerms','',3),(83,'usermgr_cmd_add','',3),(84,'usermgr_cmd_insert','',3),(85,'usermgr_cmd_edit','',3),(86,'usermgr_cmd_update','',3),(87,'usermgr_cmd_delete','',3),(88,'usermgr_cmd_list','',3),(89,'usermgr_cmd_requestPasswordReset','',3),(90,'usermgr_cmd_resetPassword','',3),(91,'usermgr_cmd_editPerms','',3),(92,'usermgr_cmd_updatePerms','',3),(93,'userpreferencemgr_cmd_editAll','',3),(94,'userpreferencemgr_cmd_updateAll','',3),(95,'accountmgr','',3),(96,'loginmgr','',3),(97,'loginmgr_cmd_logout','',3),(98,'orgmgr','',3),(99,'orgpreferencemgr','',3),(100,'orgpreferencemgr_cmd_editAll','',3),(101,'orgpreferencemgr_cmd_updateAll','',3),(102,'passwordmgr','',3),(103,'permissionmgr','',3),(104,'permissionmgr_cmd_scanNew','',3),(105,'permissionmgr_cmd_insertNew','',3),(106,'permissionmgr_cmd_scanOrphaned','',3),(107,'permissionmgr_cmd_deleteOrphaned','',3),(108,'preferencemgr','',3),(109,'profilemgr','',3),(110,'registermgr','',3),(111,'rolemgr','',3),(112,'userimportmgr','',3),(113,'userimportmgr_cmd_list','',3),(114,'userimportmgr_cmd_insertImportedUsers','',3),(115,'usermgr','',3),(116,'usermgr_cmd_syncToRole','',3),(117,'userpreferencemgr','',3),(118,'orgtypemgr',NULL,3),(119,'orgtypemgr_cmd_add',NULL,3),(120,'orgtypemgr_cmd_insert',NULL,3),(121,'orgtypemgr_cmd_edit',NULL,3),(122,'orgtypemgr_cmd_update',NULL,3),(123,'orgtypemgr_cmd_delete',NULL,3),(124,'orgtypemgr_cmd_list',NULL,3),(125,'usermgr_cmd_requestChangeUserStatus',NULL,3),(126,'usermgr_cmd_changeUserStatus',NULL,3),(127,'usermgr_cmd_viewLogin',NULL,3),(128,'usermgr_cmd_truncateLoginTbl',NULL,3),(129,'usersearchmgr',NULL,3),(130,'usersearchmgr_cmd_add',NULL,3),(131,'usersearchmgr_cmd_search',NULL,3),(132,'navstylemgr','',4),(133,'navstylemgr_cmd_changeStyle','',4),(134,'navstylemgr_cmd_list','',4),(135,'sectionmgr','',4),(136,'sectionmgr_cmd_add','',4),(137,'sectionmgr_cmd_insert','',4),(138,'sectionmgr_cmd_edit','',4),(139,'sectionmgr_cmd_update','',4),(140,'sectionmgr_cmd_delete','',4),(141,'sectionmgr_cmd_reorder','',4),(142,'sectionmgr_cmd_list','',4),(143,'adminarticlewebmgr','',6),(144,'adminarticlewebmgr_cmd_view','',6),(145,'adminarticlewebmgr_cmd_addview','',6),(146,'adminarticlewebmgr_cmd_add','',6),(147,'adminarticlewebmgr_cmd_editview','',6),(148,'adminarticlewebmgr_cmd_edit','',6),(149,'adminarticlewebmgr_cmd_delete','',6),(150,'adminarticletypewebmgr','',6),(151,'adminarticletypewebmgr_cmd_view','',6),(152,'adminarticletypewebmgr_cmd_addview','',6),(153,'adminarticletypewebmgr_cmd_add','',6),(154,'adminarticletypewebmgr_cmd_editview','',6),(155,'adminarticletypewebmgr_cmd_edit','',6),(156,'adminarticletypewebmgr_cmd_delete','',6),(157,'articleviewwebmgr','',6),(158,'articleviewwebmgr_cmd_viewarticle','',6),(159,'articleviewwebmgr_cmd_viewarticletype','',6),(160,'articleviewwebmgr_cmd_viewarticlealltype','',6),(161,'adminnewseventmgr','',7),(162,'adminnewseventmgr_cmd_view','',7),(163,'adminnewseventmgr_cmd_addview','',7),(164,'adminnewseventmgr_cmd_add','',7),(165,'adminnewseventmgr_cmd_editview','',7),(166,'adminnewseventmgr_cmd_edit','',7),(167,'adminnewseventmgr_cmd_delete','',7),(168,'adminnewseventtypemgr','',7),(169,'adminnewseventtypemgr_cmd_view','',7),(170,'adminnewseventtypemgr_cmd_addview','',7),(171,'adminnewseventtypemgr_cmd_add','',7),(172,'adminnewseventtypemgr_cmd_editview','',7),(173,'adminnewseventtypemgr_cmd_edit','',7),(174,'adminnewseventtypemgr_cmd_delete','',7),(175,'newseventviewmgr','',7),(176,'newseventviewmgr_cmd_viewarticle','',7),(177,'newseventviewmgr_cmd_viewarticletype','',7),(178,'newseventviewmgr_cmd_viewarticlealltype','',7),(179,'admintipsmgr','',8),(180,'admintipsmgr_cmd_view','',8),(181,'admintipsmgr_cmd_addview','',8),(182,'admintipsmgr_cmd_add','',8),(183,'admintipsmgr_cmd_editview','',8),(184,'admintipsmgr_cmd_edit','',8),(185,'admintipsmgr_cmd_delete','',8),(186,'admintipstypemgr','',8),(187,'admintipstypemgr_cmd_view','',8),(188,'admintipstypemgr_cmd_addview','',8),(189,'admintipstypemgr_cmd_add','',8),(190,'admintipstypemgr_cmd_editview','',8),(191,'admintipstypemgr_cmd_edit','',8),(192,'admintipstypemgr_cmd_delete','',8),(193,'tipsviewmgr','',8),(194,'tipsviewmgr_cmd_viewarticle','',8),(195,'tipsviewmgr_cmd_viewarticletype','',8),(196,'tipsviewmgr_cmd_viewarticlealltype','',8),(197,'adminstereomicroscopemgr','',9),(198,'adminstereomicroscopemgr_cmd_view','',9),(199,'adminstereomicroscopemgr_cmd_addview','',9),(200,'adminstereomicroscopemgr_cmd_add','',9),(201,'adminstereomicroscopemgr_cmd_editview','',9),(202,'adminstereomicroscopemgr_cmd_edit','',9),(203,'adminstereomicroscopemgr_cmd_delete','',9),(204,'adminstereomicroscopetypemgr','',9),(205,'adminstereomicroscopetypemgr_cmd_view','',9),(206,'adminstereomicroscopetypemgr_cmd_addview','',9),(207,'adminstereomicroscopetypemgr_cmd_add','',9),(208,'adminstereomicroscopetypemgr_cmd_editview','',9),(209,'adminstereomicroscopetypemgr_cmd_edit','',9),(210,'adminstereomicroscopetypemgr_cmd_delete','',9),(211,'stereomicroscopeViewmgr','',9),(212,'stereomicroscopeViewmgr_cmd_viewarticle','',9),(213,'stereomicroscopeViewmgr_cmd_viewarticletype','',9),(214,'stereomicroscopeViewmgr_cmd_viewarticlealltype','',9),(215,'adminproductmgr','',10),(216,'adminproductmgr_cmd_view','',10),(217,'adminproductmgr_cmd_addview','',10),(218,'adminproductmgr_cmd_add','',10),(219,'adminproductmgr_cmd_editview','',10),(220,'adminproductmgr_cmd_edit','',10),(221,'adminproductmgr_cmd_delete','',10),(222,'adminproducttypemgr','',10),(223,'adminproducttypemgr_cmd_view','',10),(224,'adminproducttypemgr_cmd_addview','',10),(225,'adminproducttypemgr_cmd_add','',10),(226,'adminproducttypemgr_cmd_editview','',10),(227,'adminproducttypemgr_cmd_edit','',10),(228,'adminproducttypemgr_cmd_delete','',10),(229,'prductviewmgr','',10),(230,'prductviewmgr_cmd_viewarticle','',10),(231,'prductviewmgr_cmd_viewarticletype','',10),(232,'prductviewmgr_cmd_viewarticlealltype','',10);
/*!40000 ALTER TABLE `web_permission` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_preference`
--

DROP TABLE IF EXISTS `web_preference`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_preference` (
  `preference_id` int(11) NOT NULL,
  `name` varchar(128) DEFAULT NULL,
  `default_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`preference_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_preference`
--

LOCK TABLES `web_preference` WRITE;
/*!40000 ALTER TABLE `web_preference` DISABLE KEYS */;
INSERT INTO `web_preference` (`preference_id`, `name`, `default_value`) VALUES (1,'sessionTimeout','1800'),(2,'timezone','Asia/Bangkok'),(3,'theme','rvtheme'),(4,'dateFormat','UK'),(5,'language','en-utf-8'),(6,'resPerPage','30'),(7,'showExecutionTimes','0'),(8,'locale','th_TH.utf8');
/*!40000 ALTER TABLE `web_preference` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_product`
--

DROP TABLE IF EXISTS `web_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_product` (
  `article_id` int(11) NOT NULL,
  `article_type_id` int(2) NOT NULL,
  `date_start` int(11) NOT NULL,
  `date_end` int(11) NOT NULL,
  `article_icon` varchar(255) NOT NULL,
  `skip_default_lang` smallint(1) NOT NULL,
  `publish` smallint(1) NOT NULL,
  `never_expired` smallint(1) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`article_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_product`
--

LOCK TABLES `web_product` WRITE;
/*!40000 ALTER TABLE `web_product` DISABLE KEYS */;
/*!40000 ALTER TABLE `web_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_product_group_status`
--

DROP TABLE IF EXISTS `web_product_group_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_product_group_status` (
  `article_type_id` int(11) NOT NULL,
  `status` smallint(1) NOT NULL,
  `date_create` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_product_group_status`
--

LOCK TABLES `web_product_group_status` WRITE;
/*!40000 ALTER TABLE `web_product_group_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `web_product_group_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_product_images`
--

DROP TABLE IF EXISTS `web_product_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_product_images` (
  `image_id` int(11) NOT NULL,
  `article_id` int(11) NOT NULL,
  `image_name` varchar(255) NOT NULL,
  `image_path` varchar(255) NOT NULL,
  `oldfilename` varchar(255) NOT NULL,
  PRIMARY KEY (`image_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_product_images`
--

LOCK TABLES `web_product_images` WRITE;
/*!40000 ALTER TABLE `web_product_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `web_product_images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_product_message`
--

DROP TABLE IF EXISTS `web_product_message`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_product_message` (
  `article_message_id` int(11) NOT NULL,
  `web_lang_id` int(2) NOT NULL,
  `article_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `message` mediumtext NOT NULL,
  `extra_field1` varchar(255) DEFAULT NULL,
  `extra_field2` varchar(255) DEFAULT NULL,
  `extra_field3` varchar(255) DEFAULT NULL,
  `extra_field4` varchar(255) DEFAULT NULL,
  `extra_field5` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`article_message_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_product_message`
--

LOCK TABLES `web_product_message` WRITE;
/*!40000 ALTER TABLE `web_product_message` DISABLE KEYS */;
/*!40000 ALTER TABLE `web_product_message` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_product_property`
--

DROP TABLE IF EXISTS `web_product_property`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_product_property` (
  `article_id` int(11) NOT NULL,
  `property1` smallint(1) NOT NULL,
  `property2` smallint(1) NOT NULL,
  `property3` smallint(1) NOT NULL,
  `property4` smallint(1) NOT NULL,
  `property5` smallint(1) NOT NULL,
  `property6` smallint(1) NOT NULL,
  PRIMARY KEY (`article_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_product_property`
--

LOCK TABLES `web_product_property` WRITE;
/*!40000 ALTER TABLE `web_product_property` DISABLE KEYS */;
/*!40000 ALTER TABLE `web_product_property` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_product_role`
--

DROP TABLE IF EXISTS `web_product_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_product_role` (
  `article_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_product_role`
--

LOCK TABLES `web_product_role` WRITE;
/*!40000 ALTER TABLE `web_product_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `web_product_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_product_series`
--

DROP TABLE IF EXISTS `web_product_series`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_product_series` (
  `series_id` int(11) NOT NULL,
  `article_type_id` int(11) NOT NULL,
  `series_name` varchar(255) NOT NULL,
  `status` smallint(1) NOT NULL,
  `date_create` int(11) NOT NULL,
  PRIMARY KEY (`series_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_product_series`
--

LOCK TABLES `web_product_series` WRITE;
/*!40000 ALTER TABLE `web_product_series` DISABLE KEYS */;
/*!40000 ALTER TABLE `web_product_series` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_product_type`
--

DROP TABLE IF EXISTS `web_product_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_product_type` (
  `article_type_id` int(2) NOT NULL,
  `type_icon` varchar(255) NOT NULL,
  PRIMARY KEY (`article_type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_product_type`
--

LOCK TABLES `web_product_type` WRITE;
/*!40000 ALTER TABLE `web_product_type` DISABLE KEYS */;
INSERT INTO `web_product_type` (`article_type_id`, `type_icon`) VALUES (1,''),(2,''),(3,''),(4,'');
/*!40000 ALTER TABLE `web_product_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_product_type_message`
--

DROP TABLE IF EXISTS `web_product_type_message`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_product_type_message` (
  `article_type_message_id` int(11) NOT NULL,
  `article_type_id` int(2) NOT NULL,
  `web_lang_id` int(2) NOT NULL,
  `type_name` varchar(128) NOT NULL,
  `description` varchar(255) NOT NULL,
  PRIMARY KEY (`article_type_message_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_product_type_message`
--

LOCK TABLES `web_product_type_message` WRITE;
/*!40000 ALTER TABLE `web_product_type_message` DISABLE KEYS */;
INSERT INTO `web_product_type_message` (`article_type_message_id`, `article_type_id`, `web_lang_id`, `type_name`, `description`) VALUES (1,1,1,'Gem Microscope',''),(2,2,1,'Biological',''),(3,3,1,'Import Microscope',''),(4,4,1,'Accessories','');
/*!40000 ALTER TABLE `web_product_type_message` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_product_type_role`
--

DROP TABLE IF EXISTS `web_product_type_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_product_type_role` (
  `article_type_id` int(2) NOT NULL,
  `role_id` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_product_type_role`
--

LOCK TABLES `web_product_type_role` WRITE;
/*!40000 ALTER TABLE `web_product_type_role` DISABLE KEYS */;
INSERT INTO `web_product_type_role` (`article_type_id`, `role_id`) VALUES (1,0),(1,1),(1,2),(2,0),(2,1),(2,2),(3,0),(3,1),(3,2),(4,0),(4,1),(4,2);
/*!40000 ALTER TABLE `web_product_type_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_role`
--

DROP TABLE IF EXISTS `web_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_role` (
  `role_id` int(11) NOT NULL DEFAULT '-1',
  `name` varchar(255) DEFAULT NULL,
  `description` text,
  `date_created` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `last_updated` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`role_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_role`
--

LOCK TABLES `web_role` WRITE;
/*!40000 ALTER TABLE `web_role` DISABLE KEYS */;
INSERT INTO `web_role` (`role_id`, `name`, `description`, `date_created`, `created_by`, `last_updated`, `updated_by`) VALUES (-1,'unassigned','not assigned a role',NULL,NULL,NULL,NULL),(0,'guest','public user',NULL,NULL,NULL,NULL),(1,'root','super user',NULL,NULL,NULL,NULL),(2,'member','has a limited set of privileges',NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `web_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_role_permission`
--

DROP TABLE IF EXISTS `web_role_permission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_role_permission` (
  `role_permission_id` int(11) NOT NULL DEFAULT '0',
  `role_id` int(11) NOT NULL DEFAULT '0',
  `permission_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`role_permission_id`),
  KEY `permission_id` (`permission_id`),
  KEY `role_id` (`role_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_role_permission`
--

LOCK TABLES `web_role_permission` WRITE;
/*!40000 ALTER TABLE `web_role_permission` DISABLE KEYS */;
INSERT INTO `web_role_permission` (`role_permission_id`, `role_id`, `permission_id`) VALUES (1,2,22),(2,2,21),(3,2,95),(4,2,43),(5,2,46),(6,2,44),(7,2,45),(8,2,96),(9,2,48),(10,2,47),(11,2,97),(12,2,58),(13,2,59),(14,2,68),(15,2,69),(16,2,72),(17,2,73),(18,2,74),(19,2,93),(20,2,94);
/*!40000 ALTER TABLE `web_role_permission` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_section`
--

DROP TABLE IF EXISTS `web_section`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_section` (
  `section_id` int(11) NOT NULL,
  `title` varchar(32) DEFAULT NULL,
  `resource_uri` varchar(128) DEFAULT NULL,
  `perms` varchar(32) DEFAULT NULL,
  `trans_id` int(11) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `root_id` int(11) DEFAULT NULL,
  `left_id` int(11) DEFAULT NULL,
  `right_id` int(11) DEFAULT NULL,
  `order_id` int(11) DEFAULT NULL,
  `level_id` int(11) DEFAULT NULL,
  `is_enabled` smallint(6) DEFAULT NULL,
  `is_static` smallint(6) DEFAULT NULL,
  `access_key` char(1) DEFAULT NULL,
  `rel` varchar(16) DEFAULT NULL,
  PRIMARY KEY (`section_id`),
  KEY `AK_key_root_id` (`root_id`),
  KEY `AK_key_order_id` (`order_id`),
  KEY `AK_key_left_id` (`left_id`),
  KEY `AK_key_right_id` (`right_id`),
  KEY `AK_id_root_l_r` (`section_id`,`root_id`,`left_id`,`right_id`),
  KEY `AK_key_level_id` (`level_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_section`
--

LOCK TABLES `web_section` WRITE;
/*!40000 ALTER TABLE `web_section` DISABLE KEYS */;
INSERT INTO `web_section` (`section_id`, `title`, `resource_uri`, `perms`, `trans_id`, `parent_id`, `root_id`, `left_id`, `right_id`, `order_id`, `level_id`, `is_enabled`, `is_static`, `access_key`, `rel`) VALUES (1,'root','uriEmpty:','1',1,0,0,0,0,0,0,0,0,'',''),(2,'User menu','uriEmpty:','-2',2,0,2,1,2,1,1,1,0,'',''),(4,'Admin menu','uriEmpty:','1',4,0,4,1,2,2,1,1,0,'','');
/*!40000 ALTER TABLE `web_section` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_sequence`
--

DROP TABLE IF EXISTS `web_sequence`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_sequence` (
  `name` varchar(64) NOT NULL,
  `id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_sequence`
--

LOCK TABLES `web_sequence` WRITE;
/*!40000 ALTER TABLE `web_sequence` DISABLE KEYS */;
INSERT INTO `web_sequence` (`name`, `id`) VALUES ('web_module',10),('web_permission',232),('web_block',2),('web_role_permission',20),('web_preference',8),('web_article',0),('web_article_images',0),('web_article_message',0),('web_article_role',0),('web_article_type',2),('web_article_type_message',2),('web_article_type_role',0),('web_block_assignment',2),('web_block_role',0),('web_example',0),('web_formmail_log',0),('web_log_table',0),('web_login',47),('web_org_preference',0),('web_organisation',0),('web_organisation_type',0),('web_product',0),('web_product_group_status',0),('web_product_images',0),('web_product_message',0),('web_product_property',0),('web_product_role',0),('web_product_series',0),('web_product_type',4),('web_product_type_message',4),('web_product_type_role',0),('web_role',2),('web_section',4),('web_table_lock',0),('web_uri_alias',0),('web_user_cookie',0),('web_user_hash',0),('web_user_permission',20),('web_user_preference',16),('web_user_session',0),('web_usr',2),('web_web_lang',1);
/*!40000 ALTER TABLE `web_sequence` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_table_lock`
--

DROP TABLE IF EXISTS `web_table_lock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_table_lock` (
  `lockID` char(32) NOT NULL,
  `lockTable` char(32) NOT NULL,
  `lockStamp` int(11) DEFAULT NULL,
  PRIMARY KEY (`lockID`,`lockTable`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_table_lock`
--

LOCK TABLES `web_table_lock` WRITE;
/*!40000 ALTER TABLE `web_table_lock` DISABLE KEYS */;
/*!40000 ALTER TABLE `web_table_lock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_uri_alias`
--

DROP TABLE IF EXISTS `web_uri_alias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_uri_alias` (
  `uri_alias_id` int(11) unsigned NOT NULL DEFAULT '0',
  `uri_alias` varchar(255) DEFAULT NULL,
  `section_id` int(11) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `keywords` text,
  `description` text,
  PRIMARY KEY (`uri_alias_id`),
  UNIQUE KEY `uri_alias` (`uri_alias`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_uri_alias`
--

LOCK TABLES `web_uri_alias` WRITE;
/*!40000 ALTER TABLE `web_uri_alias` DISABLE KEYS */;
/*!40000 ALTER TABLE `web_uri_alias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_user_cookie`
--

DROP TABLE IF EXISTS `web_user_cookie`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_user_cookie` (
  `usr_id` int(11) NOT NULL,
  `cookie_name` varchar(32) NOT NULL,
  `login_time` datetime NOT NULL,
  KEY `usr_id` (`usr_id`),
  KEY `cookie_name` (`cookie_name`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_user_cookie`
--

LOCK TABLES `web_user_cookie` WRITE;
/*!40000 ALTER TABLE `web_user_cookie` DISABLE KEYS */;
INSERT INTO `web_user_cookie` (`usr_id`, `cookie_name`, `login_time`) VALUES (1,'39a14301f06f0758e17759fe5cdfb356','2017-07-19 16:07:21'),(1,'9c92c3311626502be727bdf81fce174a','2017-07-19 17:16:16');
/*!40000 ALTER TABLE `web_user_cookie` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_user_hash`
--

DROP TABLE IF EXISTS `web_user_hash`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_user_hash` (
  `user_hash_id` int(11) NOT NULL DEFAULT '0',
  `usr_id` int(11) NOT NULL DEFAULT '0',
  `hash` varchar(64) NOT NULL,
  `ctime` int(11) NOT NULL,
  PRIMARY KEY (`user_hash_id`),
  KEY `usr_id` (`usr_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_user_hash`
--

LOCK TABLES `web_user_hash` WRITE;
/*!40000 ALTER TABLE `web_user_hash` DISABLE KEYS */;
/*!40000 ALTER TABLE `web_user_hash` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_user_permission`
--

DROP TABLE IF EXISTS `web_user_permission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_user_permission` (
  `user_permission_id` int(11) NOT NULL DEFAULT '0',
  `usr_id` int(11) NOT NULL DEFAULT '0',
  `permission_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_permission_id`),
  KEY `usr_id` (`usr_id`),
  KEY `permission_id` (`permission_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_user_permission`
--

LOCK TABLES `web_user_permission` WRITE;
/*!40000 ALTER TABLE `web_user_permission` DISABLE KEYS */;
INSERT INTO `web_user_permission` (`user_permission_id`, `usr_id`, `permission_id`) VALUES (1,2,22),(2,2,21),(3,2,95),(4,2,43),(5,2,46),(6,2,44),(7,2,45),(8,2,96),(9,2,48),(10,2,47),(11,2,97),(12,2,58),(13,2,59),(14,2,68),(15,2,69),(16,2,72),(17,2,73),(18,2,74),(19,2,93),(20,2,94);
/*!40000 ALTER TABLE `web_user_permission` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_user_preference`
--

DROP TABLE IF EXISTS `web_user_preference`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_user_preference` (
  `user_preference_id` int(11) NOT NULL,
  `usr_id` int(11) NOT NULL,
  `preference_id` int(11) NOT NULL,
  `value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`user_preference_id`),
  KEY `web_usr_user_preference_fk` (`usr_id`),
  KEY `web_preference_user_preference_fk` (`preference_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_user_preference`
--

LOCK TABLES `web_user_preference` WRITE;
/*!40000 ALTER TABLE `web_user_preference` DISABLE KEYS */;
INSERT INTO `web_user_preference` (`user_preference_id`, `usr_id`, `preference_id`, `value`) VALUES (1,1,1,'1800'),(2,1,2,'Asia/Bangkok'),(3,1,3,'rvtheme'),(4,1,4,'UK'),(5,1,5,'en-utf-8'),(6,1,6,'30'),(7,1,7,'0'),(8,1,8,'th_TH.utf8'),(9,2,1,'1800'),(10,2,2,'Asia/Bangkok'),(11,2,3,'rvtheme'),(12,2,4,'UK'),(13,2,5,'en-utf-8'),(14,2,6,'30'),(15,2,7,'0'),(16,2,8,'th_TH.utf8');
/*!40000 ALTER TABLE `web_user_preference` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_user_session`
--

DROP TABLE IF EXISTS `web_user_session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_user_session` (
  `session_id` varchar(255) NOT NULL,
  `last_updated` datetime DEFAULT NULL,
  `data_value` text,
  `usr_id` int(11) NOT NULL DEFAULT '0',
  `username` varchar(64) DEFAULT NULL,
  `expiry` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`session_id`),
  KEY `last_updated` (`last_updated`),
  KEY `usr_id` (`usr_id`),
  KEY `username` (`username`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_user_session`
--

LOCK TABLES `web_user_session` WRITE;
/*!40000 ALTER TABLE `web_user_session` DISABLE KEYS */;
/*!40000 ALTER TABLE `web_user_session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_usr`
--

DROP TABLE IF EXISTS `web_usr`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_usr` (
  `usr_id` int(11) NOT NULL DEFAULT '0',
  `organisation_id` int(11) DEFAULT '0',
  `role_id` int(11) NOT NULL DEFAULT '0',
  `username` varchar(64) DEFAULT NULL,
  `passwd` varchar(32) DEFAULT NULL,
  `first_name` varchar(128) DEFAULT NULL,
  `last_name` varchar(128) DEFAULT NULL,
  `telephone` varchar(16) DEFAULT NULL,
  `mobile` varchar(16) DEFAULT NULL,
  `email` varchar(128) DEFAULT NULL,
  `addr_1` varchar(128) DEFAULT NULL,
  `addr_2` varchar(128) DEFAULT NULL,
  `addr_3` varchar(128) DEFAULT NULL,
  `city` varchar(64) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  `country` char(2) DEFAULT NULL,
  `post_code` varchar(16) DEFAULT NULL,
  `is_email_public` smallint(6) DEFAULT NULL,
  `is_acct_active` smallint(6) DEFAULT NULL,
  `security_question` smallint(6) DEFAULT NULL,
  `security_answer` varchar(128) DEFAULT NULL,
  `date_created` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `last_updated` datetime DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`usr_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_usr`
--

LOCK TABLES `web_usr` WRITE;
/*!40000 ALTER TABLE `web_usr` DISABLE KEYS */;
INSERT INTO `web_usr` (`usr_id`, `organisation_id`, `role_id`, `username`, `passwd`, `first_name`, `last_name`, `telephone`, `mobile`, `email`, `addr_1`, `addr_2`, `addr_3`, `city`, `region`, `country`, `post_code`, `is_email_public`, `is_acct_active`, `security_question`, `security_answer`, `date_created`, `created_by`, `last_updated`, `updated_by`) VALUES (0,1,0,'nobody','21232f297a57a5a743894a0e4a801fc3','Nobody','Nobody','','','none@none.com','none','','','None','','GB','55555',0,0,1,'rover','2003-12-09 18:02:44',1,'2004-06-10 11:07:27',1),(1,1,1,'admin','133f0f1b3f99471fa621b80f386d0c5e','Carton','Trading','02909-5931-40','081-371-1392','account@cartonmicroscope.com','145/85 หมู่ที่ 3 ถนนรามอินทรา','แขวงท่าแร้ง เขตบางเขน',NULL,'กรุงเทพมหานคร',NULL,'TH',NULL,0,1,1,'carton','2017-07-19 16:01:45',1,'2017-07-19 16:01:45',1),(2,0,2,'administrative','133f0f1b3f99471fa621b80f386d0c5e','','','029095931-40','','carton@cartonmicroscope.com','100 moo 18 soi navanakorn 24','tambol klong nueng,','','klong luang','','TH','12120',0,1,1,'carton','2017-07-24 10:56:11',1,'2017-07-24 10:56:11',1);
/*!40000 ALTER TABLE `web_usr` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_web_lang`
--

DROP TABLE IF EXISTS `web_web_lang`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_web_lang` (
  `web_lang_id` int(2) NOT NULL,
  `lang_key` varchar(32) NOT NULL,
  PRIMARY KEY (`web_lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=tis620;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_web_lang`
--

LOCK TABLES `web_web_lang` WRITE;
/*!40000 ALTER TABLE `web_web_lang` DISABLE KEYS */;
INSERT INTO `web_web_lang` (`web_lang_id`, `lang_key`) VALUES (1,'en-utf-8');
/*!40000 ALTER TABLE `web_web_lang` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping events for database 'cartonmi_seagull2'
--

--
-- Dumping routines for database 'cartonmi_seagull2'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2019-02-14 15:15:32
