<?php
/* Reminder: always indent with 4 spaces (no tabs). */
// +---------------------------------------------------------------------------+
// | Copyright (c) 2008, Demian Turner                                         |
// | All rights reserved.                                                      |
// |                                                                           |
// | Redistribution and use in source and binary forms, with or without        |
// | modification, are permitted provided that the following conditions        |
// | are met:                                                                  |
// |                                                                           |
// | o Redistributions of source code must retain the above copyright          |
// |   notice, this list of conditions and the following disclaimer.           |
// | o Redistributions in binary form must reproduce the above copyright       |
// |   notice, this list of conditions and the following disclaimer in the     |
// |   documentation and/or other materials provided with the distribution.    |
// | o The names of the authors may not be used to endorse or promote          |
// |   products derived from this software without specific prior written      |
// |   permission.                                                             |
// |                                                                           |
// | THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       |
// | "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         |
// | LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR     |
// | A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT      |
// | OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     |
// | SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT          |
// | LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,     |
// | DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY     |
// | THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT       |
// | (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE     |
// | OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.      |
// |                                                                           |
// +---------------------------------------------------------------------------+
// | Seagull 0.6                                                               |
// +---------------------------------------------------------------------------+
// | setup.php                                                                 |
// +---------------------------------------------------------------------------+
// | Authors:                                                                  |
// |            Demian Turner <demian@phpkitchen.com>                          |
// |            Gerry Lachac <glachac@tethermedia.com>                         |
// |            Andy Crain <apcrain@fuse.net>                                  |
// +---------------------------------------------------------------------------+
// $Id: setup.php,v 1.5 2005/02/03 11:29:01 demian Exp $

/*
sgl setup
=========
- ability to upload and unzip/tar a packaged module
- file permission handling ideas from FUDforum installer
- more user-friendly error messages from Gallery2
- if no DB detected, prompt to create, otherwise offer to create tables


php ini
=======
- deal with register_globals and set session.use_trans_sid = 0
- allow_url_fopen = Off
- detect and deal with safe_mode
- magic_quotes must be off
- file_uploads ideally enabled

module setup
============
- choose modules and permissions must be created and set at install time
- attempt to
    - uncompress
    - move to correct location
    - apply user perms
    - apply prefs
    - add module's db tables to Config
    - load module's schema + data
    - add 'section' or 'screen' navigation links
    - register module in registry
*/

//  initialise

//  set initial paths according to install type
$pearTest = '@PHP-DIR@';
//RVS START auto setup
require_once dirname(__FILE__) . '/rvscommonfunc.php';

SGL_FrontController::init();
session_start();
$_SESSION['ERRORS'] = array();

//  check if requesting auth.txt download
if (isset($_GET['download']) && $_GET['download'] == 1) {
    if (isset($_SESSION['authString'])) {
        header("Content-Type: text/plain");
        header("Content-Length: " . strlen($_SESSION['authString']));
        header("Content-Description: Download AUTH.txt to your computer.");
        header("Content-Disposition: attachment; filename=AUTH.txt");
        print $_SESSION['authString'];
        exit;
    }
}

//  reroute to front controller
if (isset($_GET['start'])) {

    //  remove installer info
    @session_destroy();
    $_SESSION = array();

    //  clear session cookie
    $c = &SGL_Config::singleton();
    $conf = $c->getAll();
    setcookie(  $conf['cookie']['name'], null, 0, $conf['cookie']['path'],
                $conf['cookie']['domain'], $conf['cookie']['secure']);
/*
    $aUrl = array(
        'managerName' => 'default',
        'moduleName'  => 'default',
        'welcome'     => 1
    );
*/
// mgr clearcache before goto page default

        $aUrl = array(
        'managerName' => 'RvsClearCacheMgr',
        'moduleName'  => 'default',
    );
    SGL_HTTP::redirect($aUrl);
}

//  check authorization

if (is_file(SGL_VAR_DIR . '/INSTALL_COMPLETE.php')
        && empty($_SESSION['valid']) && !defined('RVS_AUTO_SETUP') ) {

    if (!empty($_POST['frmSetupPassword'])) {
        $aLines = file(SGL_VAR_DIR . '/INSTALL_COMPLETE.php');
        $secret = trim(substr($aLines[1], 1));
        if ($_POST['frmSetupPassword'] != $secret) {
            $_SESSION['message'] = 'incorrect password';
            header('Location: rvssetup.php'); //RVS modify
            exit;
        } else {
            $_SESSION['valid'] = true;
            header('Location: rvssetup.php'); //RVS modify
        }
    } else {
        SGL_Install_Common::printHeader();
        SGL_Install_Common::printLoginForm();
        SGL_Install_Common::printFooter();
        exit;
    }
}

// load QuickFormController libs
require_once 'HTML/QuickForm/Controller.php';
require_once 'HTML/QuickForm/Action/Next.php';
require_once 'HTML/QuickForm/Action/Back.php';
require_once 'HTML/QuickForm/Action/Display.php';

//  load wizard screens and qf overrides
require_once SGL_PATH . '/lib/SGL/Install/WizardLicenseAgreement.php';
require_once SGL_PATH . '/lib/SGL/Install/WizardSetupAuth.php';
require_once SGL_PATH . '/lib/SGL/Install/WizardDetectEnv.php';
require_once SGL_PATH . '/lib/SGL/Install/WizardTestDbConnection.php';
require_once SGL_PATH . '/lib/SGL/Install/WizardCreateDb.php';
require_once SGL_PATH . '/lib/SGL/Install/WizardCreateAdminUser.php';
require_once SGL_PATH . '/lib/SGL/Install/QuickFormOverride.php';

//  load tasks
require_once SGL_PATH . '/lib/SGL/Task/DetectEnv.php';
require_once SGL_PATH . '/lib/SGL/Task/Install.php';

//RVS START include
if (defined('RVS_AUTO_SETUP')) {
    require_once SGL_PATH . '/lib/SGL/Task/rvsUpdateDatabase.php';
    require_once SGL_PATH . '/lib/SGL/Task/rvsCompoPostInstall.php';
}
//RVS END

//  setup temporary logging for Seagull install
$tmpDir = SGL_Util::getTmpDir();
$log = "$tmpDir/install.log";
$ok = @ini_set('error_log', $log);


class ActionProcess extends HTML_QuickForm_Action
{
    function perform(&$page, $actionName)
    {
        //RVS START auto setup
        //$data = $page->controller->exportValues();
        $data = (defined('RVS_AUTO_SETUP')) ? $page : $page->controller->exportValues();
        //RVS END
        
        //  is this a rebuild?
        $dbh = & SGL_DB::singleton();
        $res = false;
        if (!PEAR::isError($dbh)) {
            require_once SGL_CORE_DIR . '/Sql.php';
            $table = SGL_Sql::addTablePrefix('module');
            $query = 'SELECT COUNT(*) FROM ' . $table;
            $res = $dbh->getOne($query);
        }

        if (!PEAR::isError($res) && $res > 1) { // it's a re-install
            $data['aModuleList'] = SGL_Install_Common::getModuleList();
            if (count($data['aModuleList'])) {
                foreach ($data['aModuleList'] as $key => $moduleName) {
                    if (!SGL::moduleIsEnabled($moduleName)) {
                        unset($data['aModuleList'][$key]);
                    }
                }
            }
        } else { // a new install
            SGL_Error::pop();
            if (PEAR::isError($dbh)) {
                SGL_Error::pop(); // two errors produced
            }
            $data['aModuleList'] = SGL_Install_Common::getMinimumModuleList();
        }

        //  override with custom settings if they exist
        $data = SGL_Install_Common::overrideDefaultInstallSettings($data);
        //RVS START auto setup
        if (defined('RVS_AUTO_SETUP')) {
        	$data = RVS_Task::rvsOverrideDefaultInstallSettings($data);
        }
        //RVS END auto setup
        $buildNavTask = 'SGL_Task_BuildNavigation';
        if (in_array('cms', $data['aModuleList'])) {
            require_once SGL_MOD_DIR . '/cms/init.php';
            $buildNavTask = 'SGL_Task_BuildNavigation2';
        }
        $runner = new SGL_TaskRunner();
        $runner->addData($data);
        $runner->addTask(new SGL_Task_SetTimeout());
        $runner->addTask(new SGL_Task_CreateConfig());
        $runner->addTask(new SGL_Task_LoadCustomConfig());
        $runner->addTask(new SGL_Task_DefineTableAliases());
        $runner->addTask(new SGL_Task_DisableForeignKeyChecks());
        $runner->addTask(new SGL_Task_PrepareInstallationProgressTable());
        $runner->addTask(new SGL_Task_DropTables());
        $runner->addTask(new SGL_Task_CreateTables());
        $runner->addTask(new SGL_Task_LoadTranslations());
        $runner->addTask(new SGL_Task_LoadDefaultData());
        $runner->addTask(new SGL_Task_LoadSampleData());
        $runner->addTask(new SGL_Task_LoadCustomData());
        //RVS START add task rvsCompoPostInstall
        if (defined('RVS_AUTO_SETUP')) {
            $runner->addTask(new SGL_Task_rvsCompoPostInstall());
        }
        //RVS END add task rvsCompoPostInstall        
        $runner->addTask(new SGL_Task_SyncSequences());
        $runner->addTask(new $buildNavTask());
        $runner->addTask(new SGL_Task_LoadBlockData());
        $runner->addTask(new SGL_Task_CreateConstraints());
        $runner->addTask(new SGL_Task_SyncSequences());
        $runner->addTask(new SGL_Task_EnableForeignKeyChecks());
		
        //RVS START add task rvsUpdateDatabase
        if (defined('RVS_AUTO_SETUP')) {
        	$runner->addTask(new SGL_Task_rvsUpdateDatabase());
        }
        //RVS END add task rvsUpdateDatabase()
        
        $runner->addTask(new SGL_Task_VerifyDbSetup());
        $runner->addTask(new SGL_Task_CreateFileSystem());
        //RVS START create file system
        $runner->addTask(new SGL_Task_rvsCreateFileSystem());
        //RVS END
        $runner->addTask(new SGL_Task_CreateDataObjectEntities());
        $runner->addTask(new SGL_Task_CreateDataObjectLinkFile());
        //RVS START if RVS_AUTO_SETUP no unlink and create symlink
        if (!defined('RVS_AUTO_SETUP')) {
        	$runner->addTask(new SGL_Task_UnLinkWwwData());
        	$runner->addTask(new SGL_Task_SymLinkWwwData());
        }
        //RVS END
        $runner->addTask(new SGL_Task_AddTestDataToConfig());
        $runner->addTask(new SGL_Task_CreateAdminUser());
        $runner->addTask(new SGL_Task_InstallerCleanup());
		
        //RVS START add task _rvsCheckingError
        if (defined('RVS_AUTO_SETUP')) {
        	$runner->addTask(new SGL_Task_rvsCheckingError());
        }
        //RVS END
        $ok = $runner->main();
    }
    
    //RVS START run update
    /**
     * Run auto setup
     *
     * @param unknown_type $aAutoConf
     */
    function update($aAutoConf)
    {
        $c = &SGL_Config::singleton();
        
        //  translation fallback language
        $fallbackLang = str_replace('-', '_', $aAutoConf['siteLanguage']);
        $c->set('translation', array('fallbackLang' => $fallbackLang));
        
        // Start update config
        $c->set('path', array('webRoot' => $aAutoConf['webRoot']));
        $c->set('site', array('baseUrl' => $aAutoConf['baseUrl']));
        $c->set('cookie', array('name' => $aAutoConf['siteCookie']));
        $c->set('site', array('name' => $aAutoConf['siteName']));
        
        $c->set('email', array('admin' => $aAutoConf['adminEmail']));
        $c->set('site', array('serverTimeOffset' => $aAutoConf['serverTimeOffset']));
        // tinyfck / htmlarea
        $c->set('site', array('wysiwygEditor' => 'htmlarea'));

        $ok = $c->save();
        // ENd
        $conf = $c->getAll();
        
        $aLines = file(SGL_VAR_DIR . '/INSTALL_COMPLETE.php');
        $installPassword = trim(substr($aLines[1], 1));
           
        // e-mail
        $data['adminEmail'] = $conf['email']['admin'];

        //  db details
        $data['prefix'] = $conf['db']['prefix'];
        $data['host'] = $conf['db']['host'];
        $data['name'] = $conf['db']['name'];
        $data['user'] = $conf['db']['user'];
        $data['pass'] = $conf['db']['pass'];
        $data['dbPort']['port'] = $conf['db']['port'];
        $data['dbProtocol']['protocol'] = $conf['db']['protocol'];
        $data['socket'] =$conf['db']['socket'];
        $data['dbType']['type'] = $conf['db']['type'];
            
        //  version
        $data['frameworkVersion'] = $conf['tuples']['version'];
            
        //  paths
        $data['installRoot'] = $conf['path']['installRoot'];
        $data['webRoot'] = $conf['path']['webRoot'];
        $data['baseUrl'] = $conf['site']['baseUrl'];
            
        //  various
        $data['serverTimeOffset'] = $conf['site']['serverTimeOffset'];
        $data['siteName'] = $conf['site']['name'];
        $data['siteDesc'] = $conf['site']['description'];
        $data['siteKeywords'] = $conf['site']['keywords'];
        $data['siteCookie'] = $conf['cookie']['name'];
           
        //  store translations in db
        if ( $conf['translation']['container'] == 'db' ) {
            $data['storeTranslationsInDB'] = 1;
        } else {
            $data['storeTranslationsInDB'] = 0;
        }
            
        //  add missing translations to db
        if ( $conf['translation']['addMissingTrans'] == true ) {
            $data['addMissingTranslationsToDB'] = 1;
        } else {
            $data['addMissingTranslationsToDB'] = 0;   
        }

        $fallbackLang = $conf['translation']['fallbackLang'];
        $data['siteLanguage'] = (isset($aAutoConf['siteLanguage'])) ? $aAutoConf['siteLanguage'] : str_replace('_', '-', $fallbackLang);
        $data['createTables'] = 0;
        $data['insertSampleData'] = 0;
        $data['updateTables'] = 1;
        
        //  store site language for post-install task
        $_SESSION['install_language'] = (!isset($_SESSION['install_language'])) ? $data['siteLanguage'] : $_SESSION['install_language'];
        //  and tz
        $_SESSION['install_timezone'] = (!isset($_SESSION['install_timezone'])) ? $data['serverTimeOffset'] : $_SESSION['install_timezone'];
        
        $oCommon = new SGL_Install_Common;
        //RVS START
        if (defined('RVS_AUTO_SETUP')) {
        	//  flatten module array if exists
        	if (array_key_exists('aModuleList', $aAutoConf)) {
            	$data['aModuleList'] = explode(',', $aAutoConf['aModuleList']);
        	}
        }
        //RVS END
        
        $data['serverName'] =  SGL_SERVER_NAME;
        $data['installPassword'] = $installPassword;
        
        $data['rvs_backup_path'] = SGL_VAR_DIR . '/dbbackup.sql';

        $oCommon->printHeader('');
        
        echo '<span class="title">Status: </span><span id="status"></span>
            <div id="progress_bar">
                <img src="' . SGL_BASE_URL . '/themes/default/images/progress_bar.gif" border="0" width="150" height="13">
            </div>
            <div id="additionalInfo"></div>';
        $runner = new SGL_TaskRunner();
        $runner->addData($data);
        $runner->addTask(new SGL_Task_DisableForeignKeyChecks());
        
        //$runner->addTask(new SGL_Task_CreateDatabase());
        //$runner->addTask(new SGL_Task_rvsBackupDatabase());
        
        //RVS START add task rvsCompoPostInstall
        if (defined('RVS_AUTO_SETUP')) {
            $runner->addTask(new SGL_Task_rvsCompoPostInstall());
        }
        //RVS END add task rvsCompoPostInstall
        $runner->addTask(new SGL_Task_rvsUpdateDatabase());
        $runner->addTask(new SGL_Task_EnableForeignKeyChecks());
        $runner->addTask(new SGL_Task_VerifyDbSetup());
        $runner->addTask(new SGL_Task_CreateFileSystem());
        //RVS START create file system
        $runner->addTask(new SGL_Task_rvsCreateFileSystem());
        //RVS END
        $runner->addTask(new SGL_Task_CreateDataObjectEntities());
        $runner->addTask(new SGL_Task_SyncSequences());
        $runner->addTask(new SGL_Task_InstallerCleanup());
        
        $runner->addTask(new SGL_Task_rvsCheckingError());
        
        set_time_limit(120);
        $ok = $runner->main();
    }
    //RVS END run update
}

// RVS START auto setup
if ( defined('RVS_AUTO_SETUP') && is_file($varDir . '/rvsautosetup.ini.php')) {
    $aAutoConf = array();
    $aAutoConf = parse_ini_file($varDir . '/rvsautosetup.ini.php', true);
    //case update setup
    if ( is_file($varDir . '/INSTALL_COMPLETE.php') ) {
        ActionProcess::update($aAutoConf);
    } else {
        //case new setup
        //���ǨѴ����
        $aAutoConf['frameworkVersion'] = '0.6.3';
        $aAutoConf['host'] = 'localhost';
        $aAutoConf['socket'] = '';
        
        $aAutoConf['createTables'] = 1;
        $aAutoConf['insertSampleData'] = 1;
        $aAutoConf['updateTables'] = 0;        
        $aAutoConf['installAllModules'] = 0;
        $aAutoConf['storeTranslationsInDB'] = 0;
        $aAutoConf['addMissingTranslationsToDB'] = 1;
        $aAutoConf['dbPort']['port'] = 3306;
        $aAutoConf['dbProtocol']['protocol'] = 'unix';
        $aAutoConf['dbType']['type'] = 'mysql';
        $aAutoConf['dbSequencesInOneTable']['dbSequences'] = '';
        //if can't config
        ActionProcess::perform($aAutoConf, 'next');
    }
    if (SGL_Install_Common::errorsExist()) {
        SGL_Install_Common::errorPrint();
    } 
    exit;
}
//RVS END - Auto setup

//  start wizard
$wizard =& new HTML_QuickForm_Controller('installationWizard');
$wizard->addPage(new WizardLicenseAgreement('page1'));
$wizard->addPage(new WizardSetupAuth('page2'));
$wizard->addPage(new WizardDetectEnv('page3'));
$wizard->addPage(new WizardTestDbConnection('page4'));
$wizard->addPage(new WizardCreateDb('page5'));
$wizard->addPage(new WizardCreateAdminUser('page6'));

// We actually add these handlers here for the sake of example
// They can be automatically loaded and added by the controller
$wizard->addAction('display', new ActionDisplay());
$wizard->addAction('next', new HTML_QuickForm_Action_Next());
$wizard->addAction('back', new HTML_QuickForm_Action_Back());

// This is the action we should always define ourselves
$wizard->addAction('process', new ActionProcess());

$wizard->run();

if (SGL_Install_Common::errorsExist()) {
    SGL_Install_Common::errorPrint();
}
?>
