<?php
/*
 * Verify dir list from svn
 */


if (isset($argv) && count($argv) > 1) {
    /*
     * CLI arguments
     * php verifyDirList.php targetdir=/home/amarin/public_html/seagull_mod/seagull verifylist=verify_dirlist.txt
     */
    array_shift($argv);
    foreach ($argv as $arg) {
        list($key,$value) = explode('=', $arg);
        $conf[$key] = $value;
    }
    $targetdir = isset($conf['targetdir']) ? $conf['targetdir'] : '';
    $verifylist = isset($conf['verifylist']) ? $conf['verifylist'] : 'verify_dirlist.txt';
    $result = verifyDirList($targetdir, $verifylist);
    if ($result === true ) {
        echo true;
    } else {
        echo $result;
    }
} elseif (isset($_GET) && count($_GET)) {
    /*
     * Post Url
     * verifyDirList.php?targetdir=/home/amarin/public_html/seagull_mod/seagull&verifylist=verify_dirlist.txt
     */
    $targetdir = isset($_GET['targetdir']) ? trim($_GET['targetdir']) : '';
    $verifylist = isset($_GET['verifylist']) ? trim($_GET['verifylist']) : 'verify_dirlist.txt';
    $result = verifyDirList($targetdir, $verifylist);
    if ($result === true ) {
        echo true;
    } else {
        echo "$result";
    }
}

function verifyDirList($targetdir = '', $verifylist = '')
{

    if (!is_file($verifylist)) {
        return ('ERROR :: Cannot found file ' . $verifylist);
    }

    $aLine = file($verifylist);
    $masterCount = count($aLine);
    $aExistsList = array();
    foreach ($aLine as $line) {
        $line = trim($line);
        if ($line == 'public_html' || $line = 'public_html/images') {
            continue;
        }
        if (file_exists($targetdir . '/' . $line)) {
            array_push($aExistsList, $targetdir . '/' . $line);
        }
    }

    if (count($aExistsList) > 1) {
        if ($masterCount == count($aExistsList)) {
            $msg = 'Warning :: All file and Directory are exists (Already Install)<br /><hr />';
        } else {
            $msg = 'Warning :: Some file or Directory are exists = ' . count($aExistsList) . ' files<br /><hr />';
            if (count($aExistsList) > 20) {
                $aResultExistsList = array_slice($aExistsList, 0, 20);
                $result = join("<br/>\n", $aResultExistsList);
            } else {
                $result = join("<br/>\n", $aExistsList);
            }
            $msg = $msg . $result;
        }
        return $msg;
    } else {
        return true;
    }
}

?>