<?php
/*
 * Compare two file
 * 	requre two file
 * 		master md5_filelist.txt
 * 		current md5_publishfilelist.txt
 */

if (isset($argv) && count($argv) > 1) {
    /*
     * CLI arguments
     * php md5compare.php md5master=md5_filelist.txt md5current=md5_publishfilelist.txt
     */
    array_shift($argv);
    foreach ($argv as $arg) {
        list($key,$value) = explode('=', $arg);
        $conf[$key] = $value;
    }
    $md5master = isset($conf['md5master']) ? $conf['md5master'] : 'md5_filelist.txt';
    $md5current = isset($conf['md5current']) ? $conf['md5current'] : 'md5_publishfilelist.txt';
    md5compare($md5master, $md5current);
} elseif (isset($_GET) && count($_GET)) {
    /*
     * Post Url
     * md5compare.php?md5master=md5_filelist.txt&md5current=md5_publishfilelist.txt
     */

    $md5master = isset($_GET['md5master']) ? $_GET['md5master'] : 'md5_filelist.txt';
    $md5current = isset($_GET['md5current']) ? $_GET['md5current'] : 'md5_publishfilelist.txt';
    md5compare($md5master, $md5current);
    #md5listnonupdate($md5master, $md5current);
}

function md5compare($md5master = '', $md5current = '')
{
    if (!is_file($md5master)) {
        die('ERROR :: Cannot found md5master file ' . $md5master);
    }
    if (!is_file($md5current)) {
        die('ERROR :: Cannot found md5current file ' . $md5current);
    }
    $result = diff_context($md5master, $md5current);

    
    $result = preg_replace('/\\n/','<br/>',$result);
    preg_match_all('/<del>(.*?)<\/del>/',$result,$match);
    $aDeleteList = array(); 
    foreach ($match[1] as $val) {
        $aVal = explode('<br/>',$val);
        foreach ($aVal as $val2) {
            list($key,$val) = explode('===',$val2);
            $aDeleteList[$key] = $val;
        }
    }
    
    preg_match_all('/<ins>(.*?)<\/ins>/',$result,$match);
    $aModifyList = array(); 
    foreach ($match[1] as $val) {
        $aVal = explode('<br/>',$val);
        foreach ($aVal as $val2) {
            list($key,$val) = explode('===',$val2);
            if (array_key_exists($key, $aDeleteList)) {
                $aModifyList[$key] = $val;
                unset($aDeleteList[$key]);
            }
        }
    }
    
    
    if (count($aDeleteList) || count($aModifyList)) {
        if (count($aDeleteList)) {
            echo '<h3>The following files are deleted from the server. Please verify. If correct, please remove files from SVN and publish again:</h3>';
            foreach ($aDeleteList as $key=>$val) {
                echo $key . '<br/>';
            }
        }
        if (count($aModifyList)) {
            echo '<h3>Modified file list:</h3>';
            foreach ($aModifyList as $key=>$val) {
                echo $key . '<br/>';
            }
        }
    } else {
        echo true;
    }
}

function md5listnonupdate($md5master = '', $md5current = '')
{
    if (!is_file($md5master)) {
        die('ERROR :: Cannot found md5master file ' . $md5master);
    }
    if (!is_file($md5current)) {
        die('ERROR :: Cannot found md5current file ' . $md5current);
    }
    $result = diff_context($md5master, $md5current);
    
    echo '<h3>Update file list:</h3>';
   
    preg_match_all('/<del>(.*?)<\/del>/',$result,$match);
    $aDeleteList = array(); 
    foreach ($match[1] as $val) {
        $aVal = explode('<br/>',$val);
        foreach ($aVal as $val2) {
            list($key,$val) = explode('===',$val2);
            $aDeleteList[$key] = $val;
        }
    }
    
    preg_match_all('/<ins>(.*?)<\/ins>/',$result,$match);
    $aModifyList = array(); 
    foreach ($match[1] as $val) {
        $aVal = explode('<br/>',$val);
        foreach ($aVal as $val2) {
            list($key,$val) = explode('===',$val2);
            if (array_key_exists($key, $aDeleteList)) {
                $aModifyList[$key] = $val;
                unset($aDeleteList[$key]);
            } else{
                $aAddList[$key] = $val;
            }
        }
    }

    if (count($aAddList) || count($aModifyList)) {
        if (count($aAddList)) {
            echo '<h3>Add file list:</h3>';
            foreach ($aAddList as $key=>$val) {
                echo $key . '<br/>';
            }
        }
        if (count($aModifyList)) {
            echo '<h3>Modified file list:</h3>';
            foreach ($aModifyList as $key=>$val) {
                echo $key . '<br/>';
                
            }
        }
        $result = preg_replace('/<ins>(.*)<\/ins>/', '', $result);
        $result = preg_replace('/<del>(.*)<\/del>/', '', $result);
        file_put_contents('delete_filelist.txt', $result);

    } else {
        echo true;
    }
}


function diff_context($file1, $file2)
{
    include_once 'Text/Diff.php';
    include_once 'Text/Diff/Renderer/context.php';
    include_once 'Text/Diff/Renderer/inline.php';

    if (!is_file($file1)) {
        die('ERROR :: Cannot found ' . $file1);
    }
    if (!is_file($file2)) {
        die('ERROR :: Cannot found ' . $file2);
    }

    $lines1 = file($file1);
    $lines2 = file($file2);
    $diff = &new Text_Diff($lines1, $lines2);
    $renderer = &new Text_Diff_Renderer_inline();
    $result = $renderer->render($diff);
   
    
    return $result;
}

?>