<?php

/*
 * Reset Permission  ##copyright##
 * resetperm.php?seagullpath=<seagullPath>
 * require contain permission list
 * 	seagull/var===777
 * 	seagull/www===777
 */


if (isset($argv) && count($argv) > 1) {
    /*
     * CLI arguments
     * php md5list.php dir=/home/amarin/public_html/seagull_mod/seagull rootpathlist=/home/webpub/release/projectname/verifyLog/rootPathList.txt outputfile=md5_filelist.txt
     */
    array_shift($argv);
    foreach ($argv as $arg) {
        list($key,$value) = explode('=', $arg);
        $conf[$key] = $value;
    }
    
    $seagullPath = isset($conf['seagullpath']) ? $conf['seagullpath'] : '';
    $permlist = isset($conf['permlist']) ? $conf['permlist'] : '';
    resertPerm($seagullpath, $permlist);
} elseif (isset($_GET) && count($_GET)) {
    $seagullpath = isset($_GET['seagullpath']) ? trim($_GET['seagullpath']) : '';
    $permlist = isset($_GET['permlist']) ? trim($_GET['permlist']) : 'perm_dirlist.txt';
    resertPerm($seagullpath, $permlist);
}

function resertPerm($seagullpath = '', $permlist = '')
{
    if (!is_file($permlist)) {
        die('Cannot Found ' . $permlist);
    }
    
    $path = '';
    $perm = '';
    $aPermList = file($permlist);
    if (count($aPermList)) {
        foreach ($aPermList as $line) {
            list($path, $perm) = explode('===', $line);
            if (is_dir($seagullpath . '/' . $path)) {
                chmodFiles($seagullpath . '/' . $path, $perm);
            }
        }
    }

}

function chmodFiles($dest, $mode)
{
    if ( is_dir($dest) && !is_link($dest)) {
        $folder = opendir($dest);
        while ($file = readdir($folder)) {
            if ($file == '.' || $file == '..' ) {
                continue;
            }
            if (is_link($dest . '/' . $file)) {
                continue;
            }

            if (!is_writable($dest . '/' . $file)) {
                continue;
            }
            if (is_dir($dest . '/' . $file)) {
                chmodFiles($dest . '/' . $file, $mode);
            } else {
                if (@chmod($dest . '/' . $file, octdec($mode))) {
                    echo "chmod file  $mode $dest/$file <br/>";
                } else {
                    echo "<b>Cannot chmod file $mode $dest/$file </b><br/>";
                }
            }
        }
        closedir($folder);
    }
    if (!is_link($dest) && is_writable($dest)){
        if(@chmod($dest, octdec($mode))) {
            echo "chmod dir $mode $dest <br/>";
        } else {
            echo "<b>Cannot chmod dir $mode $dest </b><br/>";
        }
    }
    return 1;
}

?>