<?php
/*
 * Generate md5 file list
 */
global $seagullPath;
set_time_limit(36000);

if (isset($argv) && count($argv) > 1) {
    /*
     * CLI arguments
     * php md5list.php dir=/home/amarin/public_html/seagull_mod/seagull rootpathlist=/home/webpub/release/projectname/verifyLog/rootPathList.txt outputfile=md5_filelist.txt
     */
    array_shift($argv);
    foreach ($argv as $arg) {
        list($key,$value) = explode('=', $arg);
        $conf[$key] = $value;
    }
    $seagullPath = isset($conf['dir']) ? $conf['dir'] : '';
    $rootpathfile = isset($conf['rootpathlist']) ? $conf['rootpathlist'] : '';
    $skipVerifyDirListfile = isset($conf['skipverifydirlist']) ? $conf['skipverifydirlist'] : '';
    
    $outputfile = isset($conf['outputfile']) ? $conf['outputfile'] : 'md5_filelist.txt';
    md5structure($seagullPath, $rootpathfile, $skipVerifyDirListfile, $outputfile);
} elseif (isset($_GET) && count($_GET)) {
    /*
     * Post Url
     * md5list.php?dir=/home/amarin/public_html/seagull_mod/seagull&outputfile=md5_filelist.txt
     */
    $seagullPath = isset($_GET['dir']) ? $_GET['dir'] : '';
    $rootpathfile = isset($_GET['rootpathlist']) ? $_GET['rootpathlist'] : '';
    $skipVerifyDirListfile = isset($_GET['skipverifydirlist']) ? $_GET['skipverifydirlist'] : '';
    $outputfile = isset($_GET['outputfile']) ? $_GET['outputfile'] : 'md5_filelist.txt';
    
    md5structure($seagullPath, $rootpathfile, $skipVerifyDirListfile, $outputfile);
}

function md5structure($dir = '', $rootpathfile = '', $skipVerifyDirListfile = '' , $outputfile = '')
{
    $startTime = microtime();
    //rootPathList.txt
    //$aPathList loop it to scan_dir 
    if (is_file($outputfile)) {
        unlink($outputfile);
    }
    
    $aSkipVerifyPathList = array();
    
    if (is_file($skipVerifyDirListfile)) {
        $aSkipVerifyPathList = file($skipVerifyDirListfile);
        sort($aSkipVerifyPathList);
    }
    if (count($aSkipVerifyPathList)) {
        for($i=0;$i<count($aSkipVerifyPathList); $i++){
           $aSkipVerifyPathList[$i] = preg_replace('/\\n/', '', $aSkipVerifyPathList[$i]);;
        }
    }
    
    
    if (is_file($rootpathfile)) {
        $aPathList = file($rootpathfile);
        sort($aPathList);
        foreach($aPathList as $path) {
            $path = preg_replace('/\\n/', '', $path);
            $fullpath = $dir . '/' . $path;
            $countCheck = scan_dir($fullpath, $outputfile, $aSkipVerifyPathList);
        }
    } else {
        $countCheck = scan_dir($dir, $outputfile, $aSkipVerifyPathList);
    }
    $endTime = microtime();
    $distanceTime = $endTime - $startTime;
    echo "md5 all file ($countCheck file) in $dir complete in $distanceTime second.\n";
}

function scan_dir($dir = '', $outputfile = '', $aSkipVerifyPathList = array())
{
    global $countCheck;
    global $seagullPath;
    
    if (is_file($dir) && is_readable($dir)) {
        $handle = fopen($outputfile, 'a');
        $md5file = md5_file($dir);
        $filepath = str_replace($seagullPath, '', $dir);
        $somecontent = "$filepath===$md5file\n";
        fwrite($handle, $somecontent);
        $countCheck++;
        fclose($handle);
        return $countCheck;
    }
     
    if (is_link($dir)) {
       $countCheck++;
       return $countCheck;
   }    
    
    $pathDir = $dir . "/";
    $handle = fopen($outputfile, 'a');
    if (!$handle) {
        die('ERROR :: Cannot open md5current file ' . $outputfile);
    }
    $hd = opendir($pathDir);
    if ($hd) {
        while (($filename = readdir($hd)) !== false) {
            $files[] = $filename;
        }
        if (count($files)) {
            sort($files);
            foreach ($files as $filename) {
                $pathCheck = $pathDir . $filename;
                if ($filename != '.' && $filename != '..' && $filename != '.svn' && $filename != '.project' && $filename != '.projectOptions' && $filename != 'var' && $filename != 'AUTH.txt') {
                    if (is_dir($pathCheck)) {
                        scan_dir($pathCheck, $outputfile, $aSkipVerifyPathList);
                    } else {
                        if (is_link($pathCheck)) {
                            continue;
                        }
                        if (is_file($pathCheck) && is_readable($pathCheck)) {
                            $md5file = md5_file($pathCheck);
                            $filepath = str_replace($seagullPath, '', $pathCheck);
                            if (in_array($filepath , $aSkipVerifyPathList)){
                                continue;
                            }
                            
                            $somecontent = "$filepath===$md5file\n";
                            fwrite($handle, $somecontent);
                            echo '.';
                            $countCheck++;
                        }
                    }
                }
            }
        }
    
        fclose($handle);
        closedir($hd);
        return $countCheck;
    }
}

?>