<?php

define('SGL_PKG_RELEASE_NAME', '1.0.1');
//define('SGL_PKG_RELEASE_NAME', $_SERVER['argv'][2]); //    passed from etc/release.sh
//define('SGL_PKG_TMP_BUILD_DIR', '/tmp/seagull-'.SGL_PKG_RELEASE_NAME);

/**
 * Generation script for PEAR package.xml file.
 * Generates a version 2 package.xml file using the package
 * PEAR_PackageFileManager.
 *
 * @link http://pear.php.net/package/PEAR_PackageFileManager
 *
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license/3_0.txt.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Frameworks
 * @package    Seagull
 * @author     Tobias Schlitt <toby@php.net>
 * @copyright  1997-2005 The PHP Group
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id: Php.php,v 1.5 2005/07/28 16:51:53 cellog Exp $
 * @link       http://www.s9y.org
 */

    /**
     * Package file manager for package.xml 2.
     */
    require_once 'PEAR/PackageFileManager2.php';

    /**
     * Some help functions.
     */
    #require_once 'generate_package_xml_functions.php';

    // Directory where the package files are located.
    //$packagedir  = SGL_PKG_TMP_BUILD_DIR;
    $packagedir  = dirname(__FILE__) . '/../';

    // Name of the channel, this package will be distributed through
    //$channel     = 'pear.phpkitchen.com';
    $channel     = 'pear.php.net';
    

    // Category and name of the package
    $category    = 'Frameworks';
    //$package     = 'Seagull';
    $package     = 'RVSeagullMod';

    $version     = SGL_PKG_RELEASE_NAME;

    // Summary description
    $summary     = <<<EOT
Seagull is a PHP framework (BSD License).
EOT;

    // Longer description
    $description = <<<EOT
Seagull is a PHP application framework with a number of
modules available that deliver CMS functionality.
EOT;

    // License information
    $license = 'BSD';

    // Notes, function to grab them directly from S9Y in
    // generate_package_xml_functions.php
    $notes = <<<EOT
BUGFIXES

IMPROVEMENTS

EOT;

    // Instanciate package file manager
    $pkg = new PEAR_PackageFileManager2();

    // Setting options
    $e = $pkg->setOptions(
        array(
            // Where are our package files.
            'packagedirectory'  => $packagedir,
            'clearcontents'     => true,           // dump any old package.xml content (set false to append release)
            // Where will package files be installed in
            // the local PEAR repository?
            //'baseinstalldir'    => 'Seagull',
            'baseinstalldir'    => 'RVSeagullMod',
            // Where should the package file be generated
            'pathtopackagefile' => $packagedir,
            // Just simple output, no MD5 sums and <provides> tags
            #'simpleoutput'      => true,

            'packagefile'       => 'package2.xml',
            // Use standard file list generator, choose CVS, if you
            // have your code in CVS
            'filelistgenerator' => 'file',

            // List of files to ignore and put not explicitly into the package
            'ignore'            =>
            array(
                'package.xml',
                'package2.xml',
                'generate_package_xml.php',
                'lib/pear/',
                //'modules/',
                'modules/articleweb/',
                'modules/event/',
                'modules/faqweb/',
                'modules/publisher/',
                'modules/mailmanweb/',
                'modules/media/',
                'modules/smfweb/',
                'modules/comment2',
                'modules/simplesite',
                'modules/siteexporter',
                'modules/sitemap',
            
                'var/',
            
                'www/themes/default_admin/',
                'www/themes/savant/',
                'www/themes/smarty/',
                '*tests*',
                '*.svn',
            ),

            // Global mapping of directories to file roles.
            // @see http://pear.php.net/manual/en/guide.migrating.customroles.defining.php
            'dir_roles'         =>
            array(
                'docs' => 'doc',
//                'lib' => 'php',
//                'modules' => 'php',
//                'etc' => 'data',
                'var' => 'data',
                'www' => 'web',
            ),

            'roles'             =>
            array(
                'php' => 'php',
                #'html' => 'web',
                #'png' => 'web',
                #'gif' => 'web',
                #'jpg' => 'web',
                '*' => 'php',
            ),

            // Define exceptions of previously defined role mappings,
            // this part uses real file names and no directories.
            'exceptions'        =>
            array(
                'CHANGELOG.txt' => 'doc',
                'CODING_STANDARDS.txt' => 'doc',
                'README.txt' => 'doc',
                'COPYING.txt' => 'php',
                'INSTALL.txt' => 'doc',
                'VERSION.txt' => 'php',
            ),

            /*'installexceptions' =>
            array(
                'mysql_SGL.php' => 'DB',
                'oci8_SGL.php' => 'DB',
                'maxdb_SGL.php' => 'DB',
                'db2_SGL.php' => 'DB',
                'Tree.php' => 'HTML',
                'WebSGL.php' => 'PEAR/Frontend',
                'RemoteSGL.php' => 'PEAR/Command',
                'RemoteSGL.xml' => 'PEAR/Command',
            ),*/
        )
    );

    // PEAR error checking
    if (PEAR::isError($e)) {
        die($e->getMessage());
    }

    // Set misc package information
    $pkg->setPackage($package);
    $pkg->setSummary($summary);
    $pkg->setDescription($description);
    $pkg->setChannel($channel);

    $pkg->setReleaseStability('beta');
    $pkg->setAPIStability('stable');
    $pkg->setReleaseVersion($version);
    $pkg->setAPIVersion($version);

    $pkg->setLicense($license);
    $pkg->setNotes($notes);

    // Our package contains PHP files (not C extension files)
    $pkg->setPackageType('php');

    // Must be available in new package.xml format
    $pkg->setPhpDep('4.3.0');
    $pkg->setPearinstallerDep('1.4.6');

    // Require custom file role for our web installation
    //$pkg->addPackageDepWithChannel('required', 'Role_Web', 'pearified.com', '1.1.0');

    // Require PEAR_DB package for initializing the database in the post install script
    


    //$pkg->addPackageDepWithChannel('required', 'Archive_Tar', 'pear.php.net', '1.3.2');
    //$pkg->addPackageDepWithChannel('required', 'Archive_Zip', 'pear.php.net', '0.1.1');
    //$pkg->addPackageDepWithChannel('required', 'File_Archive', 'pear.php.net', '1.5.4');
    
    $pkg->addPackageDepWithChannel('required', 'Cache_Lite', 'pear.php.net', '1.5.2');
    $pkg->addPackageDepWithChannel('required', 'Config', 'pear.php.net', '1.10.4');
    $pkg->addPackageDepWithChannel('required', 'DB', 'pear.php.net', '1.7.6');
    $pkg->addPackageDepWithChannel('required', 'DB_DataObject', 'pear.php.net', '1.7.15');
    $pkg->addPackageDepWithChannel('required', 'DB_NestedSet', 'pear.php.net', '1.3.6');
    $pkg->addPackageDepWithChannel('required', 'Date', 'pear.php.net', '1.4.6');
    $pkg->addPackageDepWithChannel('required', 'File', 'pear.php.net', '1.2.2');
    $pkg->addPackageDepWithChannel('required', 'HTML_Common', 'pear.php.net', '1.2.2');
    $pkg->addPackageDepWithChannel('required', 'HTML_QuickForm', 'pear.php.net', '3.2.5');
    $pkg->addPackageDepWithChannel('required', 'HTML_QuickForm_Controller', 'pear.php.net', '1.0.5');
    $pkg->addPackageDepWithChannel('required', 'HTML_Template_Flexy', 'pear.php.net', '1.2.3');
    $pkg->addPackageDepWithChannel('required', 'Log', 'pear.php.net', '1.9.2');
    $pkg->addPackageDepWithChannel('required', 'Mail', 'pear.php.net', '1.1.14');
    $pkg->addPackageDepWithChannel('required', 'Mail_Mime', 'pear.php.net', '1.3.1');
    $pkg->addPackageDepWithChannel('required', 'Net_Socket', 'pear.php.net', '1.0.6');
    $pkg->addPackageDepWithChannel('required', 'Net_Useragent_Detect', 'pear.php.net', '1.2.0');
    $pkg->addPackageDepWithChannel('required', 'Pager', 'pear.php.net', '2.3.4');
    $pkg->addPackageDepWithChannel('required', 'Text_Password', 'pear.php.net', '1.1.0');
    $pkg->addPackageDepWithChannel('required', 'Translation2', 'pear.php.net', '2.0.0beta8');
    $pkg->addPackageDepWithChannel('required', 'Validate', 'pear.php.net', '0.6.2');
    $pkg->addPackageDepWithChannel('required', 'XML_Parser', 'pear.php.net', '1.2.7');
    #$pkg->addPackageDepWithChannel('required', 'XML_Tree', 'pear.php.net', '2.0.0RC2');
    $pkg->addPackageDepWithChannel('required', 'XML_Util', 'pear.php.net', '1.1.1');
    $pkg->addPackageDepWithChannel('required', 'Net_DNS', 'pear.php.net', '1.0.0');
    $pkg->addPackageDepWithChannel('required', 'Net_URL', 'pear.php.net', '1.0.15');
    $pkg->addPackageDepWithChannel('required', 'Text_CAPTCHA', 'pear.php.net', '0.3.1');
    $pkg->addPackageDepWithChannel('required', 'Image_Text', 'pear.php.net', '0.6.0'); 
    


    //  package deps
    //  - default

    //require_once SGL_PKG_TMP_BUILD_DIR . '/modules/default/generatePearPackageXml.php';
    //$pkg->specifySubpackage($default_pkg, $dependency = false/* indicates subpackage */, $required = true);

    //  - navigation
    //require_once SGL_PKG_TMP_BUILD_DIR . '/modules/navigation/generatePearPackageXml.php';
    //$pkg->specifySubpackage($navigation_pkg, $dependency = false/* indicates subpackage */, $required = true);

    //  - user
    //require_once SGL_PKG_TMP_BUILD_DIR . '/modules/user/generatePearPackageXml.php';
    //$pkg->specifySubpackage($user_pkg, $dependency = false/* indicates subpackage */, $required = true);

    //  - publisher
#    require_once SGL_PKG_TMP_BUILD_DIR . '/modules/publisher/generatePearPackageXml.php';
#    $pkg->specifySubpackage($publisher_pkg, $dependency = false/* indicates subpackage */, $required = false);

    // Insert path to our include files into S9Y global configuration
    #$pkg->addReplacement('serendipity_config.inc.php', 'pear-config', '@php_dir@', 'php_dir');

    $pkg->addReplacement('lib/SGL/Task/Init.php', 'pear-config', '@PHP-DIR@',  'php_dir');
    $pkg->addReplacement('lib/SGL/Task/Init.php', 'pear-config', '@DATA-DIR@', 'data_dir');
    //$pkg->addReplacement('lib/SGL/Task/Init.php', 'pear-config', '@WEB-DIR@',  'web_dir');
    //$pkg->addReplacement('lib/SGL/Install/WizardCreateAdminUser.php', 'pear-config', '@WEB-DIR@',  'web_dir');
    $pkg->addReplacement('www/index.php', 'pear-config', '@DATA-DIR@', 'data_dir');
    $pkg->addReplacement('www/index.php', 'pear-config', '@PHP-DIR@',  'php_dir');
    $pkg->addReplacement('www/setup.php', 'pear-config', '@PHP-DIR@',  'php_dir');
    $pkg->addReplacement('www/setup.php', 'pear-config', '@DATA-DIR@', 'data_dir');

      // Define that we will use our custom file role in this script
//    $e = $pkg->addUsesRole('web', 'www');
//    if (PEAR::isError($e)) {
//        die($e->getMessage());
//    }

    // Mapping misc roles to file name extensions
    // Directly here, a dirty hack: Map all files without extension
    // to "doc" role
#    $e = $pkg->addRole('', 'doc');
#    if (PEAR::isError($e)) {
#        die($e->getMessage());
#    }
//    $e = $pkg->addRole('lib', 'doc');
//    if (PEAR::isError($e)) {
//        die($e->getMessage());
//    }
//
//    $e = $pkg->addRole('html', 'web');
//    if (PEAR::isError($e)) {
//        die($e->getMessage());
//    }
//    $e = $pkg->addRole('gif', 'web');
//    if (PEAR::isError($e)) {
//        die($e->getMessage());
//    }
//    $e = $pkg->addRole('jpeg', 'web');
//    if (PEAR::isError($e)) {
//        die($e->getMessage());
//    }

    // Create the current release and add it to the package definition
    $pkg->addRelease();

    // Package release needs a maintainer
    $pkg->addMaintainer('lead', 'demianturner', 'Demian Turner', 'demian@phpkitchen.com');

    // Internally generate the XML for our package.xml (does not perform output!)
    $test = $pkg->generateContents();

    //  get ver 1.0 compatible version
    #$packagexml = &$pkg->exportCompatiblePackageFile1();
    #$packagexml->addMaintainer('lead', 'demianturner', 'Demian Turner', 'demian@phpkitchen.com');
    #$test1 = $packagexml->generateContents();


    // If called without "make" parameter, we just want to debug the generated
    // package.xml file and want to receive additional information on error.

    $e = $pkg->writePackageFile();
    
    if (PEAR::isError($e)) {
        echo $e->getMessage();
    }

?>