<?php

class RVSCOMPODB
{
    /**
     * Returns the 2 letter language code, ie, de for German.
     *
     * @static
     *
     * @access public
     *
     * @return string  language abbreviation
     */
    function getCurrentLang()
    {
        if (is_file(SGL_VAR_DIR . '/rvstemplateconf.ini.php')) {
        	$aTmpConf = parse_ini_file(SGL_VAR_DIR . '/rvstemplateconf.ini.php', true);
        	$currentLang = $aTmpConf['template']['xml_lang'];
        }
        return (isset($currentLang)) ? $currentLang : SGL::getCurrentLang();
    }

    /**
     * Returns current encoding, ie, utf-8.
     *
     * @static
     *
     * @access public
     *
     * @return string  charset codepage
     */
    function getCurrentCharset()
    {
    	if (is_file(SGL_VAR_DIR . '/rvstemplateconf.ini.php')) {
        	$aTmpConf = parse_ini_file(SGL_VAR_DIR . '/rvstemplateconf.ini.php', true);
        	$GLOBALS['_SGL']['CHARSET'] = $aTmpConf['template']['charset'];
        }
        return $GLOBALS['_SGL']['CHARSET'];
        
    }
}

?>