<?php
//  Flexy template settings, include with Flexy Renderer only
define('RV_FLEXY_FORCE_COMPILE',       0);
define('RV_FLEXY_DEBUG',               0);
define('RV_FLEXY_FILTERS',             'SimpleTags');
define('RV_FLEXY_ALLOW_PHP',           true);
define('RV_FLEXY_LOCALE',              'en');
define('RV_FLEXY_COMPILER',            'Flexy');
define('RV_FLEXY_VALID_FNS',           'include');
define('RVL_FLEXY_GLOBAL_FNS',          true);
define('RV_FLEXY_IGNORE',              0); //  don't parse forms when set to true

class RVFlexyStrategy extends SGL_OutputRendererStrategy
{
    function RVFlexyStrategy(&$data, $templateEngine = null)
    {
    }   
    
    function render(/*SGL_View*/ &$data)
    {
        //  prepare flexy object
        require_once 'HTML/Template/Flexy.php';
        $flexy = $this->initEngine($data);

        $masterTemplate = isset($data->masterTemplate) ? $data->masterTemplate : 'index.tpl';

        $ok = $flexy->compile($masterTemplate);

        //  if some Flexy 'elements' exist in the output object, send them as
        //  2nd arg to Flexy::bufferedOutputObject()
        $elements = (   isset($data->flexyElements) && is_array($data->flexyElements)) ? $data->flexyElements
            : array();
        $data = $flexy->bufferedOutputObject($data, $elements);
        return $data;
    }
    
    function initEngine(&$data)
    {
        //  initialise template engine
        $options = &PEAR::getStaticProperty('HTML_Template_Flexy','options');
        if (!isset($data->theme)) {
            $data->theme = 'default';
        }

        $options = array(
                                   // the current module's templates dir from the custom theme
            'templateDir'       =>  SGL_MOD_DIR . '/default/templates'. PATH_SEPARATOR . SGL_THEME_DIR . '/rvtheme/default'. PATH_SEPARATOR . $data->componenThemePath,
                            //       
                                   // the default template dir from the default theme
                           //        SGL_MOD_DIR . '/default/templates',
                           
           // 'templateDirOrder'  => 'reverse',
            'multiSource'       => true,
            'compileDir'        => SGL_CACHE_DIR . '/tmpl/' . $data->componentName,
            'forceCompile'      => RV_FLEXY_FORCE_COMPILE,
            'debug'             => RV_FLEXY_DEBUG,
            'allowPHP'          => RV_FLEXY_ALLOW_PHP,
            'filters'           => RV_FLEXY_FILTERS,
            'locale'            => RV_FLEXY_LOCALE,
            'compiler'          => RV_FLEXY_COMPILER,
            'valid_functions'   => RV_FLEXY_VALID_FNS,
            'flexyIgnore'       => RV_FLEXY_IGNORE,
            'globals'           => true,
            'globalfunctions'   => RV_FLEXY_GLOBAL_FNS,
        );

        $ok = $this->setupPlugins($data, $options);
        $flexy = & new HTML_Template_Flexy();
        return $flexy;
    }
    
  function setupPlugins(&$data, &$options)
    {
        //  Configure Flexy to use SGL ModuleOutput Plugin
        //   If an Output.php file exists in module's dir
        $className = sprintf('%sComponentOutput', ($data->componentName) ? ucfirst($data->componentName) : 'Rvs');
        $customOutput = $data->componenPath . '/' . $className . '.php';
        if (is_readable($customOutput)) {
            if (isset($options['plugins'])) {
                $options['plugins'] = $options['plugins'] + array($className => $customOutput);
            } else {
                $options['plugins'] = array($className => $customOutput);
            }
        }
        return true;
    }
}

?>