<?php
require_once('RvPublishXmlTask.php');

class RVxmlParser{
    var $xml_obj = null;
    var $debug =0;
    var $output = array();
    var $errorDebug = true;
    var $outputXMLError =0;
    var $aProcessOutput = array();
    var $attrs;
    var $child = 0;
    var $TaskType = 0;
    var $sockCode = '';
    var $afterSockCode = '';
    var $oTask;
    var $aAssign = array();
    var $mapProcess = 0;
    
    function RVxmlParser()
    {
        $this->xml_obj = xml_parser_create();
        xml_set_object($this->xml_obj,$this);
        xml_set_character_data_handler($this->xml_obj, 'dataHandler');
        xml_set_element_handler($this->xml_obj, "startHandler", "endHandler");
        @register_shutdown_function(array(&$this->xml_obj, "destructor"));
      // xml_parser_free($this->xml_obj);
    }

    function &singleton($autoLoad = true)
    {
        static $instance;
        if (!isset($instance) || $autoLoad == false) {
            $class = __CLASS__;
            $instance = new $class($autoLoad);
        }
        return $instance;
    }
    
    /**
     * parse
     *
     * @param string $path = url
     * @return true
     */
    function parse($path)
    {
        if (!($fp = fopen($path, "r"))) {
            if ($this->errorDebug) {
                //Cannot open XML data file:
                $this->outputXMLError = sprintf("echo '::error:: Cannot open XML data file:%s::';", $path);
                die($this->outputXMLError);
            }
            return false;
        }
         while ($data = fread($fp, 4096)) {
             if (!xml_parse($this->xml_obj, $data, feof($fp))) {
                 $this->outputXMLError= sprintf("echo '::error:: error xml %s at line %d file:%s::';",
                 xml_error_string(xml_get_error_code($this->xml_obj)),
                 xml_get_current_line_number($this->xml_obj),
                 $path);
                 xml_parser_free($this->xml_obj);
                 xml_get_error_code($this->xml_obj);      
                 if ($this->errorDebug) {             
                   die($this->outputXMLError);
                 }
             }
         }
        //print_r($this->xml_obj);
        
       // return true;
    }

    /**
     * startHandler
     *
     * @param string $parser
     * @param string $name
     * @param string $attribs
     * assign to this->output
     */
    function startHandler($parser, $name, $attribs)
    {
        $_content = array();
        $_content['name'] = $name;
        if(!empty($attribs))
        $_content['attrs'] = $attribs;
        array_push($this->output, $_content);
    }
    
    /**
     * dataHandler
     *
     * @param string $parser
     * @param array $$data
     * assign to this->output
     */
    function dataHandler($parser, $data){
        if (!empty($data) && $data!="\n") {
            $_output_idx = count($this->output) - 1;
            $this->output[$_output_idx]['content'] .= $data;
        }
    }

    /**
     * endHandler
     *
     * @param string $parser
     * @param string $name
     * assign to this->output
     */
    function endHandler($parser, $name)
    {
        if (count($this->output) > 1) {
            $_data = array_pop($this->output);
            $_output_idx = count($this->output) - 1;
            $add = array();
            if(!$this->output[$_output_idx]['child'])
            $this->output[$_output_idx]['child'] = array();
            array_push($this->output[$_output_idx]['child'], $_data);
        }
    }
    ////////////////////////////////
    //
    ///////////////////////////////

    /**
     * debug
     * run debug
     * @param string $msg
     * assign to this->debug
     */
    function debug($msg)
    {
        if ($this->debug) {
            echo 'DEBUG : ' . $msg ."<br />\n";
        }
    }
    /**
     * execute()
     *set array this->output to string php function 
     * 
     * @return array
     */
    function execute()
    {
        $aCode = array();
        $aChildData = array();
       if (is_array($this->output) ) {
           if ($this->output[0]['name'] == 'RVSITEBUILDER') {
               $i = 0;
               foreach ($this->output[0]['child'] as $k) {
                   $activeCode = false;

                   switch (strtolower($k['name'])) {
                       case 'preseagull':
                           $this->TaskType = 'preseagull';
                           $this->mapProcess = 'preseagull';
                           $activeCode = true;
                           break;
                       case 'postseagull':
                           $this->TaskType = 'postseagull';
                           $this->mapProcess = 'postseagull';
                           $activeCode = true;
                           break;
                       case 'validate':
                           $this->TaskType = 'validate';
                           $this->mapProcess = 'validate';
                           $activeCode = true;
                           break;
                   }
                   if ($activeCode == true) {
                       $this->debug("Task is " . $this->TaskType);
                       $aReturnExecute[$i] = $this->_complieCode($k['child']);
                   }
                   $i++;
               }
           }else {
               $aReturnExecute = false;
           }
       }else {
           $aReturnExecute = false;
       }
       return $aReturnExecute;
    }
    /**
     * _complieCode
     *
     * @param array $aChildData
     * @return array
     */
    function _complieCode($aChildData = array())
    {
        $aCodes = array();
        
        $aCodes = $this->buildTask($aChildData);
        return $aCodes;
    }
    /**
     * buildSockData
     *
     * @param array $dataCode
     */
    function buildSockData($dataCode)
    {
        print "<pre>";
        echo "<br />\n" . htmlspecialchars($dataCode); echo "<br />\n";
    }
    
    /**
     * getChild
     *
     * @return array
     */
    function getChild()
    {
        $oTask = RvPublishXmlTask::singleton($this->mapProcess,ture);
        return $oTask->getChildID();
    }
    
    /*
     * output 
     * $sockCode
     * $afterSockCode
     */
    function buildTask($aTask = array())
    {
        $oTask = RvPublishXmlTask::singleton($this->mapProcess,ture);
        $oTask->incrementChildID();
        $oTask->mapProcess = $this->mapProcess;
        foreach ($aTask as $k) {
            $this->debug('Compile Tag ' . $k['name'] . ', Child ' . $oTask->getChildID());
            $taskName = strtolower($k['name']);
            if ($oTask->aTagsMapping[$taskName]) {
                $this->debug('Call to compile ' . $k['name']);
                
                $codeCompiled = $oTask->buildRvPublishXmlTask($taskName,$k);
                $codeResult['sock'] .= $codeCompiled['sock'];
                $codeResult['afterSock'] .= $codeCompiled['afterSock'];
            }
        }
        $oTask->decrementChildID();
        return $codeResult;
    }
    
    /**
     * calltag
     *
     * @param string $taskName
     * @param array $k
     * @return object
     */
    function calltag($taskName,$k)
    {
        $oTask = RvPublishXmlTask::singleton($this->mapProcess,ture);
        $this->debug('Call Tag ' . $taskName . ', Child ' . $oTask->getChild());
        return $oTask->buildRvPublishXmlTask($taskName,$k);
    }
}



?>
