<?php
class RvPublishXmlTask extends RVxmlParser
{
    var $mapProcess ;
    var $oTag = array();
    var $aMapProcess = array();
    var $aTagsMapping = array();
    var $aProcessOutput = array();
    var $sockCode = '';
    var $xmlMgr = 0; 
    var $childID = 0;
    var $aAssign =array();
    /**
     * RvPublishXmlTask
     *
     * @param string $mapProcess = validate,preseaull,postseaqull
     * load class XmlTaskCommon ,XmlTaskValidate ,XmlTaskProcess
     * set this->aTagsMapping 
     * @return RvPublishXmlTask
     */
    
    function RvPublishXmlTask()
    {
       require_once('XmlTaskCommon.php');
        $this->oTag['common'] = new XmlTaskCommon();
        if ($this->mapProcess) {
            $this->registeProcess();
        }
    }
    
    function registeProcess()
    {
        if ($this->mapProcess == 'validate') {
            require_once('XmlTaskValidate.php');
            $this->oTag['validate'] = new XmlTaskValidate();

        }
        elseif ($this->mapProcess== 'preseagull' || $this->mapProcess == 'postseagull' ) {
            require_once('XmlTaskProcess.php');
            $this->oTag['process'] = new XmlTaskProcess();
        }
        
        foreach ($this->oTag as $kTag => $vTag) { 
            foreach ($vTag->aTagsMapping as $k => $v) {
                $this->aTagsMapping[$k] = array($kTag, $v[0]);
            }
        }

    }
    
    function &singleton($mapProcess, $autoLoad = true)
    {
        static $instance;
        if (!isset($instance) || $autoLoad == false) {
            $class = __CLASS__;
            $instance = new $class($autoLoad);
            $instance->mapProcess = $mapProcess;
            $instance->registeProcess();
            //$this->mapProcess = $instance->mapProcess;
           
        }
        return $instance;
    }
/**
 * buildRvPublishXmlTask =API run classXmlTaskCommon ,validate ,process  into function tag 
 *
 * @param string $taskName = tag echo , if , inget , ...
 * @param array $aData = dataXML
 * and run class
 * @return string
 */
    function buildRvPublishXmlTask($taskName ,$aData=array())
    {
        $this->debug('$this->oTag['.$this->aTagsMapping[$taskName][0].']->{'.$this->aTagsMapping[$taskName][1].'}($aData);');
       //echo '$this->oTag['.$this->aTagsMapping[$taskName][0].']->{'.$this->aTagsMapping[$taskName][1].'}($aData);';
        return $this->oTag[$this->aTagsMapping[$taskName][0]]->{$this->aTagsMapping[$taskName][1]}($aData);
    }
    /**
     * Enter _compiledAssingValue 
     *
     * @param string $data
     * @param true/false $insertQuote
     * @return strint
     */
    
    function _compiledAssingValue($data = '', $insertQuote = true)
    {
    	//echo 'Assing--->' . $data .'<hr>';
        if (preg_match_all('#\${(.*?)}#', $data, $aMatch)) {
            foreach ($aMatch[1] as $index => $var) {
               // print "$index => $var<br>\n";

                for ($i=$this->getChild(); $i>=0; $i--) {
                     // print_r($this->aAssign);
                    if (isset($this->aAssign[$i][$var])) {
                       // echo"------->" . $i;
                       //echo'in loop';
                       //echo '---->' . $this->aAssign[$i][$var];
                       //echo'<hr>';
                        $data = str_replace($aMatch[0][$index], sprintf('%s%s%s',($insertQuote) ? "'." : '', '$aAssign' . $i . "['$var']", ($insertQuote) ? ".'" : ''), $data);
                        break;
                    }
                }
            }
        }

        return $data;
    }
    
    function _compiledAssingSqlValue($data = '', $insertQuote = true)
    {
    	//echo 'Assing--->' . $data .'<hr>';
        if (preg_match_all('#\${(.*?)}#', $data, $aMatch)) {
            foreach ($aMatch[1] as $index => $var) {
               // print "$index => $var<br>\n";

                for ($i=$this->getChild(); $i>=0; $i--) {
                     // print_r($this->aAssign);
                    if (isset($this->aAssign[$i][$var])) {
                       // echo"------->" . $i;
                       //echo'in loop';
                       //echo '---->' . $this->aAssign[$i][$var];
                       //echo'<hr>';
                        $data = str_replace($aMatch[0][$index], sprintf('%s%s%s',($insertQuote) ? "'." : '', '$aAssign' . $i . "['$var']", ($insertQuote) ? ".'" : ''), $data);
                        break;
                    }
                }
            }
        }

        return $data;
    }
    
    /**
     * compiledOperators
     *
     * @param string $data
     * @return string
     */
    function compiledOperators($data ='')
    {
        $format = array(
        'eq' => '==',
        'ne' => '<>',
        'gt' => '>',
        'lt' => '<',
        'ge' => '>=',
        'le' => '<=',
        'and' => ' && ',
        'or' => ' || ',
        );
        if (preg_match_all('#\[(.*?)\]#', $data, $aMatch)) {
            foreach ($aMatch[1] as $index => $code) {
                if (isset($format[$code])) {
                    $data = str_replace($aMatch[0][$index], $format[$code], $data);
                }
            }
            return $data;
        }
        else {
            return $data;
        }
    }
    
    
    /**
     * _getAssignValue
     *
     * @param string $data
     * @return string
     */
    function _getAssignValue($data = '')
    {
        $format = array(
        'ENV' => array('$', '_', '[', ']'),
        'SERVER' => array('$', '_', '[', ']'),
        'SESSION' => array('$', '_', '[', ']'),
        'INI_GET' => array('', '', '(', ')'),
        'PHPVERSION' => array('', '', '(', ')'),
        'EXTENSION_LOADED' => array('', '', '(', ')'),
        );
       // print_r($data);
        if (preg_match_all('#\$\{(ENV|SERVER|SESSION|INI_GET|PHPVERSION|EXTENSION_LOADED)\[(.*?)\]}#', $data, $aMatch)) {
            foreach ($aMatch[1] as $index => $code) {
                $setEval = sprintf('$setvar= %s%s%s%s\'%s\'%s;',
                $format[$code][0],
                $format[$code][1],
                $code,
                $format[$code][2],
                $aMatch[2][$index],
                $format[$code][3]
                );
                echo$setEval;
                echo"=========================";
                eval($setEval);
                $data = str_replace($aMatch[0][$index], $setvar, $data);
            }
            //echo$data;
            return $data;
        }
        else {
            return $data;
        }
    }
    
    
    /**
     * registerPatturn 
     *
     * @param string $inPattern
     * @return string
     */
    function registerPatturn($inPattern)
    {
        $aP = array(
        '#\^#i' => '\^',
        '#\$#i' => '\$',
        '#\(#i' => '\(',
        '#\)#i' => '\)',
        '#\{#i' => '\{',
        '#\}#i' => '\}',
        '#\|#i' => '\|',
        '#\/#i' => '\/',
        '#\+#i' => '\+',
        '#\-#i' => '\-',
        '#\.#i' => '\.',
        '#\?#i' => '\?',
        '#\*#i' => '\*',
        '#\[#i' => '\[',
        '#\]#i' => '\]',
        '#\<#i' => '\<',
        '#\>#i' => '\>',
        );
        if (count($this->aPatt) != count(array_keys($aP)) ) {
            foreach ($aP as $k => $v) {
                array_push($this->aPatt, $k);
                array_push($this->aRepl, $v);
            }
        }
        return preg_replace($this->aPatt, $this->aRepl, $inPattern);
    }

    /**
     * getChildID
     *
     * @return $this->childID
     */
    function getChildID()
    {
        return $this->childID;
    }
    
     /**
     * incrementChildID
     *
     * @return $this->childID
     */
    function incrementChildID()
    {
        $this->childID++;
    }
    
     /**
     * decrementChildID
     *
     * @return $this->childID
     */
    function decrementChildID()
    {
        $this->childID--;
    }
    function strReplace($req)
    {
        $order = array('m','M');
        $req = str_replace($order,'',$req);
        return $req;
    }
}
?>