<?php
class XmlTaskCommon extends RvPublishXmlTask
{
    var $aTagsMapping = array();
    function XmlTaskCommon()
    {
         $this->aTagsMapping = array(
            'echo' => array('Tag_Echo'),
            'writeln' => array('Tag_Writeln'),
            'assign' => array('Tag_Assign'),
            'if' => array('Tag_If'),
            'isfile' => array('Tag_isFile'),
            'isdir' => array('Tag_isDir'),
			'getsglconf' => array('Tag_getsglconf'),
			'sqlcommand' => array('Tag_sqlcommand'),
        );
    }
   
    function &singleton($autoLoad = true)
    {
        static $instance;
        if (!isset($instance)) {
            $class = __CLASS__;
            $instance = new $class($autoLoad);
        }
        return $instance;
    }
    
    /**
     * Tag_Echo
     * set xml echo to php function
     * @param array $aData
     * @return array
     */
    function Tag_Echo($aData = array())
    {
        $endLine = (!$aData['attrs']['NOLINE']) ? "\n" : '';
        $result = '';
        
        if (!isset($aData['attrs']['EVENT']) ||!$aData['attrs']['EVENT']) {
            $aData['attrs']['STATUS'] = 'show';
        }
        
        if (isset($aData['attrs']['MESSAGE'])) {
            $result .= sprintf('echo(\'::%s::%s::\'."%s");',$aData['attrs']['EVENT'] , $this->registerQuote($this->_compiledAssingValue($aData['attrs']['MESSAGE'])) ,  $this->registerQuote($endLine));
           //echo'tagecho--->' . $aData['attrs']['MESSAGE'];
          // echo'<hr>';
        }
        
        if (is_array($aData['child'])) {
            //$res = $this->buildTask($aData['child']);
            
        }
        else if (isset($aData['content'])) {
            $result .= sprintf('echo(\'::%s::%s::\'."%s");' , $aData['attrs']['EVENT'] ,  $this->registerQuote($this->_compiledAssingValue($aData['content'])) , $this->registerQuote($endLine));
        }
        $r['afterSock'] = $result;//echo $result;
        return $r;
    }

    /**
     * Tag_Writeln
     *
     * @return array
     */
    function Tag_Writeln()
    {
        return array('afterSock' => 'echo("\n");');
    }
    
    /**
     * Tag_If
     * set tagXml to phpfunction  
     * @param array $aData
     * @return array
     */
    function Tag_If($aData = array())
    {
        $result = '';
        $sock = '';
        if (isset($aData['attrs']['EXPRESSION'])) {
           $compildedAssingVal = $this->_compiledAssingValue($aData['attrs']['EXPRESSION'], false);
           $compiledOperators = $this->compiledOperators($compildedAssingVal);
            $result .= sprintf('if(%s){', $compiledOperators);
        }
        if (is_array($aData['child'])) {
            $subresult = $this->buildTask($aData['child']);
            $result .= $subresult['afterSock'];
            $sock .= $subresult['sock'];
        }
        if (isset($aData['attrs']['EXPRESSION'])) {
            $result .= '}';
        }
        return array('sock' => $sock, 'afterSock' => $result);
    }
    
    /**
     * Tag_Assign
     *
     * @param array $aData
     * set tagXML to php function = var $xxx = '';
     * 
     * @return array
     */
    function Tag_Assign($aData = array())
    {
        $result = '';
        if (isset($aData['attrs']['VAR'])) {

            $this->aAssign[$this->getChild()][$aData['attrs']['VAR']] = $this->_getAssignValue($aData['attrs']['VALUE']);
            $result .= sprintf('$aAssign%s[\'%s\']=\'%s\';', $this->getChild(), $aData['attrs']['VAR'], $this->_getAssignValue($aData['attrs']['VALUE']));
        }
        if (is_array($aData['child'])) {
            $result .= $this->buildTask($aData['child']);
            unset($this->aAssign[$this->getChild()][$aData['attrs']['VAR']]);
            $result .= sprintf('unset($aAssign%s[\'%s\']);', $this->getChild(), $aData['attrs']['VAR']);
        }
        return array('afterSock' => $result);
    }

    /**
     * function is_file()
     * 
     * @author siwakorn
     * @param <array> $aData
     * @return <string>
     */
    function Tag_isFile($aData = array())
    {
        $result = '';
        $defaultPath = $this->_getHomeSession();
        $checkFileData = preg_replace('#(.*?)\../(.*?)# ','',$aData['attrs']['FILE']);
        $fileData = $defaultPath . '/' . $checkFileData;
        if ($checkFileData == '' || $defaultPath == '') {
            $fileData = false;
        }
        
        if(isset($aData['attrs']['ASSIGN'])) {
            $this->calltag('assign',array('name' => 'ASSIGN','attrs' => array('VAR' => $aData['attrs']['ASSIGN'],'VALUE' => '$inSock[\'' . $aData['attrs']['PARAM'] . '\']')));
            $generateWirteCode = sprintf('$aAssign%s[\'%s\'] = (is_file(\'%s\')) ? 1 : 0;' , $this->getChild() , $aData['attrs']['ASSIGN'],  $fileData);
            $result['afterSock'] = $generateWirteCode . "\n";
        }
        return $result;
    }
    
    
    /**
     * function is_dir()
     *
     * @author siwakorn
     * @param <array> $aData
     * @return <string>
     */
    function Tag_isDir($aData = array())
    {
        $result = '';
        $defaultPath = $this->_getHomeSession();
        $checkPathData = preg_replace('#(.*?)\../(.*?)# ','',$aData['attrs']['PATH']);
        $pathData = $defaultPath . '/' . $checkPathData;
        if ($checkPathData == '' || $defaultPath == '') {
            $pathData = false;
        }
        
        if(isset($aData['attrs']['ASSIGN'])) {
            $this->calltag('assign',array('name' => 'ASSIGN','attrs' => array('VAR' => $aData['attrs']['ASSIGN'],'VALUE' => '$inSock[\'' . $aData['attrs']['PARAM'] . '\']')));
            $generateWirteCode = sprintf('$aAssign%s[\'%s\'] = (is_dir(\'%s\')) ? 1 : 0;' , $this->getChild() , $aData['attrs']['ASSIGN'],  $pathData);
            $result['afterSock'] = $generateWirteCode . "\n";
        }
        return $result;
    }
    
    
    function Tag_getsglconf($aData = array()){
    	//echo'<pre>';
    	//print_r($aData);
    	$result = array();
    	//$c = &SGL_Config::singleton();
    	//$conf = $c->getAll();
    	if(isset($aData['attrs']['PARAM'])) {
    		if (preg_match('/\{SGL_BASE_URL\}/', $aData['attrs']['PARAM'] ,$aMatch)) {
    			$dbType = SGL_BASE_URL;
    			
    		} else {
    			$dbType = SGL_Config::get($aData['attrs']['PARAM']);
    		}
    	}

    	if(isset($aData['attrs']['ASSIGN'])) {
    		$this->calltag('assign', array('name' => 'ASSIGN', 'attrs' => array('VAR' => $aData['attrs']['ASSIGN'] , 'VALUE' => $dbType)));
    		$generateWirteCode .= sprintf('$aAssign%s[\'%s\'] = "%s";' , $this->getChild() ,   $aData['attrs']['ASSIGN'] , $dbType);
    	}
    	$result['afterSock'] = $generateWirteCode . "\n";
    	return $result;

    }

    function Tag_sqlcommand($aData = array()){
    	$result = array();
    	if (isset($aData['content'])) {
    		$sqlData = sprintf(
    			'$db = & SGL_DB::singleton();$query =\'%s\';$res = $db->query($query);if (is_a($res, \'PEAR_Error\')) { echo\'::error::SQL query error::\';} ;', 
    			$this->_compiledAssingSqlValue($aData['content'], true));
    	}
    	//result = $this->dbh->query($query);
    	
    	$result['afterSock'] = $sqlData . "\n";
    	return $result;
    }

    /**
    * get session homepath
    *
    * @return <string> home path
    **/
    function _getHomeSession()
    {
        $aSessionPublishDB = SGL_Session::get('RVS_PUBLISH_COMPONENTDB');
        return $aSessionPublishDB['HomePath'];
    }
    
    
    function registerQuote($inPattern)
    {
        $aP = array(
        '#\"#i' => '\"',
        '#\n#i' => '\n',
        );
        $aPatt = array();
        $aRepl = array();
        foreach ($aP as $k => $v) {
            array_push($aPatt, $k);
            array_push($aRepl, $v);
        }
        return preg_replace($aPatt, $aRepl, $inPattern);
    }
    
    
    /**
     * chmod file or directory in process xml
     *
     * @param <array> $aPerData
     * @param <array> $aXmlError
     * @return <array> $aXmlError
     */
    function processChmodXML($aPerData,$aXmlError)
    {
        $path = $aPerData['attrs']['PATH'];
        $mode = octdec($aPerData['attrs']['MODE']);

        if (is_file($path) || is_dir($path)) {
            if(!chmod($path,$mode)){
                $aXmlError['chmod_permission'] = 'can not chmod file';
            }
            
        } else {
           $aXmlError['chmod_permission'] = 'file or directory is not an alias';
        }
        return $aXmlError;
    }
    
    /**
     * process tag fwrite
     *
     * @param <array> $aPerData
     * @param <array> $aXmlError
     * @return <array> $aXmlError
     */
    function processFwriteXML($aPerData,$aXmlError)
    {
        $fileWrite = $aPerData['attrs']['HANDLE'];
        $mode = $aPerData['attrs']['MODE'];
        $content = $aPerData['content'];
        
        if (is_file($fileWrite)) {
            $fp = fopen($fileWrite, $mode);
            fwrite($fp, $content);
        } else {
            $fp = fopen($fileWrite, 'w+');
            fwrite($fp, $content);
        }
        
        fclose($fp);
        return $aXmlError;
    }
    
    
    function processCopyFileXML($aPerData,$aXmlError)
    {
        
    }
    
    /**
     * validate permission form xml run preinstall
     *
     * @param <string> $path
     * @return <true / false>
     */
    function validatePermissionXML($aData)
    {
        foreach ($aData['child'] as $kChild => $vChild) {
            
            if (!is_dir($vChild['attrs']['PATH']) && !is_file($vChild['attrs']['PATH'])) {
                return array('error' => 1);
            }

            if ($vChild['name'] == 'PERMISSION') {
                $aReturnData[$kChild]['WRITABLE'] = $this->checkPathWritable($vChild['attrs']['WRITABLE'], $vChild['attrs']['PATH']);
                $aReturnData[$kChild]['READABLE'] = $this->checkPathReadable($vChild['attrs']['READABLE'], $vChild['attrs']['PATH']);
                $aReturnData[$kChild]['EXEC'] = $this->checkPathExecutable($vChild['attrs']['EXEC'], $vChild['attrs']['PATH']);
                $aReturnData[$kChild]['PATH'] = $vChild['attrs']['PATH'];
            }
        }
        return $aReturnData;
    }
    /*
    function Tag_sqlcommand($aData = array()){
    	$result = array();
    	if (isset($aData['content'])) {
    		//$sqlData = $this->registerQuote($this->_compiledAssingValue($aData['content']));
    		$sqlData = $this->_compiledAssingValue($aData['content'], false);
    	}
    	echo $sqlData;
    }
*/
    /**
     * Enter description here...
     *
     * @param unknown_type $writableConf
     * @param unknown_type $path
     * @return unknown
     */
    function checkPathWritable($writableConf, $path)
    {
        if ($writableConf == '1') {
            return  (is_writable($path)) ? true : false;
        } else {
            return  (is_writable($path)) ? false : true;
        }
    }
    
    /**
     * Enter description here...
     *
     * @param unknown_type $readableConf
     * @param unknown_type $path
     * @return unknown
     */
    function checkPathReadable($readableConf, $path)
    {
        if ($readableConf == '1') {
            return (is_readable($path)) ? true : false;
        } else {
            return (is_readable($path)) ? false : true;
        }
    }
    
    /**
     * Enter description here...
     *
     * @param unknown_type $executableConf
     * @param unknown_type $path
     * @return unknown
     */
    function checkPathExecutable($executableConf, $path)
    {
        if ($executableConf == '1') {
            return (is_executable($path)) ? true : false;
        } else {
            return (is_executable($path)) ? false : true;
        }
    }
}


?>