<?php
class XmlTaskValidate extends RvPublishXmlTask
{
    var $aTagsMapping = array();
    var $sockXML = array();
    function XmlTaskValidate()
    {
         $this->aTagsMapping = array(
        'phpversion' => array('Tag_phpversion'),
        'iniget' => array('Tag_iniget'),
        'extensionloaded' => array('Tag_extensionloaded'),
        'funcexists' => array('Tag_funcexists'),
        );
    }

    function &singleton($autoLoad = true)
    {
        static $instance;
        if (!isset($instance)) {
            $class = __CLASS__;
            $instance = new $class($autoLoad);
        }
        return $instance;
    }
    /**
     *Tag_iniget
     *
     * @param array $aData
     * set tagXml to php function and array[sock]
     *  
     * @return array
     */
    
    function Tag_iniget($aData = array())
    {
        $result = array();
        if(isset($aData['attrs']['PARAM'])) {
            $generateCode = sprintf('<?php echo \'%s =\' . ini_get(\'%s\') ."\n" ; ?>' , $aData['attrs']['PARAM'] , $aData['attrs']['PARAM']);
            $result['sock'] = $generateCode;
        }

        if(isset($aData['attrs']['ASSIGN'])) {
            $this->calltag('assign',array('name' => 'ASSIGN','attrs' => array('VAR' => $aData['attrs']['ASSIGN'],'VALUE' => '$inSock[\'' . $aData['attrs']['PARAM'] . '\']')));
            $generateWirteCode = sprintf('$aAssign%s[\'%s\'] = $inSock[\'%s\'];', $this->getChild() , $aData['attrs']['ASSIGN'],  $aData['attrs']['PARAM']);
            $result['afterSock'] = $generateWirteCode . "\n";
        }
        return $result;
    }
    
     /**
     *Tag_extensionloaded
     *
     * @param array $aData
     * set tagXml to php function and array[sock]
     *  
     * @return array
     */
    function Tag_extensionloaded($aData = array())
    {
      $result = array();
        if(isset($aData['attrs']['PARAM'])) {
            $generateCode = sprintf('<?php echo \'%s = \' . extension_loaded(\'%s\') . "\n"; ?>' , $aData['attrs']['PARAM'] , $aData['attrs']['PARAM']);
            $result['sock'] = $generateCode;
        }

        if(isset($aData['attrs']['ASSIGN'])) {
            $this->calltag('assign', array('name' => 'ASSIGN', 'attrs' => array('VAR' => $aData['attrs']['ASSIGN'], 'VALUE' => '$inSock[\'' . $aData['attrs']['PARAM'] . '\']')));
            $generateWirteCode = sprintf('$aAssign%s[\'%s\'] = $inSock[\'%s\'];' , $this->getChild() , $aData['attrs']['ASSIGN'] ,  $aData['attrs']['PARAM']);
            $result['afterSock'] = $generateWirteCode . "\n";
        }
        return $result;
    }
    
     /**
     *Tag_phpversion
     *
     * @param array $aData
     * set tagXml to php function and array[sock]
     *  
     * @return array
     */
    function Tag_phpversion($aData = array())
    {
        $result = array();

            $result['sock'] = '<?php echo \'phpversion = \' . phpversion() . "\n"; ?>';


        if(isset($aData['attrs']['ASSIGN'])) {
            $this->calltag('assign', array('name' => 'ASSIGN', 'attrs' => array('VAR' => $aData['attrs']['ASSIGN'], 'VALUE' => '$inSock[\'phpversion\']')));
            $generateWirteCode = sprintf('$aAssign%s[\'%s\'] = $inSock[\'phpversion\'];' , $this->getChild() , $aData['attrs']['ASSIGN']);
            $result['afterSock'] = $generateWirteCode . "\n";
        }
        return $result;
    }
         /**
     *Tag_funcexists
     *
     * @param array $aData
     * set tagXml to php function and array[sock]
     * $aData['attrs']['PARAM'] = arrir xml <funcexitsts PARAM='sssss'>
     *  
     * @return array
     */
    function Tag_funcexists($aData = array())
    {
      $result = array();
        if(isset($aData['attrs']['PARAM'])) {
            $generateCode = sprintf('%s = <?php echo \'%s = \' . function_exists(\'%s\') . "\n"; ?>', $aData['attrs']['PARAM'] , $aData['attrs']['PARAM']);
            $result['sock'] = $generateCode;
        }

        if(isset($aData['attrs']['ASSIGN'])) {
            $this->calltag('assign', array('name' => 'ASSIGN', 'attrs' => array('VAR' => $aData['attrs']['ASSIGN'], 'VALUE' => '$inSock[\'' . $aData['attrs']['PARAM'] . '\']')));
            $generateWirteCode = sprintf('$aAssign%s[\'%s\']= $inSock[\'%s\'];' , $this->getChild() , $aData['attrs']['ASSIGN'] ,  $aData['attrs']['PARAM']);
            $result['afterSock'] = $generateWirteCode . "\n";
        }
        return $result;
    }

}


?>