<?php
/* Reminder: always indent with 4 spaces (no tabs). */
// +---------------------------------------------------------------------------+
// WebSite:  http://www.rvglobalsoft.com
// Unauthorized copying is strictly forbidden and may result in severe legal action.
// Copyright (c) 2006 RV Global Soft Co.,Ltd. All rights reserved.
// 
// =====YOU MUST KEEP THIS COPYRIGHTS NOTICE INTACT AND CAN NOT BE REMOVE =======
// Copyright (c) 2006 RV Global Soft Co.,Ltd. All rights reserved.
// This Agreement is a legal contract, which specifies the terms of the license
// and warranty limitation between you and RV Global Soft Co.,Ltd. and RV Site Builder.
// You should carefully read the following terms and conditions before
// installing or using this software.  Unless you have a different license
// agreement obtained from RV Global Soft Co.,Ltd., installation or use of this software
// indicates your acceptance of the license and warranty limitation terms
// contained in this Agreement. If you do not agree to the terms of this
// Agreement, promptly delete and destroy all copies of the Software.
//
// =====  Grant of License =======
// The Software may only be installed and used on a single host machine.
//
// =====  Disclaimer of Warranty =======
// THIS SOFTWARE AND ACCOMPANYING DOCUMENTATION ARE PROVIDED "AS IS" AND
// WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR ANY OTHER
// WARRANTIES WHETHER EXPRESSED OR IMPLIED.   BECAUSE OF THE VARIOUS HARDWARE
// AND SOFTWARE ENVIRONMENTS INTO WHICH RV SITE BUILDER MAY BE USED, NO WARRANTY OF
// FITNESS FOR A PARTICULAR PURPOSE IS OFFERED.  THE USER MUST ASSUME THE
// ENTIRE RISK OF USING THIS PROGRAM.  ANY LIABILITY OF RV GLOBAL SOFT CO.,LTD. WILL BE
// LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT OR REFUND OF PURCHASE PRICE.
// IN NO CASE SHALL RV GLOBAL SOFT CO.,LTD. BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
// CONSEQUENTIAL DAMAGES OR LOSS, INCLUDING, WITHOUT LIMITATION, LOST PROFITS
// OR THE INABILITY TO USE EQUIPMENT OR ACCESS DATA, WHETHER SUCH DAMAGES ARE
// BASED UPON A BREACH OF EXPRESS OR IMPLIED WARRANTIES, BREACH OF CONTRACT,
// NEGLIGENCE, STRICT TORT, OR ANY OTHER LEGAL THEORY. THIS IS TRUE EVEN IF
// RV GLOBAL SOFT CO.,LTD. IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. IN NO CASE WILL
// RV GLOBAL SOFT CO.,LTD.'S LIABILITY EXCEED THE AMOUNT OF THE LICENSE FEE ACTUALLY PAID
// BY LICENSEE TO RV GLOBAL SOFT CO.,LTD.
// +---------------------------------------------------------------------------+
// $Id: rvsUpdateDatabase.php ,v $Revision$ 24 ��.�. 2549 15:34:42 parinya Exp $
// +---------------------------------------------------------------------------+

/**
 * Short Description.
 * 
 * @package package_name
 * @author  Pairote Manunphol <pairote@rvskin.com>
 * @author  Parinya <parinya@rvglobalsoft.com>
 * @version $Revision$
 * @since   PHP 4.1
 */

require_once('rvpostinstall/RVxmlParser.php');

class SGL_Task_rvsCompoPostInstall extends SGL_UpdateHtmlTask
{
    function run($data)
    {
        
        $c = &SGL_Config::singleton();
        $conf = $c->getAll();
        
        $statusText = 'Update database';
        $this->updateHtml('status', $statusText);

        //  Print table shell, with module names; we'll update statuses as we execute sql below
        $out = '<h2>Post Install Seagull</h2>';
        $out .= '<table class="inside">';
        $out .= '<tr>';
        $out .= '<th class="alignCenter">Module</th>';
        $out .= '<th class="alignCenter">Update Table</th>';
        
        $out .= '</tr>';

        if ( !(SGL::runningFromCli() || defined('SGL_ADMIN_REBUILD')) ) {
            echo($out);
        }
   
        $aModules = array();
        $modulePath = SGL_MOD_DIR;
        
        foreach ($data['aModuleList'] as $module) {
        	if (is_file($modulePath . '/' . $module . '/data/postInstall.xml')){
        		$aModules[$module] = $module;
        	}
        }
        $aCompoDB = array();
        foreach ($aModules as $kCom) {
            $filePrecess = $modulePath .'/'. strtolower($kCom) . '/data/postInstall.xml';
            if (is_file($filePrecess)) {
                $aCompoDB[$kCom]['process'] = $filePrecess;
            }
        }

        $afterSock = '';
        $out ='';
        foreach ($aCompoDB as $kModule => $vModule) {
            $loadSessionCompo['compo'] = strtolower($kModule);
            SGL_Session::set('RVS_PUBLISH_COMPONENTDB', $loadSessionCompo); 
            $aCompiled= $this->compileTagXML($vModule['process'], 'php');
            if (is_array($aCompiled)) {
                $compileTagXML[$kModule] =  $aCompiled;
                $out .= '<tr>';
                $out .= '<td>'.$kModule.'</td>';
                $out .= '<td align="center">';
                foreach ($compileTagXML[$kModule] as $v) {
                    $afterSock .= $v['afterSock'];
                    $sock .= $v['sock'];
                    $content = $this->bufferCodePHPXML($afterSock);
                    $aContent = $this->validStatusContentXML($content);
                    if($aContent['error']){
                    	$xmlError =  join('\n' , $aContent['error']);
                    	$out .= '<span class=\\"error\\">ERROR</span>';
                    }else {
                    	$out .= '<img src="' . SGL_BASE_URL . '/themes/default/images/enabled.gif" border="0" width="22" height="22">';
                    }
                    $out .=  '<br/>';
                }
                $out .= '</td>';
                $out .= '</tr>';
            }
            
        }
        
        $out .= '</table>';
        if ( !(SGL::runningFromCli() || defined('SGL_ADMIN_REBUILD')) ) {
            echo($out);
        }
        //$this->testDebug();
        //print_r($afterSock);

        ##############################################################
        
        //$aGetContents = $this->bufferCodePHPXML($afterSock);
        //$aStatusContent = $this->validStatusContentXML($aGetContents);
        //
        
        /*$aStatusContent = $this->validStatusContentXML($aGetContents);
        $errorData = $this->getContentsError($aStatusContent['error']);
        $showData = $this->getContentsShow($aStatusContent['show']);
        *///exit;
    }
    
    /**
     * compileTagXML
     *
     * @param string  $url
     * @param string $url = 'array', 'phpcode'
     */
    function compileTagXML($url,$returnType)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $oXML  = & RVxmlParser::singleton(false);
        $oXML->errorDebug = false;
        $oXML->parse($url);
        if ($returnType =='php') {
            $aPHPCode = $oXML->execute();
        } elseif ($returnType=='array') {
            $aPHPCode = $oXML->output;

        }else {
            $aPHPCode = $oXML->output;
            unset($oXML->output);
        }
        if ($oXML->outputXMLError) {
            $aPHPCode['error'] = $oXML->outputXMLError;
        }
        return $aPHPCode;
    }
    
    function bufferCodePHPXML($RunCodePHPXML)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        //echo '----->' . $RunCodePHPXML .  '<------';
        ob_start();
        eval($RunCodePHPXML);
        $getContents = ob_get_contents();
        ob_end_clean();
       // echo $getContents;
       
        return $getContents;
    }
    function validStatusContentXML($oGetContents)
    {
    	SGL::logMessage(null, PEAR_LOG_DEBUG);
    	$oGetContents = trim($oGetContents);
    	$aStatusContent =  (preg_match_all('#::(.*?)::(.*?)::#', $oGetContents, $aMatch)) ? $aMatch[1] : false;
    	if (is_array($aStatusContent)) {
    		foreach ($aStatusContent as $key => $val) {
    			$aDisplay[$val][$key] = $aMatch[2][$key];
    		}
    	}
    	return $aDisplay;
    }


}
?>