<?php
/* Reminder: always indent with 4 spaces (no tabs). */
// +---------------------------------------------------------------------------+
// WebSite:  http://www.rvglobalsoft.com
// Unauthorized copying is strictly forbidden and may result in severe legal action.
// Copyright (c) 2006 RV Global Soft Co.,Ltd. All rights reserved.
// 
// =====YOU MUST KEEP THIS COPYRIGHTS NOTICE INTACT AND CAN NOT BE REMOVE =======
// Copyright (c) 2006 RV Global Soft Co.,Ltd. All rights reserved.
// This Agreement is a legal contract, which specifies the terms of the license
// and warranty limitation between you and RV Global Soft Co.,Ltd. and RV Site Builder.
// You should carefully read the following terms and conditions before
// installing or using this software.  Unless you have a different license
// agreement obtained from RV Global Soft Co.,Ltd., installation or use of this software
// indicates your acceptance of the license and warranty limitation terms
// contained in this Agreement. If you do not agree to the terms of this
// Agreement, promptly delete and destroy all copies of the Software.
//
// =====  Grant of License =======
// The Software may only be installed and used on a single host machine.
//
// =====  Disclaimer of Warranty =======
// THIS SOFTWARE AND ACCOMPANYING DOCUMENTATION ARE PROVIDED "AS IS" AND
// WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR ANY OTHER
// WARRANTIES WHETHER EXPRESSED OR IMPLIED.   BECAUSE OF THE VARIOUS HARDWARE
// AND SOFTWARE ENVIRONMENTS INTO WHICH RV SITE BUILDER MAY BE USED, NO WARRANTY OF
// FITNESS FOR A PARTICULAR PURPOSE IS OFFERED.  THE USER MUST ASSUME THE
// ENTIRE RISK OF USING THIS PROGRAM.  ANY LIABILITY OF RV GLOBAL SOFT CO.,LTD. WILL BE
// LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT OR REFUND OF PURCHASE PRICE.
// IN NO CASE SHALL RV GLOBAL SOFT CO.,LTD. BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
// CONSEQUENTIAL DAMAGES OR LOSS, INCLUDING, WITHOUT LIMITATION, LOST PROFITS
// OR THE INABILITY TO USE EQUIPMENT OR ACCESS DATA, WHETHER SUCH DAMAGES ARE
// BASED UPON A BREACH OF EXPRESS OR IMPLIED WARRANTIES, BREACH OF CONTRACT,
// NEGLIGENCE, STRICT TORT, OR ANY OTHER LEGAL THEORY. THIS IS TRUE EVEN IF
// RV GLOBAL SOFT CO.,LTD. IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. IN NO CASE WILL
// RV GLOBAL SOFT CO.,LTD.'S LIABILITY EXCEED THE AMOUNT OF THE LICENSE FEE ACTUALLY PAID
// BY LICENSEE TO RV GLOBAL SOFT CO.,LTD.
// +---------------------------------------------------------------------------+
// $Id: rvsUpdateDatabase.php ,v $Revision$ 24 ��.�. 2549 15:34:42 parinya Exp $
// +---------------------------------------------------------------------------+

/**
 * Short Description.
 * 
 * @package package_name
 * @author  Pairote Manunphol <pairote@rvskin.com>
 * @author  Parinya <parinya@rvglobalsoft.com>
 * @version $Revision$
 * @since   PHP 4.1
 */


class SGL_Task_rvsUpdateDatabase extends SGL_UpdateHtmlTask
{
    function run($data)
    {
        
        require_once SGL_CORE_DIR . '/Sql.php';
        $c = &SGL_Config::singleton();
        $this->conf = $c->getAll();
        $this->setup();
        $statusText = 'Update database';
        $this->updateHtml('status', $statusText);

        //  Print table shell, with module names; we'll update statuses as we execute sql below
        $out = '<h2>Update database</h2>';
        $out .= '<table class="inside">';
        $out .= '<tr>';
        $out .= '<th class="alignCenter">Module</th>';
        $out .= '<th class="alignCenter">New Module</th>';
        $out .= '<th class="alignCenter">Level</th>';
        $out .= '<th class="alignCenter">Update Schema</th>';
        $out .= '<th class="alignCenter">Update Default Data</th>';
        $out .= '<th class="alignCenter">Update Data</th>';
        $out .= '</tr>';

        if ( !(SGL::runningFromCli() || defined('SGL_ADMIN_REBUILD')) ) {
            echo($out);
        }

        foreach ($data['aModuleList'] as $module) {
            $out = '<tr>';
            $out .= '<td class="title">' . ucfirst($module) . '</td>';
            $out .= '<td id="' . $module . '_new" class="alignCenter"></td>';
            $out .= '<td id="' . $module . '_level" class="alignCenter"></td>';
            $out .= '<td id="' . $module . '_updateschema" class="alignCenter"></td>';
            $out .= '<td id="' . $module . '_updatedata" class="alignCenter"></td>';
            $out .= '<td id="' . $module . '_update" class="alignCenter"></td>';
            $out .= '</tr>';

            if (!(SGL::runningFromCli() || defined('SGL_ADMIN_REBUILD'))) {
                echo($out);
            }
        }

        if ( !(SGL::runningFromCli() || defined('SGL_ADMIN_REBUILD'))) {
            echo('</table>');
            if ( !defined('SGL_NO_FLUSH') ) flush(); /// Don't flush if define SGL_NO_FLUSH [Parinya::20060624]
        }

        foreach ($data['aModuleList'] as $module) {
            $updataSitePath = SGL_MOD_DIR . '/' . $module . '/data';
            //echo $updataSitePath . '<br>';
            $lastUpdateLevel = (isset($this->conf['rvs_db_level'][$module])) ? $this->conf['rvs_db_level'][$module]: null;
            if ($lastUpdateLevel == null ) {
                if ( is_file($updataSitePath . $this->filename1) ) {
                	$result = SGL_Sql::parse($updataSitePath . $this->filename1, 0, array('SGL_Sql', 'execute'));
                    //$result = SGL_Sql::parseAndExecute($updataSitePath . $this->filename1, 0);
                }
                if ( is_file($updataSitePath . $this->filename2) && $result) {
                	$result = SGL_Sql::parse($updataSitePath . $this->filename2, 0, array('SGL_Sql', 'execute'));
                    //$result = SGL_Sql::parseAndExecute($updataSitePath . $this->filename2, 0);
                }
                if ( is_file($updataSitePath . $this->filename3) && $result) {
                	$result = SGL_Sql::parse($updataSitePath . $this->filename3, 0, array('SGL_Sql', 'execute'));
                    //$result = SGL_Sql::parseAndExecute($updataSitePath . $this->filename3, 0);
                }
                
                $displayHtml = (isset($result)) ? $this->success : $this->failure;
                $this->updateHtml($module . '_new', $displayHtml);
                
                if ( !isset($result) || !$result) {
                    continue;
                }
                $lastUpdateLevel = 1;
                $c->set('rvs_db_level', array($module => 1));
            } else if ( $lastUpdateLevel == 0 ) {
                $lastUpdateLevel = 1;
                $c->set('rvs_db_level', array($module => 1));
                $this->updateHtml($module . '_new', $this->noFile);
            } else {
                $this->updateHtml($module . '_new', $this->noFile);
            }
            
            $levelUpdate = (int)$lastUpdateLevel + 1;
            $StartlevelUpdate = $levelUpdate;
            while ( is_file($updataSitePath . '/update.my.' . $levelUpdate . '.sql') ||
                      is_file($updataSitePath . preg_replace('/\{x}/i', $levelUpdate, $this->fileupdate1)) ||
                      is_file($updataSitePath . preg_replace('/\{x}/i', $levelUpdate, $this->fileupdate2)) ) {
                
                if ( is_file($updataSitePath . preg_replace('/\{x}/i', $levelUpdate, $this->fileupdate1)) ) {
                    $result = SGL_Sql::parse($updataSitePath . preg_replace('/\{x}/i', $levelUpdate, $this->fileupdate1), 0, array('SGL_Sql', 'execute'));
                	//$result = SGL_Sql::parseAndExecute($updataSitePath . preg_replace('/\{x}/i', $levelUpdate, $this->fileupdate1), 0);
                    $displayHtml = $result ? $this->success : $this->failure;
                    $this->updateHtml($module . '_updateschema', '<b>Level '. $levelUpdate . '</b>');
                } else {
                    $this->updateHtml($module . '_updateschema', $this->noFile);
                }
                
                
                if ( is_file($updataSitePath . preg_replace('/\{x}/i', $levelUpdate, $this->fileupdate2)) ) {
                	$result = SGL_Sql::parse($updataSitePath . preg_replace('/\{x}/i', $levelUpdate, $this->fileupdate2), 0, array('SGL_Sql', 'execute'));
                    //$result = SGL_Sql::parseAndExecute($updataSitePath . preg_replace('/\{x}/i', $levelUpdate, $this->fileupdate2), 0);
                    $displayHtml = $result ? $this->success : $this->failure;
                    $this->updateHtml($module . '_updatedata', '<b>Level '. $levelUpdate . '</b>');
                } else {
                    $this->updateHtml($module . '_updatedata', $this->noFile);
                }
                
                if ( is_file($updataSitePath . '/update.my.' . $levelUpdate . '.sql' ) ) {
                	//echo $updataSitePath . '/update.my.' . $levelUpdate . '.sql<br>';
                	$result = SGL_Sql::parse($updataSitePath . '/update.my.' . $levelUpdate . '.sql', 0, array('SGL_Sql', 'execute'));
                    //$result = SGL_Sql::parseAndExecute($updataSitePath . '/update.my.' . $levelUpdate . '.sql', 0);
                    //print_r($result);
                    $displayHtml = $result ? $this->success : $this->failure;
                    $this->updateHtml($module . '_update', '<b>Level '. $levelUpdate . '</b>');
                } else {
                    $this->updateHtml($module . '_update', $this->noFile);
                }
                
                $c->set('rvs_db_level', array($module => "$levelUpdate"));
                $levelUpdate++;
            }

            if ( $levelUpdate == $StartlevelUpdate ) {
                $this->updateHtml($module . '_level', $this->noFile);
                $this->updateHtml($module . '_updateschema', $this->noFile);
                $this->updateHtml($module . '_updatedata', $this->noFile);
                $this->updateHtml($module . '_update', $this->noFile);
            } else {
            	$updateTo = (int)$levelUpdate - 1;
            	if ($updateTo <> $StartlevelUpdate) {
            		$updateMsg = "$StartlevelUpdate - $updateTo";
            	} else {
            		$updateMsg = "$updateTo";
            	}
                $this->updateHtml($module . '_level', $updateMsg);
                $this->updateHtml($module . '_updateschema', $this->success);
                $this->updateHtml($module . '_updatedata', $this->success);
                $this->updateHtml($module . '_update', $this->success);
            }
        }
        $configFile = SGL_VAR_DIR . '/' . SGL_SERVER_NAME . '.conf.php';
        $ok = $c->save($configFile);
    }
}

class SGL_Task_rvsCheckingError extends SGL_UpdateHtmlTask
{
    function run($data)
    {
        if ( !SGL_Install_Common::errorsExist()) {
            echo "\n". '<script>location.replace(\'' . SGL_BASE_URL . '/rvssetup.php?start\');</script>';
        }
    }   
}

class SGL_Task_rvsCreateFileSystem extends SGL_UpdateHtmlTask
{
	function run($data)
	{
	    require_once 'System.php';

		foreach ($data['aModuleList'] as $module) {
		    switch (strtolower($module)) {
            case 'blogweb' :
                $cacheDir = SGL_CACHE_DIR . '/templates_c';
                if (!is_dir($cacheDir)) {
                    System::mkDir(array($cacheDir));
                    if (is_dir($cacheDir)) {
                        @chmod($cacheDir, 0777);
                    } else {
                        SGL_Install_Common::errorPush(PEAR::raiseError('Problem creating template_c dir'));
                    }
                }
                break;
		    }
		}
	}
}

class RVS_Task extends SGL_UpdateHtmlTask
{
	function rvsOverrideDefaultInstallSettings($data)
	{
		//RVS START auto setup
         if ( defined('RVS_AUTO_SETUP') && is_file(SGL_VAR_DIR . '/rvsautosetup.ini.php') ) {
            $aAutoConf = parse_ini_file(SGL_VAR_DIR . '/rvsautosetup.ini.php', true);
            $aAutoConf['aModuleList'] = (isset($aAutoConf['aModuleList'])) ? explode(',', $aAutoConf['aModuleList']) : $data['aModuleList'];
            //$aRet = array_merge($aRet, $aAutoConf);
            $data['aModuleList'] = $aAutoConf['aModuleList'];
            $data['siteCookie'] = $aAutoConf['siteCookie'];
            $data['adminPassword'] = $aAutoConf['adminPassword'];
            $data['adminPassword2'] = $aAutoConf['adminPassword2'];
            $data['adminUserName'] = $aAutoConf['adminUserName'];
            
         }
        //RVS END
        return $data;
	}
}
?>