<?php
/**
 * Basic lang file structure - borrowed from phpMyAdmin, lib/select_lang.lib.php.
 *
 * @package default
 * @author  phpMyAdmin group
 * @version $Revision: 1.7 $
 * @since   PHP 4.1
 */

    //  language choices
    /**
     * All the supported languages have to be listed in the array below.
     * 1. The key must be the "official" ISO 639 language code and, if required,
     *    the dialect code. It can also contain some informations about the
     *    charset (see the Russian case).
     * 2. The first of the values associated to the key is used in a regular
     *    expression to find some keywords corresponding to the language inside two
     *    environment variables.
     *    These values contains:
     *    - the "official" ISO language code and, if required, the dialect code
     *      also ('bu' for Bulgarian, 'fr([-_][[:alpha:]]{2})?' for all French
     *      dialects, 'zh[-_]tw' for Chinese traditional...);
     *    - the '|' character (it means 'OR');
     *    - the full language name.
     * 3. The second values associated to the key is the name of the file to load
     *    without the 'inc.php' extension.
     * 4. The last values associated to the key is the language code as defined by
     *    the RFC1766.
     *
     * Beware that the sorting order (first values associated to keys by
     * alphabetical reverse order in the array) is important: 'zh-tw' (chinese
     * traditional) must be detected before 'zh' (chinese simplified) for
     * example.
     *
     * When there are more than one charset for a language, we put the -utf-8
     * first.
     *
     * For Russian, we put 1251 first, because MSIE does not accept 866
     * and users would not see anything.
     */

    $GLOBALS['_SGL']['LANGUAGE'] = (SGL::isMinimalInstall())
        ? array('en-iso-8859-15'=> array('en([-_][[:alpha:]]{2})?|english',  'english-iso-8859-15', 'en'))
        : array(    //in sitebuilder
        			'af-iso-8859-1'=> array('af','afrikaans-iso-8859-1','af', 'af_ZA.iso88591','afrikaans'),
					'sq-iso-8859-1'=> array('sq','albanian-iso-8859-1','sq', 'sq_AL.iso88591','albanian'),
					'ar-windows-1256'=> array('ar','arabic-windows-1256','ar', 'ar_AE.iso88596','arabic'),
					'az-iso-8859-9'=> array('az','azerbaijani-iso-8859-9','az', 'az_AZ.utf8' , 'azerbaijani'),
					'eu-iso-8859-1'=> array('eu','basque-iso-8859-1','eu', 'eu_ES.iso88591' , 'basque'),
					'becyr-windows-1251'=> array('becyr','belarusian-windows-1251','becyr', 'be_BY' , 'belarusian'),//Belarusian   Belarus
					'bs-windows-1250'=> array('bs','bosnian-windows-1250','bs', 'bs_BA.iso88592' , 'bosnian'),					
					'bg-windows-1251'=> array('bg','bulgarian-windows-1251','bg', 'bg_BG.cp1251' , 'bulgarian'),
					'ca-iso-8859-1'=> array('ca','catalan-iso-8859-1','ca', 'ca_ES.iso88591' , 'catalan'),
					'hr-windows-1250'=> array('hr','croatian-windows-1250','hr', 'hr_HR.iso88592' , 'croatian'),					
					'da-iso-8859-1'=> array('da','danish-iso-8859-1','da', 'da_DK.iso88591' , 'danish'),
					'nl-iso-8859-1'=> array('nl','dutch-iso-8859-1','nl', 'nl_NL.iso88591' , 'dutch'),
        			'et-iso-8859-1'=> array('et','estonian-iso-8859-1','et', 'et_EE.iso88591' , 'estonian'),
					'fi-iso-8859-1'=> array('fi','finnish-iso-8859-1','fi', 'fi_FI.iso88591' , 'finnish'),					
					'gl-iso-8859-1'=> array('gl','galician-iso-8859-1','gl', 'gl_ES.iso88591', 'galician'),					
					'el-iso-8859-7'=> array('el','greek-iso-8859-7','el', 'el_GR.iso88597', 'greek'),
					'he-iso-8859-8'=> array('he','hebrew-iso-8859-8','he', 'he_IL.iso88598', 'hebrew'),
					'hu-iso-8859-2'=> array('hu','hungarian-iso-8859-2','hu', 'hu_HU.iso88592', 'hungarian'),
					'id-iso-8859-1'=> array('id','indonesian-iso-8859-1','id', 'id_ID.iso88591', 'hungarian'),					
					'ja-shift_jis'=> array('ja','japanese-shift_jis','ja', 'ja_JP.ujis', 'japanese'),
					'ko-euc-kr'=> array('ko','korean-euc-kr','ko', 'ko_KR.euckr', 'korean'),
					'lv-windows-1257'=> array('lv','latvian-windows-1257','lv', 'lv_LV.iso885913', 'latvian'),
					'lt-windows-1257'=> array('lt','lithuanian-windows-1257','lt', 'lt_LT.iso885913', 'lithuanian'),										
					'fa-windows-1256'=> array('fa','persian-windows-1256','fa', 'fa_IR', 'persian'),										
					'ro-iso-8859-1'=> array('ro','romanian-iso-8859-1','ro', 'ro_RO.iso88592', 'romanian'),					
					'srcyr-windows-1251'=> array('srcyr','serbian-windows-1251','srcyr', 'sr_YU', 'serbian'),//Serbian      Yugoslavia
					'srcyr-windows-1250'=> array('srcyr','serbian-latin-windows-1250','srcyr','sh_SP', 'serbian latin'),//******
					'sk-windows-1250'=> array('sk','slovak-windows-1250','sk', 'sk_SK.iso88592', 'slovak'),
					'sl-iso-8859-2'=> array('sl','slovenian-iso-8859-2','sl', 'sl_SI.iso88592', 'slovenian'),					
					'sv-iso-8859-1'=> array('sv','swedish-iso-8859-1','sv', 'sv_FI.iso88591', 'swedish'),
					'tt-iso-8859-9'=> array('tt','tatarish-iso-8859-9','tt', 'tt_RU.utf8', 'tatarish'),										
					'uk-windows-1251'=> array('uk','ukrainian-windows-1251','uk', 'uk_UA', 'ukrainian'),        
                    'en-iso-8859-15'=> array('en([-_][[:alpha:]]{2})?|english',  'english-iso-8859-15', 'en'),
                    'en-utf-8'=> array('en([-_][[:alpha:]]{2})?|english',  'english-utf-8', 'en', 'en_US.utf8'),
                    'th-utf-8'=> array('th|thai', 'thai-utf-8', 'th', 'th_TH.utf8'),
					
        			//in seagull
                    'es-iso-8859-1'=> array('es([-_][[:alpha:]]{2})?|spanish', 'spanish-iso-8859-1', 'es'),
                    'es-utf-8'=> array('es([-_][[:alpha:]]{2})?|spanish', 'spanish-utf-8', 'es'),
                    'fr-iso-8859-1'=> array('fr([-_][[:alpha:]]{2})?|french', 'french-iso-8859-1', 'fr'),
                    'fr-utf-8'     => array('fr([-_][[:alpha:]]{2})?|french', 'french-utf-8', 'fr'),
                    'it-iso-8859-1'=> array('it|italian', 'italian-iso-8859-1', 'it'),
                    'ja-euc-jp' => array('ja|japanese', 'japanese-euc-jp', 'ja'),
                    'ja-utf-8' => array('ja|japanese', 'japanese-utf-8', 'ja'),                    
                    'no-iso-8859-1'=> array('no|norwegian', 'norwegian-iso-8859-1', 'no'),
                    'ptbr-iso-8859-1' => array('pt[-_]br|brazilian portuguese', 'brazilian_portuguese-iso-8859-1', 'pt-BR'),
                    'pt-iso-8859-1'=> array('pt([-_][[:alpha:]]{2})?|portuguese', 'portuguese-iso-8859-1', 'pt'),
                    'pl-iso-8859-2'=> array('pl|polish', 'polish-iso-8859-2', 'pl'),
                    'ru-windows-1251' => array('ru|russian', 'russian-windows-1251', 'ru'),
                    'ru-utf-8'      => array('ru|russian', 'russian-utf-8', 'ru'),                    
                    'tr-iso-8859-9'=> array('tr|turkish', 'turkish-iso-8859-9', 'tr'),
                    'tr-utf-8'     => array('tr|turkish', 'turkish-utf-8', 'tr'),
                    'zhtw-utf-8'  => array('zh[-_](tw|hk)|chinese traditional', 'chinese_traditional-utf-8', 'zh-TW'),
                    'zhtw-big5'   => array('zh[-_](tw|hk)|chinese traditional', 'chinese-big5', 'zh-TW'),
                    'zh-utf-8'     => array('zh|chinese simplified', 'chinese_simplified-utf-8', 'zh'),
                    'zh-gb2312'    => array('zh|chinese simplified', 'chinese-gb2312', 'zh'),
        
        			// This Language is SGL 			
                    'de-iso-8859-1'=> array('de([-_][[:alpha:]]{2})?|german', 'german-iso-8859-1', 'de', 'de_DE', 'german'),                    
                    'th-tis-620'=> array('th|thai',  'th-tis-620', 'th', 'th_TH.tis620', 'thai'),                
					'ms-iso-8859-1'=> array('ms|malaysian', 'malaysian-iso-8859-1', 'ms', 'ms_MY.iso88591', 'malaysian'),			
					'pt-br-iso-8859-1' => array('pt[-_]br|brazilian portuguese', 'brazilian_portuguese-iso-8859-1', 'pt-BR','pt_BR.iso88591', 'brazilian portuguese'),
					// This Language is Different charset	between SGL and SiteBuilder Database	
					'cs-windows-1250'=> array('cs','czech-windows-1250','cs', 'cs_CZ.iso88592', 'czech'), 					//SiteBuilder Database Lang 
                    //'cs-iso-8859-2'=> array('cs|czech', 'czech-iso-8859-2', 'cs'),				//SGL Lang 				
                    //'ru-win1251'   => array('ru|russian', 'russian-windows-1251', 'ru'), 		//SGL Lang 
					//'zh'           => array('zh|chinese simplified', 'chinese-gb2312', 'zh'),	//SGL Lang 	
					'zh-big5'=> array('zh','chinese-big5','zh', 'zh_TW.big5', 'traditional chinese'),	 											//SiteBuilder Database Lang 									                               
					//'zh-tw'        => array('zh[-_]tw|chinese traditional', 'chinese-big5', 'zh-TW'),		//SGL Lang
    );

    function SGL_cmp(&$a, $b)
    {
        return (strcmp($a[1], $b[1]));
    }
?>
