<?php

/* Reminder: always indent with 4 spaces (no tabs). */
// +---------------------------------------------------------------------------+
// WebSite:  http://www.webexperts.co.th
// Unauthorized copying is strictly forbidden and may result in severe legal action.
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// 
// =====YOU MUST KEEP THIS COPYRIGHTS NOTICE INTACT AND CAN NOT BE REMOVE =======
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// This Agreement is a legal contract, which specifies the terms of the license
// and warranty limitation between you and Web Experts Co.,Ltd. and RV Site Builder.
// You should carefully read the following terms and conditions before
// installing or using this software.  Unless you have a different license
// agreement obtained from Web Experts Co.,Ltd., installation or use of this software
// indicates your acceptance of the license and warranty limitation terms
// contained in this Agreement. If you do not agree to the terms of this
// Agreement, promptly delete and destroy all copies of the Software.
//
// =====  Grant of License =======
// The Software may only be installed and used on a single host machine.
//
// =====  Disclaimer of Warranty =======
// THIS SOFTWARE AND ACCOMPANYING DOCUMENTATION ARE PROVIDED "AS IS" AND
// WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR ANY OTHER
// WARRANTIES WHETHER EXPRESSED OR IMPLIED.   BECAUSE OF THE VARIOUS HARDWARE
// AND SOFTWARE ENVIRONMENTS INTO WHICH RV SITE BUILDER MAY BE USED, NO WARRANTY OF
// FITNESS FOR A PARTICULAR PURPOSE IS OFFERED.  THE USER MUST ASSUME THE
// ENTIRE RISK OF USING THIS PROGRAM.  ANY LIABILITY OF Web Experts Co.,Ltd. WILL BE
// LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT OR REFUND OF PURCHASE PRICE.
// IN NO CASE SHALL Web Experts Co.,Ltd. BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
// CONSEQUENTIAL DAMAGES OR LOSS, INCLUDING, WITHOUT LIMITATION, LOST PROFITS
// OR THE INABILITY TO USE EQUIPMENT OR ACCESS DATA, WHETHER SUCH DAMAGES ARE
// BASED UPON A BREACH OF EXPRESS OR IMPLIED WARRANTIES, BREACH OF CONTRACT,
// NEGLIGENCE, STRICT TORT, OR ANY OTHER LEGAL THEORY. THIS IS TRUE EVEN IF
// Web Experts Co.,Ltd. IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. IN NO CASE WILL
// Web Experts Co.,Ltd.'S LIABILITY EXCEED THE AMOUNT OF THE LICENSE FEE ACTUALLY PAID
// BY LICENSEE TO Web Experts Co.,Ltd.

class ArticleWeb_Block_BigContentArticleWeb
{
    var $template     = 'blocksBigContentArticle.html';
    var $templatePath = 'articleweb';
    var $webRoot = SGL_BASE_URL;
    
    function init(&$output, &$blockID, &$aParams)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        return $this->getBlockContent($output, &$aParams);
    }

    function getBlockContent(&$output, &$aParams)
    {
        return $this->process($blockOutput, &$aParams);
    }
    
    function process(&$output, &$aParams)
    {
        $output->moduleName     = $this->templatePath;
        $output->masterTemplate = $this->template;
        $aArticleWeb = $this->retrieveAll();

        if (count($aArticleWeb) >= 1) {
            
            $output->lastArticleId = $aArticleWeb[0]['article_id'];
            $output->lastArticleIcon = $aArticleWeb[0]['article_icon'];
            $output->lastArticleMessage = $aArticleWeb[0]['message'];
            $output->typeName = $aArticleWeb[0]['typeName'];
        }
        
        $output->webRoot = $this->webRoot;
        $c = &SGL_Config::singleton();
        $blockConf->conf = $c->ensureModuleConfigLoaded('articleweb');  
        $output->contentPicWidth = $blockConf->conf['BigContentArticleWebBlock']['iconWidth'];
        $output->contentPicHeight = $blockConf->conf['BigContentArticleWebBlock']['iconHeigh'];
        
        $view = new SGL_HtmlSimpleView($output);
        return $view->render();
    }
    
    function retrieveAll()
    {
        $c = &SGL_Config::singleton();
        $dbh = & SGL_DB::singleton();
        $blockConf->conf = $c->ensureModuleConfigLoaded('articleweb');
        
        $bigContentTypeId = isset($blockConf->conf['BigContentArticleWebBlock']['BigContentTypeId']) ? $blockConf->conf['BigContentArticleWebBlock']['BigContentTypeId'] : 1;
        
        $lastArticleWeb = Array();
        $currentTime = time();
        
        $maxTextTitle = $blockConf->conf['BigContentArticleWebBlock']['titleLength'];
        
        if ($_SESSION['aPrefs']['language'] == '') {
            $defaultLang = $blockConf->conf['Default']['defaultLang'];
        } else {
            $defaultLang = $_SESSION['aPrefs']['language'];
        }

        $query = "
                    SELECT web_lang_id
                    FROM {$blockConf->conf['table']['web_lang']}
                    WHERE lang_key = '{$defaultLang}'
                    ";
        $defaultLangId = $dbh->getOne($query);

        $query = "SELECT 
                            a.date_start , a.article_id , a.article_icon , am.title , am.message
                        FROM 
                            {$blockConf->conf['table']['article']} a,
                            {$blockConf->conf['table']['article_message']} am
                        WHERE
                            a.article_id = am.article_id
                            AND a.article_type_id = '{$bigContentTypeId}'
                            AND a.publish = '1'
                            AND (am.web_lang_id = '{$defaultLangId}' AND am.title != '' AND am.message != '')
                            ";

        $aArticleWeb = $dbh->getAll($query, DB_FETCHMODE_ASSOC);
        
        if (count($aArticleWeb) <= 0) {
            $query = "SELECT 
                                a.date_start , a.article_id , a.article_icon , am.title , am.message
                            FROM 
                                {$blockConf->conf['table']['article']} a,
                                {$blockConf->conf['table']['article_message']} am
                            WHERE
                                a.article_id = am.article_id
                                AND a.article_type_id = '{$bigContentTypeId}'
                                AND a.publish = '1'
                                AND (am.web_lang_id != '{$defaultLangId}' AND am.title != '' AND am.message != '')
                                ";
            $aArticleWeb = $dbh->getAll($query, DB_FETCHMODE_ASSOC);
        }
        mb_internal_encoding("UTF-8");
        
        if (count($aArticleWeb) != 0) {
            $aArticleWeb[0]['typeName'] = $aArticleWeb[0]['title'];
            $aArticleWeb[0]['title'] = mb_substr($aArticleWeb[0]['title'],0,$maxTextTitle);
        }
        return $aArticleWeb;
    }
}
?>