<?php

/* Reminder: always indent with 4 spaces (no tabs). */
// +---------------------------------------------------------------------------+
// WebSite:  http://www.webexperts.co.th
// Unauthorized copying is strictly forbidden and may result in severe legal action.
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// 
// =====YOU MUST KEEP THIS COPYRIGHTS NOTICE INTACT AND CAN NOT BE REMOVE =======
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// This Agreement is a legal contract, which specifies the terms of the license
// and warranty limitation between you and Web Experts Co.,Ltd. and RV Site Builder.
// You should carefully read the following terms and conditions before
// installing or using this software.  Unless you have a different license
// agreement obtained from Web Experts Co.,Ltd., installation or use of this software
// indicates your acceptance of the license and warranty limitation terms
// contained in this Agreement. If you do not agree to the terms of this
// Agreement, promptly delete and destroy all copies of the Software.
//
// =====  Grant of License =======
// The Software may only be installed and used on a single host machine.
//
// =====  Disclaimer of Warranty =======
// THIS SOFTWARE AND ACCOMPANYING DOCUMENTATION ARE PROVIDED "AS IS" AND
// WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR ANY OTHER
// WARRANTIES WHETHER EXPRESSED OR IMPLIED.   BECAUSE OF THE VARIOUS HARDWARE
// AND SOFTWARE ENVIRONMENTS INTO WHICH RV SITE BUILDER MAY BE USED, NO WARRANTY OF
// FITNESS FOR A PARTICULAR PURPOSE IS OFFERED.  THE USER MUST ASSUME THE
// ENTIRE RISK OF USING THIS PROGRAM.  ANY LIABILITY OF Web Experts Co.,Ltd. WILL BE
// LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT OR REFUND OF PURCHASE PRICE.
// IN NO CASE SHALL Web Experts Co.,Ltd. BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
// CONSEQUENTIAL DAMAGES OR LOSS, INCLUDING, WITHOUT LIMITATION, LOST PROFITS
// OR THE INABILITY TO USE EQUIPMENT OR ACCESS DATA, WHETHER SUCH DAMAGES ARE
// BASED UPON A BREACH OF EXPRESS OR IMPLIED WARRANTIES, BREACH OF CONTRACT,
// NEGLIGENCE, STRICT TORT, OR ANY OTHER LEGAL THEORY. THIS IS TRUE EVEN IF
// Web Experts Co.,Ltd. IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. IN NO CASE WILL
// Web Experts Co.,Ltd.'S LIABILITY EXCEED THE AMOUNT OF THE LICENSE FEE ACTUALLY PAID
// BY LICENSEE TO Web Experts Co.,Ltd.

require_once SGL_MOD_DIR . '/user/classes/UserDAO.php';
require_once 'Image/Transform/Driver/GD.php';

class AdminArticleTypeWebMgr extends SGL_Manager
{
    function AdminArticleTypeWebMgr()
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        parent::SGL_Manager();

        $this->template     = 'articleTypeManager.html';
        $this->pageTitle    = 'Admin Article Manager';

        $this->da = & UserDAO::singleton();      
        
        $this->_aActionsMapping =  array(
            'view'      => array('view'),
            'addview'      => array('addview'),
            'add'      => array('add', 'redirectToDefault'),
            'editview'      => array('editview'),
            'edit'      => array('edit', 'redirectToDefault'),
            'delete'      => array('delete', 'redirectToDefault'),                     
        );
        
        $this->iconImagePath = 'images/Image/';
        
        /// START :: rewrite $thsi->conf
        $req = &SGL_Request::singleton();
        $moduleName = $req->get('moduleName');
        $managerName = $req->get('managerName');
        if (strtolower($moduleName) != 'articleweb') {
            /// rewrite conf table name
            $fileRewrireTable = SGL_MOD_DIR . '/' . $moduleName . '/data/rewriteTableAliases.ini';
            if (is_file($fileRewrireTable)) {
                $fileData = parse_ini_file($fileRewrireTable);
                foreach ($fileData as $key => $val) {
                    $this->conf['table'][$key] = SGL_Config::get('db.prefix') . $val;
                }
            }
            ///set default parent conf
            $defaultConfmodule = SGL_MOD_DIR . '/articleweb/conf.ini';
            if (is_file($defaultConfmodule)) {
                $aDefaultConf = parse_ini_file($defaultConfmodule, true);
				foreach ($aDefaultConf as $mgr => $keyconf) {
                    $this->conf[$mgr] = $keyconf;
                }
            }
            ///merge parent conf + current conf by managerName
            $targetConfmodule = SGL_MOD_DIR . '/' . $moduleName . '/conf.ini';
            if (is_file($targetConfmodule)) {
                $aTargetConf = parse_ini_file($targetConfmodule, true);
                foreach ($aTargetConf as $mgr => $keyconf) {
                    if (strtolower($mgr) == strtolower($managerName . 'Mgr')) {
                        array_merge($this->conf[__CLASS__], $this->conf[$mgr]);
                    }
                }
            }
        }
        /// START :: rewrite $thsi->conf
    }

    function validate($req, &$input)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $this->validated    = true;
        $input->error       = array();        
        $input->masterTemplate = $this->masterTemplate;        
        $input->template    = $this->template;
        $input->action      = ($req->get('action')) ? $req->get('action') : 'view';
        
        $input->pageTitle   = $this->pageTitle;
        $input->pageAction = $input->action;
        
        $input->frmPerms = $req->get('frmPerms');
        $input->frmTypeLang = $req->get('frmTypeLang');        
        $input->frmTypeIcon = $req->get('frmTypeIcon');
        $input->frmTypeID = $req->get('frmTypeID');        
        $input->frmDelete = $req->get('frmDelete');        
        $input->frmAutoResizeIcon = $req->get('frmAutoResizeIcon');
        
        $input->sortBy      = SGL_Util::getSortBy($req->get('frmSortBy'), SGL_SORTBY_USER);
        $input->sortOrder   = SGL_Util::getSortOrder($req->get('frmSortOrder'));

        $input->assetFileArray = $req->get('assetFile');
        $input->assetFileName         = $input->assetFileArray['name'];
        $input->assetFileType         = $input->assetFileArray['type'];
        $input->assetFileTmpName      = $input->assetFileArray['tmp_name'];
        $input->assetFileSize         = $input->assetFileArray['size'];
        
        $input->iconWidth = $this->conf['AdminArticleTypeWebMgr']['iconWidth'];
        $input->iconHeigh = $this->conf['AdminArticleTypeWebMgr']['iconHeigh'];
                        
        ################ Start validate ###############
         /// START :: custom  adjust commond input datas ::: BooM
        $this->_customCommondInput($req, $input);
        /// END :: custom  adjust commond input datas ::: BooM

        ################ Set Action Input #################
        switch ($input->action) {
            case "add" :
            case "edit" :
            default :
        }
        
        /// START :: custom adjust  by action
        $this->_customInputByAction($input->action, $req, $input);
        /// END :: custom adjust  by action
        $aErrors = array();
        
        /// START :: custom common validate
        $this->_customCommondValidate($input, $aErrors);
        /// END :: custom common validate
        switch ($input->action) {
            case "add":
                $this->_validateAdd($input, &$aErrors);
                if (count($aErrors) > 0) { 
                    $input->template = 'articleTypeEdit.html';
                    $input->action = 'addview';
                }
                break;
            case 'addview':
                $input->template = 'articleTypeEdit.html';
                $input->typeAdd = true;
                break;
            case "edit":
                $this->_validateEdit($input, &$aErrors);
                if (count($aErrors) > 0) {
                    $input->template = 'articleTypeEdit.html'; 
                    $input->action = 'editview';
                }
                break;
            case 'editview' :
                $input->template = 'articleTypeEdit.html';
                $input->typeEdit = true;
                break;
            case "delete":
                $this->_validateDelete($input,$aErrors);
                if (count($aErrors) > 0) {
                    $input->template = 'articleTypeManager.html';
                    $input->action = 'view';
                }
                break;
        }
        
         /// START :: custom valdiate and custom template by action
        $this->_customValidateByAction($input->action, $input, $aErrors);
        $this->_customUseTemplatebyAction($input->template, $input->action);
        /// END :: custom valdiate and custom template by action
        ################ End validate ###############
        
        //  if errors have occured
         if (count($aErrors) > 0) {
            SGL_Output::translate(SGL::raiseMsg('Validation Failed.'));
            /// START :: custom error by action
            $this->_customaErrorByAction($input, $aErrors);
            /// END ::
            $input->error = $aErrors;
            //$this->validated = false;
        }

    }

    
    function display(&$output)
    {
        $defaultLang = $this->conf['Default']['defaultLang'];
        $query = "SELECT web_lang_id
						FROM {$this->conf['table']['web_lang']} 
        				WHERE lang_key = '{$defaultLang}'
        ";
        $defaultLangID = $this->dbh->getOne($query);
        
        $output->displayTab  = 'generalSiteOptions' . $defaultLangID;
        
        $output->addOnLoadEvent("showSelectedOptions('frmRoleEdit','$output->displayTab')");
        
        /// START :: custom display
        $this-> _customOutputDisplay($output);
        /// END :: custom display
    }
    
    function _cmd_view($input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        
        if (isset($_SESSION['aPrefs']['language'])) {
            $this->conf['Default']['defaultLang'] = $_SESSION['aPrefs']['language'];
        }

        $allowedSortFields = array('article_type_id','type_name','description');
        if (!empty($input->sortBy)
               && !empty($input->sortOrder)
               && in_array($input->sortBy, $allowedSortFields)) {
            $orderByQuery = ' ORDER BY ' . $input->sortBy . ' ' . $input->sortOrder;
        } else {
            $orderByQuery = ' ORDER BY article_type_id ASC ';
        }
        
        $defaultLang = $this->conf['Default']['defaultLang'];
        
        /// START :: custom query data1
        $queryNumber = 1;
        $orderByQuery = ' ORDER BY web_lang_id ASC';
        $aDataQuery = array($queryNumber => array('adjustOrderBy' => $orderByQuery, 'lang_key' => $defaultLang));
        $this->_customQueryData('view', $input, $queryNumber, $aDataQuery);
        /// END :: custom query data1
        
        $query = sprintf("
            SELECT 
                web_lang_id
            FROM 
                {$this->conf['table']['web_lang']}
                %s
            WHERE 
                lang_key = '{$defaultLang}'
                %s 
                %s
        ", 
            isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
             , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
             , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );
        $defaultLangID = $this->dbh->getOne($query);

        /// START: custom query 1
       $this->_customAfterInsertDB('view', $queryNumber, $aDataQuery[$queryNumber],  $input);
       /// END: custom query 1
           
        /// START :: custom query data2
        $queryNumber = 2;
        $orderByQuery = ' ORDER BY article_type_id ASC ';
        $aDataQuery = array($queryNumber => array('adjustOrderBy' => $orderByQuery, 'web_lang_id' => $defaultLangID));
        $this->_customQueryData('view', $input, $queryNumber, $aDataQuery);
        /// END :: custom query data2
        
        $query = sprintf("
            SELECT 
					a.article_type_id, at.type_name, at.description, a.type_icon
			FROM 
					{$this->conf['table']['article_type']} a
					, {$this->conf['table']['article_type_message']} at
			WHERE 
                at.web_lang_id ={$aDataQuery[$queryNumber]['web_lang_id']}
                AND a.article_type_id = at.article_type_id
                %s
                %s
		   ",
		    isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
             , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
             , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );

        $limit = $_SESSION['aPrefs']['resPerPage'];

        $pagerOptions = array(
            'mode'     => 'Sliding',
            'delta'    => 3,
            'perPage'  => $limit,
            'spacesBeforeSeparator' => 0,
            'spacesAfterSeparator'  => 0,
            'curPageSpanPre'        => '<span class="currentPage">',
            'curPageSpanPost'       => '</span>',
        );
        $aPagedData = SGL_DB::getPagedData($this->dbh, $query, $pagerOptions);
        
       /// START: custom query 2
       $this->_customAfterInsertDB('view', $queryNumber, $aDataQuery[$queryNumber],  $input);
       /// END: custom query 2
       
        foreach ($aPagedData['data'] as $key => $val) {
            /// START :: custom query data3
            $queryNumber = 3;
            $aDataQuery = array(
                $queryNumber => array(
                    'adjustOrderBy' => $orderByQuery, 
                    'article_type_id' => $aPagedData['data'][$key]['article_type_id']
                )
            );
            
            $this->_customQueryData('view', $input, $queryNumber, $aDataQuery);
            /// END :: custom query data3
            $query = sprintf("
                SELECT 
                    r.name
                FROM 
                    {$this->conf['table']['article_type_role']} a, {$this->conf['table']['role']} r
                    %s
                WHERE 
                    a.article_type_id ={$aDataQuery[$queryNumber]['article_type_id']}
                    AND a.role_id = r.role_id
                    %s
                    %s
            ",
                isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );
							
            $aRole = $this->dbh->getCol($query);

            /// START: custom query 1
            $this->_customAfterInsertDB('vierw', $queryNumber, $aDataQuery[$queryNumber],  $input);
            /// END: custom query 1
       
            $aPagedData['data'][$key]['perm'] = join(',', $aRole);
            $aPagedData['data'][$key]['type_name'] = $aPagedData['data'][$key]['type_name'] ? $aPagedData['data'][$key]['type_name'] : '-';
            $aPagedData['data'][$key]['description'] = $aPagedData['data'][$key]['description'] ? $aPagedData['data'][$key]['description'] : '-';
            $srcImgLocation = SGL_WEB_ROOT . '/' . $this->iconImagePath . $aPagedData['data'][$key]['type_icon'];
            
            if (!is_file($srcImgLocation)) {
                $aPagedData['data'][$key]['type_icon'] = 0;
            }
        }

        $output->aPagedData = $aPagedData;
        if (is_array($aPagedData['data']) && count($aPagedData['data'])) {
            $output->pager = ($aPagedData['totalItems'] <= $limit) ? false : true;
        }
       $output->Type = SGL_Output::translate('Type');
       $output->Type = Main::quoteSmart($output->Type);
       
       $this-> _customOutputCMD('view', $input, $output);
    }
    
    function _cmd_addview($input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);

        $defaultLang = $this->conf['Default']['defaultLang'];
        
        /// START :: custom query data1
        $queryNumber = 1;
        $orderByQuery = ' ORDER BY web_lang_id ASC ';
        $aDataQuery = array($queryNumber => array('adjustOrderBy' => $orderByQuery, 'lang_key' => $defaultLang));
        $this->_customQueryData('addview', $input, $queryNumber, $aDataQuery);
        /// END :: custom query data1
        $query = sprintf("
            SELECT 
                web_lang_id
            FROM 
                {$this->conf['table']['web_lang']}
                %s
            WHERE 
                lang_key = '{$aDataQuery[$queryNumber]['lang_key']}'
                %s
                %s
        ",
            isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
            , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
            , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );
                
        $defaultLangID = $this->dbh->getOne($query);
         /// START: custom query 1
        $this->_customAfterInsertDB('addview', $queryNumber, $aDataQuery[$queryNumber],  $input);
        /// END: custom query 1
        
        /// START :: custom query data1
        $queryNumber = 2;
        $aDataQuery = array($queryNumber => array('adjustOrderBy' => $orderByQuery));
        $this->_customQueryData('addview', $input, $queryNumber, $aDataQuery);
        /// END :: custom query data1
        $query = sprintf("
            SELECT 
                web_lang_id, lang_key
            FROM 
                {$this->conf['table']['web_lang']}
        ");
        
        $aLangs  = SGL_Util::getLangsDescriptionMap();
        $aTypeData = $this->dbh->getAssoc($query);
        /// START: custom query 2
        $this->_customAfterInsertDB('addview', $queryNumber, $aDataQuery[$queryNumber],  $input);
        /// END: custom query 2
               
        foreach ($aTypeData as $key=>$val) {
            $langName = explode(' ',$aLangs[$val]);
            $typeLang[$key]['lang_name'] = SGL_Output::translate($langName[0]);
            $typeLang[$key]['type_name'] = ''; 
            $typeLang[$key]['description'] = ''; 
        }

        $output->frmTypeLang = $typeLang;
        
        //  build role widget
        $aRoles[SGL_GUEST]    = SGL_String::translate('guest');
        $output->aRoles       = $aRoles + $this->da->getRoles();
        $output->permsSelected = SGL_GUEST;
        
        if (!$this->_detectGd()) {
            $output->skipGd = 1;
        }
        
        $this-> _customOutputCMD('addview', $input, $output);
    }
    
    function _cmd_add($input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        
        if ($input->assetFileName == '') {
            $iconType = '';
        } else {
            $iconType = $this->_uploadImage($input->assetFileName, $input->assetFileTmpName);
            $srcImgLocation = SGL_WEB_ROOT . '/' . $this->iconImagePath . $iconType;
            $targetLocation = SGL_WEB_ROOT . '/' . $this->iconImagePath . $iconType;
            
            if (is_file($srcImgLocation)) {
                if ($this->_detectGd() && $input->frmAutoResizeIcon) {
                    $im = new Image_Transform_Driver_GD();
                    $this->_resizeImageAndSave($im, $srcImgLocation, $targetLocation, $input->iconWidth, $input->iconHeigh);
                }
            } else {
                $iconType = '';                                
            }
        }

        $articleTypeID = $this->dbh->nextId($this->conf['table']['article_type']);
        
        /// START :: custom query data1
        $queryNumber = 1;
        $aDataQuery = array($queryNumber => 
            array(
                'article_type_id' => $articleTypeID,
                'type_icon' => $iconType,
            )
        );
        $this->_customQueryData('add', $input, $queryNumber, $aDataQuery);
        /// END :: custom query data1
        
        $query = "
            INSERT INTO 
                {$this->conf['table']['article_type']} ( `article_type_id` , `type_icon` )
            VALUES (
                '{$aDataQuery[$queryNumber]['article_type_id']}', '{$aDataQuery[$queryNumber]['type_icon']}'
            );";

        $this->dbh->query($query);
        
        // START: custom query 1
        $this->_customAfterInsertDB('add', $queryNumber, $aDataQuery[$queryNumber],  $input);
        /// END: custom query 1
        
        foreach ($input->frmPerms as $key => $val) {
            /// START :: custom query data2
            $queryNumber = 2;
            $aDataQuery = array($queryNumber => 
                array(
                    'article_type_id' => $articleTypeID,
                    'role_id' => $val,
                )
            );
            $this->_customQueryData('add', $input, $queryNumber, $aDataQuery);
            /// END :: custom query data2
            
            $query = "
                INSERT INTO 
                    {$this->conf['table']['article_type_role']} ( `article_type_id` , `role_id` )
                VALUES (
                    '{$aDataQuery[$queryNumber]['article_type_id']}', {$aDataQuery[$queryNumber]['role_id']}
                );";
            $this->dbh->query($query);
            
            // START: custom query 2
            $this->_customAfterInsertDB('add', $queryNumber, $aDataQuery[$queryNumber],  $input);
            /// END: custom query 2
        }
        
        foreach ($input->frmTypeLang as $langId=>$val) {
            $articleTypeMessageID = $this->dbh->nextId($this->conf['table']['article_type_message']);
            $input->frmTypeLang[$langId]['name'] = Main::quoteSmart($input->frmTypeLang[$langId]['name']);
            $input->frmTypeLang[$langId]['description'] = Main::quoteSmart($input->frmTypeLang[$langId]['description']);
            
            /// START :: custom query data3
            $queryNumber = 3;
            $aDataQuery = array($queryNumber => 
                array(
                    'article_type_message_id' => $articleTypeMessageID,
                    'article_type_id' => $articleTypeID,
                    'web_lang_id' => $langId,
                    'type_name' => $input->frmTypeLang[$langId]['name'],
                    'description' => $input->frmTypeLang[$langId]['description'],
                )
            );
            $this->_customQueryData('add', $input, $queryNumber, $aDataQuery);
            /// END :: custom query data3
            
            $query = "
                INSERT INTO 
                    {$this->conf['table']['article_type_message']} ( `article_type_message_id` , `article_type_id` , `web_lang_id` , `type_name` , `description` )
                VALUES (
                    '{$aDataQuery[$queryNumber]['article_type_message_id']}'
                    , '{$aDataQuery[$queryNumber]['article_type_id']}'
                    , {$aDataQuery[$queryNumber]['web_lang_id']}
                    , {$aDataQuery[$queryNumber]['type_name']}
                    , {$aDataQuery[$queryNumber]['description']}
                );
            ";
            $this->dbh->query($query);
            
            // START: custom query 3
            $this->_customAfterInsertDB('add', $queryNumber, $aDataQuery[$queryNumber],  $input);
            /// END: custom query 3
        }
        
        $this-> _customOutputCMD('add', $input, $output);
        SGL::raiseMsg('Type Name successfully updated', true, SGL_MESSAGE_INFO);
    }
    
    function _cmd_editview ($input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        
        $defaultLang = ($this->conf['Default']['defaultLang']) ? $this->conf['Default']['defaultLang'] : 'en';
        
         /// START :: custom query data1
        $queryNumber = 1;
        $aDataQuery = array($queryNumber => 
            array(
                'lang_key' => $defaultLang,
            )
        );
        $this->_customQueryData('editview', $input, $queryNumber, $aDataQuery);
        /// END :: custom query data1
        
        $query = sprintf("
            SELECT 
                web_lang_id
            FROM 
                {$this->conf['table']['web_lang']}
                %s
            WHERE 
                lang_key = '{$aDataQuery[$queryNumber]['lang_key']}'
                %s
                %s
        ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : ''
            , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
            , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : '');
            
        $defaultLangID = $this->dbh->getOne($query);
  
               
        $query = "SELECT 
                        web_lang_id, lang_key
                        FROM {$this->conf['table']['web_lang']};";
        
        $aLangData = $this->dbh->getAssoc($query);
        
        $typeLang = array();
        $aLangs  = SGL_Util::getLangsDescriptionMap();

        foreach ($aLangData as $key => $val) {
            $langName = explode(' ', $aLangs[$val]);
            
            $typeLang[$key]['lang_name'] = SGL_Output::translate($langName[0]);
            
            /// START :: custom query data2
            $queryNumber = 2;
            $aDataQuery = array($queryNumber => 
                array(
                    'article_type_id' => $input->frmTypeID,
                    'web_lang_id' => $key,
                )
            );
            $this->_customQueryData('editview', $input, $queryNumber, $aDataQuery);
            /// END :: custom query data2
            $query = sprintf("
                SELECT 
                    atm.web_lang_id, atm.type_name, atm.description
                FROM 
                    {$this->conf['table']['article_type']} a
                    , {$this->conf['table']['article_type_message']} atm
                    %s
                WHERE 
                    a.article_type_id = atm.article_type_id
                    AND atm.article_type_id ='{$aDataQuery[$queryNumber]['article_type_id']}'
                    AND atm.web_lang_id ='{$aDataQuery[$queryNumber]['web_lang_id']}'
                    %s
                    %s
                ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : ''
                    , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                    , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : '');
        
            $aTypeData = $this->dbh->getRow($query);

            $typeLang[$key]['type_name'] = (isset($aTypeData->type_name)) ? $aTypeData->type_name : '';
            $typeLang[$key]['description'] = (isset($aTypeData->description)) ? $aTypeData->description : '';
        }
                
        /// START :: custom query data3
        $queryNumber = 3;
        $aDataQuery = array($queryNumber => 
            array(
                'article_type_id' => $input->frmTypeID,
            )
        );
        $this->_customQueryData('editview', $input, $queryNumber, $aDataQuery);
        /// END :: custom query data3
        $query = sprintf("
            SELECT
                type_icon 
            FROM 
                {$this->conf['table']['article_type']}
                %s
            WHERE 
                article_type_id = '{$aDataQuery[$queryNumber]['article_type_id']}'
                %s
                %s
            ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : ''
                , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : '');
        
        $typeIcon = $this->dbh->getOne($query);

        /// START :: custom query data4
        $queryNumber = 4;
        $aDataQuery = array($queryNumber => 
            array(
                'article_type_id' => $input->frmTypeID,
            )
        );
        $this->_customQueryData('editview', $input, $queryNumber, $aDataQuery);
        /// END :: custom query data4
            
        $query = sprintf("
            SELECT 
                role_id
			FROM 
				{$this->conf['table']['article_type_role']}
				%s
			WHERE 
			     article_type_id ='{$aDataQuery[$queryNumber]['article_type_id']}'
			     %s
        ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : ''
            , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
            , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : '');
            
        $permsSelected = $this->dbh->getCol($query);
        
        //  build role widget
        $aRoles[SGL_GUEST]    = SGL_String::translate('guest');

        $output->aRoles       = $aRoles + $this->da->getRoles();
        $output->permsSelected = $permsSelected;
        $output->frmTypeIcon = $typeIcon; 
        $output->frmTypeLang = $typeLang;
        
        if (!$this->_detectGd()) {
            $output->skipGd = 1;
        }
        
        $this-> _customOutputCMD('editview', $input, $output);
    }

    function _cmd_edit($input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        if (!empty($input->assetFileName) &&  $input->assetFileName != '') {
            if (isset($input->frmTypeIcon)) {
                $targetIcon = SGL_WEB_ROOT . '/' . $this->iconImagePath . $input->frmTypeIcon;
                if (is_file($targetIcon)) {
                    unlink($targetIcon);
                }
            }
            
            $iconType = $this->_uploadImage($input->assetFileName, $input->assetFileTmpName);
            
            $srcImgLocation = SGL_WEB_ROOT . '/' . $this->iconImagePath . $iconType;
            $targetLocation = SGL_WEB_ROOT . '/' . $this->iconImagePath . $iconType;
            if (is_file($srcImgLocation)) {
                if ($this->_detectGd() && $input->frmAutoResizeIcon) {
                    $im = new Image_Transform_Driver_GD();
                    $this->_resizeImageAndSave($im, $srcImgLocation, $targetLocation, $input->iconWidth, $input->iconHeigh);
                }
            } else {
                $iconType = '';                
            }
            
            /// START :: custom query data1
            $queryNumber = 1;
            $aDataQuery = array($queryNumber => 
                array(
                    'article_type_id' => $input->frmTypeID,
                    'type_icon' => $iconType
                )
            );
            $this->_customQueryData('edit', $input, $queryNumber, $aDataQuery);
            /// END :: custom query data1
            
            $query = "
                UPDATE 
                    {$this->conf['table']['article_type']} 
                SET 
					`type_icon` = '{$aDataQuery[$queryNumber]['type_icon']}' 
				WHERE 
				    `article_type_id` = '{$aDataQuery[$queryNumber]['article_type_id']}' 
				LIMIT 1 ";
				
            $this->dbh->query($query);
        }

        /// START :: custom query data2
        $queryNumber = 2;
        $aDataQuery = array($queryNumber => 
            array(
                'article_type_id' => $input->frmTypeID,
            )
        );
        $this->_customQueryData('edit', $input, $queryNumber, $aDataQuery);
        /// END :: custom query data2        
        
        $query = "
            DELETE FROM 
                {$this->conf['table']['article_type_role']}
            WHERE 
                article_type_id = '{$aDataQuery[$queryNumber]['article_type_id']}'
        ";
        $this->dbh->query($query);
        // START: custom query 2
        $this->_customAfterInsertDB('edit', $queryNumber, $aDataQuery[$queryNumber],  $input);
        /// END: custom query 2
        
        if (is_array($input->frmPerms)) {
            foreach ($input->frmPerms as $key=>$val) {
                /// START :: custom query data2
                $queryNumber = 2;
                $aDataQuery = array($queryNumber => 
                    array(
                        'article_type_id' => $input->frmTypeID,
                        'role_id' => $val
                    )
                );
                $this->_customQueryData('edit', $input, $queryNumber, $aDataQuery);
                /// END :: custom query data2        
                $query = "
                    INSERT INTO 
                        {$this->conf['table']['article_type_role']} 
                        ( 
                            `article_type_id`
                            , `role_id`
                        )
                    VALUES 
                        (
                            '{$aDataQuery[$queryNumber]['article_type_id']}'
                            , {$aDataQuery[$queryNumber]['role_id']}
                        )
                    ;
                ";
                $this->dbh->query($query);
                // START: custom query 2
                $this->_customAfterInsertDB('edit', $queryNumber, $aDataQuery[$queryNumber],  $input);
                /// END: custom query 2
            }
        }
        
        if (is_array($input->frmTypeLang)) {
            foreach ($input->frmTypeLang as $langId => $val) {
                //mysql_real_escape_string
                /// START :: custom query data3
                $queryNumber = 3;
                $aDataQuery = array($queryNumber => 
                    array(
                        'article_type_id' => $input->frmTypeID,
                        'web_lang_id' => $langId,
                        'type_name' => Main::quoteSmart($input->frmTypeLang[$langId]['name']),
                        'description' => Main::quoteSmart($input->frmTypeLang[$langId]['description']),
                    )
                );
                $this->_customQueryData('edit', $input, $queryNumber, $aDataQuery);
                /// END :: custom query data3

                $query = "
                    UPDATE 
                        {$this->conf['table']['article_type_message']} 
                    SET 
						`type_name` = {$aDataQuery[$queryNumber]['type_name']}, 
						`description` = {$aDataQuery[$queryNumber]['description']} 
                    WHERE 
                        `article_type_id` =  {$aDataQuery[$queryNumber]['article_type_id']} 
                        AND web_lang_id={$aDataQuery[$queryNumber]['web_lang_id']} 
                    LIMIT 1 ";
                $this->dbh->query($query);
                /// START: custom query 3
                $this->_customAfterInsertDB('edit', $queryNumber, $aDataQuery[$queryNumber],  $input);
                /// END: custom query 3
            }
        }
        SGL::raiseMsg('Type Name successfully updated', true, SGL_MESSAGE_INFO); 
    }
    
    function _cmd_delete(&$input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        if (isset($input->frmDelete)) {
            if (is_array($input->frmDelete)) {
                foreach ($input->frmDelete as $articleTypeID) {
                    $this->deleteArticleType($articleTypeID);
                }
            } else {
                $this->deleteArticleType($input->frmDelete);
            }
            /// START _customOutputCMD
            $this-> _customOutputCMD('delete', $input, $output);
            /// END ----------------------------
        }
        SGL::raiseMsg('Type Name successfully delete', true, SGL_MESSAGE_INFO);
    }
    
    function deleteArticleType($articleTypeID)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $query = "
            SELECT 
                type_icon
            FROM 
                {$this->conf['table']['article_type']}
            WHERE 
                article_type_id = '{$articleTypeID}'
        ";
                
        $iconType = $this->dbh->getOne($query);
        
        if ($iconType != '') {
            $targetIcon = SGL_WEB_ROOT . '/' . $this->iconImagePath . $iconType;
            if (is_file($targetIcon)) {
                unlink($targetIcon);
            }
        }
        
        $query = "
            DELETE FROM 
                {$this->conf['table']['article_type']}
            WHERE 
                article_type_id = '{$articleTypeID}'
        ";
        $this->dbh->query($query);
                
        $query = "
            DELETE FROM 
                {$this->conf['table']['article_type_role']}
            WHERE 
                article_type_id = '{$articleTypeID}'
        ";
        $this->dbh->query($query);
                
        $query = "
            DELETE FROM 
                {$this->conf['table']['article_type_message']}
            WHERE 
                article_type_id = '{$articleTypeID}'
        ";
        $this->dbh->query($query);
    }
    
    function _uploadImage($assetFileName = '', $assetFileTmpName = '')
    {
        $extention = end(explode('.', $assetFileName));
        $uniqueName = md5($assetFileName . SGL_Session::getUid() . SGL_Date::getTime());
        $iconName = $uniqueName . '.' . $extention;        
        $targetLocation = SGL_WEB_ROOT . '/' . $this->iconImagePath . $iconName;
        move_uploaded_file($assetFileTmpName, $targetLocation);  
        return $iconName;
    }
    
    /*
     * Copy from rvsitebuilder/modules/sitebuilder/class/MainComponent.php
     */
    function _detectGd()
    {
        $gdfuncList = get_extension_funcs('gd');
        ob_start();
        @phpinfo(INFO_MODULES);
        $output = ob_get_contents();
        ob_end_clean();
        $matches[1] = "";
        if (preg_match("/GD Version[ \t]*(<[^>]+>[ \t]*)+([^<>]+)/s",$output,$matches)) {
          $gdversion = $matches[2];
        }
                 
        if ( $gdfuncList ) {
            if ( in_array('imagegd2',$gdfuncList) ) {
                return true;
            } else {
                return false;
             }
        } else {
           return false;
        }
    }
    
    function _resizeImageAndSave($im, $srcImgLocation, $targetLocation, $newWidth, $newHeight)
    {
        // load image
        $ret = $im->load($srcImgLocation);
        if (PEAR::isError($ret)) {
            return false;
        }
        $ret = $im->fit($newWidth, $newHeight);
        if (PEAR::isError($ret)) {
            return false;
        }
        $ret = $im->save($targetLocation, 'jpeg');
    }
    
     function _validateAdd($input, &$aErrors)
    {
        foreach ($input->frmTypeLang as $langId=>$val) {
            if ($input->frmTypeLang[$langId]['name'] == '') {
                $aErrors["typeNameBlank"] = SGL_Output::translate('Please insert type name all type.');
            }
            if (strlen($input->frmTypeLang[$langId]['name']) > 128) {
                $aErrors["typeNameLimit"] = SGL_Output::translate('Type name not more than 128 charactor.');
            }
        }

        return true;
    }
    
     function _validateEdit($input, &$aErrors)
    {
        foreach ($input->frmTypeLang as $langId=>$val) {
            if ($input->frmTypeLang[$langId]['name'] == '') {
                $aErrors["typeNameBlank"] = SGL_Output::translate('Please insert type name all type.');
            }
            if (strlen($input->frmTypeLang[$langId]['name']) > 128) {
                $aErrors["typeNameLimit"] = SGL_Output::translate('Type name not more than 128 charactor.');
            }
        }

        return true;
    }
    
    function _validateDelete(&$input, &$aErrors)
    {
        $aDelete = $input->frmDelete;

        $i = 0;
        if (!$aDelete) {
            return false;
        }
        foreach ($aDelete as $k => $v) {

            $query = "SELECT COUNT(article_id)
                        FROM {$this->conf['table']['article']} 
                        WHERE article_type_id = '{$v}'
                        ";
            $aGetData = $this->dbh->getCol($query);
        
            if ($i == 0) {
                $a = $aGetData[0];
            } else {
                $a = $a + $aGetData[0];
            }
            $i++;
        }
        
        if ($a > 0) {
            // set error return error
            $aErrors["aDeleteError"] = SGL_Output::translate('Please move data out category for delete.') . $a . " file";
        } else {
            return true;
        }
    }
    
    ################################################################
    # IF YOU WANT TO ADJUST DEFAULT MODULE ARTCLEWEB, 
    # PLEASE EDITE YOUR CODES HERE!!!
    #
    ################################################################
    
    /**
     * Custom  adjust input datas for all action 
     *
     * @param <mix> $req
     * @param <mix> $input
     */
    function _customCommondInput($req, &$input)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        /// If you want to custom validate action edit, please edit here!!
    }
    
    /**
     * Custom  adjust input datas for action only 
     *
     * @param <mix> $req
     * @param <mix> $input
     */
    function _customInputByAction($action = 'view', $req, &$input)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        switch ($action) {
            case "add" :
            case "edit" :
            case "delete":
            case 'view':
            case  'addview':
            case  'editview':
            case 'deleteImage':
            default :
                break;
        }
    }
    
    /**
     * Custom validate all action
     *
     * @param <mix> $input
     * @param <array> $aErrors
     */
    function _customCommondValidate($input, &$aErrors)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        
    }
    
    /**
    * Custom validate by action only
    *
    * @param <string> $action;
    * @param <mix> $input
    * @param <array> $aErrors
    */
    function _customValidateByAction($action = 'view', $input, &$aErrors)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        switch ($action) {
            case "add" :
            case "edit" :
            case "delete":
            case 'view':
            case  'addview':
            case  'editview':
            case 'deleteImage':
            default :
                break;
        }
    }
    
    /**
     * Custom output after process cmd_action has completed.
     *
     * @param <string> $action
     * @param <mix> $output
     */
    function _customOutputAfterRunCmd($action = 'view', &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        switch ($action) {
            case "add" :
            case "edit" :
            case "delete":
            case 'view':
            case  'addview':
            case  'editview':
            case 'deleteImage':
            default :
                break;
        }
    }
    
    /**
     * Custom change template by action
     *
     * @param <string> $template
     * @param <string> $action
     *
     * @return <string> $template
     */
    function _customUseTemplatebyAction(&$template, $action)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        /// If you want to custom validate action edit, please edit here!!
        switch ($action) {
            case "add" :
            case "edit" :
            case "delete":
            case 'view':
            case  'addview':
            case  'editview':
            case 'deleteImage':
            default :
                break;
        }
    }

    /**
     * Custom array Errors
     *
     * @param <array> $aErrors
     *
     * @return <array> $aErrors
     */
    function _customaErrorByAction($input, &$aErrors)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        /// If you want to custom code, please edit here!!
    }

    /**
     * Custom Output for display
     *
     * @param <mix> $output
     */
    function _customOutputDisplay(&$output)
    {
        switch ($output->action) {
            case "add" :
            case "edit" :
            case "delete":
            case 'view':
            case  'addview':
            case  'editview':
            case 'deleteImage':
            default :
                break;
        }
    }
    
    /**
     * Custom input data befor insert datas to database in cmd_add
     *
     * @param <mix> $input
     * @param <array> $aDatas ;
     * 
     * @return <array>
     */
    function _customCmdAddBeforInsertArtcleDataToRecord($input, &$aDatas)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        
    }
    
    /**
     * Custom query data by action
     *
     * @param <string> $action
     * @param <mix> $input
     * @param <number> $queryNumber
     * @param <array> $aDataquery
     */
    function _customQueryData($action = 'view', $input, $queryNumber = null, &$aDataquery)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        if (is_null($queryNumber)) {
            return ;
        }
        switch ($action) {
            case "add" :
            case "edit" :
            case "delete":
            case 'view':
            case  'addview':
            case  'editview':
            case 'deleteImage':
            default :
                break;
        }
    }
    
    /**
     * Custom adjust output after run precess (cmd)
     *
     * @param <obj> $input
     * @param <obj> $output
     * 
     * @return $output;
     */
    function _customOutputCMD($action = 'view', $input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        switch ($action) {
            case "add" :
                break;
            case "edit" :
                break;
            case "delete":
                break;
            case 'view': default:
                break;
            case  'addview':
                break;
            case  'editview':
                break;
            case 'deleteImage':
                break;
        }
    }
    
    /**
     * Custom insert article data to database
     *
     * @param <string> $action
     * @param <number> $numberIndex
     * @param <array> $aArticleData
     * @param <obj> $input
     */
    function _customAfterInsertDB($action = 'view', $numberIndex = 0, $aArticleData = array(), $input)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
    }
    #######################################################
    ##                                        END FUNCTION ADJUST                                           #
    #######################################################
}
?>
