<?php

/* Reminder: always indent with 4 spaces (no tabs). */
// +---------------------------------------------------------------------------+
// WebSite:  http://www.webexperts.co.th
// Unauthorized copying is strictly forbidden and may result in severe legal action.
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// 
// =====YOU MUST KEEP THIS COPYRIGHTS NOTICE INTACT AND CAN NOT BE REMOVE =======
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// This Agreement is a legal contract, which specifies the terms of the license
// and warranty limitation between you and Web Experts Co.,Ltd. and RV Site Builder.
// You should carefully read the following terms and conditions before
// installing or using this software.  Unless you have a different license
// agreement obtained from Web Experts Co.,Ltd., installation or use of this software
// indicates your acceptance of the license and warranty limitation terms
// contained in this Agreement. If you do not agree to the terms of this
// Agreement, promptly delete and destroy all copies of the Software.
//
// =====  Grant of License =======
// The Software may only be installed and used on a single host machine.
//
// =====  Disclaimer of Warranty =======
// THIS SOFTWARE AND ACCOMPANYING DOCUMENTATION ARE PROVIDED "AS IS" AND
// WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR ANY OTHER
// WARRANTIES WHETHER EXPRESSED OR IMPLIED.   BECAUSE OF THE VARIOUS HARDWARE
// AND SOFTWARE ENVIRONMENTS INTO WHICH RV SITE BUILDER MAY BE USED, NO WARRANTY OF
// FITNESS FOR A PARTICULAR PURPOSE IS OFFERED.  THE USER MUST ASSUME THE
// ENTIRE RISK OF USING THIS PROGRAM.  ANY LIABILITY OF Web Experts Co.,Ltd. WILL BE
// LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT OR REFUND OF PURCHASE PRICE.
// IN NO CASE SHALL Web Experts Co.,Ltd. BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
// CONSEQUENTIAL DAMAGES OR LOSS, INCLUDING, WITHOUT LIMITATION, LOST PROFITS
// OR THE INABILITY TO USE EQUIPMENT OR ACCESS DATA, WHETHER SUCH DAMAGES ARE
// BASED UPON A BREACH OF EXPRESS OR IMPLIED WARRANTIES, BREACH OF CONTRACT,
// NEGLIGENCE, STRICT TORT, OR ANY OTHER LEGAL THEORY. THIS IS TRUE EVEN IF
// Web Experts Co.,Ltd. IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. IN NO CASE WILL
// Web Experts Co.,Ltd.'S LIABILITY EXCEED THE AMOUNT OF THE LICENSE FEE ACTUALLY PAID
// BY LICENSEE TO Web Experts Co.,Ltd.

require_once 'Image/Transform/Driver/GD.php';

class AdminArticleWebMgr extends SGL_Manager
{
    function AdminArticleWebMgr()
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        parent::SGL_Manager();

        $this->template     = 'articleManager.html';
        $this->pageTitle    = 'Admin Article Manager';
        
        $this->saveImagePath =  'images/Image/';
        $this->_aActionsMapping =  array(
            'view'      => array('view'),
            'addview'      => array('addview'),
            'editview'      => array('editview'),
            'add'      => array('add', 'redirectToDefault'),
            'edit'      => array('edit', 'redirectToDefault'),
            'delete'      => array('delete', 'redirectToDefault'),             
            'deleteImage'      => array('deleteImage', 'editview'),
            'deleteImageInArticle' => array('deleteImageInArticle'),
        );
        /// START :: rewrite $thsi->conf
        $req = &SGL_Request::singleton();
        $moduleName = $req->get('moduleName');
        $managerName = $req->get('managerName');
        if (strtolower($moduleName) != 'articleweb') {
            /// rewrite conf table name
            $fileRewrireTable = SGL_MOD_DIR . '/' . $moduleName . '/data/rewriteTableAliases.ini';
            if (is_file($fileRewrireTable)) {
                $fileData = parse_ini_file($fileRewrireTable);
                foreach ($fileData as $key => $val) {
                    $this->conf['table'][$key] = SGL_Config::get('db.prefix') . $val;
                }
            }
            ///set default parent conf
            $defaultConfmodule = SGL_MOD_DIR . '/articleweb/conf.ini';
            if (is_file($defaultConfmodule)) {
                $aDefaultConf = parse_ini_file($defaultConfmodule, true);
				foreach ($aDefaultConf as $mgr => $keyconf) {
                    $this->conf[$mgr] = $keyconf;
                }
            }
            ///merge parent conf + current conf by managerName
            $targetConfmodule = SGL_MOD_DIR . '/' . $moduleName . '/conf.ini';
            if (is_file($targetConfmodule)) {
                $aTargetConf = parse_ini_file($targetConfmodule, true);
                foreach ($aTargetConf as $mgr => $keyconf) {
                    if (strtolower($mgr) == strtolower($managerName . 'Mgr')) {
                        array_merge($this->conf[__CLASS__], $this->conf[$mgr]);
                    }
                }
            }
        }
        /// START :: rewrite $thsi->conf
    }

    function validate($req, &$input)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $this->validated    = true;
        $input->error       = array();        
        $input->masterTemplate = $this->masterTemplate;        
        $input->template    = $this->template;
        $input->action      = ($req->get('action')) ? $req->get('action') : 'view';
        
        $input->pageTitle   = $this->pageTitle;
        $input->pageAction = $input->action;

        //$input->frm      = $req->get('frm');
        $input->frmAdd   = $req->get('frmAdd');
        $input->frmData   = $req->get('frmData', true);
        $input->frmEdit = $req->get('frmEdit');
        $input->frmEditArticleID = $req->get('frmEditArticleID');
        $input->frmPerms   = $req->get('frmPerms');
        $input->frmDelete   = $req->get('frmDelete');
        $input->frmAutoResizeIcon = $req->get('frmAutoResizeIcon');
        $input->frmAutoResizeImages = $req->get('frmAutoResizeImages');
        
        $input->assetFileArray = $req->get('assetFile');
        $input->frmUploadImages = $req->get('frmUploadImages');

        $input->sortBy      = SGL_Util::getSortBy($req->get('frmSortBy'), SGL_SORTBY_USER);
        $input->sortOrder   = SGL_Util::getSortOrder($req->get('frmSortOrder'));
        
        $input->frmAdd['defaultLang'] = isset($input->frmAdd['defaultLang']) ? $input->frmAdd['defaultLang'] : '';
        $input->frmAdd['publish'] = isset($input->frmAdd['publish']) ? $input->frmAdd['publish'] : '';
        $input->frmAdd['neverExpired'] = isset($input->frmAdd['neverExpired']) ? $input->frmAdd['neverExpired'] : '';
        
        if (count($input->assetFileArray) != 0) {
            $input->assetFileName         = $input->assetFileArray['name'];
            $input->assetFileTmpName      = $input->assetFileArray['tmp_name'];
        }

        /// START :: custom  adjust commond input datas ::: BooM
        $this->_customCommondInput($req, &$input);
        /// END :: custom  adjust commond input datas ::: BooM
        
        if ( $input->action == "add" || $input->action == "edit" ) {
            if (count($input->frmPerms) == "" || count($input->frmPerms) == "0") {
            $aErrors['perms'] = "Please selete perms is null";
            }
           
       
            
        } elseif ($input->action == "deleteImageInArticle") {
            $input->frmDelImagesID = $req->get('frmDelImagesID');
        }
        
    ################ Start validate ###############
        /// START :: custom adjust  by action
        $this->_customInputByAction($input->action, $req, $input);
        /// END :: custom adjust  by action
        
        $aErrors = array();
        
        /// START :: custom common validate
        $this->_customCommondValidate($input, $aErrors);
        /// END :: custom common validate
        
        switch ($input->action) {
            case "add":          
                $this->_validateAdd($input, &$aErrors);
                if (count($aErrors) > 0) { 
                    $input->template = 'articleEdit.html';
                }
                break;
            case "addview":
             	$input->template = 'articleEdit.html';
            	break;
            case "edit":
                $this->_validateEdit($input, &$aErrors);
               // print_r($aErrors);
                //exit;
                if (count($aErrors) > 0) {
                    $input->template = 'articleEdit.html'; 
                }
                break;
            case "editview" :
            case "deleteImageInArticle" :
                $input->template     = 'articleEdit.html';
                $input->articleEdit = "edit";
                break;
            case "delete":
                break;
        }
        
        /// START :: custom valdiate and custom template by action
        $this->_customValidateByAction($input->action, $input, $aErrors);
        $this->_customUseTemplatebyAction($input->template, $input->action);
        /// END :: custom valdiate and custom template by action
        ################ End validate ###############
        
        //  if errors have occured

         if (count($aErrors) > 0) {
            SGL_Output::translate(SGL::raiseMsg('Validation Failed.'));
            $input->error = $aErrors;
            //$this->validated = false; //disable this code because want validate Error elsewhere other
        }
    }

    function display(&$output)
    {
        $c = &SGL_Config::singleton();
        $output->wysiwyg = true;
        $c->set('debug', array('adminGuiAllowed' => true));
        
        //  select appropriate jscalendar lang file depending on prefs defined language
        $lang = SGL::getCurrentLang();
        $jscalendarLangFile = (is_file(SGL_WEB_ROOT . '/js/jscalendar/lang/calendar-' . $lang . '.js'))
            ? 'js/jscalendar/lang/calendar-' . $lang . '.js'
            : 'js/jscalendar/lang/calendar-en.js';
        $output->addJavascriptFile(array(
            'js/jscalendar/calendar.js',
            $jscalendarLangFile,
            'js/jscalendar/calendar-setup.js'));

        $defaultLang = $this->conf['Default']['defaultLang'];
        $query = "
            SELECT 
                web_lang_id
            FROM 
                {$this->conf['table']['web_lang']} 
            WHERE 
                lang_key = '{$defaultLang}'
        ";
                
        $defaultLangID = $this->dbh->getOne($query);
        $output->displayTab  = 'generalSiteOptions' . $defaultLangID;
        $output->addOnLoadEvent("showSelectedOptions('formAddArticle','$output->displayTab')");
        /// START :: custom display
        $this-> _customOutputDisplay($output);

        /// END :: custom display
    }
    
    function _cmd_view($input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        
        if (isset($_SESSION['aPrefs']['language'])) {
            $this->conf['Default']['defaultLang'] = $_SESSION['aPrefs']['language'];
        }
        
        $allowedSortFields = array('article_id','title','type_name','publish','date_start','date_end','never_expired');
        if (!empty($input->sortBy)
               && !empty($input->sortOrder)
               && in_array($input->sortBy, $allowedSortFields)) {
            $orderByQuery = ' ORDER BY ' . $input->sortBy . ' ' . $input->sortOrder;
        } else {
            $orderByQuery = ' ORDER BY article_id ASC ';
        }
        /// START :: custom query data1
        $queryNumber = 1;
        $aDataQuery = array($queryNumber => array('adjustOrderBy' => $orderByQuery, 'lang_key' => $this->conf['Default']['defaultLang']));
        $this->_customQueryData('view', $input, $queryNumber, $aDataQuery);
        /// END :: custom query data1
        
            $query = sprintf("
            SELECT
                a.article_id, a.date_start, a.publish, a.never_expired, a.date_end, atm.type_name, al.web_lang_id, am.title
            FROM 
                {$this->conf['table']['article']} a, 
                {$this->conf['table']['article_type_message']} atm, 
                {$this->conf['table']['web_lang']} al, 
                {$this->conf['table']['article_message']} am
                %s
            WHERE 
                al.lang_key = '{$aDataQuery[$queryNumber]['lang_key']}'
                AND atm.web_lang_id = al.web_lang_id
                AND atm.article_type_id = a.article_type_id
                AND am.web_lang_id = al.web_lang_id
                AND am.article_id = a.article_id
                %s
                %s
            ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
             , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
             , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );
            
        $limit = $this->conf['AdminArticleWebMgr']['pageNumberPerPage'];
        $pagerOptions = array(
            'mode'     => 'Sliding',
            'delta'    => 3,
            'perPage'  => $limit,
            'spacesBeforeSeparator' => 0,
            'spacesAfterSeparator'  => 0,
            'curPageSpanPre'        => '<span class="currentPage">',
            'curPageSpanPost'       => '</span>',
        );
        $aPagedData = SGL_DB::getPagedData($this->dbh, $query, $pagerOptions);

        foreach ($aPagedData['data'] as $key=> $val) {
            /// START :: custom query data2
            $queryNumber = 2;
            $aDataQuery = array($queryNumber => array('adjustOrderBy' => ''));
            $this->_customQueryData('view', $input, $queryNumber, $aDataQuery);
            /// END :: custom query data2
            $query = sprintf("
                SELECT
                    r.name
                FROM 
                    {$this->conf['table']['article_role']} a, 
                    {$this->conf['table']['role']} r
                    %s
                WHERE
                    a.article_id = '{$aPagedData['data'][$key]['article_id']}'
                    AND a.role_id = r.role_id
                    %s
                    %s
                 ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                     , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                     , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : '');
            
            $aRole = $this->dbh->getCol($query);
            $aPagedData['data'][$key]['perm'] = join(',',$aRole);
            
            if ($aPagedData['data'][$key]['publish'] == 1) {
                $aPagedData['data'][$key]['publish'] = true;
            } else {
                $aPagedData['data'][$key]['publish'] = false;
            }
            
            if ($aPagedData['data'][$key]['never_expired'] == 1) {
                $aPagedData['data'][$key]['never_expired'] = true;
            } else {
                $aPagedData['data'][$key]['never_expired'] = false;
            }
        }
        
        /// START :: custom query data3
        $queryNumber = 3;
        $aDataQuery = array($queryNumber => array('adjustOrderBy' => '', 'lang_key' => $this->conf['Default']['defaultLang']));
        $this->_customQueryData('view', $input, $queryNumber, $aDataQuery);
        /// END :: custom query data3
        $query = sprintf("
            SELECT
                    al.web_lang_id, am.article_type_id, am.type_name
            FROM 
                {$this->conf['table']['web_lang']} al, 
                {$this->conf['table']['article_type_message']} am
                %s
            WHERE
                al.lang_key = '{$aDataQuery[$queryNumber]['lang_key']}'
                AND am.web_lang_id = al.web_lang_id
                %s
                %s", 
                isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : ''
                , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );
        
        $aTypeIdSelect = $this->dbh->getAll($query);
        mb_internal_encoding("UTF-8");
        
        $aTitleLength = $this->conf['AdminArticleWebMgr']['titleLength'];
        
        if (count($aPagedData['data'])) {
            foreach ($aPagedData['data'] as $k => $v) {
                if (strlen($v['title']) > $aTitleLength) {
                    $aPagedData['data'][$k]['title'] = mb_substr($v['title'],0, $aTitleLength) . '...';
                }
            }
        }

        $output->typeIdSelect = $aTypeIdSelect;
        $output->aPagedData = $aPagedData;

        $output->Select = SGL_Output::translate('Select');
        $output->Select = Main::quoteSmart($output->Select);
        
        if (is_array($aPagedData['data']) && count($aPagedData['data'])) {
            $output->pager = ($aPagedData['totalItems'] <= $limit) ? false : true;
        }
        
        $this-> _customOutputCMD('view', $input, $output);
    }

////////////////////////// _cmd_addview /////////////////////////////////
    
    function _cmd_addview(&$input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $dateEndConf = $this->conf['AdminArticleWebMgr']['articleAge'];
        $output->articleAdd = "add";
        
        /// START :: custom query data1
        $queryNumber = 1;
        $aDataQuery = array($queryNumber => array('adjustOrderBy' => '', 'article_type_id' => $input->frmAdd['articleTypeId']));
        $this->_customQueryData('addview', $input, $queryNumber, $aDataQuery);
        /// END :: custom query data1
        
        $query = sprintf("
            SELECT
                    article_type_id, type_name
            FROM 
                {$this->conf['table']['article_type_message']}
                %s
            WHERE
                article_type_id = '{$aDataQuery[$queryNumber]['article_type_id']}'
                %s
                %s", 
                isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : ''
                , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );
                
        $typeSelect = $this->dbh->getRow($query);

        /// START :: custom query data2
        $queryNumber = 2;
        $aDataQuery = array($queryNumber => array('adjustOrderBy' => ''));
        $this->_customQueryData('addview', $input, $queryNumber, $aDataQuery);
        /// END :: custom query data2
        
        $query = sprintf("
            SELECT
                    web_lang_id, lang_key
            FROM 
                {$this->conf['table']['web_lang']}
                %s
                %s
                %s", 
                isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : ''
                , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );
        
        $aLangs  = SGL_Util::getLangsDescriptionMap();
        
        $aTypeData = $this->dbh->getAssoc($query);
        foreach ($aTypeData as $key=>$val) {
            $langName = explode(' ',$aLangs[$val]);
            $typeLang[$key]['lang_name'] = SGL_Output::translate($langName[0]);
            $typeLang[$key]['type_name'] = ''; 
            $typeLang[$key]['description'] = '';
        }
        
        /// START :: custom query data3
        $queryNumber = 3;
        $aDataQuery = array($queryNumber => array('adjustOrderBy' => '', 'article_type_id' => $input->frmAdd['articleTypeId']));
        $this->_customQueryData('addview', $input, $queryNumber, $aDataQuery);
        /// END :: custom query data3
        
           $query = sprintf("SELECT r.role_id, r.name
                         FROM 
                            {$this->conf['table']['article_type_role']} a,
                            {$this->conf['table']['role']} r
                            %s
                         WHERE a.article_type_id = '{$aDataQuery[$queryNumber]['article_type_id']}'
                             %s
                         AND r.role_id = a.role_id
                         	%s", 
                            isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : ''
                            , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                            , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );

        $aRole = $this->dbh->getAll($query, DB_FETCHMODE_ASSOC);

        for ($i = 0; $i < sizeof($aRole); $i++) {
            $id = $aRole[$i]['role_id'];
            $aRoleOption[$id] = $aRole[$i]['name'];
            
            if ($i == 0) {
                $permsSelected = $id;
            }
        }
        
        /// START :: custom query data4
        $queryNumber = 4;
        $aDataQuery = array($queryNumber => array('adjustOrderBy' => '', 'lang_key' => $this->conf['Default']['defaultLang']));
        $this->_customQueryData('addview', $input, $queryNumber, $aDataQuery);
        /// END :: custom query data4
        
        $query = sprintf("SELECT
                            `web_lang_id`
                        FROM
                            {$this->conf['table']['web_lang']}
                            %s
                        WHERE
                            `lang_key` = '{$aDataQuery[$queryNumber]['lang_key']}'
                            %s
                            %s", 
                            isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : ''
                            , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                            , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );

        $defaultLangID = $this->dbh->getOne($query);
        
        foreach ($typeLang as $key => $v) {
            if ($key == $defaultLangID && count($aTypeData) > 1) {
                $typeLang[$key]['defaultLang'] = "1";
            } else {
                $typeLang[$key]['defaultLang'] = "";
            }
        }

        if (!$this->_detectGd()) {
            $output->skipGd = 1;
        }
        
        $output->articleTypeId = $input->frmAdd['articleTypeId'];
        $output->typeName = $typeSelect->type_name;
        $output->aTypeLang = $typeLang;
        $output->langTitle = "yes";
        $output->aRoles = $aRoleOption;
        $output->permsSelected = $permsSelected;

        $output->dateStartHidden = strftime("%Y-%m-%d %H:%M:%S");
        $output->dateEndHidden = strftime("%Y-%m-%d %H:%M:%S" , strtotime("+$dateEndConf days"));
        
        $output->dateStartShow = strftime("%d %B %Y, %H:%M");
        $output->dateEndShow = strftime("%d %B %Y, %H:%M",strtotime("+$dateEndConf days"));
        
        $output->iconWidth = $this->conf['AdminArticleWebMgr']['iconWidth'];
        $output->iconHeigh = $this->conf['AdminArticleWebMgr']['iconHeigh'];

        $output->checkNeverExpired = $this->conf['AdminArticleWebMgr']['neverExpired'];
        $output->checkPublish = $this->conf['AdminArticleWebMgr']['publish'];
        $output->checkDefaultLang = $this->conf['AdminArticleWebMgr']['skipDefaultLang'];
        $output->titleWysiwyg = $this->conf['AdminArticleWebMgr']['titleWysiwyg'];
        $output->messageWysiwyg = $this->conf['AdminArticleWebMgr']['messageWysiwyg'];
        
        $this-> _customOutputCMD('addview', $input, $output);
    }

    ////////////////////////////////////////////////////////////////////////
    ////////////////////////// _cmd_add /////////////////////////////////
    ////////////////////////////////////////////////////////////////////////

    function _cmd_add(&$input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        
         if (isset($input->assetFileName) && $input->assetFileName != "") {
            $iconArticle = $this->_uploadImage($input->assetFileName, $input->assetFileTmpName);
        
            if ($this->_detectGd() && $input->frmAutoResizeIcon) {
                $im = new Image_Transform_Driver_GD();
                $srcImgLocation = SGL_WEB_ROOT . '/' . $this->saveImagePath . $iconArticle;
                $targetLocation = SGL_WEB_ROOT . '/' . $this->saveImagePath . $iconArticle;
                $this->_resizeImageAndSave($im, $srcImgLocation, $targetLocation,$this->conf['AdminArticleWebMgr']['iconWidth'], $this->conf['AdminArticleWebMgr']['iconHeigh']);
            }
         } else {
             $iconArticle = '';
         }

         if (isset($input->frmUploadImages)) {
            $aUploadImageDatas = array();
             foreach ($input->frmUploadImages['name'] as $k => $v) {
                 if ($input->frmUploadImages['error'][$k] > 0) {
                     continue;
                 }
                 $imageArticle = $this->_uploadImage($input->frmUploadImages['name'][$k], $input->frmUploadImages['tmp_name'][$k]);
                 $aUploadImageDatas[] = array(
                    'filename' => $imageArticle,
                    'oldfilename' => $input->frmUploadImages['name'][$k],
                    'path' => $this->saveImagePath,
                );
                if ($this->_detectGd() && $input->frmAutoResizeImages) {
                    $im = new Image_Transform_Driver_GD();
                    $srcImgLocation = SGL_WEB_ROOT . '/' . $this->saveImagePath . $imageArticle;
                    $targetLocation = SGL_WEB_ROOT . '/' . $this->saveImagePath . $imageArticle;
                    $this->_resizeImageAndSave($im, $srcImgLocation, SGL_WEB_ROOT . '/' . $this->saveImagePath . 'm_' . $imageArticle, '50%', '50%');
                    $this->_resizeImageAndSave($im, $srcImgLocation, SGL_WEB_ROOT . '/' . $this->saveImagePath . 's_' . $imageArticle, '25%', '25%');
                 }
             }
         }

        $articleID = $this->dbh->nextId($this->conf['table']['article']);
        $timeStampStart = $this->getTimeStamp($input->frmAdd['dateStart']);
        $timeStampEnd = $this->getTimeStamp($input->frmAdd['dateEnd']);

        $defaultLang = isset($input->frmAdd['defaultLang']) ? $input->frmAdd['defaultLang'] : '0';
        
         /// START :: custom query data1
        $queryNumber = 1;
        $aDataQuery = array($queryNumber => 
            array(
                'article_id' => $articleID,
                'article_type_id' => $input->frmAdd['articleTypeId'],
                'date_start' => $timeStampStart,
                'date_end' => $timeStampEnd,
                'article_icon' => $iconArticle,
                'skip_default_lang' => $input->frmAdd['defaultLang'],
                'publish' => $input->frmAdd['publish'],
                'never_expired' => $input->frmAdd['neverExpired'],
                'user_id' => $input->frmAdd['author'],
            )
        );
        $this->_customQueryData('add', $input, $queryNumber, $aDataQuery);
        /// END :: custom query data1
        
        $query = "
            INSERT INTO 
                {$this->conf['table']['article']} (`article_id`,`article_type_id`,`date_start`,`date_end`,`article_icon`,`skip_default_lang`,`publish`,`never_expired`, `user_id`) 
            VALUES (
                '{$aDataQuery[$queryNumber]['article_id']}'
                , '{$aDataQuery[$queryNumber]['article_type_id']}'
                , '{$aDataQuery[$queryNumber]['date_start']}'
                , '{$aDataQuery[$queryNumber]['date_end']}'
                , '{$aDataQuery[$queryNumber]['article_icon']}'
                , '{$aDataQuery[$queryNumber]['skip_default_lang']}'
                , '{$aDataQuery[$queryNumber]['publish']}'
                , '{$aDataQuery[$queryNumber]['never_expired']}'
                , '{$aDataQuery[$queryNumber]['user_id']}'
          )";

        $ok = $this->dbh->query($query);
        $dbQuery = (DB::isError($ok)) ? false : true;
        
        
        /// START: custom query 1
        $this->_customAfterInsertDB('add', $queryNumber, $aDataQuery[$queryNumber],  $input);
        /// END: custom query 1
        
        if (is_array($input->frmPerms)) {
            foreach ($input->frmPerms as $key => $v) {
            
               /// START: custom input insert 2
                $queryNumber = 2;
                $aDataQuery = array( $queryNumber => 
                    array(
                		'article_id' => $articleID,
                		'role_id' => $v,
                    )
                );
                $this->_customQueryData('add', $input, $queryNumber, $aDataQuery);
                /// END :: custom query data4
               /// END: custom input insert 2
        
                $query = "
                INSERT INTO 
                    {$this->conf['table']['article_role']} ( `article_id` , `role_id` )
                VALUES (
                    '{$aDataQuery[$queryNumber]['article_id']}', '{$aDataQuery[$queryNumber]['role_id']}'
                )";
                $this->dbh->query($query);
            
           /// START: custom query 2
               $this->_customAfterInsertDB('add', $queryNumber, $aDataQuery[$queryNumber],  $input);
           /// END: custom query 2
            }
        }
        
        foreach ($input->frmData as $keyLangId => $v) {
            $articleMessageId = $this->dbh->nextId($this->conf['table']['article_message']);
            $subject = (isset($v['subject'])) ? Main::quoteSmart($v['subject']) : '""';
            $textData = (isset($v['textData'])) ? Main::quoteSmart($v['textData']) : '""';
            
            $extraField1 = (isset($v['extraField1'])) ? Main::quoteSmart($v['extraField1']) : '""';
            $extraField2 = (isset($v['extraField2'])) ? Main::quoteSmart($v['extraField2']) : '""';
            $extraField3 = (isset($v['extraField3'])) ? Main::quoteSmart($v['extraField3']) : '""';
            $extraField4 = (isset($v['extraField4'])) ? Main::quoteSmart($v['extraField4']) : '""';
            $extraField5 = (isset($v['extraField5'])) ? Main::quoteSmart($v['extraField5']) : '""';
            
            /// START: custom input insert 3
            $queryNumber = 3;
            $aDataQuery = array( $queryNumber => 
                array(
                    'article_message_id' => $articleMessageId,
                    'web_lang_id' => $keyLangId,
                    'article_id' => $articleID,
                    'title' => $subject,
                    'message' => $textData,
                    'extra_field1' => $extraField1,
                    'extra_field2' => $extraField2,
                    'extra_field3' => $extraField3,
                    'extra_field4' => $extraField4,
                    'extra_field5' => $extraField5
                )
            );
            $this->_customQueryData('add', $input, $queryNumber, $aDataQuery);
           /// END: custom input insert 3
           
            $query = "
                INSERT INTO 
                    {$this->conf['table']['article_message']} (
                        `article_message_id` ,
                        `web_lang_id` ,
                        `article_id` ,
                        `title` ,
                        `message`,
                        `extra_field1`,
                        `extra_field2`,
                        `extra_field3`,
                        `extra_field4`,
                        `extra_field5`
                    )
                VALUES (
                    '{$aDataQuery[$queryNumber]['article_message_id']}' ,
                    '{$aDataQuery[$queryNumber]['web_lang_id']}' ,
                    '{$aDataQuery[$queryNumber]['article_id']}' ,
                    {$aDataQuery[$queryNumber]['title']} ,
                    {$aDataQuery[$queryNumber]['message']} ,
                    {$aDataQuery[$queryNumber]['extra_field1']} ,
                    {$aDataQuery[$queryNumber]['extra_field2']} ,
                    {$aDataQuery[$queryNumber]['extra_field3']} ,
                    {$aDataQuery[$queryNumber]['extra_field4']} ,
                    {$aDataQuery[$queryNumber]['extra_field5']}
                )";
            $this->dbh->query($query);
            
            /// START: custom query 3
            $this->_customAfterInsertDB('add', $queryNumber, $aDataQuery[$queryNumber],  $input);
           /// END: custom query 3
           
        }
        
        if (isset($aUploadImageDatas)) {
            foreach ($aUploadImageDatas as $k => $v) {
                /// START: custom input insert 4
                $queryNumber = 4;
                $articleImageId = $this->dbh->nextId($this->conf['table']['article_images']);
                $aDataQuery = array( $queryNumber => 
                    array(
                        'article_image_id' => $articleImageId,
                        'article_id' => $articleID,
                        'image_name' => $v['filename'],
                        'oldfilename' => $v['oldfilename'],
                        'image_path' => $v['path'],
                    )
                );
                $this->_customQueryData('add', $input, $queryNumber, $aDataQuery);
                /// END: custom input insert 4

                $query = "
                    INSERT INTO 
                        {$this->conf['table']['article_images']} ( 
                            `image_id` ,
                            `article_id` ,
                            `oldfilename`,
                            `image_name` ,
                            `image_path`
                        )
                    VALUES (
                        '{$aDataQuery[$queryNumber]['article_image_id']}' ,
                        '{$aDataQuery[$queryNumber]['article_id']}' ,
                        '{$aDataQuery[$queryNumber]['oldfilename']}' ,
                        '{$aDataQuery[$queryNumber]['image_name']}' ,
                        '{$aDataQuery[$queryNumber]['image_path']}'
                    )";
                $this->dbh->query($query);
                /// START: custom query 4
                $this->_customAfterInsertDB('add', $queryNumber, $aDataQuery[$queryNumber],  $input);
                /// END: custom query 4
            }
        }
        
        if ($input->imageError) {
            SGL::raiseMsg($input->imageError,false, SGL_MESSAGE_WARNING);
        } else {
            SGL::raiseMsg('Article successfully updated', true, SGL_MESSAGE_INFO);
        }

        /// START: customOutputCMD
        $this-> _customOutputCMD('add', $input, $output);
        /// END: customOutputCMD
        return $dbQuery;
    }
    
////////////////////////////////////////////////////////////////////////////
////////////////////////// _cmd_editview /////////////////////////////////
////////////////////////////////////////////////////////////////////////////
    
    function _cmd_editview(&$input, &$output)
    {
        
        $output->articleEdit = "edit";
        $queryNumber = 1;
        $aDataQuery = array($queryNumber => array());
        $this->_customQueryData('editview', $input, $queryNumber, $aDataQuery);
        
        $query = sprintf("
                    SELECT 
                        `web_lang_id`
                    FROM 
                        {$this->conf['table']['web_lang']}
                        %s
                    WHERE 
                        `lang_key` = '{$this->conf['Default']['defaultLang']}'
                        %s
                        %s
                      ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                       , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                       , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );
        $defaultLangID = $this->dbh->getOne($query);

        $queryNumber = 2;
        $aDataQuery = array($queryNumber => array());
        $this->_customQueryData('editview', $input, $queryNumber, $aDataQuery);
        
        $query = sprintf("
                    SELECT 
                        *
                    FROM 
                        {$this->conf['table']['web_lang']}
                        %s
                    WHERE 
                        %s
                        %s
                      ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                       , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : '1'
                       , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );  
        $aLangs  = SGL_Util::getLangsDescriptionMap();
        $aTypeData = $this->dbh->getAssoc($query);

        foreach ($aTypeData as $key=>$val) {
            if ($key == $defaultLangID && count($aTypeData) > 1) {
                $typeLang[$key]['defaultLang'] = '1';
            } else {
                $typeLang[$key]['defaultLang'] = '';
            }
            $langName = explode(' ',$aLangs[$val]);
            $typeLang[$key]['lang_name'] = SGL_Output::translate($langName[0]);
        }
        $queryNumber = 3;
        $aDataQuery = array($queryNumber => array('article_id' => $input->frmEditArticleID));
        $this->_customQueryData('editview', $input, $queryNumber, $aDataQuery);
        $query = sprintf("
                    SELECT 
                        * 
                    FROM 
                        {$this->conf['table']['article_message']} m, 
                        {$this->conf['table']['web_lang']} l
                        %s
                    WHERE 
                        `article_id` = '{$aDataQuery[$queryNumber]['article_id']}'
                         AND m.web_lang_id = l.web_lang_id
                         %s
                         %s
                         ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                          , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                          , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );

        $articleMessage = $this->dbh->getAll($query, DB_FETCHMODE_ASSOC);

        foreach ($articleMessage as $key=>$val) {
            $langId = $val['web_lang_id'];
            $typeLang[$langId]['article_message_id'] = $val['article_message_id'];
            $typeLang[$langId]['title'] = $val['title'];
            $typeLang[$langId]['message'] = $val['message'];
            
            $typeLang[$langId]['extraField1'] = $val['extra_field1'];
            $typeLang[$langId]['extraField2'] = $val['extra_field2'];
            $typeLang[$langId]['extraField3'] = $val['extra_field3'];
            $typeLang[$langId]['extraField4'] = $val['extra_field4'];
            $typeLang[$langId]['extraField5'] = $val['extra_field5'];
        }
        
        $queryNumber = 4;
  
        $aDataQuery = array($queryNumber => array('article_id' => $input->frmEditArticleID));
        $this->_customQueryData('editview', $input, $queryNumber, $aDataQuery);
        $query = sprintf("
                    SELECT 
                        * 
                    FROM 
                        {$this->conf['table']['article']}
                        %s
                    WHERE 
                        `article_id` = '{$aDataQuery[$queryNumber]['article_id']}'
                        %s
                        %s
                        ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                         , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                         , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );
        $article = $this->dbh->getRow($query, DB_FETCHMODE_ASSOC);
        $queryNumber = 5;
        $aDataQuery = array($queryNumber => array());
        $this->_customQueryData('editview', $input, $queryNumber, $aDataQuery);
        $query = sprintf("
                    SELECT 
                        r.role_id, r.name
                    FROM 
                        {$this->conf['table']['article_type_role']} a, 
                        {$this->conf['table']['role']} r
                        %s
                    WHERE 
                        a.article_type_id = '{$article['article_type_id']}'
                        AND r.role_id = a.role_id
                        %s
                        %s
                        ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                         , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                         , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );

        $aRole = $this->dbh->getAll($query, DB_FETCHMODE_ASSOC);

        for ($i = 0; $i < sizeof($aRole); $i++) {
            $id = $aRole[$i]['role_id'];
            $aRoleOption[$id] = $aRole[$i]['name'];
        }
        $queryNumber = 6;
        $aDataQuery = array($queryNumber => array());
        $this->_customQueryData('editview', $input, $queryNumber, $aDataQuery);
        $query = sprintf("
                    SELECT 
                        article_type_id, type_name
                    FROM 
                        {$this->conf['table']['article_type_message']}
                        %s
                    WHERE 
                        article_type_id = '{$article['article_type_id']}'
                        AND web_lang_id = '{$defaultLangID}'
                        %s
                        %s
 						", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                         , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                         , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );

        $typeSelect = $this->dbh->getRow($query);
     
        $queryNumber = 7;
        $aDataQuery = array($queryNumber => array('article_id' => $input->frmEditArticleID));
        $this->_customQueryData('editview', $input, $queryNumber, $aDataQuery);
        $query = sprintf("SELECT role_id
                        FROM 
                            {$this->conf['table']['article_role']}
                            %s
                        WHERE 
                            article_id = '{$aDataQuery[$queryNumber]['article_id']}'
                            %s
                            %s
                       	", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                         , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                         , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );
        $permsSelected = $this->dbh->getCol($query);
       // print_r($permsSelected);
        if (count($permsSelected) == "") {
            $output->permsSelected = 1;
        } else {
            $output->permsSelected = $permsSelected;
        }

        if (!$this->_detectGd()) {
            $output->skipGd = 1;
        }
        $queryNumber = 8;
        $aDataQuery = array($queryNumber => array());
        $this->_customQueryData('editview', $input, $queryNumber, $aDataQuery);
        $query = sprintf("
                    SELECT 
                        username
                    FROM 
                        {$this->conf['table']['user']}
                        %s
                    WHERE 
                        usr_id = '{$article['user_id']}'
                        %s
                        %s
                       	", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                       	, isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                       	, isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );

        $userCreate = $this->dbh->getOne($query);

        $queryNumber = 9;
        $aDataQuery = array($queryNumber => array('article_id' => $input->frmEditArticleID));
        $this->_customQueryData('editview', $input, $queryNumber, $aDataQuery);
        $query = sprintf("
                    SELECT 
                        a.image_id, a.image_name, a.image_path, a.oldfilename
                    FROM 
                        {$this->conf['table']['article_images']} a
                        %s
                    WHERE 
                        a.article_id = '{$aDataQuery[$queryNumber]['article_id']}'
                        %s
                        %s
                        ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                         , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                         , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );

        $aArticleImages = $this->dbh->getAll($query, DB_FETCHMODE_ASSOC);
        
        $output->aArticleImages = $aArticleImages;
        $output->aRoles = $aRoleOption;

        $dateStartHidden =  strftime("%Y-%m-%d %H:%M",$article['date_start']);
        $dateEndHidden =  strftime("%Y-%m-%d %H:%M",$article['date_end']);

        $dateStartShow = strftime("%d %B %Y %H:%M",$article['date_start']);
        $dateEndShow = strftime("%d %B %Y %H:%M",$article['date_end']);
        
        $output->dateStartHidden = $dateStartHidden;
        $output->dateEndHidden = $dateEndHidden;

        $output->dateStartShow = $dateStartShow;
        $output->dateEndShow = $dateEndShow;
        
        $output->aTypeLang = $typeLang;
        $output->articleTypeId = $article['article_type_id'];
        $output->typeName = $typeSelect->type_name;
        $output->articleId = $article['article_id'];
        $output->author = $userCreate;

        $output->checkNeverExpired = $article['never_expired'];
        $output->checkPublish = $article['publish'];
        $output->checkDefaultLang = $article['skip_default_lang'];

        $output->icon = $article['article_icon'];
        $output->iconWidth = $this->conf['AdminArticleWebMgr']['iconWidth'];
        $output->iconHeigh = $this->conf['AdminArticleWebMgr']['iconHeigh'];
        $output->titleWysiwyg = $this->conf['AdminArticleWebMgr']['titleWysiwyg'];
        $output->messageWysiwyg = $this->conf['AdminArticleWebMgr']['messageWysiwyg'];
        
        /// START: customOutputCMD
        $this-> _customOutputCMD('editview', $input, $output);
        /// END: customOutputCMD
    }

////////////////////////// _cmd_edit /////////////////////////////////

    function _cmd_edit($input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $timeStampStart = $this->getTimeStamp($input->frmAdd['dateStart']);
        $timeStampEnd = $this->getTimeStamp($input->frmAdd['dateEnd']);
        
        $iconArticle = '';
        if (isset($input->assetFileName) && $input->assetFileName != "") {
            if (isset($input->frmEdit['iconArticle']) && $input->frmEdit['iconArticle'] != '') {
                $srcImgArticle = SGL_WEB_ROOT . '/' . $this->saveImagePath . $input->frmEdit['iconArticle'];
                if (is_file($srcImgArticle)) {
                    unlink($srcImgArticle);
                }
            }

            $iconArticle = $this->_uploadImage($input->assetFileName, $input->assetFileTmpName);

            if ($this->_detectGd() && $input->frmAutoResizeIcon) {
                $im = new Image_Transform_Driver_GD();
                $srcImgLocation = SGL_WEB_ROOT . '/' . $this->saveImagePath . $iconArticle;
                $targetLocation = SGL_WEB_ROOT . '/' . $this->saveImagePath . $iconArticle;
                $this->_resizeImageAndSave($im, $srcImgLocation, $targetLocation,$this->conf['AdminArticleWebMgr']['iconWidth'], $this->conf['AdminArticleWebMgr']['iconHeigh']);
            }
        }

        if (isset($input->frmUploadImages)) {
            $aUploadImageDatas = array();
            foreach ($input->frmUploadImages['name'] as $k => $v) {
                if ($input->frmUploadImages['error'][$k] > 0) {
                    continue;
                }
                $imageArticle = $this->_uploadImage($input->frmUploadImages['name'][$k], $input->frmUploadImages['tmp_name'][$k]);
                $aUploadImageDatas[] = array(
                    'filename' => $imageArticle,
                    'oldfilename' => $input->frmUploadImages['name'][$k],
                    'path' => $this->saveImagePath,
                );
                if ($this->_detectGd() && $input->frmAutoResizeImages) {
                    $im = new Image_Transform_Driver_GD();
                    $srcImgLocation = SGL_WEB_ROOT . '/' . $this->saveImagePath . $imageArticle;
                    $targetLocation = SGL_WEB_ROOT . '/' . $this->saveImagePath . $imageArticle;
                    $mImageWSize = $this->conf['AdminArticleWebMgr']['m_imagesWidth'] ? $this->conf['AdminArticleWebMgr']['m_imagesWidth'] : '50%';
                    $mImageHSize = $this->conf['AdminArticleWebMgr']['m_imagesHeigh'] ? $this->conf['AdminArticleHeigh']['m_imagesHeigh'] : '50%';
                    $sImageWSize = $this->conf['AdminArticleWebMgr']['m_imagesWidth'] ? $this->conf['AdminArticleWebMgr']['s_imagesWidth'] : '25%';
                    $sImageHSize = $this->conf['AdminArticleWebMgr']['m_imagesHeigh'] ? $this->conf['AdminArticleHeigh']['s_imagesHeigh'] : '25%';
                    
                    $this->_resizeImageAndSave($im, $srcImgLocation, SGL_WEB_ROOT . '/' . $this->saveImagePath . 'm_' . $imageArticle, $mImageWSize, $mImageHSize, 1);
                    $this->_resizeImageAndSave($im, $srcImgLocation, SGL_WEB_ROOT . '/' . $this->saveImagePath . 's_' . $imageArticle, $sImageWSize, $sImageHSize, 1);
                }
            }
        }
        /// START :: custom query data1
        $queryNumber = 1;
        $aDataQuery = array($queryNumber => 
            array(
                'article_type_id' => $input->frmAdd['articleTypeId'],
                'date_start' => $timeStampStart,
                'date_end' => $timeStampEnd,
                'article_icon' => $iconArticle,
                'skip_default_lang' => $input->frmAdd['defaultLang'],
                'publish' => $input->frmAdd['publish'],
                'never_expired' => $input->frmAdd['neverExpired'],
                'article_id' => $input->frmEdit['articleId'],
            )
        );
        $this->_customQueryData('edit', $input, $queryNumber, $aDataQuery);
        /// END :: custom query data1
            
        $query = "
            UPDATE 
                {$this->conf['table']['article']}
            SET
                `article_type_id` = '{$aDataQuery[$queryNumber]['article_type_id']}',
                `date_start` = '{$aDataQuery[$queryNumber]['date_start']}',
                `date_end` = '{$aDataQuery[$queryNumber]['date_end']}',
                `article_icon` = '{$aDataQuery[$queryNumber]['article_icon']}',
                `skip_default_lang` = '{$aDataQuery[$queryNumber]['skip_default_lang']}',
                `publish` = '{$aDataQuery[$queryNumber]['publish']}',
                `never_expired` = '{$aDataQuery[$queryNumber]['never_expired']}'
            WHERE 
                `article_id` =  '{$aDataQuery[$queryNumber]['article_id']}'
            ";

        $this->dbh->query($query);
            
        // START: custom query 1
        $this->_customAfterInsertDB('edit', $queryNumber, $aDataQuery[$queryNumber],  $input);
        /// END: custom query 1

        /// START :: custom query data2
        $queryNumber = 2;
        $aDataQuery = array($queryNumber => 
            array(
                'article_id' => $input->frmEdit['articleId'],
            )
        );
        $this->_customQueryData('edit', $input, $queryNumber, $aDataQuery);
        /// END :: custom query data2
            
        $query = "
            DELETE FROM 
                {$this->conf['table']['article_role']}
            WHERE 
                `article_id` = '{$input->frmEdit['articleId']}'
        ";

        $this->dbh->query($query);
            
        // START: custom query 2
        $this->_customAfterInsertDB('edit', $queryNumber, $aDataQuery[$queryNumber],  $input);
        /// END: custom query 2
        
        if (is_array($input->frmPerms)) {
            foreach ($input->frmPerms as $key => $val) {
                /// START :: custom query data3
                $queryNumber = 3;
                $aDataQuery = array($queryNumber => 
                    array(
                        'article_id' => $input->frmEdit['articleId'],
                        'role_id' => $val,
                    )
                );
                $this->_customQueryData('edit', $input, $queryNumber, $aDataQuery);
                /// END :: custom query data3
            
                $query = "
                    INSERT INTO 
                        {$this->conf['table']['article_role']} ( `article_id` , `role_id` )
                    VALUES (
                        '{$aDataQuery[$queryNumber]['article_id']}', '{$aDataQuery[$queryNumber]['role_id']}'
                    )
                ";

                $this->dbh->query($query);
            }
        }
        
        foreach ($input->frmData as $key => $val) {
            $subject = Main::quoteSmart($input->frmData[$key]['subject']);
            $textData = Main::quoteSmart($input->frmData[$key]['textData']);
            
            $extraField1 = Main::quoteSmart($val['extraField1']);
            $extraField2 = Main::quoteSmart($val['extraField2']);
            $extraField3 = Main::quoteSmart($val['extraField3']);
            $extraField4 = Main::quoteSmart($val['extraField4']);
            $extraField5 = Main::quoteSmart($val['extraField5']);
            
            /// START :: custom query data4
            $queryNumber = 4;
            $aDataQuery = array($queryNumber => 
                array(
                    'article_id' => $input->frmEdit['articleId'],
                    'web_lang_id' => $key,
                    'title' => $subject,
                    'message' => $textData,
                    'extra_field1' => $extraField1,
                    'extra_field2' => $extraField2,
                    'extra_field3' => $extraField3,
                    'extra_field4' => $extraField4,
                    'extra_field5' => $extraField5,
                    'adjustWhere' => "AND `web_lang_id` = '$key' ",
                    'adjustOrderBy' => 'LIMIT 1 ',
                )
            );
            $this->_customQueryData('edit', $input, $queryNumber, $aDataQuery);
            /// END :: custom query data4
            
            $query = sprintf("
                UPDATE 
                    {$this->conf['table']['article_message']} 
                SET
                    `title` = {$aDataQuery[$queryNumber]['title']},
                    `message` = {$aDataQuery[$queryNumber]['message']},
                    `extra_field1` = {$aDataQuery[$queryNumber]['extra_field1']},
                    `extra_field2` = {$aDataQuery[$queryNumber]['extra_field2']},
                    `extra_field3` = {$aDataQuery[$queryNumber]['extra_field3']},
                    `extra_field4` = {$aDataQuery[$queryNumber]['extra_field4']},
                    `extra_field5` = {$aDataQuery[$queryNumber]['extra_field5']}
                WHERE 
                    `article_id` = '{$aDataQuery[$queryNumber]['article_id']}'
                    %s
                    %s
            ", 
                isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );
            $this->dbh->query($query);

            // START: custom query 4
            $this->_customAfterInsertDB('edit', $queryNumber, $aDataQuery[$queryNumber],  $input);
            /// END: custom query 4
        }
        
        if (isset($aUploadImageDatas)) {
            foreach ($aUploadImageDatas as $k => $v) {
                /// START: custom input insert 3
                $queryNumber = 4;
                $articleImageId = $this->dbh->nextId($this->conf['table']['article_images']);
                $aDataQuery = array( $queryNumber => 
                    array(
                        'article_image_id' => $articleImageId,
                        'article_id' => $input->frmEdit['articleId'],
                        'image_name' => $v['filename'],
                        'oldfilename' => $v['oldfilename'],
                        'image_path' => $v['path'],
                    )
                );
                $this->_customQueryData('add', $input, $queryNumber, $aDataQuery);
                 /// END: custom input insert 3

                $query = "
                    INSERT INTO 
                        {$this->conf['table']['article_images']} ( 
                            `image_id` ,
                            `article_id` ,
                            `image_name` ,
                            `oldfilename` ,
                            `image_path`
                        )
                    VALUES (
                        '{$aDataQuery[$queryNumber]['article_image_id']}' ,
                        '{$aDataQuery[$queryNumber]['article_id']}' ,
                        '{$aDataQuery[$queryNumber]['image_name']}' ,
                        '{$aDataQuery[$queryNumber]['oldfilename']}' ,
                        '{$aDataQuery[$queryNumber]['image_path']}'
                    )";
                $this->dbh->query($query);
               /// END: custom input insert 3
               
                /// START: custom query 4
                $this->_customAfterInsertDB('edit', $queryNumber, $aDataQuery[$queryNumber],  $input);
               /// END: custom query 4
            }
            
            /// START customOutputCMD
           $this-> _customOutputCMD('edit', $input, $output);
           /// END customOutputCMD
        }
        if ($input->imageError) {
            SGL::raiseMsg($input->imageError, true, SGL_MESSAGE_WARNING);
        } else {
            SGL::raiseMsg('Article successfully updated', true, SGL_MESSAGE_INFO);
        }
    }

////////////////////////// _cmd_delete /////////////////////////////////

    function _cmd_delete(&$input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);

        if (is_array($input->frmDelete)) {
            foreach ($input->frmDelete as $k => $v) {
                $this->_deleteDataInDB( $v);
            }
        } else if (is_string($input->frmDelete)){
            $this->_deleteDataInDB($input->frmDelete);
        }
        SGL::raiseMsg('Article successfully delete', true, SGL_MESSAGE_INFO);
        
        $this-> _customOutputCMD('delete', $input, $output);
        return true;
    }

    function _deleteDataInDB($articleID = null)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        if ($articleID != null) {
            $queryNumber = 1;
            $aDataQuery = array($queryNumber => array('article_id' => $articleID));
            $this->_customQueryData('deleteDataInDB', $input, $queryNumber, $aDataQuery);
            $query = sprintf("
                    SELECT 
                        a.image_id, a.image_name, a.image_path, a.oldfilename
                    FROM 
                        {$this->conf['table']['article_images']} a
                        %s
                    WHERE 
                        a.article_id = '{$aDataQuery[$queryNumber]['article_id']}'
                        %s
                        %s
                        ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                         , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                         , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );
            $aArticleImages = $this->dbh->getAll($query, DB_FETCHMODE_ASSOC);
        
            $query = "DELETE FROM {$this->conf['table']['article']} WHERE `article_id` = '{$articleID}'";
            $this->dbh->query($query);
        
            $query = "DELETE FROM {$this->conf['table']['article_message']} WHERE `article_id` = '{$articleID}'";
            $this->dbh->query($query);
        
            $query = "DELETE FROM {$this->conf['table']['article_role']} WHERE `article_id` = '{$articleID}'";
            $this->dbh->query($query);
            
            $query = "DELETE FROM {$this->conf['table']['article_images']} WHERE `article_id` = '{$articleID}'";
            $this->dbh->query($query);
            
            $this->_customDeleteDataInDB($query);
            $query = "
                SELECT 
                    article_icon
                FROM 
                    {$this->conf['table']['article']}
                WHERE 
                    article_id= '{$articleID}'
            ";
            $iconType = $this->dbh->getOne($query);
            
            $targetIcon = SGL_WEB_ROOT . '/' . $this->saveImagePath . $iconType;
        
            if (is_file($targetIcon)) {
                unlink($targetIcon);
            }
            
            foreach ($aArticleImages as $k => $v) {
                $targetIcon = SGL_WEB_ROOT . '/' . $v['image_path'] . $v['image_name'];
                if (is_file($targetIcon)) {
                    unlink($targetIcon);
                }
                $targetIcon = SGL_WEB_ROOT . '/' . $v['image_path'] . 'm_' . $v['image_name'];
                if (is_file($targetIcon)) {
                    unlink($targetIcon);
                }
                $targetIcon = SGL_WEB_ROOT . '/' . $v['image_path'] . 's_' . $v['image_name'];
                if (is_file($targetIcon)) {
                    unlink($targetIcon);
                }
            }
            return 1;
        } else {
            return 0;
        }
    }
    
    function _cmd_deleteImageInArticle($input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        if (empty($input->frmDelImagesID) || $input->frmDelImagesID == '') {
            return 0;   
        }
        
        if (is_array($input->frmDelImagesID)) {
            foreach ($input->frmDelImagesID as $k => $v) {
                $this->_deleteImageInArticle($v);
            }
        } else {
            $this->_deleteImageInArticle($input->frmDelImagesID);   
        }
        
        $req = &SGL_Request::singleton();
        $managerName = $req->get('managerName');
        
        SGL::raiseMsg('Article images successfully delete', true, SGL_MESSAGE_INFO);
        SGL_HTTP::redirect(array('managerName' => $managerName,'action'=>'editview' , 'frmEditArticleID' => $input->frmEditArticleID));
    }
    
    function _deleteImageInArticle($imageID)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $queryNumber = 1;
        $aDataQuery = array($queryNumber => array('image_id' => $imageID));
       // $this->_customQueryData('deleteDataInDB', $input, $queryNumber, $aDataQuery);
        $query = sprintf("
            SELECT 
                a.image_name, a.image_path
            FROM 
                {$this->conf['table']['article_images']} a
                %s
            WHERE 
                a.image_id = '{$aDataQuery[$queryNumber]['image_id']}'
                %s
                %s
            ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );
        $aArticleImages = $this->dbh->getAll($query, DB_FETCHMODE_ASSOC);
        foreach ($aArticleImages as $k => $v) {
            $targetIcon = SGL_WEB_ROOT . '/' . $v['image_path'] . $v['image_name'];
            if (is_file($targetIcon)) {
                unlink($targetIcon);
            }
            $targetIcon = SGL_WEB_ROOT . '/' . $v['image_path'] . 'm_' . $v['image_name'];
            if (is_file($targetIcon)) {
                unlink($targetIcon);
            }
            $targetIcon = SGL_WEB_ROOT . '/' . $v['image_path'] . 's_' . $v['image_name'];
            if (is_file($targetIcon)) {
                unlink($targetIcon);
            }
        }
        $query = "DELETE FROM {$this->conf['table']['article_images']} WHERE `image_id` = '{$aDataQuery[$queryNumber]['image_id']}'";
        $this->dbh->query($query);
    }
    
    function _cmd_deleteImage($input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        
        // START :: custom query data1
        $queryNumber = 1;
        $aDataQuery = array($queryNumber => array('adjustOrderBy' => '', 'article_id' => $input->frmEditArticleID));
        $this->_customQueryData('deleteImage', $input, $queryNumber, $aDataQuery);
        /// END :: custom query data1
        
        $query = sprintf("
            SELECT 
                article_icon
            FROM 
                {$this->conf['table']['article']}
                %s
            WHERE 
                article_id= '{$aDataQuery[$queryNumber]['article_id']}'
                %s
                %s
            ",
            isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : ''
            , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
            , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );
                
        $iconType = $this->dbh->getOne($query);
        $targetIcon = SGL_WEB_ROOT . '/' . $this->saveImagePath . $iconType;
        
        if (is_file($targetIcon)) {
            unlink($targetIcon);
        }
            
         // START :: custom query data2
        $queryNumber = 2;
        $aDataQuery = array($queryNumber => array('adjustOrderBy' => '', 'article_id' => $input->frmEditArticleID));
        $this->_customQueryData('deleteImage', $input, $queryNumber, $aDataQuery);
        /// END :: custom query data2
                                 
        $query = sprintf("
            UPDATE 
                {$this->conf['table']['article']} 
            SET 
                `article_icon` = '' 
            WHERE 
                article_id= '{$aDataQuery[$queryNumber]['article_id']}'
            ",
            isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : ''
            , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
            , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );
        $this->dbh->query($query);
        
        SGL::raiseMsg('Article icon successfully delete', true, SGL_MESSAGE_INFO);
        
        $this-> _customOutputCMD('deleteImage', $input, $output);
        return true;
    }
    
    function getTimeStamp($dateString)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $tmpGetDateTime = explode(' ', $dateString);
        $tmpDate = $tmpGetDateTime[0];
        $tmpTime = $tmpGetDateTime[1];

        $tmpGetDate = explode('-', $tmpDate);
        $tmpGetTime  = explode(':', $tmpTime);

        $timestamp = mktime($tmpGetTime[0], $tmpGetTime[1], $tmpGetTime[2], $tmpGetDate[1], $tmpGetDate[2], $tmpGetDate[0]);
        return $timestamp;
    }

    function _uploadImage($fileName, $fileTempName)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $extention = end(explode('.', $fileName));
        $uniqueName = md5($fileName . SGL_Session::getUid() . SGL_Date::getTime());
        $iconName = $uniqueName . '.' . $extention;        
        $targetLocation = SGL_WEB_ROOT . '/' . $this->saveImagePath . $iconName;
        move_uploaded_file($fileTempName, $targetLocation);  
        return $iconName;
    }
    
    function getExtentionFile($filename)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $extention = end(explode('.', $filename));
        $name = preg_replace("#\.$extention$#si", '', $extention);
        $aExten = array(
            'filename' => $filename,
            'name' => $name,
            'extention' => $extention,
        );
        return $aExten;
    }
    
    function _detectGd()
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $gdfuncList = get_extension_funcs('gd');
        ob_start();
        @phpinfo(INFO_MODULES);
        $output = ob_get_contents();
        ob_end_clean();
        $matches[1] = "";
        
        if (preg_match("/GD Version[ \t]*(<[^>]+>[ \t]*)+([^<>]+)/s",$output,$matches)) {
            $gdversion = $matches[2];
        }

        if ( $gdfuncList ) {
            if ( in_array('imagegd2',$gdfuncList) ) {
                return true;
            } else {
                return false;
             }
        } else {
           return false;
        }
    }

    function _resizeImageAndSave($im, $srcImgLocation, $targetLocation, $newWidth, $newHeight, $linkScale = 0)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $ret = $im->load($srcImgLocation);
        if (PEAR::isError($ret)) {
            return false;
        }
        
        if (preg_match('#(.*)%$#si', $newWidth, $aMatch) && $im->img_x > 0) {
            $newWidth = $im->img_x * ($aMatch[1]/100);
        }
        
        if (preg_match('#(.*)%$#si', $newHeight, $aMatch) && $im->img_y > 0) {
            $newHeight = $im->img_y * ($aMatch[1]/100);
        }
        
        if ($linkScale) {
            if ($im->img_x < $im->img_y) {
                $x = ($newHeight * $im->img_x) / $im->img_y;
                $y = $newHeight;
            } else {
                $x = $newWidth;
                $y = ($newWidth * $im->img_y) / $im->img_x;
            }
            $newHeight = $y;
            $newWidth = $x;
        }

        $ret = $im->fit($newWidth, $newHeight);
        
        if (PEAR::isError($ret)) {
            return false;
        }
        $ret = $im->save($targetLocation, 'jpeg');
    }
    
    function _validateAdd($input, &$aErrors)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $this->_validateEdit($input, $aErrors);
    }
    
    function _validateEdit($input, &$aErrors)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $defaultLang = $this->conf['Default']['defaultLang'];
        $query = "
            SELECT 
                web_lang_id
            FROM 
                {$this->conf['table']['web_lang']} 
            WHERE 
                lang_key = '{$defaultLang}'
        ";
        $defaultLangID = $this->dbh->getOne($query);
        $transNum = 0;
        
        foreach ($input->frmData as $keyLangId => $v) {
            $subject = $v['subject'];
            if ($keyLangId == $defaultLangID) {
                if ( $input->frmAdd['defaultLang'] == 0 && $subject == '') {
                    $transNum = $transNum - 1;
                } else {
                    $transNum = $transNum + 1;
                }
            } else {
                if ($subject == '') { 
                    $transNum = $transNum - 1;
                } else {
                    $transNum = $transNum + 1;
                }
            }
        }
        if ($transNum < 1) {
            $aErrors["titleNameBlank"] = SGL_Output::translate('Please insert type name all type.');
        }
        
        $isImageFileType = $this->isImageFileType($input->frmUploadImages);
        if($isImageFileType) {
             $input->imageError = $isImageFileType;
             unset($input->frmUploadImages);
        }
        return true;
    }
    
    ####################### common function ##########################
    # for get all role to action add / edit
    function getAllPerms()
    {
        $aPerms = array();
        $query = "SELECT `role_id`
                            FROM `{$this->conf['table']['role']}` ";
        $aData = $this->dbh->getAll($query, DB_FETCHMODE_ASSOC);
        
        foreach ($aData as $k => $v) {
            if ($v['role_id'] != '-1') {
                $aPerms[$v['role_id']] = $v['role_id'];
            }
        }
        return $aPerms;
    }
    
    
    ################################################################
    # IF YOU WANT TO ADJUST DEFAULT MODULE ARTCLEWEB, 
    # PLEASE EDITE YOUR CODES HERE!!!
    #
    ################################################################
    
    /**
     * Custom  adjust input datas for all action 
     *
     * @param <mix> $req
     * @param <mix> $input
     */
    function _customCommondInput($req, &$input)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        /// If you want to custom validate action edit, please edit here!!
    }
    
    /**
     * Custom  adjust input datas for action only 
     *
     * @param <mix> $req
     * @param <mix> $input
     */
    function _customInputByAction($action = 'view', $req, &$input)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        switch ($action) {
            case "add" :
            case "edit" :
            case "delete":
            case 'view':
            case  'addview':
            case  'editview':
            case 'deleteImage':
            default :
                break;
        }
    }
    
    /**
     * Custom validate all action
     *
     * @param <mix> $input
     * @param <array> $aErrors
     */
    function _customCommondValidate($input, &$aErrors)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        
    }
    
    /**
    * Custom validate by action only
    *
    * @param <string> $action;
    * @param <mix> $input
    * @param <array> $aErrors
    */
    function _customValidateByAction($action = 'view', $input, &$aErrors)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        switch ($action) {
            case "add" :
            case "edit" :
            case "delete":
            case 'view':
            case  'addview':
            case  'editview':
            case 'deleteImage':
            default :
                break;
        }
    }
    
    /**
     * Custom output after process cmd_action has completed.
     *
     * @param <string> $action
     * @param <mix> $output
     */
    function _customOutputAfterRunCmd($action = 'view', &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        switch ($action) {
            case "add" :
            case "edit" :
            case "delete":
            case 'view':
            case  'addview':
            case  'editview':
            case 'deleteImage':
            default :
                break;
        }
    }
    
    /**
     * Custom change template by action
     *
     * @param <string> $template
     * @param <string> $action
     *
     * @return <string> $template
     */
    function _customUseTemplatebyAction(&$template, $action)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        /// If you want to custom validate action edit, please edit here!!
        switch ($action) {
            case "add" :
            case "edit" :
            case "delete":
            case 'view':
            case  'addview':
            case  'editview':
            case 'deleteImage':
            default :
                break;
        }
    }

    /**
     * Custom array Errors
     *
     * @param <array> $aErrors
     *
     * @return <array> $aErrors
     */
    function _customaErrorByAction($input, &$aErrors)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        /// If you want to custom code, please edit here!!
    }

    /**
     * Custom Output for display
     *
     * @param <mix> $output
     */
    function _customOutputDisplay(&$output)
    {
        switch ($output->action) {
            case "add" :
            case "edit" :
            case "delete":
            case 'view':
            case  'addview':
            case  'editview':
            case 'deleteImage':
            default :
                break;
        }
    }
    
    /**
     * Custom input data befor insert datas to database in cmd_add
     *
     * @param <mix> $input
     * @param <array> $aDatas ;
     * 
     * @return <array>
     */
    function _customCmdAddBeforInsertArtcleDataToRecord($input, &$aDatas)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        
    }
    
    /**
     * Custom query data by action
     *
     * @param <string> $action
     * @param <mix> $input
     * @param <number> $queryNumber
     * @param <array> $aDataquery
     */
    function _customQueryData($action = 'view', $input, $queryNumber = null, &$aDataquery)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        if (is_null($queryNumber)) {
            return ;
        }
        switch ($action) {
            case "add" :
            case "edit" :
            case "delete":
            case 'view':
            case  'addview':
            case  'editview':
            case 'deleteImage':
            default :
                break;
        }
    }
    
    function _customDeleteDataInDB($articleID = null)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        
    }
    
    /**
     * Custom adjust output after run precess (cmd)
     *
     * @param <obj> $input
     * @param <obj> $output
     * 
     * @return $output;
     */
    function _customOutputCMD($action = 'view', $input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        switch ($action) {
            case "add" :
                break;
            case "edit" :
                break;
            case "delete":
                break;
            case 'view': default:
                break;
            case  'addview':
                break;
            case  'editview':
                break;
            case 'deleteImage':
                break;
        }
    }
    
    /**
     * Custom insert article data to database
     *
     * @param <string> $action
     * @param <number> $numberIndex
     * @param <array> $aArticleData
     * @param <obj> $input
     */
    function _customAfterInsertDB($action = 'view', $numberIndex = 0, $aArticleData = array(), $input)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
    }
    
    
   function isImageFileType($aFile)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $typeImage =  $this->conf['AdminArticleWebMgr']['fileUploadImageType'];
        $pat = preg_replace('/\,/si' , '|',$typeImage);
        foreach ($aFile['type'] as $kFile => $vFile) {
            if (!preg_match('/image\/[' . $pat . ']/si',$vFile,$aMatch) && $vFile) {
                return "File not macth please upload file again" ;
            }
        }
    }
    #######################################################
    ##                                        END FUNCTION ADJUST                                           #
    #######################################################
}
?>
