<?php

/* Reminder: always indent with 4 spaces (no tabs). */
// +---------------------------------------------------------------------------+
// WebSite:  http://www.webexperts.co.th
// Unauthorized copying is strictly forbidden and may result in severe legal action.
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// 
// =====YOU MUST KEEP THIS COPYRIGHTS NOTICE INTACT AND CAN NOT BE REMOVE =======
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// This Agreement is a legal contract, which specifies the terms of the license
// and warranty limitation between you and Web Experts Co.,Ltd. and RV Site Builder.
// You should carefully read the following terms and conditions before
// installing or using this software.  Unless you have a different license
// agreement obtained from Web Experts Co.,Ltd., installation or use of this software
// indicates your acceptance of the license and warranty limitation terms
// contained in this Agreement. If you do not agree to the terms of this
// Agreement, promptly delete and destroy all copies of the Software.
//
// =====  Grant of License =======
// The Software may only be installed and used on a single host machine.
//
// =====  Disclaimer of Warranty =======
// THIS SOFTWARE AND ACCOMPANYING DOCUMENTATION ARE PROVIDED "AS IS" AND
// WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR ANY OTHER
// WARRANTIES WHETHER EXPRESSED OR IMPLIED.   BECAUSE OF THE VARIOUS HARDWARE
// AND SOFTWARE ENVIRONMENTS INTO WHICH RV SITE BUILDER MAY BE USED, NO WARRANTY OF
// FITNESS FOR A PARTICULAR PURPOSE IS OFFERED.  THE USER MUST ASSUME THE
// ENTIRE RISK OF USING THIS PROGRAM.  ANY LIABILITY OF Web Experts Co.,Ltd. WILL BE
// LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT OR REFUND OF PURCHASE PRICE.
// IN NO CASE SHALL Web Experts Co.,Ltd. BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
// CONSEQUENTIAL DAMAGES OR LOSS, INCLUDING, WITHOUT LIMITATION, LOST PROFITS
// OR THE INABILITY TO USE EQUIPMENT OR ACCESS DATA, WHETHER SUCH DAMAGES ARE
// BASED UPON A BREACH OF EXPRESS OR IMPLIED WARRANTIES, BREACH OF CONTRACT,
// NEGLIGENCE, STRICT TORT, OR ANY OTHER LEGAL THEORY. THIS IS TRUE EVEN IF
// Web Experts Co.,Ltd. IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. IN NO CASE WILL
// Web Experts Co.,Ltd.'S LIABILITY EXCEED THE AMOUNT OF THE LICENSE FEE ACTUALLY PAID
// BY LICENSEE TO Web Experts Co.,Ltd.

class ArticleViewWebMgr extends SGL_Manager
{
    function ArticleViewWebMgr()
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        parent::SGL_Manager();

        $this->pageTitle    = 'ArticleViewWeb Manager';
        $this->template     = 'viewArticleAllType.html';

        $this->_aActionsMapping =  array(
            'view'      => array('view'),
            'viewArticle'       => array('viewArticle'),
            'viewArticleType'       => array('viewArticleType'),
            'viewArticleAllType'       => array('viewArticleAllType'),
            'viewLatestArticleType'     =>  array('viewLatestArticleType')
        );
        /// START :: rewrite $thsi->conf
        $req = &SGL_Request::singleton();
        $moduleName = $req->get('moduleName');
        $managerName = $req->get('managerName');
        if (strtolower($moduleName) != 'articleweb') {
            /// rewrite conf table name
            $fileRewrireTable = SGL_MOD_DIR . '/' . $moduleName . '/data/rewriteTableAliases.ini';
            if (is_file($fileRewrireTable)) {
                $fileData = parse_ini_file($fileRewrireTable);
                foreach ($fileData as $key => $val) {
                    $this->conf['table'][$key] = SGL_Config::get('db.prefix') . $val;
                }
            }
            ///set default parent conf
            $defaultConfmodule = SGL_MOD_DIR . '/articleweb/conf.ini';
            if (is_file($defaultConfmodule)) {
                $aDefaultConf = parse_ini_file($defaultConfmodule, true);
				foreach ($aDefaultConf as $mgr => $keyconf) {
                    $this->conf[$mgr] = $keyconf;
                }
            }
            ///merge parent conf + current conf by managerName
            $targetConfmodule = SGL_MOD_DIR . '/' . $moduleName . '/conf.ini';
            if (is_file($targetConfmodule)) {
                $aTargetConf = parse_ini_file($targetConfmodule, true);
                foreach ($aTargetConf as $mgr => $keyconf) {
                    if (strtolower($mgr) == strtolower($managerName . 'Mgr')) {
                        array_merge($this->conf[__CLASS__], $this->conf[$mgr]);
                    }
                }
            }
        }
        /// START :: rewrite $thsi->conf
    }

    function validate($req, &$input)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $this->validated    = true;
        $input->error       = array();        
        $input->masterTemplate = $this->masterTemplate;        
        $input->action      = ($req->get('action')) ? $req->get('action') : 'view';
        
        $input->pageTitle   = $this->pageTitle;
        $input->pageAction = $input->action;
        
        $input->template    = $this->template;
        
        ################ Get input ###############
        $input->frmArticleTypeID = $req->get('frmArticleTypeID');
        $input->frmArticleID = $req->get('frmArticleID');
        $input->pageID = $req->get('pageID');
        
        ################ End input ###############

        ################ Start validate ##############
        /// START :: custom  adjust commond input datas ::: BooM
        $this->_customCommondInput($req, $input);
        /// END :: custom  adjust commond input datas ::: BooM

        ################ Set Action Input #################
        switch ($input->action) {
            case "add" :
            case "edit" :
            default :
        }
        /// START :: custom adjust  by action
        $this->_customInputByAction($input->action, $req, $input);
        /// END :: custom adjust  by action
        $aErrors = array();
        
        /// START :: custom common validate
        $this->_customCommondValidate($input, $aErrors);
        /// END :: custom common validate
        ################ End validate ###############
        
        
        switch ($input->action) {
            case "view":
                break;
            case "viewArticle":
                $input->template    = 'viewArticle.html';
                break;
            case "viewArticleType":
                $input->template    = 'viewArticleType.html';
                break;
            case "viewArticleAllType":
                $input->template    = 'viewArticleAllType.html';
                break;
            case "viewLatestArticleType":
                $input->template    = 'viewLatestArticleType.html';
                break;
        }
        
        /// START :: custom valdiate and custom template by action
        $this->_customValidateByAction($input->action, $input, $aErrors);
        $this->_customUseTemplatebyAction($input->template, $input->action);
        /// END :: custom valdiate and custom template by action
        
        //  if errors have occured
         if (isset($aErrors) && count($aErrors)) {
            Main::translate(SGL::raiseMsg('Please fill in all the indicated fields and try again.'));
             /// START :: custom error by action
            $this->_customaErrorByAction($input, $aErrors);
            /// END ::
            $input->error = $aErrors;
            $this->validated = false;
        }
    }

    function display(&$output)
    {
        /// START :: custom display
        $this-> _customOutputDisplay($output);
        /// END :: custom display
    }

    function _cmd_view(&$input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
    }

    function _cmd_viewArticle(&$input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        
        if (!$input->frmArticleID) {
            return 0;
        }
        //require_once SGL_MOD_DIR . '/default/blocks/LangSwitcher2.php';
        //$oLangSwitcher2 = new Default_Block_LangSwitcher2();
        //$output->langsw =  $oLangSwitcher2->getBlockContent($output, $aParams);
        
        $output->imagesDir = SGL_BASE_URL  . '/themes/default/images';
        $defaultLang = $this->conf['Default']['defaultLang'];

        if (isset($_SESSION['aPrefs']['language'])) {
            $defaultLang = $_SESSION['aPrefs']['language'];
        }
        $queryNumber = 1;
        $aDataQuery = array($queryNumber => array());
        $this->_customQueryData('viewArticle', $input, $queryNumber, $aDataQuery);
        $query = sprintf("
                    SELECT 
                        web_lang_id
					FROM 
					    {$this->conf['table']['web_lang']}
						%s
        			WHERE 
        			    lang_key = '{$defaultLang}'
        				%s
        				%s
                       ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                        , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                        , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );

        $defaultLangID = $this->dbh->getOne($query);
        $queryNumber = 2;
        $aDataQuery = array($queryNumber => array());
        $this->_customQueryData('viewArticle', $input, $queryNumber, $aDataQuery);
        
        $query = sprintf("
                    SELECT 
                        web_lang_id
					FROM 
					    {$this->conf['table']['web_lang']}
					    %s 
        			WHERE 
        			    lang_key != '{$this->conf['Default']['defaultLang']}'
        			    %s
        			    %s
                        ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                         , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                         , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );
        
        $secondLangID = $this->dbh->getOne($query);
        $roleID = SGL_Session::getRoleId();
        $currentTime = time();
        
        $queryNumber = 3;
        $aDataQuery = array($queryNumber => array());
        $this->_customQueryData('viewArticle', $input, $queryNumber, $aDataQuery);
        
        $query = sprintf("
                    SELECT 
							*
					FROM 
							{$this->conf['table']['article']} a, 
							{$this->conf['table']['article_message']} am, 
							{$this->conf['table']['article_role']} ar, 
							{$this->conf['table']['user']} u
							%s
						WHERE 
							a.article_id = am.article_id
							AND ar.article_id = a.article_id
							AND u.usr_id = a.user_id
							AND a.article_id = '{$input->frmArticleID}'
        					AND ar.role_id = '{$roleID}'
        					AND (
									(am.web_lang_id = '{$defaultLangID }' AND a.skip_default_lang=0) 
									OR
									(a.skip_default_lang = '1' AND am.web_lang_id = '{$secondLangID}')
        							)
        					AND (
                                    (a.publish =1 AND a.date_start <= '{$currentTime}')
								     AND 
									 (a.never_expired =1 OR a.date_end >= '{$currentTime}')
							        )
							%s
							%s
    					", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                         , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                         , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );

        $result = $this->dbh->getAll($query);

        if (is_array($result) && count($result)) {
            $output->articleTitle = $result[0]->title;
            $output->articleMessage =  $result[0]->message;
            $output->articleAuthorName = $result[0]->first_name;
            $output->articleAuthorEmail = $result[0]->email;
            $output->articleStartDate = $result[0]->date_start;

            $output->extraField1 = $result[0]->extra_field1;
            $output->extraField2 = $result[0]->extra_field2;
            $output->extraField3 = $result[0]->extra_field3;
            $output->extraField4 = $result[0]->extra_field4;
            $output->extraField5 = $result[0]->extra_field5;

            $srcImgLocation = SGL_WEB_ROOT . '/images/Image/' . $result[0]->article_icon;

            if (is_file($srcImgLocation)) {
                $output->articleIcon = $result[0]->article_icon;
            } else {
                $output->articleIcon = 0;  
            }

            $output->showEmail = $this->conf['ArticleViewWebMgr']['showEmail'];
            $output->showAuthor = $this->conf['ArticleViewWebMgr']['showAuthor'];
            $output->showStartDate = $this->conf['ArticleViewWebMgr']['showDate'];
            $this->_customOutputDisplay($output);
        }
        $this-> _customOutputCMD('viewArticle', $input, $output); 
    }

    function _cmd_viewArticleType(&$input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        
        $titleLengthAlltype = $this->conf['ArticleViewWebMgr']['titleLengthAlltype'];
        $messageLengthAllType = $this->conf['ArticleViewWebMgr']['messageLengthAllType'];
        
        if (!$input->frmArticleTypeID) {
            return 0;
        }
        
        $defaultLang = $this->conf['Default']['defaultLang'];
        if (isset($_SESSION['aPrefs']['language'])) {
            $defaultLang = $_SESSION['aPrefs']['language'];
        }
        $queryNumber = 1;
        $aDataQuery = array($queryNumber => array());
        $this->_customQueryData('viewArticleType', $input, $queryNumber, $aDataQuery);
        
        $query = sprintf("
                    SELECT 
                        web_lang_id
					FROM 
					    {$this->conf['table']['web_lang']}
					    %s
        			WHERE 
        			    lang_key = '{$defaultLang}'
        			    %s
        			    %s
                        ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                        , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                        , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );
        $defaultLangID = $this->dbh->getOne($query);
        
        $queryNumber = 2;
        $aDataQuery = array($queryNumber => array());
        $this->_customQueryData('viewArticleType', $input, $queryNumber, $aDataQuery);
        
        $query = sprintf("
                    SELECT 
                        web_lang_id
					FROM 
					    {$this->conf['table']['web_lang']} 
					    %s
        			WHERE 
        			    lang_key != '{$this->conf['Default']['defaultLang']}'
        			    %s
        			    %s
        			   ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                        , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                        , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );
        $secondLangID = $this->dbh->getOne($query);
        
        $queryNumber = 3;
        $aDataQuery = array($queryNumber => array());
        $this->_customQueryData('viewArticleType', $input, $queryNumber, $aDataQuery);
        
        $query = sprintf("
            SELECT 
				at.type_name, a.type_icon
			FROM 
				{$this->conf['table']['article_type']} a, {$this->conf['table']['article_type_message']} at
				%s
			WHERE 
				at.web_lang_id = '{$defaultLangID}'
        		AND a.article_type_id = '{$input->frmArticleTypeID}'
				AND a.article_type_id = at.article_type_id
				%s
				%s
				", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
				 , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
				 , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );
        
        $result = $this->dbh->getRow($query);
        $output->articleTypeName = $result->type_name;
        $output->articleTypeIcon = $result->type_icon;
        
        $roleID = SGL_Session::getRoleId();
        
        $currentTime = time();
        
        $queryNumber = 4;
        $adjustOrderBy = 'ORDER BY a.date_start DESC';
        $aDataQuery = array($queryNumber => array('adjustOrderBy'=>$adjustOrderBy));
        $this->_customQueryData('viewArticleType', $input, $queryNumber, $aDataQuery);
        $query = sprintf("
                    SELECT 
							*
					FROM 
							{$this->conf['table']['article']} a, 
							{$this->conf['table']['article_message']} am, 
							{$this->conf['table']['article_role']} ar
							%s
					WHERE 
							a.article_id = am.article_id
							AND ar.article_id = a.article_id
							AND ar.role_id = '{$roleID}'
							AND a.article_type_id = '{$input->frmArticleTypeID}'
        					AND (
									(am.web_lang_id = {$defaultLangID } AND a.skip_default_lang=0) 
									OR
									(a.skip_default_lang = '1' AND am.web_lang_id = '{$secondLangID}')
									)
        					AND (
									(a.publish =1 AND a.date_start <= '{$currentTime}')
								AND 
									(a.never_expired =1 OR a.date_end >= '{$currentTime}')
							)
                            %s
                            %s
                           ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                            , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                            , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );
        
        $limit = $this->conf['ArticleViewWebMgr']['maxLastArticleForType'] ? $this->conf['ArticleViewWebMgr']['maxLastArticleForType'] :10;
        
        $pagerOptions = array(
            'mode'     => 'Sliding',
            'delta'    => 3,
            'perPage'  => $limit,
            'spacesBeforeSeparator' => 0,
            'spacesAfterSeparator'  => 0,
            'curPageSpanPre'        => '<span class="currentPage">',
            'curPageSpanPost'       => '</span>',
        );
        $aPagedData = SGL_DB::getPagedData($this->dbh, $query, $pagerOptions);
        mb_internal_encoding("UTF-8");
        
        foreach ($aPagedData['data'] as $key=>$val) {
            
            if (strlen($aPagedData['data'][$key]['title']) > $titleLengthAlltype) {
                $aPagedData['data'][$key]['title'] = mb_substr($aPagedData['data'][$key]['title'], 0, $titleLengthAlltype);    
            }
            
            if (strlen($aPagedData['data'][$key]['message']) > $messageLengthAllType) {
                $aPagedData['data'][$key]['message'] = htmlspecialchars_decode($aPagedData['data'][$key]['message']);
                $aPagedData['data'][$key]['message'] = strip_tags($aPagedData['data'][$key]['message']);
                $aPagedData['data'][$key]['message'] = preg_replace('/\ {5,}/','',$aPagedData['data'][$key]['message']);
                $aPagedData['data'][$key]['message'] = mb_substr($aPagedData['data'][$key]['message'],0,$messageLengthAllType);
                $aPagedData['data'][$key]['more'] = 1;
            }
        }

        $output->aPagedData = $aPagedData;
        
        $this->_customOutputDisplay($output);
        
        if (is_array($aPagedData['data']) && count($aPagedData['data'])) {
            $output->pager = ($aPagedData['totalItems'] <= $limit) ? false : true;
        }
        
        $output->showDate = $this->conf['ArticleViewWebMgr']['showDateForType'];
        $this->_customOutputCMD('viewArticleType', $input, $output);
        
    }
    
    function _cmd_viewArticleAllType(&$input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);

        $titleLengthAlltype = $this->conf['ArticleViewWebMgr']['titleLengthAlltype'];
        $messageLengthAllType = $this->conf['ArticleViewWebMgr']['messageLengthAllType'];
        $maxLastArticleAllType = $this->conf['ArticleViewWebMgr']['maxLastArticleAllType'];
        $aTypeData = array();
        // ������ DefaultLang
        $defaultLang = $this->conf['Default']['defaultLang'];
        if (isset($_SESSION['aPrefs']['language'])) {
            $aLanguages = $GLOBALS['_SGL']['LANGUAGE'];
            
            if (array_key_exists($_SESSION['aPrefs']['language'], $aLanguages)) {
                $defaultLang = $_SESSION['aPrefs']['language'];
            }
        }
        
        // �� ID �ͧ DefaultLang
        $queryNumber = 1;
        $aDataQuery = array($queryNumber => array());
        $this->_customQueryData('viewArticleAllType', $input, $queryNumber, $aDataQuery);
        
        $query = sprintf("
                    SELECT 
                        web_lang_id
                    FROM 
                        {$this->conf['table']['web_lang']}
                        %s
                    WHERE 
                        lang_key = '{$defaultLang}'
                        %s
                        %s
            		   ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
            			, isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
            			, isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );
        $defaultLangID = $this->dbh->getOne($query);

        // �� ID �ͧ Lang �������� DefaultLang
        
        $queryNumber = 2;
        $aDataQuery = array($queryNumber => array());
        $this->_customQueryData('viewArticleAllType', $input, $queryNumber, $aDataQuery);
        
        $query = sprintf("
                    SELECT 
                        web_lang_id
                    FROM 
                        {$this->conf['table']['web_lang']}
                        %s
                    WHERE 
                        lang_key != '{$this->conf['Default']['defaultLang']}'
                        %s
                        %s
        			   ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
            			, isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
            			, isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );
        $secondLangID = $this->dbh->getOne($query);        
        
        // �� ID �ͧ Role ����� ��� ���� � �Ѩ�غѹ
        $roleID = SGL_Session::getRoleId();
        $currentTime = time();
        
        // �� Type ����t
        
        $queryNumber = 3;
        $aDataQuery = array($queryNumber => array());
        $this->_customQueryData('viewArticleAllType', $input, $queryNumber, $aDataQuery);
        $query = sprintf("
                        SELECT 
                            at.article_type_id,
                            at.type_name,
                            a.type_icon
                        FROM 
                            {$this->conf['table']['article_type']} a,
                            {$this->conf['table']['article_type_message']} at,
                            {$this->conf['table']['article_type_role']} rt
                            %s
                        WHERE 
                            at.web_lang_id = '{$defaultLangID}'
                            AND rt.role_id = '{$roleID}'
                            AND a.article_type_id = at.article_type_id
                            AND a.article_type_id = rt.article_type_id
                            %s
                            %s
                           ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                			, isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                			, isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );

        $aType = $this->dbh->getAll($query, DB_FETCHMODE_ASSOC);
        
        foreach ($aType as $key=>$val) {
            $id = $val['article_type_id'];
            $aTypeData[$id]['type_name'] = $val['type_name'];
            $srcImgLocationType = SGL_WEB_ROOT . '/images/Image/' . $val['type_icon'];
            
            if (is_file($srcImgLocationType)) {
                $aTypeData[$id]['type_icon'] = $val['type_icon'];
            } else {
                $aTypeData[$id]['type_icon'] = '';
            }
        
        //�� Article ����t �ͧ type ����
        $queryNumber = 4;
        $adjustOrderBy = "LIMIT 0 , {$maxLastArticleAllType}";
        $aDataQuery = array($queryNumber => array('adjustOrderBy' =>$adjustOrderBy));
        $this->_customQueryData('viewArticleAllType', $input, $queryNumber, $aDataQuery);
        
        
        $query = sprintf("
                    SELECT 
                        a.article_id, 
                        a.article_type_id,
                        a.article_icon, 
                        a.skip_default_lang, 
                        a.date_start
                    FROM 
                        {$this->conf['table']['article']} a,
                        {$this->conf['table']['article_role']} r
                        %s
                    WHERE 
                        r.role_id = '{$roleID}'
                        AND a.article_type_id = '{$id}'
                        AND a.article_id = r.article_id
                        AND a.publish = '1'
                        AND ((
                                    a.never_expired = '1'
                                ) 
                                OR
                                (
                                    a.never_expired = '0'
                                AND a.date_end >= {$currentTime}
                                ))
                        %s
                        %s
                         ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                         , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                         , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );

        $aArticleAll = $this->dbh->getAll($query, DB_FETCHMODE_ASSOC);

        foreach ($aArticleAll as $k => $v) {
            
            $aTypeId = $v['article_type_id'];
            $aArticleId = $v['article_id'];
            
            if ($v['skip_default_lang'] == '1') {
                $defaultLangID = $secondLangID;
            }
            
            $queryNumber = 5;
            $aDataQuery = array($queryNumber => array());
            $this->_customQueryData('viewArticleAllType', $input, $queryNumber, $aDataQuery);
            
            // �� Message ����Ѻ Article ��鹨� ����hѴ���§���� Data
            $query = sprintf("
                        SELECT 
                            title, 
                            message, 
                            article_message_id
                        FROM 
                            {$this->conf['table']['article_message']}
                            %s
                        WHERE 
                            article_id = {$v['article_id']}
                            AND 
                            web_lang_id = '{$defaultLangID}'
                            %s
                            %s
                            ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                             , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                             , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );
                             
                             
            $aArticleMess[$aTypeId] = $this->dbh->getRow($query, DB_FETCHMODE_ASSOC);
            mb_internal_encoding("UTF-8");
            
            $aTitle = isset($aArticleMess[$aTypeId]['title']) ? $aArticleMess[$aTypeId]['title'] : '';
            $aMessage = isset($aArticleMess[$aTypeId]['message']) ? $aArticleMess[$aTypeId]['message'] : '';
            
            $aArticleMess[$aTypeId]['title'] = mb_substr($aTitle,0,$titleLengthAlltype);
            $aArticleMess[$aTypeId]['message'] = mb_substr($aMessage,0,$messageLengthAllType);
            
            $aArticleMess[$aTypeId]['article_id'] = $v['article_id'];
            $aArticleMess[$aTypeId]['date_start'] = strftime("%d %B %Y %H:%M",$v['date_start']);
            $srcImgLocation = SGL_WEB_ROOT . '/images/Image/' . $v['article_icon'];

            if (is_file($srcImgLocation)) {
                $aArticleMess[$aTypeId]['article_icon'] = $v['article_icon'];
            } else {
                $aArticleMess[$aTypeId]['article_icon'] = '';
            }
            $aTypeData[$id]['data'][$k] = $aArticleMess[$aTypeId];
        }
    }

        $output->aTypeData = $aTypeData;
        $output->showDateStart = $this->conf['ArticleViewWebMgr']['showDateAllType'];
    }
    
    function _cmd_viewLatestArticleType(&$input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        
        
        if (!$input->frmArticleTypeID) {
            return 0;
        }
        
        $defaultLang = $this->conf['Default']['defaultLang'];
        if (isset($_SESSION['aPrefs']['language'])) {
            $defaultLang = $_SESSION['aPrefs']['language'];
        }
        
        $queryNumber = 1;
        $aDataQuery = array($queryNumber => array());
        $this->_customQueryData('viewLatestArticleType', $input, $queryNumber, $aDataQuery);
        
        $query = sprintf("
                    SELECT 
                        web_lang_id
                    FROM 
                        {$this->conf['table']['web_lang']}
                        %s
                    WHERE 
                        lang_key = '{$defaultLang}'
                        %s
                        %s
                       ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                        , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                        , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );
        $defaultLangID = $this->dbh->getOne($query);
        
        $queryNumber = 2;
        $aDataQuery = array($queryNumber => array());
        $this->_customQueryData('viewLatestArticleType', $input, $queryNumber, $aDataQuery);
        
        $query = sprintf("
                    SELECT 
                        web_lang_id
                    FROM 
                        {$this->conf['table']['web_lang']} 
                        %s
                    WHERE 
                        lang_key != '{$this->conf['Default']['defaultLang']}'
                        %s
                        %s
         			   ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                        , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                        , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );
        $secondLangID = $this->dbh->getOne($query);
        
        $queryNumber = 3;
        $aDataQuery = array($queryNumber => array('article_type_id' => $input->frmArticleTypeID));
        $this->_customQueryData('viewLatestArticleType', $input, $queryNumber, $aDataQuery);
        
        $query = sprintf("
                    SELECT 
                        at.type_name, 
                        a.type_icon
                    FROM 
                        {$this->conf['table']['article_type']} a, 
                        {$this->conf['table']['article_type_message']} at
                        %s
                    WHERE 
                        at.web_lang_id = '{$defaultLangID}'
                        AND a.article_type_id = '{$aDataQuery[$queryNumber]['article_type_id']}'
                        AND a.article_type_id = at.article_type_id
                        %s
                        %s
                        ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                        , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                        , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );
        
        $result = $this->dbh->getRow($query);
        $output->articleTypeName = $result->type_name;
        $output->articleTypeIcon = $result->type_icon;
        
        $roleID = SGL_Session::getRoleId();
        
        $currentTime = time();
        
        $articleID = $input->frmArticleID;

        if (! $input->frmArticleID) {
            $queryNumber = 3;
            $adjustOrderBy = 'ORDER BY a.date_start DESC';
            $aDataQuery = array($queryNumber => array(
                                                                                'article_type_id' => $input->frmArticleTypeID,
            																	'adjustOrderBy' => $adjustOrderBy,
                                                                                ));
            $this->_customQueryData('viewLatestArticleType', $input, $queryNumber, $aDataQuery); 
            $query = sprintf("
                        SELECT 
                                a.article_id
                        FROM 
                                {$this->conf['table']['article']} a, 
                                {$this->conf['table']['article_message']} am, 
                                {$this->conf['table']['article_role']} ar
                                %s
                            WHERE 
                                a.article_id = am.article_id
                                AND ar.article_id = a.article_id
                                AND ar.role_id = '{$roleID}'
                                AND a.article_type_id = '{$aDataQuery[$queryNumber]['article_type_id']}'
                                AND (
                                        (am.web_lang_id = {$defaultLangID } AND a.skip_default_lang=0) 
                                        OR
                                        (a.skip_default_lang = '1' AND am.web_lang_id = '{$secondLangID}')
                                        )
                                AND (
                                        (a.publish =1 AND a.date_start <= '{$currentTime}')
                                        AND 
                                        (a.never_expired =1 OR a.date_end >= '{$currentTime}')
                                )
                                %s
                                %s
                               ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                                , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                                , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );
    
            $articleID = $this->dbh->getOne($query);
        }
        $queryNumber = 4;
        $adjustOrderBy='ORDER BY a.date_start DESC';
        $aDataQuery = array($queryNumber => array('adjustOrderBy' => $adjustOrderBy));
        $this->_customQueryData('viewLatestArticleType', $input, $queryNumber, $aDataQuery);
            $query = sprintf("
                        SELECT 
                            *
                        FROM 
                            {$this->conf['table']['article']} a, 
                            {$this->conf['table']['article_message']} am, 
                            {$this->conf['table']['article_role']} ar,
                            {$this->conf['table']['user']} u
                            %s
                        WHERE 
                            a.article_id = am.article_id
                            AND ar.article_id = a.article_id
                            AND u.usr_id = a.user_id
                            AND a.article_id = '{$articleID}'
                            AND ar.role_id = '{$roleID}'
                            AND (
                                    (am.web_lang_id = '{$defaultLangID }' AND a.skip_default_lang=0) 
                                    OR
                                    (a.skip_default_lang = '1' AND am.web_lang_id = '{$secondLangID}')
                                    )
                            AND (
                                    (a.publish =1 AND a.date_start <= '{$currentTime}')
                                AND 
                                    (a.never_expired =1 OR a.date_end >= '{$currentTime}')
                            )
                            %s
                            %s
                           	", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                             , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                             , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );

        $result = $this->dbh->getAll($query);

        if (is_array($result) && count($result)) {
            $output->articleTitle = $result[0]->title;
            $output->articleMessage =  $result[0]->message;
            $output->articleAuthorName = $result[0]->first_name;
            $output->articleAuthorEmail = $result[0]->email;
            $output->articleStartDate = $result[0]->date_start;

            $output->extraField1 = $result[0]->extra_field1;
            $output->extraField2 = $result[0]->extra_field2;
            $output->extraField3 = $result[0]->extra_field3;
            $output->extraField4 = $result[0]->extra_field4;
            $output->extraField5 = $result[0]->extra_field5;

            $srcImgLocation = SGL_WEB_ROOT . '/images/Image/' . $result[0]->article_icon;

            if (is_file($srcImgLocation)) {
                $output->articleIcon = $result[0]->article_icon;
            } else {
                $output->articleIcon = 0;  
            }

            // Loop images
            $queryNumber = 5;
            $aDataQuery = array($queryNumber => array('article_id' => $result[0]->article_id));
            $this->_customQueryData('editview', $input, $queryNumber, $aDataQuery);
            $query = sprintf("
                            SELECT
                                a.image_id, a.image_name, a.image_path, a.oldfilename
                            FROM
                                {$this->conf['table']['article_images']} a
                                %s
                            WHERE
                                a.article_id = '{$aDataQuery[$queryNumber]['article_id']}'
                                %s
                                %s
                        	", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                            , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                            , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );

                        $aArticleImages = $this->dbh->getAll($query, DB_FETCHMODE_ASSOC);

                        $output->aArticleImages = $aArticleImages;


            $output->showEmail = $this->conf['ArticleViewWebMgr']['showEmail'];
            $output->showAuthor = $this->conf['ArticleViewWebMgr']['showAuthor'];
            $output->showStartDate = $this->conf['ArticleViewWebMgr']['showDate'];
        }

        /*
         * load latest article type menu
         */

        $queryNumber =6;
        $adjustOrderBy='ORDER BY a.date_start DESC';
        $aDataQuery = array($queryNumber => array(
        																	'article_type_id' => $input->frmArticleTypeID,
        																	'adjustOrderBy' => $adjustOrderBy
                                                                            ));
        $this->_customQueryData('viewLatestArticleType', $input, $queryNumber, $aDataQuery);
                $query = sprintf("SELECT 
                            *
                        FROM 
                            {$this->conf['table']['article']} a, 
                            {$this->conf['table']['article_message']} am, 
                            {$this->conf['table']['article_role']} ar
                            %s
                        WHERE 
                            a.article_id = am.article_id
                            AND ar.article_id = a.article_id
                            AND ar.role_id = '{$roleID}'
                            AND a.article_type_id = '{$aDataQuery[$queryNumber]['article_type_id']}'
                            AND (
                                    (am.web_lang_id = {$defaultLangID } AND a.skip_default_lang=0) 
                                    OR
                                    (a.skip_default_lang = '1' AND am.web_lang_id = '{$secondLangID}')
                                    )
                            AND (
                                    (a.publish =1 AND a.date_start <= '{$currentTime}')
                                AND 
                                    (a.never_expired =1 OR a.date_end >= '{$currentTime}')
                            )
                            %s
                            %s
                            ", isset($aDataQuery[$queryNumber]['adjustFrom']) ? $aDataQuery[$queryNumber]['adjustFrom'] : '' 
                             , isset($aDataQuery[$queryNumber]['adjustWhere']) ? $aDataQuery[$queryNumber]['adjustWhere'] : ''
                             , isset($aDataQuery[$queryNumber]['adjustOrderBy']) ? $aDataQuery[$queryNumber]['adjustOrderBy'] : ''   );
        
        $limit = $this->conf['ArticleViewWebMgr']['maxLastArticleForType'] ? $this->conf['ArticleViewWebMgr']['maxLastArticleForType'] :10;
        
        $pagerOptions = array(
            'mode'     => 'Sliding',
            'delta'    => 3,
            'perPage'  => $limit,
            'spacesBeforeSeparator' => 0,
            'spacesAfterSeparator'  => 0,
            'curPageSpanPre'        => '<span class="currentPage">',
            'curPageSpanPost'       => '</span>',
        );
        $aPagedData = SGL_DB::getPagedData($this->dbh, $query, $pagerOptions);

        $output->aPagedData = $aPagedData;
        if (is_array($aPagedData['data']) && count($aPagedData['data'])) {
            $output->pager = ($aPagedData['totalItems'] <= $limit) ? false : true;
        }
        
    }    
    
    ################################################################
    # IF YOU WANT TO ADJUST DEFAULT MODULE ARTCLEWEB, 
    # PLEASE EDITE YOUR CODES HERE!!!
    #
    ################################################################
    
    /**
     * Custom  adjust input datas for all action 
     *
     * @param <mix> $req
     * @param <mix> $input
     */
    function _customCommondInput($req, &$input)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        /// If you want to custom validate action edit, please edit here!!
    }
    
    /**
     * Custom  adjust input datas for action only 
     *
     * @param <mix> $req
     * @param <mix> $input
     */
    function _customInputByAction($action = 'view', $req, &$input)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        switch ($action) {
            case "add" :
            case "edit" :
            case "delete":
            case 'view':
            case  'addview':
            case  'editview':
            case 'deleteImage':
            default :
                break;
        }
    }
    
    /**
     * Custom validate all action
     *
     * @param <mix> $input
     * @param <array> $aErrors
     */
    function _customCommondValidate($input, &$aErrors)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        
    }
    
    /**
    * Custom validate by action only
    *
    * @param <string> $action;
    * @param <mix> $input
    * @param <array> $aErrors
    */
    function _customValidateByAction($action = 'view', $input, &$aErrors)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        switch ($action) {
            case "add" :
            case "edit" :
            case "delete":
            case 'view':
            case  'addview':
            case  'editview':
            case 'deleteImage':
            default :
                break;
        }
    }
    
    /**
     * Custom output after process cmd_action has completed.
     *
     * @param <string> $action
     * @param <mix> $output
     */
    function _customOutputAfterRunCmd($action = 'view', &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        switch ($action) {
            case "add" :
            case "edit" :
            case "delete":
            case 'view':
            case  'addview':
            case  'editview':
            case 'deleteImage':
            default :
                break;
        }
    }
    
    /**
     * Custom change template by action
     *
     * @param <string> $template
     * @param <string> $action
     *
     * @return <string> $template
     */
    function _customUseTemplatebyAction(&$template, $action)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        /// If you want to custom validate action edit, please edit here!!
        switch ($action) {
            case "add" :
            case "edit" :
            case "delete":
            case 'view':
            case  'addview':
            case  'editview':
            case 'deleteImage':
            default :
                break;
        }
    }

    /**
     * Custom array Errors
     *
     * @param <array> $aErrors
     *
     * @return <array> $aErrors
     */
    function _customaErrorByAction($input, &$aErrors)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        /// If you want to custom code, please edit here!!
    }

    /**
     * Custom Output for display
     *
     * @param <mix> $output
     */
    function _customOutputDisplay(&$output)
    {
        switch ($output->action) {
            case "add" :
            case "edit" :
            case "delete":
            case 'view':
            case  'addview':
            case  'editview':
            case 'deleteImage':
            default :
                break;
        }
    }
    
    function _customOutputCMD($action, $input, $output){
        
    }
    
    
    /**
     * Custom input data befor insert datas to database in cmd_add
     *
     * @param <mix> $input
     * @param <array> $aDatas ;
     * 
     * @return <array>
     */
    function _customCmdAddBeforInsertArtcleDataToRecord($input, &$aDatas)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        
    }
    
    /**
     * Custom query data by action
     *
     * @param <string> $action
     * @param <mix> $input
     * @param <number> $queryNumber
     * @param <array> $aDataquery
     */
    function _customQueryData($action = 'view', $input, $queryNumber = null, &$aDataquery)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        if (is_null($queryNumber)) {
            return ;
        }
        switch ($action) {
            case "add" :
            case "edit" :
            case "delete":
            case 'view':
            case  'addview':
            case  'editview':
            case 'deleteImage':
            default :
                break;
        }
    }
    #######################################################
    ##                                        END FUNCTION ADJUST                                           #
    #######################################################
    
}
?>