<?php

// Insert Hash ##################################

function insertHash($input)
{

    $dbh = & SGL_DB::singleton();

    // รับค่า config
    $c = &SGL_Config::singleton();
    $conf = $c->getAll();    

    // รับค่า input
    $req = &SGL_Request::singleton();
    $frm = $req->getAll();

    $query = "
        SELECT `usr_id`
        FROM {$conf['table']['user']} 
        WHERE `username` = '{$input->user->username}'
    ";
    $uid = $dbh->getOne($query);

    $timestamp = time();
    $hash = md5($uid . $timestamp);

    $query = "
        INSERT INTO {$conf['table']['user_auth_hash']} (
            `usr_id` ,
            `username` ,
            `hash` ,
            `createtime`
        ) VALUES (
            '{$uid}', 
            '{$input->user->username}', 
            '{$hash}', 
            '{$timestamp}'
        )
    ";
    $dbh->query($query);

    return $hash;
}

// Remove Hash ##################################

function removeHash($userId)
{

    $dbh = & SGL_DB::singleton();

    // รับค่า config
    $c = &SGL_Config::singleton();
    $conf = $c->getAll();    

    $query = "
        DELETE FROM {$conf['table']['user_auth_hash']} 
        WHERE `usr_id` = '{$userId}'
    ";
    $dbh->query($query);

}

// Remove User ##################################

function removeUser($aUserId)
{
    $dbh = & SGL_DB::singleton();
    
    // รับค่า config
    $c = &SGL_Config::singleton();
    $conf = $c->getAll();    

    if (count($aUserId) < 1) {
        return;  
    }
    
    $userId = implode(',', $aUserId);

    $query = "
        DELETE FROM {$conf['table']['user']} 
        WHERE usr_id IN ({$userId});
    ";
    $dbh->query($query);

}

// Check Hash ##################################

function checkHash($username)
{

    $dbh = & SGL_DB::singleton();
    
    // รับค่า config
    $c = &SGL_Config::singleton();
    $conf = $c->getAll();    
    
    $query = "
        SELECT `usr_id` 
        FROM {$conf['table']['user_auth_hash']} 
        WHERE `username` = '{$username}'
    ";

    $userId = $dbh->getOne($query);

    if ($userId) {
        return false;
    } 

    return true;

}



// Delete Expire Hash ##################################
function deleteExpireHash()
{
    $dbh = & SGL_DB::singleton();
    $timestamp = time();
    $aUserExpire = Array();
    $aUserId = Array();
    
    // รับค่า config
    $c = &SGL_Config::singleton();
    $conf = $c->getAll();

    // หา expire time โดยเอาเวลาปัจจุบันไปลบกับ expire time แล้วกำหนดเป็นตัวแปร checktime
    $checktime = $timestamp - ($conf['RegisterMgr']['authExpire'] * 86400);
//    $checktime = $timestamp;    // Please remove after test
    
    // Remove User ที่เลือกก่อน
    $query = "
        SELECT `username`,`usr_id` 
        FROM {$conf['table']['user_auth_hash']} 
        WHERE `createtime` < '{$checktime}' 
    ";
    $aUserExpire = $dbh->getAll($query, DB_FETCHMODE_ASSOC);

    // ลบ Hash Key & ลบ User

    $oUserDAO = & UserDAO::singleton();
    
    for ($i = 0; $i < count($aUserExpire); $i++) {
        removeHash($aUserExpire[$i]['usr_id']);
        
        if ($aUserExpire[$i]['usr_id'] == SGL_ADMIN) {
            continue;
        }

        $oUserDAO->deletePrefsByUserId($aUserExpire[$i]['usr_id']);
        $oUserDAO->deletePermsByUserId($aUserExpire[$i]['usr_id']);
    
        if (!empty($conf['cookie']['rememberMeEnabled'])) {
            $oUserDAO->deleteUserLoginCookiesByUserId($aUserExpire[$i]['usr_id']);
        }
        
        $aUserId[] = $aUserExpire[$i]['usr_id'];
    }
    removeUser($aUserId);
   

}

// Send Activate Email ##################################
function sendActivateEmail($oUser, $moduleName, $conf, $hashKey)
{
    require_once SGL_CORE_DIR . '/Emailer.php';

    $realName = $oUser->first_name . ' ' . $oUser->last_name;
    $recipientName = (trim($realName)) ? $realName : '&lt;no name supplied&gt;';
    $options = array(
                'toEmail'       => $oUser->email,
                'toRealName'    => $recipientName,
                'fromEmail'     => $conf['email']['admin'],
                'replyTo'       => $conf['email']['admin'],
                'subject'       => 'Welcome to ' . $conf['site']['name'],
                'template'  => SGL_THEME_DIR . '/' . $_SESSION['aPrefs']['theme'] . '/' . $moduleName . '/email_registration_activation.php',
                'username'      => $oUser->username,
                'password'      => $oUser->passwdClear,
                'activateURL'      => $conf['site']['baseUrl'] . '/' . $conf['site']['frontScriptName'] . '/authweb/useractivate/action/update/key/' . $hashKey,
    );

    $message = & new SGL_Emailer($options);
    $message->prepare();
    $message->send();

    //  check error stack
    return (SGL_Error::count()) ? false : true;
}

?>