<?php

/* Reminder: always indent with 4 spaces (no tabs). */
// +---------------------------------------------------------------------------+
// WebSite:  http://www.webexperts.co.th
// Unauthorized copying is strictly forbidden and may result in severe legal action.
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// 
// =====YOU MUST KEEP THIS COPYRIGHTS NOTICE INTACT AND CAN NOT BE REMOVE =======
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// This Agreement is a legal contract, which specifies the terms of the license
// and warranty limitation between you and Web Experts Co.,Ltd. and RV Site Builder.
// You should carefully read the following terms and conditions before
// installing or using this software.  Unless you have a different license
// agreement obtained from Web Experts Co.,Ltd., installation or use of this software
// indicates your acceptance of the license and warranty limitation terms
// contained in this Agreement. If you do not agree to the terms of this
// Agreement, promptly delete and destroy all copies of the Software.
//
// =====  Grant of License =======
// The Software may only be installed and used on a single host machine.
//
// =====  Disclaimer of Warranty =======
// THIS SOFTWARE AND ACCOMPANYING DOCUMENTATION ARE PROVIDED "AS IS" AND
// WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR ANY OTHER
// WARRANTIES WHETHER EXPRESSED OR IMPLIED.   BECAUSE OF THE VARIOUS HARDWARE
// AND SOFTWARE ENVIRONMENTS INTO WHICH RV SITE BUILDER MAY BE USED, NO WARRANTY OF
// FITNESS FOR A PARTICULAR PURPOSE IS OFFERED.  THE USER MUST ASSUME THE
// ENTIRE RISK OF USING THIS PROGRAM.  ANY LIABILITY OF Web Experts Co.,Ltd. WILL BE
// LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT OR REFUND OF PURCHASE PRICE.
// IN NO CASE SHALL Web Experts Co.,Ltd. BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
// CONSEQUENTIAL DAMAGES OR LOSS, INCLUDING, WITHOUT LIMITATION, LOST PROFITS
// OR THE INABILITY TO USE EQUIPMENT OR ACCESS DATA, WHETHER SUCH DAMAGES ARE
// BASED UPON A BREACH OF EXPRESS OR IMPLIED WARRANTIES, BREACH OF CONTRACT,
// NEGLIGENCE, STRICT TORT, OR ANY OTHER LEGAL THEORY. THIS IS TRUE EVEN IF
// Web Experts Co.,Ltd. IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. IN NO CASE WILL
// Web Experts Co.,Ltd.'S LIABILITY EXCEED THE AMOUNT OF THE LICENSE FEE ACTUALLY PAID
// BY LICENSEE TO Web Experts Co.,Ltd.

require_once 'DB/DataObject.php';

/**
 * UserActivateMgr
 *
 * @package seagull
 * @author  RV Global Soft Team <bus@webexperts.co.th>
 */
class UserActivateMgr extends SGL_Manager
{
    function UserActivateMgr()
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        parent::SGL_Manager();

        $this->_aActionsMapping =  array(
            'update'          => array('update'),
            'view'          => array('view'),
        );
    }

    function validate($req, &$input)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $this->validated    = true;
        $input->error       = array();        
        $input->masterTemplate = $this->masterTemplate;        
        $input->action      = ($req->get('action')) ? $req->get('action') : 'view';
        $input->pageTitle   = $this->pageTitle . ' :: ' . $input->action;
        $input->template    = $this->template;
        $input->key = $req->get('key');
        
    ################ Start validate ###############
        $aErrors = array();
        
        switch ($input->action) {
            case "update":
                $input->template    = 'authPage.html';
                $this->_validateUpdate($input, $aErrors);
                break;
        }

        //  if errors have occured
         if (count($aErrors) > 0) {
            $input->error = $aErrors;
            $this->validated = false;
        }        
    }

    function _validateUpdate(&$input, &$aErrors)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $c = &SGL_Config::singleton();
        $conf = $c->getAll();
        
        if (!$input->key) {
            array_push($aErrors, SGL_String::translate('Invalid activation key.'));
            SGL::raiseMsg('Invalid activation key.', true, SGL_MESSAGE_ERROR);
            return;
        }        
        
        // ตรวจสอบ key กับฐานข้อมูล
        $query = "
            SELECT `usr_id` 
            FROM {$conf['table']['user_auth_hash']} 
            WHERE `hash` = '{$input->key}'
        ";
        
        $userId = $this->dbh->getOne($query);

        if (!$userId) {
            array_push($aErrors, SGL_String::translate('Invalid activation key.'));
            SGL::raiseMsg('Invalid activation key.', true, SGL_MESSAGE_ERROR);
            return;
        } else {
            $input->userId = $userId;
        }
        
    }
    
    function _cmd_update(&$input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $c = &SGL_Config::singleton();
        $conf = $c->getAll();
        $userModulesConf = $c->ensureModuleConfigLoaded('user');        
        // ลบ key ออกจากฐานข้อมูล
        $query = "
            DELETE FROM {$conf['table']['user_auth_hash']} 
            WHERE `usr_id` = '{$input->userId}'
        ";
        $this->dbh->query($query);
                            
        if (!$userModulesConf['RegisterMgr']['autoEnable']) {
            $output->adminApprove = SGL_String::translate('Your registration is being reviewed, you will be notified shortly');
        }
        
        /**
         * TODO: auto login after enter valid key to confirm email
         * we may modify LoginMgr->_doLogin to allow login using only key but not sure on the security
         *
        if ($userModulesConf['RegisterMgr']['autoLogin'] && $userModulesConf['RegisterMgr']['autoEnable']) {        
                // $input->key
                $input->username = '?????';
                $input->password = '??????';
                $input->action = "login";
                $oLogin = new LoginMgr();
                $oLogin->_cmd_login($input, $output);                            
        } 

        */             
        
                
        SGL::raiseMsg('User activate successfully.', true, SGL_MESSAGE_INFO);
    }

    function _cmd_view(&$input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);

        $output->template = 'authPage.html';
        

    }

}
?>
