<?php

require_once 'Date/TimeZone.php';
require_once 'DB/DataObject.php';

@define('PMF_SESSION_CURRENT_USER', 'PMF_CURRENT_USER');
@define('PMF_SESSION_ID_TIMESTAMP', 'PMF_SESSION_TIMESTAMP');

class FaqApi 
{
    
    function verifyAccount()
    {
        $dbh = & SGL_DB::singleton();

        // รับค่า config
        $c = &SGL_Config::singleton();
        $conf = $c->getAll();

        // รับค่า input
        $req = &SGL_Request::singleton();
        $frm = $req->getAll();

        $sglUserName = SGL_Session::getUsername();

        $query = "
        SELECT  user_id
        FROM  " . $conf['table']['faqweb_faquser'] . "
        WHERE login = '{$sglUserName}'
        LIMIT 0,1
        ";
        $res = $dbh->getAll($query, DB_FETCHMODE_ASSOC);
        if (count($res) < 1) {
            $oUser = DB_DataObject::factory($conf['table']['user']);
            $oUser->get(SGL_Session::getUid());
            $input->username = $oUser->username;
            $input->email = $oUser->email;
            $input->password = $frm['frmPassword'];

            $this->registerUser($input);
        }
        return true;
    }

    function addUser($input)
    {
        
        $input->username = $input->user->username;
        $input->password = $input->user->passwd;
        $input->email =  $input->user->email;
        
        $dbh = & SGL_DB::singleton();

        // รับค่า config
        $c = &SGL_Config::singleton();
        $conf = $c->getAll();
        
        $sglUserName = $input->username;
        
        $query = "
        SELECT  user_id
        FROM  " . $conf['table']['faqweb_faquser'] ."
        WHERE login = '{$sglUserName}'
        LIMIT 0,1
        ";
        $res = $dbh->getAll($query, DB_FETCHMODE_ASSOC);

        if (count($res) < 1) {
            $this->registerUser($input);
        }
        return true;
    }

    /*
     * faqweb/www/inc/PMF_User/User.php
     * createUser()
     */
    
    function registerUser($input)
    {
        $dbh = & SGL_DB::singleton();
        
        $login = $input->username;
        $password = md5($input->password);
        $email = $input->email;
        
        $now = time();
        
        // รับค่า config
        $c = &SGL_Config::singleton();
        $conf = $c->getAll();
        
        $userId = $dbh->nextId($conf['table']['faqweb_faquser']);
       
        
        $query = sprintf(
                    "INSERT INTO
                        %s
                        (user_id, login, session_timestamp, member_since)
                    VALUES
                        (%d, '%s', %d, '%s')",
                    $conf['table']['faqweb_faquser'],
                    $userId,
                    $login,
                    $now,
                    date('YmdHis', $now)
                    );
                    
        $dbh->query($query);        

        $query = sprintf(
                    "INSERT INTO
                        %suserdata
                    (user_id, last_modified, display_name, email)
                    VALUES
                        (%d, '%s', '%s', '%s')",
                    $conf['table']['faqweb_faquserdata'],
                    $userId,
                    date('YmdHis', time()),
                    $login,
                    $email
                    );        
        $dbh->query($query);
                    
        $query = "
          INSERT INTO
            " . $conf['table']['faqweb_faquserlogin'] . "
          (login, pass)
            VALUES
          ('" . $login . "', '" . $password . "')
        ";
        $dbh->query($query);

        return true;
    }

    function login($password)
    {
        // รับค่า config
        $c = &SGL_Config::singleton();
        $conf = $c->getAll();

        $sglUserName = SGL_Session::getUsername();

        $sglUserId = SGL_Session::getUid();
        require_once SGL_MOD_DIR . '/user/classes/UserDAO.php';
        $daUser    = &UserDAO::singleton();
        $aPref=$daUser->getPrefsByUserId($sglUserId);
        $sglSessionTimeout = $aPref['sessionTimeout'];
       
        $this->_resetPassword($sglUserName, $password);


       $users =  $this->pmf_getUserByLogin($sglUserName);
       $this->pmf_updateSessionId(true, $users->user_id);
       
       
        $this->pmf_saveToSession($users->user_id);
        
        $dbh = & SGL_DB::singleton();
        $query = "
                UPDATE
                    ". $conf['table']['faqweb_faquser'] . "
                SET
                    auth_source = 'local'
                WHERE
                    user_id = " . $users->user_id;
          
        $res = $dbh->query($query);

        setcookie("pmf_auth_",  session_id(),time() + $sglSessionTimeout, '/');
        setcookie("pmf_sid",  $users->user_id,time() + $sglSessionTimeout, '/');
        
        $usrId = SGL_Session::getUid();
        
        $query = "
            SELECT value
            FROM ".$conf['table']['user_preference'] ."
            WHERE preference_id = '5' and usr_id = '" . $usrId . "'";
        
        $userPrefLang = $dbh->getOne($query);
        require_once(SGL_MOD_DIR . '/main/classes/Main.php');
        $oMain = new Main;
        $setPmfLang = $oMain->languageMap('faqweb', $userPrefLang);

        setcookie('pmf_lang', $setPmfLang , time() + $sglSessionTimeout,'/');
        
        return true;
    }
 


    function logout()
    {
        $dbh = & SGL_DB::singleton();

        // รับค่า config
        $c = &SGL_Config::singleton();
        $conf = $c->getAll();
        $sglUserName = SGL_Session::getUsername();
        $users =  $this->pmf_getUserByLogin($sglUserName);
        
        $_SESSION[PMF_SESSION_CURRENT_USER] = null;
        unset($_SESSION[PMF_SESSION_CURRENT_USER]);
        // 
        // delete session-ID
        $query = "
            UPDATE
                " . $conf['table']['faqweb_faquser'] . "
            SET
                session_id = null
            WHERE
                user_id = ". $users->user_id;
        
        $res = $dbh->query($query);

        return true;
    }


    function changePassword($password, $relogin = true)
    {

        $dbh = & SGL_DB::singleton();
        $sglUserName = SGL_Session::getUsername();

        $this->_resetPassword($sglUserName, $password);

        if ($relogin === true) {
            $this->logout();
            $this->login($password);
        }
        
        return true;
    }


    function _resetPassword($username, $password)
    {
        
        $cryptPassword = md5($password);
        
        $dbh = & SGL_DB::singleton();
        
        // รับค่า config
        $c = &SGL_Config::singleton();
        $conf = $c->getAll();
        
        $query = "
            UPDATE
                " . $conf['table']['faqweb_faquserlogin'] . "
            SET
                pass = '" . $cryptPassword . "'    
            
            WHERE
                login = '".$username."'
        ";
        
        $res = $dbh->query($query);
        return true;
    }

    function _getAuthorIdByUsername($username)
    {

    }

    // การเปลี่ยน Username ทำให้รหัสผ่านเดิมใช้ไม่ได้ ต้อง reset รหัสผ่าน
    function changeUsername($currentUsername, $newUsername, $email)
    {
        $dbh = & SGL_DB::singleton();

        // รับค่า config
        $c = &SGL_Config::singleton();
        $conf = $c->getAll();
        
        $query = "
            SELECT user_id
            FROM " . $conf['table']['faqweb_faquser'] . "
            WHERE login = '{$currentUsername}'
                ";
        
        $pmfUserId = $dbh->getOne($query);
        
        $query = "
        UPDATE " . $conf['table']['faqweb_faquser'] . "
        SET login = '$newUsername'
        WHERE login = '{$currentUsername}'
        ";
        $dbh->query($query);

        $query = "
        UPDATE " . $conf['table']['faqweb_faquserlogin'] . "
        SET login = '$newUsername'
        WHERE login = '{$currentUsername}'
        ";
        $dbh->query($query);
        

        
        $query = "
        UPDATE " . $conf['table']['faqweb_faquserdata'] . "
        SET 
        display_name = '$newUsername',
        email = '$email' 
        WHERE user_id = '{$pmfUserId}'
        ";
        $dbh->query($query);
        
        if ($currentUsername == 'admin'){
            $query = "
            UPDATE " . $conf['table']['faqweb_faqconfig'] . "
            SET 
            config_value = '$newUsername'
            WHERE config_name = 'main.metaPublisher'
            ";
            $dbh->query($query);
            
            $query = "
            UPDATE " . $conf['table']['faqweb_faqconfig'] . "
            SET 
            config_value = '$email'
            WHERE config_name = 'main.administrationMail' 
            ";
            $dbh->query($query);
        }

        return true;
    }


    function deleteUser($aUserId)
    {


        $dbh = & SGL_DB::singleton();
        $c = &SGL_Config::singleton();
        $conf = $c->getAll();
        
        if (!is_array($aUserId)) {
            $aUserId = array($aUserId);
        } else {
            $aUserId = array_unique($aUserId);
        }

        $userIdQuery = implode(',', $aUserId);

        $query = "
            SELECT username
            FROM " . $conf['table']['user'] . "
            WHERE usr_id IN (" . $userIdQuery . ")
                ";
        
        $aSglUserName = $dbh->getCol($query);
        $memberList = '';
        foreach ($aSglUserName as $key) {
            $memberList .= '\'' . $key . '\',';
        }
        $memberList .= '\' \'';
       
       
        $query = "SELECT user_id, login
                    FROM " . $conf['table']['faqweb_faquser'] . "
                WHERE login IN ({$memberList})";

        $aPfmUserId = $dbh->getAll($query);

        if (!is_array($aPfmUserId)) {
            $aPfmUserId = array($aPfmUserId);
        } else {
            $aPfmUserId = array_unique($aPfmUserId);
        }
        
        foreach ($aPfmUserId as $key=>$val) {
            $userId = $val->user_id;
            $userName = $val->login;
            $query = "
            DELETE FROM
            " . $conf['table']['faqweb_faquser'] . "
            WHERE
            user_id = ".$userId;
            $dbh->query($query);
            
            $query = "
            DELETE FROM
            " . $conf['table']['faqweb_faquserdata'] . "
            WHERE
            user_id = ".$userId;
            $dbh->query($query);
            
            $query = "
            DELETE FROM
            " . $conf['table']['faqweb_faquserlogin'] . "
            WHERE
            login = '" . $userName . "'";
            $dbh->query($query);
                
        }
        
                
        
        return true;

    }


    function changeUserPreference($input)
    {
        $dbh = & SGL_DB::singleton();
        
        
        require_once(SGL_MOD_DIR . '/main/classes/Main.php');
        $oMain = new Main;
        $setPmfLang = $oMain->languageMap('faqweb', $input->aPrefs['language']);

        setcookie('pmf_lang', $setPmfLang , time() + 3600,'/');
        
    }

    /*
     * not know
     */

    function changeDefaultPreference($input)
    {
 

    }
    
    function pmf_updateSessionId($updateLastlogin = false, $userID)
    {
        $dbh = & SGL_DB::singleton();

        // รับค่า config
        $c = &SGL_Config::singleton();
        $conf = $c->getAll();
        
        // renew the session-ID
        $oldSessionId = session_id();

        // store session-ID age
        $now = time();
        $_SESSION[PMF_SESSION_ID_TIMESTAMP] = $now;

        // save session information in user table
        $query = sprintf(
                    "UPDATE
                        %s
                    SET
                        session_id          = '%s',
                        session_timestamp   = %d,
                        %s
                        ip                  = '%s'
                    WHERE
                        user_id = %d",
                    $conf['table']['faqweb_faquser'],
                    session_id(),
                    $now,
                    $updateLastlogin ?  "last_login = '".date('YmdHis', $now)."'," : '',
                    $_SERVER['REMOTE_ADDR'],
                    $userID
                    );
        $res = $dbh->query($query);

        return true;
    }
    
    function pmf_saveToSession($userID)
    {
        // save CurrentUser in session
        $_SESSION[PMF_SESSION_CURRENT_USER] = $userID;
        
    }

    function pmf_getUserByLogin($login, $raise_error = true)
    {
        
        $dbh = & SGL_DB::singleton();

        // รับค่า config
        $c = &SGL_Config::singleton();
        $conf = $c->getAll();
        
        // get user
        $query = "
          SELECT
            user_id,
            login,
            account_status
          FROM
            " . $conf['table']['faqweb_faquser'] . "
          WHERE
            login = '". $login ."'
        ";
        $res = $dbh->getAll($query);
        return $res[0];
    }
    
}
?>