<?php
/**
 * $Id: stat.show.php,v 1.13 2007/03/31 13:10:48 thorstenr Exp $
 *
 * Show the session
 *
 * @author       Thorsten Rinne <thorsten@phpmyfaq.de>
 * @since        2003-02-24
 * @copyright    (c) 2003-2007 phpMyFAQ Team
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 */

if (!defined('IS_VALID_PHPMYFAQ_ADMIN')) {
    header('Location: http://'.$_SERVER['HTTP_HOST'].dirname($_SERVER['SCRIPT_NAME']));
    exit();
}

if ($permission['viewlog']) {
    require_once(PMF_ROOT_DIR.'/inc/Session.php');

    $sid = (int)$_GET['id'];

    printf('<h2>%s "<span style="color: Red;">%d</span>"</h2>',
        $PMF_LANG['ad_sess_session'],
        $sid);

    $session = new PMF_Session($db, $LANGCODE);
    $time = $session->getTimeFromSessionId($sid);

	$trackingdata = explode("\n", file_get_contents(PMF_ROOT_DIR.'/data/tracking'.date('dmY', $time)));
?>
    <table class="list">
    <tfoot>
	    <tr>
            <td colspan="2"><a href="javascript:history.back()"><?php print $PMF_LANG["ad_sess_back"]; ?></a></td>
        </tr>
    </tfoot>
    <tbody>
<?php
        $num = 0;
        foreach ($trackingdata as $line) {
        	$data = explode(';', $line);
			if ($data[0] == $sid) {
				$num++;
?>
        <tr>
            <td class="list"><?php print date("Y-m-d H:i:s", $data[7]); ?></td>
            <td class="list"><?php print $data[1]; ?> (<?php print $data[2]; ?>)</td>
        </tr>
<?php
				if ($num == 1) {
?>
        <tr>
            <td class="list"><?php print $PMF_LANG["ad_sess_referer"]; ?></td>
            <td class="list"><a href="<?php print $data[5]; ?>" target="_blank"><?php print str_replace("?", "? ", $data[5]); ?></a></td>
        </tr>
        <tr>
            <td class="list"><?php print $PMF_LANG["ad_sess_browser"]; ?></td>
            <td class="list"><?php print $data[6]; ?></td>
        </tr>
        <tr>
            <td class="list"><?php print $PMF_LANG["ad_sess_ip"]; ?>:</td>
            <td class="list"><?php print $data[3]; ?></td>
        </tr>
<?php
                }
            }
        }
?>
    </tbody>
    </table>
<?php
} else {
	print $PMF_LANG['err_NotAuth'];
}