<?php
/**
 * $Id: Relation.php,v 1.9.2.2 2007/06/23 13:46:00 thorstenr Exp $
 *
 * The Relation class for dynamic related record linking
 *
 * @author      Marco Enders <marco@minimarco.de>
 * @author      Thorsten Rinne <thorsten@phpmyfaq.de>
 * @author      Adrianna Musiol <musiol@imageaccess.de>
 * @package     phpMyFAQ
 * @since       2006-06-18
 * @copyright   (c) 2006-2007 phpMyFAQ Team
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 */

class PMF_Relation
{
    /**
    * DB handle
    *
    * @var  object
    */
    var $db;

    /**
    * Language
    *
    * @var  string
    */
    var $language;

    /**
    * Language strings
    *
    * @var  string
    */
    var $pmf_lang;

    /**
    * Constructor
    *
    */
    function PMF_Relation(&$db, $language)
    {
        global $PMF_LANG;

        $this->db = &$db;
        $this->language = $language;
        $this->pmf_lang = $PMF_LANG;
    }

    /**
     * Saves the keywords for the related articles
     *
     * @param    string
     * @access   public
     * @author   Marco Enders <marco@minimarco.de>
     * @author   Thorsten Rinne <thorsten@phpmyfaq.de>
     */
    function saveRelationKeywords($relation_keywords)
    {
        $relation = explode(' ', $relation_keywords);
        foreach ($relation as $relation_word) {
            if (strlen($relation_word) > 2) {
                $query = sprintf(
                    "SELECT
                        keyword
                    FROM
                        %sfaqkeywords
                    WHERE
                        lang = '%s' AND keyword = '%s'",
                    SQLPREFIX,
                    $this->language,
                    $relation_word);
                $result_relation = $this->db->query($query);
            }

            if ($db->num_rows($result_relation) == 0) {
                $query = sprintf(
                    "INSERT INTO
                        %sfaqkeywords
                    VALUES
                        (%d,'%s')",
                    SQLPREFIX,
                    $relation_word);
                $this->db->query($query);
            }
        }
    }

    /**
     * Verlinkt einen Artikel dynamisch mit der Suche ber die bergebenen Schlsselwrter
     *
     * @param    string     $strHighlight
     * @param    string     $strSource
     * @param    integer    $intCount
     * @return   string
     * @access   public
     * @author   Marco Enders <marco@minimarco.de>
     * @author   Thorsten Rinne <thorsten@phpmyfaq.de>
     */
    function setRelationLinks($strHighlight, $strSource, $intCount = 0)
    {
        global $in_content;
        $x = 0;
        $arrMatch = array();

        preg_match_all(
            '/(<a[^<>]*?>.*?<\/a>)|(<.*?>)/is',
            $strSource,
            $arrMatch);
        $strSource = preg_replace(
            '/(<a[^<>]*?>.*?<\/a>)|(<.*?>)/is',
            '~+*# replaced html #*+~',
            $strSource);
        $x = $x + preg_match(
            '/('.preg_quote($strHighlight).')/ims',
            $strSource);
        $strSource = preg_replace(
            '/('.preg_quote($strHighlight).')/ims',
            '<a href="index.php?action=search&search='.$strHighlight.'" title="Insgesamt '.$intCount.' Artikel zu diesem Schlagwort ('.$strHighlight.') vorhanden. Jetzt danach suchen..." class="relation">$1</a>',
            $strSource);

        foreach($arrMatch[0] as $html) {
            $strSource = preg_replace(
                '/'.preg_quote('~+*# replaced html #*+~').'/',
                $html,
                $strSource,
                1);
        }

        if ($x == 0) {
            $in_content = false;
        } else {
            $in_content = true;
        }
        return $strSource;
    }


    /**
     * Returns all relevant Articles for a FAQ record
     *
     * @param   integer $record_id
     * @param   string  $thema
     * @return  string
     * @access  public
     * @since   2006-08-29
     * @author  Thomas Zeithaml <info@spider-trap.de>
     * @author  Adrianna Musiol <musiol@imageaccess.de>
     */
    function getAllRelatedById($record_id, $article_name, $keywords)
    {
        global $sids, $PMF_LANG, $PMF_CONF, $faqconfig, $faq, $current_groups;
        $relevantslisting = '';
        $begriffe = str_replace('-', ' ', $article_name) . $keywords;
        $i = $last_id = 0;

        $result = $this->db->search(SQLPREFIX."faqdata",
                          array(SQLPREFIX."faqdata.id AS id",
                                SQLPREFIX."faqdata.lang AS lang",
                                SQLPREFIX."faqcategoryrelations.category_id AS category_id",
                                SQLPREFIX."faqdata.thema AS thema",
                                SQLPREFIX."faqdata.content AS content"),
                          SQLPREFIX."faqcategoryrelations",
                          array(SQLPREFIX."faqdata.id = ".SQLPREFIX."faqcategoryrelations.record_id",
                                SQLPREFIX."faqdata.lang = ".SQLPREFIX."faqcategoryrelations.record_lang"),
                          array(SQLPREFIX."faqdata.thema",
                                SQLPREFIX."faqdata.content",
                                SQLPREFIX."faqdata.keywords"),
                          $begriffe,
                          array(SQLPREFIX."faqdata.active" => "'yes'"));

        while (($row = $this->db->fetch_object($result)) && ($i < $PMF_CONF['records.numberOfRelatedArticles'])) {
            if ($row->id == $record_id || $row->id == $last_id) {
                continue;
            }

			$localPermission = false;

			if ($faqconfig->get('main.permLevel') == 'medium') {
                $perm_group = $faq->getPermission('group', $row->id);
				foreach($current_groups as $index => $value){
					if (in_array($value, $perm_group)) {
						$localPermission = true;
					}
				}
			}

			if ($localPermission) {
				$perm_user = $faq->getPermission('user', $row->id);
				foreach ($perm_user as $index => $value) {
					if ($value == -1) {
						$localPermission = true;
						break;
					} elseif (((int)$value == $current_user)) {
						$localPermission = true;
						break;
					} else {
						$localPermission = false;
					}
				}
			}

			if ($localPermission) {
			    $relevantslisting .= ('' == $relevantslisting ? '<ul>' : '');
			    $relevantslisting .= '<li>';
			    $url = sprintf('%saction=artikel&amp;cat=%d&amp;id=%d&amp;artlang=%s',
                    $sids,
			        $row->category_id,
			        $row->id,
			        $row->lang);
			    $oLink = new PMF_Link(PMF_Link::getSystemRelativeUri().'?'.$url);
			    $oLink->itemTitle = $row->thema;
			    $oLink->text = PMF_htmlentities($row->thema, ENT_QUOTES, $this->pmf_lang['metaCharset']);
			    $oLink->tooltip = $row->thema;
			    $relevantslisting .= $oLink->toHtmlAnchor().'</li>';
			}
            $i++;
            $last_id = $row->id;
        }
        $relevantslisting .= ($i > 0 ? '</ul>' : '');

        return ('' == $relevantslisting ? '-' : $relevantslisting);
    }
}