<?php
/**
 * $Id: index.php,v 1.113.2.3 2008/01/26 08:48:35 thorstenr Exp $
 *
 * This is the main public frontend page of phpMyFAQ. It detects the browser's
 * language, gets and sets all cookie, post and get informations and includes
 * the templates we need and set all internal variables to the template
 * variables. That's all.
 *
 * @author       Thorsten Rinne <thorsten@phpmyfaq.de>
 * @author       Lars Tiedemann <php@larstiedemann.de>
 * @since        2001-02-12
 * @copyright:   (c) 2001-2007 phpMyFAQ Team
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 */

//
// Check if data.php exist -> if not, redirect to installer
//

define('RVS_COMPONENT_NAME', 'faqweb');
define('SGL_BASE_URL', dirname(dirname($_SERVER['SCRIPT_NAME'])));

if (!file_exists('inc/data.php') && !file_exists('inc/rvdata.php')) {
    header("Location: install/installer.php");
    exit();
}

//
// Prepend and start the PHP session
//

if (is_file(dirname(dirname($_SERVER['SCRIPT_FILENAME'])) . '/rvsStaticWeb.php')) {
    require_once  dirname(dirname($_SERVER['SCRIPT_FILENAME'])) . '/rvsStaticWeb.php';
}

require_once('inc/Init.php');
define('IS_VALID_PHPMYFAQ', null);


/*  Load Seagull Session */

if (!defined('USE_RVSSEAGULL_MODE')) {
    PMF_Init::cleanRequest();
    session_name('pmf_auth_'.$faqconfig->get('main.phpMyFAQToken'));
    session_start();
}


//
// Include required the link class, the template parser class, the captcha class, the category class,
// the main FAQ class, the glossary class and the IDNA class
//
require_once('inc/Link.php');
require_once('inc/Template.php');
require_once('inc/Captcha.php');
require_once('inc/Category.php');
require_once('inc/Faq.php');
require_once('inc/Glossary.php');
require_once('inc/Session.php');
require_once('inc/Tags.php');
require_once('inc/libs/idna_convert.class.php');
$IDN = new idna_convert;

//
// get language (default: english)
//
$pmf = new PMF_Init();
$LANGCODE = $pmf->setLanguage($faqconfig->get('main.languageDetection'), $faqconfig->get('main.language'));

/// START load language seagull_mod to component
$seagullLang = RVSGLWrapper::getCompoUseLang();
$LANGCODE = ($seagullLang[0]) ? $seagullLang[0] : $LANGCODE;
/// END load language seagull_mod to component

// Preload English strings
require_once ('lang/language_en.php');

if (isset($LANGCODE) && PMF_Init::isASupportedLanguage($LANGCODE) && !isset($_GET['gen'])) {
    // Overwrite English strings with the ones we have in the current language,
    // but don't include UTF-8 encoded files, these will break the captcha images
    require_once('lang/language_'.$LANGCODE.'.php');
} else {
    $LANGCODE = 'en';
}

//
// Authenticate current user
//
require_once ('inc/PMF_User/CurrentUser.php');
$auth = null;
$error = '';
if (isset($_POST['faqpassword']) and isset($_POST['faqusername'])) {
    // login with username and password
    $user = new PMF_CurrentUser();
    $faqusername = $db->escape_string($_POST['faqusername']);
    $faqpassword = $db->escape_string($_POST['faqpassword']);
    if ($user->login($faqusername, $faqpassword)) {
        // login, if user account is NOT blocked
        if ($user->getStatus() != 'blocked') {
            $auth = true;
        } else {
            $error = $PMF_LANG["ad_auth_fail"]." (".$faqusername." / *)";
        }
    } else {
        // error
        $error = sprintf('%s<br /><a href="admin/password.php" title="%s">%s</a>',
            $PMF_LANG['ad_auth_fail'], $PMF_LANG['lostPassword'], $PMF_LANG['lostPassword']);
        $user = null;
        unset($user);
    }
} else {
    // authenticate with session information
    $user = PMF_CurrentUser::getFromSession($faqconfig->get('main.ipCheck'));
    if ($user) {
        $auth = true;
    } else {
        $user = null;
        unset($user);
    }
}

//
// Get current user rights
//
$permission = array();
if (isset($auth)) {
    // read all rights, set them FALSE
    $allRights = $user->perm->getAllRightsData();
    foreach ($allRights as $right) {
        $permission[$right['name']] = false;
    }
    // check user rights, set them TRUE
    $allUserRights = $user->perm->getAllUserRights($user->getUserId());
    foreach ($allRights as $right) {
        if (in_array($right['right_id'], $allUserRights))
            $permission[$right['name']] = true;
    }
}

//
// Logout
//
if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'logout' && isset($auth)) {
    $user->deleteFromSession();
    $user = null;
    unset($user);
    $auth = null;
    unset($auth);
}

//
// Get current user and group id - default: -1
//
if (isset($user) && is_object($user)) {
    $current_user   = $user->getUserId();
    if (is_a($user->perm, 'PMF_PermMedium')) {
        $current_groups = $user->perm->getUserGroups($current_user);
    } else {
        $current_groups = array(-1);
    }
    if (0 == count($current_groups)) {
        $current_groups = array(-1);
    }
} else {
    $current_user   = -1;
    $current_groups = array(-1);
}

//
// use mbstring extension if available and when possible
//
$valid_mb_strings = array('ja', 'en', 'uni');
$mbLanguage = ('utf-8' == strtolower($PMF_LANG['metaCharset'])) && ($PMF_LANG['metaLanguage'] != 'ja') ? 'uni' : $PMF_LANG['metaLanguage'];
if (function_exists('mb_language') && in_array($mbLanguage, $valid_mb_strings)) {
    mb_language($mbLanguage);
    mb_internal_encoding($PMF_LANG['metaCharset']);
}

//
// found a session ID in _GET or _COOKIE?
//
$faqsession = new PMF_Session($db, $LANGCODE);
if ((!isset($_GET['sid'])) && (!isset($_COOKIE['pmf_sid']))) {
    // Create a per-site unique SID
    Tracking('new_session', 0);
    setcookie('pmf_sid', $sid, time() + 3600);
} else {
    if (isset($_COOKIE['pmf_sid']) && is_numeric($_COOKIE['pmf_sid'])) {
        $faqsession->checkSessionId((int)$_COOKIE['pmf_sid'], $_SERVER['REMOTE_ADDR']);
    } else {
        $faqsession->checkSessionId((int)$_GET['sid'], $_SERVER['REMOTE_ADDR']);
    }
}

//
// is user tracking activated?
//
$sids = '';
if ($faqconfig->get('main.enableUserTracking')) {
    if (isset($sid)) {
        if (!isset($_COOKIE['pmf_sid'])) {
            $sids = 'sid='.(int)$sid.'&amp;lang='.$LANGCODE.'&amp;';
        }
    } elseif (isset($_GET['sid']) || isset($_COOKIE['pmf_sid'])) {
        if (!isset($_COOKIE['pmf_sid'])) {
            if (is_numeric($_GET['sid'])) {
                $sids = 'sid='.(int)$_GET['sid'].'&amp;lang='.$LANGCODE.'&amp;';
            }
        }
    }
} else {
    if (!setcookie('pmf_lang', $LANGCODE, time() + 3600)) {
        $sids = 'lang='.$LANGCODE.'&amp;';
    }
}

//
// Found a article language?
//
if (isset($_POST['artlang']) && PMF_Init::isASupportedLanguage($_POST['artlang']) ) {
    $lang = strip_tags($_POST['artlang']);
} else {
    $lang = $LANGCODE;
}

//
// Create a new FAQ object
//
$faq = new PMF_Faq($db, $lang, $current_user, $current_groups);

//
// Create a new Category object
//
$category = new PMF_Category($LANGCODE, $current_user, $current_groups);

//
// Create a new Tags object
//
$oTag = new PMF_Tags($db, $LANGCODE);

//
// Found a record ID?
//
if (isset($_REQUEST['id']) && is_numeric($_REQUEST['id']) == true) {
    $id       = (int)$_REQUEST['id'];
    $title    = ' - ' . $faq->getRecordTitle($id);
    $keywords = ' ' . $faq->getRecordKeywords($id);
} else {
    $id       = '';
    $title    = ' -  powered by phpMyFAQ ' . $faqconfig->get('main.currentVersion');
    $keywords = '';
}

//
// found a solution ID?
//
if (isset($_REQUEST['solution_id']) && is_numeric($_REQUEST['solution_id']) === true) {
    $solution_id = (int)$_REQUEST['solution_id'];
    $title       = ' -  powered by phpMyFAQ '.$faqconfig->get('main.currentVersion');
    $keywords    = '';
    $a = $faq->getIdFromSolutionId($solution_id);
    if (is_array($a)) {
        $id = $a['id'];
        $lang = $a['lang'];
    }
}

//
// Found a category ID?
//
if (isset($_GET['cat'])) {
    $cat = (int)$_GET['cat'];
} else {
    if (isset($_POST['cat'])) {
        $cat = (int)$_POST['cat'];
    } else {
        $cat = 0;
    }
}

$cat_from_id = -1;
if (is_numeric($id) && $id > 0) {
    $cat_from_id = $category->getCategoryIdFromArticle($id);
}
if ($cat_from_id != -1 && $cat == 0) {
    $cat = $cat_from_id;
}
$category->transform(0);
$category->collapseAll();
if ($cat != 0) {
    $category->expandTo($cat);
}
if (   isset($cat)
    && ($cat != 0)
    && ($id == '')
    && isset($category->categoryName[$cat]['name'])
    ) {
    $title = ' - '.$category->categoryName[$cat]['name'];
}

//
// Found an action request?
//
if (isset($_REQUEST["action"]) && is_string($_REQUEST["action"]) && !preg_match("=/=", $_REQUEST["action"]) && isset($allowedVariables[$_REQUEST["action"]])) {
    $action = trim($_REQUEST["action"]);
} else {
    $action = "main";
}

//
// Select the template for the requested page
//
if (isset($auth)) {
    $login_tpl = 'template/loggedin.tpl';
} else {
    $login_tpl = 'template/loginbox.tpl';
}
if ($action != 'main') {
    $inc_tpl = 'template/' . $action . '.tpl';
    $inc_php = $action.".php";
    $writeLangAdress = $_SERVER['PHP_SELF']."?".str_replace("&", "&amp;",$_SERVER["QUERY_STRING"]);
} else {
    if (isset($solution_id) && is_numeric($solution_id)) {
        // show the record with the solution ID
        $inc_tpl = 'template/artikel.tpl';
        $inc_php = 'artikel.php';
    } else {
        $inc_tpl = 'template/main.tpl';
        $inc_php = 'main.php';
    }
    $writeLangAdress = $_SERVER['PHP_SELF']."?".$sids;
}

//
// Set right column
//
// Check in any tags with at leat one entry exist
$hasTags = $oTag->existTagRelations();
if ($hasTags && (($action == 'artikel') || ($action == 'show'))) {
    $right_tpl = $action == 'artikel' ? 'template/catandtag.tpl' : 'template/tagcloud.tpl';
} else {
    $right_tpl = 'template/startpage.tpl';
}

//
// Load template files and set template variables
//

/// START:: Builder SGL Output : BooM
if (defined('USE_RVSSEAGULL_MODE')) {
    $output = new SGL_Output();
}
/// END:: Builder SGL Output : BooM

$tpl = new PMF_Template (array(
        'index'                 => 'template/index.tpl',
        'loginBox'              => $login_tpl,
        'rightBox'              => $right_tpl,
        'writeContent'          => $inc_tpl));

$usersOnLine = getUsersOnline();
$totUsersOnLine = $usersOnLine[0] + $usersOnLine[1];
$main_template_vars = array(
        'title'             => $faqconfig->get('main.titleFAQ').$title,
        'baseHref'          => PMF_Link::getSystemUri('index.php'),
        'version'           => $faqconfig->get('main.currentVersion'),
        'header'            => str_replace('"', '', $faqconfig->get('main.titleFAQ')),
        'metaTitle'         => str_replace('"', '', $faqconfig->get('main.titleFAQ')),
        'metaDescription'   => $faqconfig->get('main.metaDescription'),
        'metaKeywords'      => $faqconfig->get('main.metaKeywords').$keywords,
        'metaPublisher'     => $faqconfig->get('main.metaPublisher'),
        'metaLanguage'      => $PMF_LANG['metaLanguage'],
        'metaCharset'       => $PMF_LANG['metaCharset'],
        'stylesheet'        => $PMF_LANG['dir'] == 'rtl' ? 'style.rtl' : 'style',
        'action'            => $action,
        'dir'               => $PMF_LANG['dir'],
        'msgCategory'       => $PMF_LANG['msgCategory'],
        'showCategories'    => $category->printCategories($cat),
        'searchBox'         => $PMF_LANG['msgSearch'],
        'languageBox'       => $PMF_LANG['msgLangaugeSubmit'],
        'writeLangAdress'   => $writeLangAdress,
        'switchLanguages'   => selectLanguages($LANGCODE, true),
        'userOnline'        => $totUsersOnLine.$PMF_LANG['msgUserOnline'].
                                sprintf($PMF_LANG['msgUsersOnline'],
                                $usersOnLine[0],
                                $usersOnLine[1]),
        'copyright'         => 'powered by <a href="http://www.phpmyfaq.de" target="_blank">phpMyFAQ</a> '.$faqconfig->get('main.currentVersion')
);

if ($faqconfig->get('main.enableRewriteRules')) {
    $links_template_vars = array(
        "faqHome"               => $_SERVER['PHP_SELF'],
        "msgSearch"             => '<a href="'.PMF_Link::getSystemRelativeUri('index.php').'search.html">'.$PMF_LANG["msgAdvancedSearch"].'</a>',
        'msgAddContent'         => '<a href="'.PMF_Link::getSystemRelativeUri('index.php').'addcontent.html">'.$PMF_LANG["msgAddContent"].'</a>',
        "msgQuestion"           => '<a href="'.PMF_Link::getSystemRelativeUri('index.php').'ask.html">'.$PMF_LANG["msgQuestion"].'</a>',
        "msgOpenQuestions"      => '<a href="'.PMF_Link::getSystemRelativeUri('index.php').'open.html">'.$PMF_LANG["msgOpenQuestions"].'</a>',
        'msgHelp'               => '<a href="'.PMF_Link::getSystemRelativeUri('index.php').'help.html">'.$PMF_LANG["msgHelp"].'</a>',
        "msgContact"            => '<a href="'.PMF_Link::getSystemRelativeUri('index.php').'contact.html">'.$PMF_LANG["msgContact"].'</a>',
        "backToHome"            => '<a href="'.PMF_Link::getSystemRelativeUri('index.php').'index.html">'.$PMF_LANG["msgHome"].'</a>',
        "allCategories"         => '<a href="'.PMF_Link::getSystemRelativeUri('index.php').'showcat.html">'.$PMF_LANG["msgShowAllCategories"].'</a>',
        "writeSendAdress"       => PMF_Link::getSystemRelativeUri('index.php').'search.html',
        'showInstantResponse'   => '<a href="'.PMF_Link::getSystemRelativeUri('index.php').'instantresponse.html">'.$PMF_LANG['msgInstantResponse'].'</a>',
        'showSitemap'           => getLinkHtmlAnchor($_SERVER['PHP_SELF'].'?'.$sids.'action=sitemap&amp;lang='.$LANGCODE, $PMF_LANG['msgSitemap']),
        'opensearch'            => PMF_Link::getSystemRelativeUri('index.php').'search.html'
        );
} else {
    $links_template_vars = array(
        "faqHome"               => $_SERVER['PHP_SELF'],
        "msgSearch"             => '<a href="'.$_SERVER['PHP_SELF'].'?'.$sids.'action=search">'.$PMF_LANG["msgAdvancedSearch"].'</a>',
        "msgAddContent"         => '<a href="'.$_SERVER['PHP_SELF'].'?'.$sids.'action=add">'.$PMF_LANG["msgAddContent"].'</a>',
        "msgQuestion"           => '<a href="'.$_SERVER['PHP_SELF'].'?'.$sids.'action=ask">'.$PMF_LANG["msgQuestion"].'</a>',
        "msgOpenQuestions"      => '<a href="'.$_SERVER['PHP_SELF'].'?'.$sids.'action=open">'.$PMF_LANG["msgOpenQuestions"].'</a>',
        "msgHelp"               => '<a href="'.$_SERVER['PHP_SELF'].'?'.$sids.'action=help">'.$PMF_LANG["msgHelp"].'</a>',
        "msgContact"            => '<a href="'.$_SERVER['PHP_SELF'].'?'.$sids.'action=contact">'.$PMF_LANG["msgContact"].'</a>',
        "allCategories"         => '<a href="'.$_SERVER['PHP_SELF'].'?'.$sids.'action=show">'.$PMF_LANG["msgShowAllCategories"].'</a>',
        "backToHome"            => '<a href="'.$_SERVER['PHP_SELF'].'?'.$sids.'">'.$PMF_LANG["msgHome"].'</a>',
        "writeSendAdress"       => $_SERVER['PHP_SELF'].'?'.$sids.'action=search',
        'showInstantResponse'   => '<a href="'.$_SERVER['PHP_SELF'].'?'.$sids.'action=instantresponse">'.$PMF_LANG['msgInstantResponse'].'</a>',
        'showSitemap'           => '<a href="'.$_SERVER['PHP_SELF'].'?'.$sids.'action=sitemap&amp;lang='.$LANGCODE.'">'.$PMF_LANG['msgSitemap'].'</a>',
        'opensearch'            => $_SERVER['PHP_SELF'].'?'.$sids.'action=search',
        );
}

if (DEBUG) {
    $cookies = '';
    foreach($_COOKIE as $key => $value) {
        $cookies .= $key.': '.$value.'<br />';
    }
    $debug_template_vars = array(
        'debugMessages' => '<div id="debug_main">DEBUG INFORMATION:<br />'.$db->sqllog().'</div><div id="debug_cookies">COOKIES:<br />'.$cookies.'</div>');
} else {
    // send headers and print template
    header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
    header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");
    header("Cache-Control: no-store, no-cache, must-revalidate");
    header("Cache-Control: post-check=0, pre-check=0", false);
    header("Pragma: no-cache");
    header("Content-type: text/html; charset=".$PMF_LANG['metaCharset']);
    header("Vary: Negotiate,Accept");
    $debug_template_vars = array('debugMessages' => '');
}


$hasTags = $oTag->existTagRelations();
if ($hasTags && (($action == 'artikel') || ($action == 'show'))) {
    $right_tpl = $action == 'artikel' ? 'template/catandtag.tpl' : 'template/tagcloud.tpl';
} else {
    $right_tpl = 'template/startpage.tpl';
}

//
// Get main template, set main variables
//


$tpl->processTemplate(
    'index',
    array_merge(
        $main_template_vars,
        $links_template_vars,
        $debug_template_vars));

//
// Show login box or logged-in user information
//
if (isset($auth)) {
    $aloginBox = array(
        'loggedinas'        => $PMF_LANG['ad_user_loggedin'],
        'currentuser'       => $user->getUserData('display_name'),
        'printAdminPath'    => (in_array(true, $permission)) ? 'admin/index.php' : '#',
        'adminSection'      => $PMF_LANG['adminSection'],
        'printLogoutPath'   => $_SERVER['PHP_SELF'].'?action=logout',
        'logout'            => $PMF_LANG['ad_menu_logout']);
} else {
    $aloginBox = array(
        'writeLoginPath'    => $_SERVER['PHP_SELF'].'?action=login',
        'login'             => $PMF_LANG['ad_auth_ok'],
        'username'          => $PMF_LANG['ad_auth_user'],
        'password'          => $PMF_LANG['ad_auth_passwd'],
        'msgLoginFailed'    => $error);
}

if (defined('USE_RVSSEAGULL_MODE')) { rvs_cloneoutput($output,$aloginBox); }
$tpl->processTemplate('loginBox', $aloginBox);
$tpl->includeTemplate('loginBox', 'index');

/// START buil category option for all othor
if ($action != 'search') {
    $category->buildTree();
}
$numcate = $category->printCategoryOptions($cat);
/// END buil category option for all othor

$arightBox = array(
    'writeTopTenHeader'     => $PMF_LANG['msgTopTen'],
    'writeTopTenRow'        => $faq->getTopTen(),
    'writeNewestHeader'     => $PMF_LANG['msgLatestArticles'],
    'writeNewestRow'        => $faq->getLatest(),
    'writeTagCloudHeader'   => $PMF_LANG['msg_tags'],
    'writeTags'             => $oTag->printHTMLTagsCloud(),
    'msgAllCatArticles'     => $PMF_LANG['msgAllCatArticles'],
    'printCategoryOptions'              =>$numcate,
    'allCatArticles'        => $faq->showAllRecordsWoPaging($cat));

if (defined('USE_RVSSEAGULL_MODE')) { rvs_cloneoutput($output, $arightBox); }
$tpl->processTemplate('rightBox', $arightBox);



$tpl->includeTemplate('rightBox', 'index');

/// START:: If user RVSSeagull mod change template to Flexy: BooM
if (defined('USE_RVSSEAGULL_MODE')) {
    $output->componenThemePath = dirname(__FILE__) . '/rvstemplates';
    $output->componenPath = dirname(__FILE__);
    $output->componentName = 'faqweb';
    $output->webRoot = RVSGLWrapper::getSGLBaseURL(0);
    $output->wwwRoot = RVSGLWrapper::getSGLBaseURL(0);

    $rvsIncTpl = ($inc_tpl)? $inc_tpl : 'main.tpl';
    $rvsRightTpl = ($right_tpl)? $right_tpl : 'startpage.tpl';
    $rvsIncTpl  = preg_replace('#^template\/#si','' , $rvsIncTpl);
    $rvsRightTpl  = preg_replace('#^template\/#si','' , $rvsRightTpl);
    $output->template = $rvsIncTpl;
    $output->IncluudeTemplate = $rvsRightTpl;
     $output->writeSearchAdress = $_SERVER['PHP_SELF'];
    $aView = array_merge($main_template_vars, $links_template_vars, $debug_template_vars);
    rvs_cloneoutput($output, $aView);

    $output->aTopFaqData = $faq->getTopTenData(5, 0, $faq->language);
    $output->aLatestFaqData = $faq->getLatestData(5, $faq->language);
    
    $output->writeTopTenHeader = preg_replace('#10#si', '5' , $output->writeTopTenHeader);
    $output->FAQLANG = $PMF_LANG;
}
/// END:: If user RVSSeagull mod change template to Flexy: BooM

//
// Include requested PHP file
//

require_once($inc_php);


if ('xml' != $action) {
/// START:: Modifine rander template: BooM
    if (defined('USE_RVSSEAGULL_MODE')) {
        $output->viewObj = $output;
        $view = new RVFlexyStrategy($output, 'Flexy');
        echo $view->render($output);
    } else {
        $tpl->printTemplate();
    }
/// END:: Modifine rander template: BooM
}


//
// Disconnect from database
//
$db->dbclose();

function rvs_getwebRoot()
{
    //$serendipity['smarty']
    return (defined('SGL_BASE_URL')) ? SGL_BASE_URL : dirname(dirname($_SERVER['REQUEST_URI']));
}

function rvs_cloneoutput(&$output = array(), $tplOutput = array())
{
    foreach ($tplOutput as $k => $v) {
        $output->$k = preg_replace('#&amp;#si','&',$v);
   }
}

function rvs_gethomepath($currentCategory = false)
{
    global $PMF_LANG, $category;
    $oLink = new PMF_Link(PMF_Link::getSystemRelativeUri());
    $oLink->itemTitle =$PMF_LANG["msgHome"];
    $oLink->text = $PMF_LANG["msgHome"];
    $aPathwayLink = array();
    array_push($aPathwayLink, $oLink->toHtmlAnchor());
    if ($currentCategory != false) {
        $cPathway = $category->getPath($currentCategory, ' &raquo; ', true);
        foreach (explode(' &raquo; ', $cPathway) as $link) {
             array_push($aPathwayLink, $link);
        }
    }
    return $aPathwayLink;
}