<?php
/**
* $Id: show.php,v 1.15 2007/03/13 18:43:32 thorstenr Exp $
*
* @author       Thorsten Rinne <thorsten@phpmyfaq.de>
* @since        2002-08-27
* @copyright    (c) 2002-2007 phpMyFAQ Team
*
* The contents of this file are subject to the Mozilla Public License
* Version 1.1 (the 'License'); you may not use this file except in
* compliance with the License. You may obtain a copy of the License at
* http://www.mozilla.org/MPL/
*
* Software distributed under the License is distributed on an 'AS IS'
* basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
* License for the specific language governing rights and limitations
* under the License.
*/

if (!defined('IS_VALID_PHPMYFAQ')) {
    header('Location: http://'.$_SERVER['HTTP_HOST'].dirname($_SERVER['SCRIPT_NAME']));
    exit();
}

if (isset($_REQUEST['cat']) && is_numeric($_REQUEST['cat'])) {
    $currentCategory = (int)$_REQUEST['cat'];
}

if (isset($currentCategory) && $currentCategory != 0 && isset($category->categoryName[$currentCategory])) {

    Tracking('show_category', $currentCategory);
    $parent = $category->categoryName[$currentCategory]['parent_id'];
    $name = $category->categoryName[$currentCategory]['name'];

    $records = $faq->showAllRecords($currentCategory, $faqconfig->get('records.orderby'), $faqconfig->get('records.sortby'));
    if (!$records) {
        $categories = new PMF_Category($LANGCODE);
        $categories->transform($currentCategory);
        $categories->collapseAll();
        $records = $categories->viewTree();
    }

    $up = '';
    if ($parent != 0) {
        $url = sprintf('%saction=show&amp;cat=%d',
                    $sids,
                    $parent);
        $oLink = new PMF_Link(PMF_Link::getSystemRelativeUri().'?'.$url);
        $oLink->itemTitle = $category->categoryName[$parent]['name'];
        $oLink->text = $PMF_LANG['msgCategoryUp'];
        $up = $oLink->toHtmlAnchor();
    }

    $aTemplateDatas = array(
        'writeCategory' => $PMF_LANG['msgEntriesIn'].$name,
        'writeThemes' => $records,
        'writeOneThemeBack' => $up);
    $tpl->processTemplate('writeContent', $aTemplateDatas);
    $tpl->includeTemplate('writeContent', 'index');

/// START: register output for flexy template: BooM  
    if (defined('USE_RVSSEAGULL_MODE')) {
        rvs_cloneoutput($output, $aTemplateDatas);
        $aCatDatas = $category->getAllCategories();
        $aCatDataOut[1] = $aCatDatas[$currentCategory];
        $aCatDataOut[$i]['link'] = $aCatDatas[$currentCategory]['name'];
        $aCatDataOut[1]['allRecords'] = $records;
        $aCatDataOut[1]['colWidth'] =  '100%';
        $output->aCatDataOut = $aCatDataOut;
        $output->aPathway = rvs_gethomepath();
        $aParentPath = array();
        rvs_getParentWay($aParentPath, $aCatDatas, $currentCategory);
        foreach ($aParentPath as $link) {
            array_push($output->aPathway, $link);
        }


    }
/// END: register output for flexy template: BooM  
} else {

    Tracking('show_all_categories', 0);
    $aTemplateDatas = array(
        'writeCategory' => $PMF_LANG['msgFullCategories'],
        'writeThemes' => $category->viewTree(),
        'writeOneThemeBack' => '');
    $tpl->processTemplate('writeContent', $aTemplateDatas);
    $tpl->includeTemplate('writeContent', 'index');
    
/// START: register output for flexy template: BooM    
    if (defined('USE_RVSSEAGULL_MODE')) {
        rvs_cloneoutput($output, $aTemplateDatas);
        $aCatDatas = $category->getAllCategories();
        $i = 0;
        $maxRow = count($aCatDatas)-1;
        $colWidth = ($maxRow >= 3) ? intval(100/3) : intval(100/$maxRow);

        foreach ($aCatDatas as $id => $aCatDataInRow) {
            if ($aCatDataInRow['parent_id'] != 0) {
                $parentConf[$aCatDataInRow['parent_id']][$id] =  true;
            }
        }

        foreach ($aCatDatas as $id => $aCatDataInRow) {
            if ($id==0 || $aCatDataInRow['parent_id'] != 0) { continue; }
            $i++;
            $aCatDataOut[$i] = $aCatDataInRow;
            $aCatDataOut[$i]['link'] = $category->addCategoryLink($sids, $aCatDataInRow['id'], $aCatDataInRow['name'], $aCatDataInRow['description']);
            $aCatDataOut[$i]['allRecords'] = rvs_buildSubLink($parentConf, $id, $aCatDataInRow);
            $aCatDataOut[$i]['colWidth'] = $colWidth . '%';
            if ($i != $maxRow && ($i%3) ==0) {
                $aCatDataOut[$i]['closeTR'] = 1;
            }
        }
        $output->aCatDataOut = $aCatDataOut;
        $output->aPathway = rvs_gethomepath();
    }
/// END: register output for flexy template: BooM  
}

function rvs_buildSubLink($parentConf, $id, $aCatDataInRow)
{
    global $category, $aCatDatas, $faqconfig, $faq, $sids;
    $result = '';
    if (isset($parentConf[$id]) && count($parentConf[$id]) > 0) {
        foreach ($parentConf[$id] as $pid => $pv ) {
            $result .= '<ul class="phpmyfaq_ul">';
           $result .= $category->addCategoryLink($sids, $aCatDatas[$pid]['id'], $aCatDatas[$pid]['name'], $aCatDatas[$pid]['description']);
           $result .= rvs_buildSubLink($parentConf, $pid);
           $result .= '</ul>';
        }
    } else {
        $result .= $faq->showAllRecords($id, $faqconfig->get('records.orderby'), $faqconfig->get('records.sortby'));
    }
    return $result;
}

function rvs_getParentWay(&$aParent = array(), $aCatDatas, $id)
{
    global $category;
    $cPathway = $category->getPath($id, ' &raquo; ', true);
    array_unshift($aParent, $cPathway);
    if ($aCatDatas[$id]['parent_id'] != 0) {
            rvs_getParentWay($aParent, $aCatDatas, $aCatDatas[$id]['parent_id']);
    } 
}