<?php
/**
* $Id: xmlrpc.php,v 1.16.2.1 2007/05/31 18:41:00 thorstenr Exp $
*
* This is the XML-RPC interface
*
* @author       Thorsten Rinne <thorsten@phpmyfaq.de>
* @since        2004-05-14
* @copyright    (c) 2004-2007 phpMyFAQ Team
*
* The contents of this file are subject to the Mozilla Public License
* Version 1.1 (the "License"); you may not use this file except in
* compliance with the License. You may obtain a copy of the License at
* http://www.mozilla.org/MPL/
*
* Software distributed under the License is distributed on an "AS IS"
* basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
* License for the specific language governing rights and limitations
* under the License.
*/

require_once('inc/Init.php');
define('IS_VALID_PHPMYFAQ', null);
PMF_Init::cleanRequest();
session_name('pmf_auth_'.$faqconfig->get('main.phpMyFAQToken'));
session_start();

/* get configuration, constants, main functions, category class, XML-RPC classes */
require_once("inc/constants.php");
require_once("inc/functions.php");
require_once("inc/Category.php");
include_once("inc/libs/xmlrpc.php");
include_once("inc/libs/xmlrpcs.php");

$category = new PMF_Category();

function search($begriff)
{
    global $db, $category, $PMF_LANG, $PMF_CONF;
    $output = "";
    $result = $db->search(SQLPREFIX."faqdata",
                    array(SQLPREFIX."faqdata.id AS id",
                            SQLPREFIX."faqdata.lang AS lang",
                            SQLPREFIX."faqcategoryrelations.category_id AS category_id",
                            SQLPREFIX."faqdata.thema AS thema",
                            SQLPREFIX."faqdata.content AS content"),
                    SQLPREFIX."faqcategoryrelations",
                    array(SQLPREFIX."faqdata.id = ".SQLPREFIX."faqcategoryrelations.record_id",
                            SQLPREFIX."faqdata.lang = ".SQLPREFIX."faqcategoryrelations.record_lang"),
                    array(SQLPREFIX."faqdata.thema",
                            SQLPREFIX."faqdata.content",
                            SQLPREFIX."faqdata.keywords"),
                    $begriff,
                    array(SQLPREFIX."faqdata.active"=>"yes"));
    $num = $db->num_rows($result);
    if ($num > 0) {
        $output .= $num.$PMF_LANG["msgSearchAmounts"]."\n";
        while ($row = $db->fetch_object($result)) {
            $rubriktext = $category->categoryName[$row->rubrik]["name"];
            $thema = chopString($row->thema, 15);
            $output .= PMF_htmlentities($rubriktext, ENT_QUOTES, $PMF_LANG['metaCharset']).";".PMF_htmlentities($row->thema, ENT_QUOTES, $PMF_LANG['metaCharset']).";"."http://".$_SERVER['HTTP_HOST'].str_replace ("xmlrpc.php", "index.php", $_SERVER['PHP_SELF'])."?action=artikel&cat=".$row->category_id."&id=".$row->id."&artlang=".$row->lang."\n";
        }
    } else {
        $output = "No Articles found";
    }

    return $output;
}

function PMFSearch($params)
{
    $param = $params->getParam(0);
    if (isset($param)) {
        if ($param->scalartyp() == "string") {
            $searchString = $param->scalarval();
            $ret = new xmlrpcval(search($searchString), "string");
            return new xmlrpcresp($ret);
        } else {
            global $xmlrpcerruser;
            $ret = new xmlrpcresp(0, $xmlrpcerruser, "Wrong Parameter!");
            return $ret;
        }
    } else {
        global $xmlrpcerruser;
        $ret = new xmlrpcresp(0, $xmlrpcerruser, "No data received from client!");
        return $ret;
    }
}

$xmlrpc = new xmlrpc_server(array("phpmyfaq.PMFSearch" => array("function" => "PMFSearch")));

$db->dbclose();
