<?php

class Main_Block_LangSwitcherWeb
{
    var $templatePath = 'main';

    function init(&$output, $blockid, &$aParams)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);

        if (SGL::isMinimalInstall()) {
            // only one language exists in minimal install
            return false;
        }
        return $this->getBlockContent($output, $aParams);
    }

    function getBlockContent(&$output, &$aParams)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);

        if (empty($aParams)) {
            $aParams = array();
        }
        $aDefaultParams = array(
            'template'  => 'blockLangSwitcherWeb.html',
            'extension' => 'png'
        );
        if (is_file(dirname(__FILE__)  . '/LangSwitcherWeb.ini')) {
            $aParams =  parse_ini_file(dirname(__FILE__) . '/LangSwitcherWeb.ini');
        }
        
        $aParams = array_merge($aDefaultParams, $aParams);

        $input = &SGL_Registry::singleton();
        $conf  = $input->getConfig();
        $url   = $input->getCurrentUrl();

        $aLangs          = SGL_Util::getLangsDescriptionMap();
        $aLangsDef       = $GLOBALS['_SGL']['LANGUAGE'];
        $aInstalledLangs = str_replace('_', '-',
            explode(',', $conf['translation']['installedLanguages']));

        $aLangData = array();
        
        if ($aParams['defaultlang'] != '') {
            $defaultlang = $aParams['defaultlang'];
            $aDefaultlang = array($defaultlang => $aLangs[$defaultlang]);
            unset($aLangs[$defaultlang]);
            $aLangs = array_merge($aDefaultlang, $aLangs);
        }
        
        $langcount = 0;
        
        foreach ($aLangs as $langKey => $langName) {
            $langcount = $langcount + 1;
            if (!in_array($langKey, $aInstalledLangs)) {
                continue;
            }
            preg_match('/(.+) \(.+\)/', $langName, $matches);

            // main data
            $aLangData[$langKey]['name'] = $matches[1];
            $aLangData[$langKey]['code'] = $aLangsDef[$langKey][2];
            $aLangData[$langKey]['key']  = $langKey;
            $aLangData[$langKey]['seperator']  = 1;
            if ($langcount == count($aLangs)) {
                $aLangData[$langKey]['seperator']  = 0;
            }

            // the best way to build lang switching url found so far taking into
            // account UrlParser strategy, cleanUrls, session info etc
            $url->aQueryData['lang'] = $langKey;
            $aQueryData = $url->getQueryData(true);
            $action = '';
            $params = '';
            if (isset($aQueryData['action'])) {
                $action = $aQueryData['action'];
                unset($aQueryData['action']);
            }
            foreach ($aQueryData as $key => $value) {
                if (empty($value) && !is_numeric($value)
                        || false !== strpos($key, $conf['cookie']['name'])) {
                    continue;
                }
                $params[] = $key . '|' . $value;
            }
            if (!empty($params)) {
                $params = implode('||', $params);
            }
            $aLangData[$langKey]['url'] = $url->makeLink($action, '', '',
                array(), $params);

            $aLangData[$langKey]['is_current'] =
                SGL::getCurrentLang() == $aLangData[$langKey]['code'];
            $theme = isset( $_SESSION['aPrefs']['theme'])
                ? $_SESSION['aPrefs']['theme']
                : 'default';
            $imageFile = SGL_WEB_ROOT . '/themes/' . $theme .
                '/images/flags/' . $langKey . '.' . $aParams['extension'];
            $imageDir = (isset($output->imagesDir))
                ? $output->imagesDir
                : SGL_BASE_URL  . '/themes/' . $theme . '/image';
            $aLangData[$langKey]['image'] = file_exists($imageFile)
                ? "$imageDir/flags/{$langKey}.{$aParams['extension']}"
                : false;
        }
        
        $blockOutput                 = & new SGL_Output();
        $blockOutput->conf           = $conf;
        $blockOutput->theme          = $theme;
        $blockOutput->imagesDir      = $imageDir;
        $blockOutput->masterTemplate = $aParams['template'];
        $blockOutput->aLangs         = $aLangData;

        return $this->process($blockOutput);
    }

    function process(&$output)
    {
        $output->moduleName = $this->templatePath;

        $view = & new SGL_HtmlSimpleView($output);
        return $view->render();
    }
}
?>