<?php

/* Reminder: always indent with 4 spaces (no tabs). */
// +---------------------------------------------------------------------------+
// WebSite:  http://www.webexperts.co.th
// Unauthorized copying is strictly forbidden and may result in severe legal action.
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// 
// =====YOU MUST KEEP THIS COPYRIGHTS NOTICE INTACT AND CAN NOT BE REMOVE =======
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// This Agreement is a legal contract, which specifies the terms of the license
// and warranty limitation between you and Web Experts Co.,Ltd. and RV Site Builder.
// You should carefully read the following terms and conditions before
// installing or using this software.  Unless you have a different license
// agreement obtained from Web Experts Co.,Ltd., installation or use of this software
// indicates your acceptance of the license and warranty limitation terms
// contained in this Agreement. If you do not agree to the terms of this
// Agreement, promptly delete and destroy all copies of the Software.
//
// =====  Grant of License =======
// The Software may only be installed and used on a single host machine.
//
// =====  Disclaimer of Warranty =======
// THIS SOFTWARE AND ACCOMPANYING DOCUMENTATION ARE PROVIDED "AS IS" AND
// WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR ANY OTHER
// WARRANTIES WHETHER EXPRESSED OR IMPLIED.   BECAUSE OF THE VARIOUS HARDWARE
// AND SOFTWARE ENVIRONMENTS INTO WHICH RV SITE BUILDER MAY BE USED, NO WARRANTY OF
// FITNESS FOR A PARTICULAR PURPOSE IS OFFERED.  THE USER MUST ASSUME THE
// ENTIRE RISK OF USING THIS PROGRAM.  ANY LIABILITY OF Web Experts Co.,Ltd. WILL BE
// LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT OR REFUND OF PURCHASE PRICE.
// IN NO CASE SHALL Web Experts Co.,Ltd. BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
// CONSEQUENTIAL DAMAGES OR LOSS, INCLUDING, WITHOUT LIMITATION, LOST PROFITS
// OR THE INABILITY TO USE EQUIPMENT OR ACCESS DATA, WHETHER SUCH DAMAGES ARE
// BASED UPON A BREACH OF EXPRESS OR IMPLIED WARRANTIES, BREACH OF CONTRACT,
// NEGLIGENCE, STRICT TORT, OR ANY OTHER LEGAL THEORY. THIS IS TRUE EVEN IF
// Web Experts Co.,Ltd. IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. IN NO CASE WILL
// Web Experts Co.,Ltd.'S LIABILITY EXCEED THE AMOUNT OF THE LICENSE FEE ACTUALLY PAID
// BY LICENSEE TO Web Experts Co.,Ltd.

require_once 'DB/DataObject.php';

/**
 * WebFormMgr
 *
 * @package seagull
 * @author  RV Global Soft Team <bus@webexperts.co.th>
 */
class AdminWebFormMgr extends SGL_Manager
{
    function AdminWebFormMgr()
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        parent::SGL_Manager();

        $this->_aActionsMapping =  array(
            'view'          => array('view'),
            'viewmail'          => array('viewmail'),
            'delete'          => array('delete', 'view')
        );
    }

    function validate($req, &$input)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $this->validated    = true;
        $input->error       = array();
        $input->masterTemplate = $this->masterTemplate;
        $input->action      = ($req->get('action')) ? $req->get('action') : 'view';
        $input->mailID = ($req->get('mailID')) ? $req->get('mailID') : '';
        
        $input->frmDelete = ($req->get('frmDelete')) ? $req->get('frmDelete') : '';
        
        $input->sortBy      = SGL_Util::getSortBy($req->get('frmSortBy'), SGL_SORTBY_USER);
        $input->sortOrder   = SGL_Util::getSortOrder($req->get('frmSortOrder'));
        
        $input->pageTitle   = $this->pageTitle . ' :: ' . $input->action;

        $input->template = 'formMailManager.html';
      
    ################ Start validate ###############
        $aErrors = array();
        
        switch ($input->action) {
            case "viewmail":
                $input->template = 'viewMail.html';
                break;                                    
        }

        //  if errors have occured
         if (count($aErrors) > 0) {
            $input->error = $aErrors;
            
            SGL::raiseMsg(SGL_Output::translate('Validation Failed.') . '<br /><br />' . join('<br/>', $input->error),false);
            
            $this->validated = false;
        }        
    }
    
    function display(&$output)
    {

    }

    function _cmd_view(&$input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);        
        
        $allowedSortFields = array('mail_id','subject','date');
        if (!empty($input->sortBy)
               && !empty($input->sortOrder)
               && in_array($input->sortBy, $allowedSortFields)) {
            $orderByQuery = ' ORDER BY ' . $input->sortBy . ' ' . $input->sortOrder;
        } else {
            $orderByQuery = ' ORDER BY mail_id ASC ';
        }
        
        
        $query = "
            SELECT 
                    mail_id , subject , message , date 
            FROM 
                    {$this->conf['table']['formmail_log']}
                    {$orderByQuery}";
            

        $limit = $_SESSION['aPrefs']['resPerPage'];

        $pagerOptions = array(
            'mode'     => 'Sliding',
            'delta'    => 3,
            'perPage'  => $limit,
            'spacesBeforeSeparator' => 0,
            'spacesAfterSeparator'  => 0,
            'curPageSpanPre'        => '<span class="currentPage">',
            'curPageSpanPost'       => '</span>',
        );
        
        $aPagedData = SGL_DB::getPagedData($this->dbh, $query, $pagerOptions);
        $output->aPagedData = $aPagedData;
        
        if (is_array($aPagedData['data']) && count($aPagedData['data'])) {
            $output->pager = ($aPagedData['totalItems'] <= $limit) ? false : true;
        }
        
    }
    
    function _cmd_delete(&$input, &$output)
    {
        if (is_array($input->frmDelete)) {
            foreach ($input->frmDelete as $k => $v) {
                $this->_deleteDataInDB( $v);
            }
            
        } if (is_string($input->frmDelete)){
             $this->_deleteDataInDB( $input->frmDelete);           
        }

    }
    
    function _cmd_viewmail(&$input, &$output)
    {
        $query = sprintf("
            SELECT 
                    mail_id , subject , message , date 
            FROM 
                    {$this->conf['table']['formmail_log']}
            WHERE `mail_id` = %s; 
            ", $input->mailID);
            
        $aMailData = $this->dbh->getRow($query);

        $output->frmSubject = $aMailData->subject;
        $output->frmMessage = $aMailData->message;
        $output->frmDate = $aMailData->date;
    }

    function _deleteDataInDB($mailID)
    {
        if ($mailID) {
            $query = sprintf("
                DELETE FROM {$this->conf['table']['formmail_log']} 
                WHERE `mail_id` = %s LIMIT 1;
            ", $mailID);
            $this->dbh->query($query);
        }
    }
    

    
}
?>
