<?php

/* Reminder: always indent with 4 spaces (no tabs). */
// +---------------------------------------------------------------------------+
// WebSite:  http://www.webexperts.co.th
// Unauthorized copying is strictly forbidden and may result in severe legal action.
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// 
// =====YOU MUST KEEP THIS COPYRIGHTS NOTICE INTACT AND CAN NOT BE REMOVE =======
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// This Agreement is a legal contract, which specifies the terms of the license
// and warranty limitation between you and Web Experts Co.,Ltd. and RV Site Builder.
// You should carefully read the following terms and conditions before
// installing or using this software.  Unless you have a different license
// agreement obtained from Web Experts Co.,Ltd., installation or use of this software
// indicates your acceptance of the license and warranty limitation terms
// contained in this Agreement. If you do not agree to the terms of this
// Agreement, promptly delete and destroy all copies of the Software.
//
// =====  Grant of License =======
// The Software may only be installed and used on a single host machine.
//
// =====  Disclaimer of Warranty =======
// THIS SOFTWARE AND ACCOMPANYING DOCUMENTATION ARE PROVIDED "AS IS" AND
// WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR ANY OTHER
// WARRANTIES WHETHER EXPRESSED OR IMPLIED.   BECAUSE OF THE VARIOUS HARDWARE
// AND SOFTWARE ENVIRONMENTS INTO WHICH RV SITE BUILDER MAY BE USED, NO WARRANTY OF
// FITNESS FOR A PARTICULAR PURPOSE IS OFFERED.  THE USER MUST ASSUME THE
// ENTIRE RISK OF USING THIS PROGRAM.  ANY LIABILITY OF Web Experts Co.,Ltd. WILL BE
// LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT OR REFUND OF PURCHASE PRICE.
// IN NO CASE SHALL Web Experts Co.,Ltd. BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
// CONSEQUENTIAL DAMAGES OR LOSS, INCLUDING, WITHOUT LIMITATION, LOST PROFITS
// OR THE INABILITY TO USE EQUIPMENT OR ACCESS DATA, WHETHER SUCH DAMAGES ARE
// BASED UPON A BREACH OF EXPRESS OR IMPLIED WARRANTIES, BREACH OF CONTRACT,
// NEGLIGENCE, STRICT TORT, OR ANY OTHER LEGAL THEORY. THIS IS TRUE EVEN IF
// Web Experts Co.,Ltd. IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. IN NO CASE WILL
// Web Experts Co.,Ltd.'S LIABILITY EXCEED THE AMOUNT OF THE LICENSE FEE ACTUALLY PAID
// BY LICENSEE TO Web Experts Co.,Ltd.

class ExampleMgr extends SGL_Manager
{
    function ExampleMgr()
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        parent::SGL_Manager();

        $this->pageTitle    = 'Example Manager';

        $this->_aActionsMapping =  array(
            'view' => array('view'),
            'addview' => array('addview'),
            'add' => array('add', 'redirectToDefault'),
            'editview' => array('editview'),
            'edit' => array('edit', 'redirectToDefault'),  
            'delete' => array('delete', 'redirectToDefault'),
        );
    }

    function validate($req, &$input)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $this->validated    = true;
        $input->error       = array();        
        $input->masterTemplate = $this->masterTemplate;        
        $input->action      = ($req->get('action')) ? $req->get('action') : 'view';
        $input->pageTitle   = $this->pageTitle . ' :: ' . $input->action;
        $input->template    = $this->template;
        
        ################ Get input ###############
        $input->frmUsrID = $req->get('frmUsrID');
        $input->frmName = $req->get('frmName');        
        $input->frmEmail = $req->get('frmEmail');
        ################ End input ###############

        ################ Start validate ###############
        $aErrors = array();
        
        switch ($input->action) {
            case "add":
                $input->template    = 'exampleAdd.html';
                $this->_validateSample($input, &$aErrors);
                break;
            case "edit":
                $input->template    = 'exampleEdit.html';
                $this->_validateSample($input, &$aErrors);
                break;
            case "delete":
                $this->_validateSample($input, &$aErrors);
                break;
        }
        

        ################ End validate ###############
        
        //  if errors have occured
         if (count($aErrors) > 0) {
            Main::translate(SGL::raiseMsg('Validation Failed.'));
            $input->error = $aErrors;
            $this->validated = false;
        }
        
    }

    function display(&$output)
    {

    }

     function _cmd_view(&$input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $output->template = 'exampleView.html';
        $query = "
            SELECT
                *
            FROM {$this->conf['table']['example']}";
        $limit = 5;

        $pagerOptions = array(
            'mode'     => 'Sliding',
            'delta'    => 3,
            'perPage'  => $limit,
            'spacesBeforeSeparator' => 0,
            'spacesAfterSeparator'  => 0,
            'curPageSpanPre'        => '<span class="currentPage">',
            'curPageSpanPost'       => '</span>',
        );
        $aPagedData = SGL_DB::getPagedData($this->dbh, $query, $pagerOptions);

        $output->aPagedData = $aPagedData;
        if (is_array($aPagedData['data']) && count($aPagedData['data'])) {
            $output->pager = ($aPagedData['totalItems'] <= $limit) ? false : true;
        }
    }

    function _cmd_addview(&$input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $output->template    = 'exampleEdit.html';
        $output->frmAdd    = true;
    }
    
    function _cmd_add(&$input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        
        $usrId = $this->findNextId('usr_id',$this->conf['table']['example']);

        $query = "INSERT INTO `{$this->conf['table']['example']}` ( `usr_id` , `name` , `email` )
					VALUES ({$usrId},'{$input->frmName}','{$input->frmEmail}');";
        $res = $this->dbh->query($query);
    }

    function _cmd_editview(&$input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $output->template    = 'exampleEdit.html';
        $output->frmEdit    = true;
        
        $query = "
            SELECT
                usr_id, name, email
            FROM {$this->conf['table']['example']}
            WHERE usr_id={$input->frmUsrID};";
        
        $aTypeData = $this->dbh->getAll($query);
        $output->frmUsrId = $aTypeData[0]->usr_id;
        $output->frmName = $aTypeData[0]->name;
        $output->frmEmail = $aTypeData[0]->email;
        
    }
    
    function _cmd_edit(&$input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        
        $query = "UPDATE `{$this->conf['table']['example']}` SET 
						`usr_id` = '{$input->frmUsrID}',
						`name` = '{$input->frmName}',
						`email` = '{$input->frmEmail}' 
						WHERE `usr_id` =  {$input->frmUsrID} LIMIT 1 ";
        $this->dbh->query($query);
    }
    
    function _cmd_delete(&$input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
                 
       $query = "DELETE FROM {$this->conf['table']['example']}
						WHERE usr_id={$input->frmUsrID}
						";
       
        $this->dbh->query($query);
    }
    
    function findNextId($tableId = '', $tableName = '')
    {
        $query = "SELECT MAX( $tableId )
                        FROM $tableName";
        $id = $this->dbh->getOne($query);
        
        $id = $id ? $id : 0;
        return $id + 1;
    }

    function _validateSample($input, &$aErrors)
    {
/*        
        if (ERROR) {
            array_push($aErrors, SGL::Translate('dont have xxxxxxx'));
        }
*/        
        return true;
    }    
}
?>