<?php

/* Reminder: always indent with 4 spaces (no tabs). */
// +---------------------------------------------------------------------------+
// WebSite:  http://www.webexperts.co.th
// Unauthorized copying is strictly forbidden and may result in severe legal action.
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// 
// =====YOU MUST KEEP THIS COPYRIGHTS NOTICE INTACT AND CAN NOT BE REMOVE =======
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// This Agreement is a legal contract, which specifies the terms of the license
// and warranty limitation between you and Web Experts Co.,Ltd. and RV Site Builder.
// You should carefully read the following terms and conditions before
// installing or using this software.  Unless you have a different license
// agreement obtained from Web Experts Co.,Ltd., installation or use of this software
// indicates your acceptance of the license and warranty limitation terms
// contained in this Agreement. If you do not agree to the terms of this
// Agreement, promptly delete and destroy all copies of the Software.
//
// =====  Grant of License =======
// The Software may only be installed and used on a single host machine.
//
// =====  Disclaimer of Warranty =======
// THIS SOFTWARE AND ACCOMPANYING DOCUMENTATION ARE PROVIDED "AS IS" AND
// WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR ANY OTHER
// WARRANTIES WHETHER EXPRESSED OR IMPLIED.   BECAUSE OF THE VARIOUS HARDWARE
// AND SOFTWARE ENVIRONMENTS INTO WHICH RV SITE BUILDER MAY BE USED, NO WARRANTY OF
// FITNESS FOR A PARTICULAR PURPOSE IS OFFERED.  THE USER MUST ASSUME THE
// ENTIRE RISK OF USING THIS PROGRAM.  ANY LIABILITY OF Web Experts Co.,Ltd. WILL BE
// LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT OR REFUND OF PURCHASE PRICE.
// IN NO CASE SHALL Web Experts Co.,Ltd. BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
// CONSEQUENTIAL DAMAGES OR LOSS, INCLUDING, WITHOUT LIMITATION, LOST PROFITS
// OR THE INABILITY TO USE EQUIPMENT OR ACCESS DATA, WHETHER SUCH DAMAGES ARE
// BASED UPON A BREACH OF EXPRESS OR IMPLIED WARRANTIES, BREACH OF CONTRACT,
// NEGLIGENCE, STRICT TORT, OR ANY OTHER LEGAL THEORY. THIS IS TRUE EVEN IF
// Web Experts Co.,Ltd. IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. IN NO CASE WILL
// Web Experts Co.,Ltd.'S LIABILITY EXCEED THE AMOUNT OF THE LICENSE FEE ACTUALLY PAID
// BY LICENSEE TO Web Experts Co.,Ltd.

class Main 
{
    
    function Main()
    {

    }


    function verifyModules($moduleName)
    {
        $c = &SGL_Config::singleton();
        $conf = $c->getAll();   
        $dbh = & SGL_DB::singleton();        
        // Return true or false
        $query = "
            SELECT module_id
            FROM " . $conf['table']['module'] . "
            WHERE name = '{$moduleName}'
        ";
    
        $res = $dbh->getAll($query, DB_FETCHMODE_ASSOC);
        // If enable module and copy modules script status is true
        if (is_dir(SGL_MOD_DIR . '/' . $moduleName) && (count($res) > 0) && $this->isModuleSetupDb($moduleName)) {
            return true;
        } else {
            return false;
        }
    }
    
    function isModuleSetupDb($component) 
    {
        $c = &SGL_Config::singleton();
        $conf = $c->getAll();   
        $dbh = & SGL_DB::singleton();
           
        if ($component == 'smfweb') {
            $query = "
            SELECT ID_MEMBER
            FROM " . $conf['table']['smfweb_members'];
    
            $res = $dbh->getAll($query, DB_FETCHMODE_ASSOC);
            if (count($res)){
                return true;
            }        
        } elseif ($component == 'blogweb') {
            $query = "
            SELECT username
            FROM " . $conf['table']['serendipity_authors'];
    
            $res = $dbh->getAll($query, DB_FETCHMODE_ASSOC);
            if (count($res)){
                return true;
            }
        } elseif ($component == 'faqweb') {
            $query = "
            SELECT user_id
            FROM " . $conf['table']['faqweb_faquser'];
    
            $res = $dbh->getAll($query, DB_FETCHMODE_ASSOC);
            if (count($res)){
                return true;
            }
        } else {
            return true;
        
        }
        return false;
    }
    
    
    /**
     * Formats input so it can be safely used in a query avoid SQL injection
     * http://php.net/manual/en/security.database.sql-injection.php
     * 
     * This is similar to PEAR::DB_common::quoteSmart which locale independent
     * but only support MySQL and use mysql_real_escape_string to escape string.
     * 
     * @param mixed $value  the data to be formatted
     * @return mixed  the formatted data.  
     */
    function quoteSmart($value, $skipQuotes = false) 
    {
                
        if (is_int($value)) {
            $safeValue =  $value;                
        } elseif (is_float($value)) {
            $safeValue = $this->_quoteFloat($value);
        } elseif (is_bool($value)) {
            $safeValue = $this->_quoteBoolean($value);
        } elseif (is_null($value)) {
            $safeValue = 'NULL';
        } else {
           // if magic quotes are enabled, any slashes are removed by $req->get();
           // no logic needed to take care of it again.
           $safeValue = "'" . mysql_real_escape_string($value) . "'";
        } 
        
        if ($skipQuotes) {
            // เอา ' ออก
        }
        
        return $safeValue;
    }

    /**
     * Formats a float value for use within a query in a locale-independent
     * manner. 
     * 
     * Copied from PEAR::DB_common but only support MySQL
     *
     * @param float the float value to be quoted.
     * @return string the quoted string.
     * @see PEAR::DB_common::quoteBoolean() v 1.7.9
     */
    function _quoteFloat($float)
    {
        return "'" . mysql_real_escape_string(str_replace(',', '.', strval(floatval($float)))) . "'";
    }

    /**
     * Formats a boolean value for use within a query in a locale-independent
     * manner.
     *
     * Identical to PEAR::DB_common
     *    
     * @param boolean the boolean value to be quoted.
     * @return string the quoted string.
     * @see PEAR::DB_common::quoteBoolean() v 1.7.9
     */
    function _quoteBoolean($boolean)
    {
        return $boolean ? '1' : '0';
    }

    
    function jsAddSlashes($str)
    {
       $pattern = array(
           "/\\\\/"  , "/\n/"    , "/\r/"    , "/\"/"    ,
           "/\'/"    , "/&/"    , "/</"    , "/>/"
       );
       $replace = array(
           "\\\\\\\\", "\\n"    , "\\r"    , "\\\""    ,
           "\\'"    , "\\x26"  , "\\x3C"  , "\\x3E"
       );
       return preg_replace($pattern, $replace, $str);
    }
    
    /**
     * ทำหน้าที่ Map ภาษาของ Component ต่างๆ เรียกใช้โดย SGL > Task > Process
     * 
     * @param component the component name to find the language key
     * @param lang the current SGL language key
     * @return mixed $lang (ภาษาสำหรับ component) หรือ false ถ้าไม่พบภาษา
     */
    function languageMap($component, $lang)
    {
        if ($component == 'smfweb') {
                $aLangMap = array(
                    'en-iso-8859-15' => 'english',
                    'en-utf-8' => 'english',
                    'th-utf-8' => 'thai-utf8',
                );
                $resLang = array_key_exists($lang, $aLangMap) ? $aLangMap[$lang] : 'english';
                
        } elseif ($component == 'blogweb') {
                $aLangMap = array(
                    'en-iso-8859-15' => 'en',
                    'en-utf-8' => 'en',
                );
                $resLang = array_key_exists($lang, $aLangMap) ? $aLangMap[$lang] : 'en';
        } elseif ($component == 'faqweb') {
                $aLangMap = array(
                    'en-iso-8859-15' => 'en',
                    'en-utf-8' => 'en',
                    'th-utf-8' => 'th',
                );
                $resLang = array_key_exists($lang, $aLangMap) ? $aLangMap[$lang] : 'en';
                
        } else {
            return false;
        
        }
        
        return $resLang;
    }
    
    /**
     * create an archive of these files using the createFilesCompression() function
     * 
     * @param string $srcDir source directory for created
     * @param string $srcFolderName folder name for created
     * @param string $compress gz
     * 
     * @author apiruk boonruksa 20061204
     */
    function createFilesCompression($srcDir, $srcFolderName, $compress = "zip")
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);

        // ZIP
        if (file_exists($srcDir) && $srcFolderName && trim($compress) == "zip") {
            require_once SGL_LIB_PEAR_DIR . '/Archive/Zip.php';
            if ( !class_exists('Archive_Zip') ) {
                echo ("Archive_Zip class name invalid /Archive/Tar.php");
            }
            $obj = new Archive_Zip($srcFolderName . '.zip');
            
            
            $dh  = opendir($srcDir . '/' . $srcFolderName);
            while (false !== ($filename = readdir($dh))) {
                if ($filename == '.' || $filename == '..') {
                    continue; 
                }
                $files[] = $filename;
            }
            if ($obj->create($files)) {
                return 1;
            } else {
                return 0;
            }
            
        }
        return 0;

    }
 



}
?>