<?php

/* Reminder: always indent with 4 spaces (no tabs). */
// +---------------------------------------------------------------------------+
// WebSite:  http://www.webexperts.co.th
// Unauthorized copying is strictly forbidden and may result in severe legal action.
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// 
// =====YOU MUST KEEP THIS COPYRIGHTS NOTICE INTACT AND CAN NOT BE REMOVE =======
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// This Agreement is a legal contract, which specifies the terms of the license
// and warranty limitation between you and Web Experts Co.,Ltd. and RV Site Builder.
// You should carefully read the following terms and conditions before
// installing or using this software.  Unless you have a different license
// agreement obtained from Web Experts Co.,Ltd., installation or use of this software
// indicates your acceptance of the license and warranty limitation terms
// contained in this Agreement. If you do not agree to the terms of this
// Agreement, promptly delete and destroy all copies of the Software.
//
// =====  Grant of License =======
// The Software may only be installed and used on a single host machine.
//
// =====  Disclaimer of Warranty =======
// THIS SOFTWARE AND ACCOMPANYING DOCUMENTATION ARE PROVIDED "AS IS" AND
// WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR ANY OTHER
// WARRANTIES WHETHER EXPRESSED OR IMPLIED.   BECAUSE OF THE VARIOUS HARDWARE
// AND SOFTWARE ENVIRONMENTS INTO WHICH RV SITE BUILDER MAY BE USED, NO WARRANTY OF
// FITNESS FOR A PARTICULAR PURPOSE IS OFFERED.  THE USER MUST ASSUME THE
// ENTIRE RISK OF USING THIS PROGRAM.  ANY LIABILITY OF Web Experts Co.,Ltd. WILL BE
// LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT OR REFUND OF PURCHASE PRICE.
// IN NO CASE SHALL Web Experts Co.,Ltd. BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
// CONSEQUENTIAL DAMAGES OR LOSS, INCLUDING, WITHOUT LIMITATION, LOST PROFITS
// OR THE INABILITY TO USE EQUIPMENT OR ACCESS DATA, WHETHER SUCH DAMAGES ARE
// BASED UPON A BREACH OF EXPRESS OR IMPLIED WARRANTIES, BREACH OF CONTRACT,
// NEGLIGENCE, STRICT TORT, OR ANY OTHER LEGAL THEORY. THIS IS TRUE EVEN IF
// Web Experts Co.,Ltd. IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. IN NO CASE WILL
// Web Experts Co.,Ltd.'S LIABILITY EXCEED THE AMOUNT OF THE LICENSE FEE ACTUALLY PAID
// BY LICENSEE TO Web Experts Co.,Ltd.

class PublicMgr extends SGL_Manager
{
    function PublicMgr()
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        parent::SGL_Manager();

        $this->pageTitle   = 'Public';
        
        
        $this->_aActionsMapping =  array(
            'view'   => array('view'),
            'print'   => array('print'),
        );
    }

    function validate($req, &$input)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $this->validated    = true;
        $input->masterTemplate = $this->masterTemplate;
        
        $input->action = ($req->get('action')) ? $req->get('action') : 'view';
        $input->page = ($req->get('page')) ? $req->get('page') : '';
        
        if ($input->action == 'print') {
            $input->masterTemplate =  'masterBlank.html';
        }
        
        
        if ($this->_loadTemplate($input) === true) { 
            $input->pageTitle = $this->pageTitle . ' :: ' . $input->page;
            $input->template = $input->fullPage;
        } else {
            SGL::raiseError('Cannot find page file! ' . $input->page);
            $input->template =  'error.html';
            $input->pageTitle = 'Error :: ' . $input->page;
        }   
    }
    
    function display(&$output)
    {
       $output->addJavascriptFile('js/scriptaculous/lib/prototype.js');
       $output->addJavascriptFile('js/scriptaculous/src/effects.js');
       $output->addJavascriptFile('js/lightbox/lightbox.js');
       $output->addCssFile('js/lightbox/css/lightbox.css'); 
       
    }
    
    function _loadTemplate(&$input)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
//        $input->page = trim(strtolower($input->page));
        $input->fullPage = $input->page . '.html';

        $defaultTheme = 'rvtheme';

        if (isset($_SESSION['aPrefs']['theme'])) {
            $defaultTheme = $_SESSION['aPrefs']['theme'];
        }
        
        if (file_exists(SGL_THEME_DIR . '/' . $defaultTheme . '/main/' . $input->fullPage)) {
            return true;
        } elseif (file_exists(SGL_MOD_DIR . '/main/templates/' . $input->fullPage)) {
            return true;
        }
        return false;
    }
    
    function _cmd_view(&$input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $output->testTime = strftime("%b %d %Y %H:%M:%S", time());
    }
    
    function _cmd_print(&$input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        
    }
}
?>
