<?php

/*
 * prepare()
 * 
 * Validate:
 *      validate new
 *      check_referer($referers)
 *      check_recipient($CONF)  new
 *      check_banlist($banlist = array(), $email)
 *      formMailFilter($item)
 *      
 * 
 * Manage Content:
 *      buildMail() new
 *      parse_form($array, $sort = "")
 *      tranferHash($Hash)
 *      hostnameToFilename()
 * 
 * 
 * Action:
 *      mail_it($content, $subject, $email, $recipient)
 *      redirectToPage($redirect)
 *      javaRedirect($page)
 * 
 * 
 */

/**
 * @global VERSION <Jack's Formmail.php Version>
 * Default "5.0"
 */
define("VERSION", "5.0");

/**
 * @global SEPARATOR <field / value seperator>
 *
 * Default ": "
 */
define("SEPARATOR", ": ");

/**
 * @global NEWLINE <content newline>
 *
 * Default "\n"
 */
define( "NEWLINE" , "\n");

class WebFormMail
{
    function WebFormMail()
    {
        $this->aLang = array();
    }
    
    function prepare($aMailVars = array(), $aLangs) {
        /*
         * Assign Mail Variable
         * $bcc,$required,$name,$email,$EMAIL,$zip_code,$ZIP_CODE,$phone_no,$fax_no,$sort,$attachment,$attachment_name,$attachment_size,$attachment_type
         * $file,$file_name,$file_size,$path_to_file,$file2,$file2_name,$env_report,$ar_file,$redirect
         * $subject,$bgcolor,$text_color,$link_color,$vlink_color,$alink_color,$style_sheet,background,missing_fields_redirect
         */
        
        global $bcc,$required,$require,$name,$email,$EMAIL,$zip_code,$ZIP_CODE,$phone_no,$PHONE_NO,$fax_no,$FAX_NO,$sort,$attachment,$attachment_name,$attachment_size,$attachment_type,
        $file,$file_name,$file_size,$path_to_file,$file2,$file2_name,$env_report,$ar_file,$redirect,
        $subject,$bgcolor,$text_color,$link_color,$vlink_color,$alink_color,$style_sheet,$background,$missing_fields_redirect,
        $charset;

         $this->aLang = $aLangs;
        
        $bcc = '';

        $required = $aMailVars['required'];
        
        if ( isset ($aMailVars['require'])) {
            $require = $aMailVars['require'];
        }
        
        if ( isset ($aMailVars['name'])) {
            $name = $aMailVars['name'];
        }
        
        if ( isset($aMailVars['email'])) {
            $email = $aMailVars['email'];
        }
        
        if ( isset($aMailVars['EMAIL'])) {
            $EMAIL = $aMailVars['EMAIL'];
        }
        
        if ( isset($aMailVars['zip_code'])) {
            $zip_code = $aMailVars['zip_code'];
        }
        
        if ( isset($aMailVars['ZIP_CODE'])) {
            $ZIP_CODE = $aMailVars['ZIP_CODE'];
        }
        
        if ( isset($aMailVars['phone_no'])) {
            $phone_no = $aMailVars['phone_no'];
        }
        
        if ( isset($aMailVars['PHONE_NO'])) {
            $phone_no= $aMailVars['PHONE_NO'];
        }
        
        if ( isset($aMailVars['fax_no'])) {
            $fax_no = $aMailVars['fax_no'];
        }
        
        if ( isset($aMailVars['FAX_NO'])) {
            $FAX_NO = $aMailVars['FAX_NO'];
        }
        
        if ( isset($aMailVars['sort'])) {
            $sort = $aMailVars['sort'];
        }
        
        if ( isset($aMailVars['attachment'])) {
            $attachment = $aMailVars['attachment'];
        }
        
        if ( isset($aMailVars['attachment']['name'])) {
            $attachment_name = $aMailVars['attachment']['name'];
        }
        
        if ( isset($aMailVars['attachment']['size'])) {
            $attachment_size = $aMailVars['attachment']['size'];
        }
        
        if ( isset($aMailVars['attachment']['type'])) {
            $attachment_type = $aMailVars['attachment']['type'];
        }
        
        if ( isset($aMailVars['file'])) {
            $file = $aMailVars['file'];
        }
        
        if ( isset($aMailVars['file']['name'])) {
            $file_name = $aMailVars['file']['name'];
        }
        
        if ( isset($aMailVars['file_size'])) {
            $file_size = $aMailVars['file_size'];
        }
        
        if ( isset($aMailVars['path_to_file'])) {
            $path_to_file = $aMailVars['path_to_file'];
        }
        
        if ( isset($aMailVars['file2'])) {
            $file2 = $aMailVars['file2'];
        }
        
        if ( isset($aMailVars['file2']['name'])) {
            $file2_name = $aMailVars['file2']['name'];
        }
        
        if ( isset($aMailVars['file2_size'])) {
            $file2_size = $aMailVars['file2_size'];
        }
        
        if ( isset($aMailVars['env_report'])) {
            $env_report = $aMailVars['env_report'];
        }
        
        if ( isset($aMailVars['ar_file'])) {
            $ar_file = $aMailVars['ar_file'];
        }
        
        if ( isset($aMailVars['redirect'])) {
            $redirect = $aMailVars['redirect'];
        }
        
        if ( isset($aMailVars['subject']) ) {
            $subject = $aMailVars['subject'];
        }
        else if ( isset($CONF['subject']['msg']) ) {
            $subject = $CONF['subject']['msg'];
        }
        else {
            $subject = '';
        }
        
        if ( isset($aMailVars['title'])) {
            $title = $aMailVars['title'];
        }
        
        if ( isset($aMailVars['bgcolor'])) {
            $bgcolor = $aMailVars['bgcolor'];
        }
        else {
            $bgcolor = '';
        }
        
        if ( isset($aMailVars['text_color'])) {
            $text_color = $aMailVars['text_color'];
        }
        else {
            $text_color = '';
        }
        
        if ( isset($aMailVars['link_color'])) {
            $link_color = $aMailVars['link_color'];
        }
        else {
            $link_color = '';
        }
        
        if ( isset($aMailVars['vlink_color'])) {
            $vlink_color = $aMailVars['vlink_color'];
        }
        else {
            $vlink_color = '';
        }
        
        if ( isset($aMailVars['alink_color'])) {
            $alink_color = $aMailVars['alink_color'];
        }
        else {
            $alink_color = '';
        }
        
        if ( isset($aMailVars['style_sheet'])) {
            $style_sheet = $aMailVars['style_sheet'];
        }
        else {
            $style_sheet = '';
        }
        
        if ( isset($aMailVars['background'])) {
            $background = $aMailVars['background'];
        }
        else {
            $background = '';
        }
        
        if ( isset($aMailVars['missing_fields_redirect'])) {
            $missing_field_redirect = $aMailVars['missing_fields_redirect'];
        }
        else {
            $missing_field_redirect = '';
        }
        
        if ( isset($aMailVars['missing_fields_redirect'])) {
            $missing_fields_redirect = $aMailVars['missing_fields_redirect'];
        }
        else {
            $missing_fields_redirect = '';
        }
        
        if ( isset($aMailVars['charset'])) {
            $charset = $aMailVars['charset'];
        }
        
        /**
         * required : Required is an alias for require,
         *
         * @see require
         * @example
         * <input type=hidden name="required" value="email,phone_no">
         */
        if ( $required ) {
            $require = $required;
        }
    }
    
    function validate($aMailVars = array(), $CONF = array(), $request = array(), &$aErrors)
    {
        global $bcc,$required,$require,$name,$email,$EMAIL,$zip_code,$ZIP_CODE,$phone_no,$PHONE_NO,$fax_no,$FAX_NO,$sort,$attachment,$attachment_name,$attachment_size,$attachment_type,
        $file,$file_name,$file_size,$path_to_file,$file2,$file2_name,$env_report,$ar_file,$redirect,
        $subject,$bgcolor,$text_color,$link_color,$vlink_color,$alink_color,$style_sheet,$background,$missing_fields_redirect,$charset,$recipient;

          if (count($request) > 1) {
                $_GET = $request;
         }
        
        /**
         * bcc :This configuration allows you to specify to whom you wish for your form results to be Blind Carbon Copied to.
         *
         * This variables is disable.
         */
        
       
        /*
         * Validate 1
         */
        /**
         * recipient : This INI configuration allows you to specify to whom you wish for your form results to be mailed.
         *
         * @example
         * [recipient]
         * 1=yourEmail@yourDomail
         */
        if ( count($CONF['recipient']) > 0 ) {
            $recipient_in = $this->tranferHash($CONF['recipient']);
        
            for ($i=0; $i<count($recipient_in); $i++) {
                $recipient_to_test = trim($recipient_in[$i]);
        
                if ( !preg_match("/[0-9a-z]+@+[0-9a-z]/i", $recipient_to_test) ) {
                    $aErrors['recipient1'] ="<b>" . $this->aLang["I NEED VALID RECIPIENT EMAIL ADDRESS"] .  "($recipient_to_test) " . $this->aLang["TO CONTINUE</b>"];
                }
            }
        }
        else {
            $aErrors['recipient2'] = "<b>" . $this->aLang["I NEED VALID RECIPIENT EMAIL ADDRESS"] . "</b>";
        }
        
        $recipient = $this->tranferHash($CONF['recipient']);
        

        /*
         * Validate 2
         */        
        include(dirname(__FILE__) . '/fsbb.php');
        $rvblocker = new formSpamBotBlocker();
        
        // spambot
        $rvblocker->setTimeWindow(2,14400);
        $isnotSpamBot = $rvblocker->isnotSpamBot();
        if ($isnotSpamBot  == false) {
            $aErrors['rvblocker'] = "<b>" . $this->aLang["This was an INVALID submission. You have acted like a spambot!"] . "</b>";
        }
        // end spambot
        
        
        if ( count($CONF['referers']) > 0 ) {
            $referers = $this->tranferHash($CONF['referers']);
            if (!$this->check_referer($referers)) {
                $aErrors['referers'] = $this->aLang["You are coming from an <b>unauthorized domain.</b>"];
            }
        }
        
        /*
         * Validate 3
         */        
        
        /**
         * banlist : This INI configuration allows you to define the domains and emails that you would like banned from using your Formmail.php.
         *
         * @example
         * [banlist]
         * 1=*@somedomain.com
         * 2=user@domain.com
         * 3=etc@domains.com
         */
        if ( count($CONF['banlist']) > 0 ) {
            $banlist = $this->tranferHash($CONF['banlist']);
            if ($this->check_banlist($banlist, $email)) {
                $aErrors['banlist'] = $this->aLang["You are using from a <b>banned email address.</b>"];
            }
        }
        
        /*
         * Validate 4
         */
        
        /**
         * require : You can now require for certain fields in your form to be filled
         * in before the user can successfully submit the form.
         * Simply place all field names that you want to be mandatory into this field.
         * If the required fields are not filled in, the user will be notified of what they need to fill in,
         * and a link back to the form they just submitted will be provided.
         *
         * @example
         * <input type=hidden name="require" value="email,phone_no">
         */
        
        if ( isset($require) ) {
            $require = ereg_replace( " +", "", $require);
            $required = split(",",$require);
            $missing_field_list = '';
            for ($i=0;$i<count($required);$i++) {
                $string = trim($required[$i]);
                if ( !isset($string) || $string == '') continue;
                if ( (!($_REQUEST[$string]))  ) {
                    $missing_field_list .= "<b>" . $this->aLang["Missing:"] . " $required[$i]</b><br>\n";
                }
            }
            if ( isset($missing_field_list) && $missing_field_list <> '' ) {
                $aErrors['require'] = $missing_field_list;
            }
        }

        /*
         * Validate 5
         */
        
        /**
         * email : This form field will allow the user to specify their return e-mail address.
         * If you want to be able to return e-mail to your user,
         * I strongly suggest that you include this form field and allow them to fill it in.
         * This will be put into the From: field of the message you receive.
         * The email address submitted will be checked for validity.
         *
         * @example
         * <input type=text name="email">
         */
        
        if ( $email || $EMAIL) {
             
            $email = trim($email);
             
            if ( isset($EMAIL) && $EMAIL <> '') {
                $email = trim($EMAIL);
            }
            if (!eregi("^[_\.0-9a-z-]+@([0-9a-z][0-9a-z-]+\.)+[a-z]{2,6}$", $email)) {
                $aErrors['email'] = $this->aLang["your <b>email address"] . " ( $email )" . $this->aLang["</b> is invalid."];
            }
            $EMAIL = $email;
        }        

        /*
         * Validate 6
         */        
        
        /**
         * zip_code : This form field will allow the user to specify a zip code.
         * The zip code submitted will be checked for basic validity and
         * must match one of the following formats.
         *
         *      12345
         *      12345-1234
         *      A1B 2C3 (for candians :P)
         *
         * @example
         * <input type=text name="zip_code">
         */
        if ( $ZIP_CODE || $zip_code) {
            $zip_code = trim($zip_code);
            if ( isset($ZIP_CODE) && $ZIP_CODE <> '') {
                $zip_code = trim($ZIP_CODE);
            }
        
            if (
            !ereg("(^[0-9]{5})-([0-9]{4}$)", trim($zip_code)) &&
            (!ereg("^[a-zA-Z][0-9][a-zA-Z][[:space:]][0-9][a-zA-Z][0-9]$", trim($zip_code)))
            && (!ereg("(^[0-9]{5})", trim($zip_code)))
            ) {
                $aErrors['zip_code'] = $this->aLang["your <b>zip/postal code</b> is invalid"];
            }
        }        
        
        /*
         * Validate 7
         */          
        
        /**
         * phone_no : This form field will allow the user to specify a phone number.
         * The phone number submitted will be checked for validity and
         * must match one of the following formats.
         *
         *      123.123.1234
         *  123-123-1234
         *  (123)123.1234
         *  (123)123-1234
         *  etc..
         *
         * @example
         * <input type=text name="phone_no">
         */
        if ( $PHONE_NO || $phone_no) {
            $phone_no = trim($phone_no);
            if ( isset($PHONE_NO) && $PHONE_NO <> '') $phone_no = trim($PHONE_NO);
        
            if (!ereg("(^(.*)[0-9]{3})(.*)([0-9]{3})(.*)([0-9]{4}$)", $phone_no)) {
                $aErrors['zip_code'] = $this->aLang["your <b>phone number</b> is invalid"];
            }
        }        

        /*
         * Validate 8
         */              
        
        /**
         * fax_no : This form field will allow the user to specify a fax number.
         * The fax number submitted will be checked for validity and
         * must match one of the following formats.
         *
         *      123.123.1234
         *      123-123-1234
         *      (123)123.1234
         *      (123)123-1234
         *      etc..
         *
         * @example
         * <input type=text name="fax_no">
         */
        if ( $FAX_NO || $fax_no) {
            $fax_no = trim($fax_no);
            if ( isset($FAX_NO) && $FAX_NO <> '') $fax_no = trim($FAX_NO);
            if (!ereg("(^(.*)[0-9]{3})(.*)([0-9]{3})(.*)([0-9]{4}$)", $fax_no)) {
                $aErrors['zip_code'] = $this->aLang["your <b>fax number</b> is invalid"];
            }
        }        
    }
    
    function sendmail() {
        global $bcc,$required,$name,$email,$EMAIL,$zip_code,$ZIP_CODE,$phone_no,$fax_no,$sort,$attachment,$attachment_name,$attachment_size,$attachment_type,
        $file,$file_name,$file_size,$path_to_file,$file2,$file2_name,$env_report,$ar_file,$redirect,
        $subject,$bgcolor,$text_color,$link_color,$vlink_color,$alink_color,$style_sheet,$background,$missing_fields_redirect,$charset,$recipient;
        
        $content = $this->buildMail();
        $result = $this->mail_it($content, $subject, $email, $recipient);
        if ($result != 1) {
            return $result;
        }
        return 1;
    }
    
    function buildMail() {
        /**
         * sort : This field allows you to choose the order in which you wish
         * for your variables to appear in the email that Formmail.php generates.
         * You can choose to have the field sorted alphabetically or specify a set order
         * in which you want the fields to appear in your mail message.
         * By leaving this field out, the order will simply default to the order in which the browsers
         * sends the information to the script
         * (which is usually the exact same order as they appeared in the form.)
         * When sorting by a set order of fields,
         * you should include the phrase "order:" as the first part of your value for the sort field,
         * and then follow that with the field names you want to be listed in the email message,
         * separated by commas.
         *
         * @example To sort alphabetically:
         * <input type=hidden name="sort" value="alphabetic">
         * @example To sort by a set field order:
         * <input type=hidden name="sort" value="order:name1,name2,etc...">
         */

        global $bcc,$required,$name,$email,$EMAIL,$zip_code,$ZIP_CODE,$phone_no,$fax_no,$sort,$attachment,$attachment_name,$attachment_size,$attachment_type,
        $file,$file_name,$file_size,$path_to_file,$file2,$file2_name,$env_report,$ar_file,$redirect,
        $subject,$bgcolor,$text_color,$link_color,$vlink_color,$alink_color,$style_sheet,$background,$missing_fields_redirect,$charset;
        
        if ($sort == "alphabetic") {
            uksort($_POST, "strnatcasecmp");
        }
        else if (
        ereg('^order:.*,.*', $sort) &&
        $list = explode(',', ereg_replace('^order:', '', $sort)) ) {
            $sort = $list;
        }
        $countSpamMakeTag = 0;
         foreach ($_POST as $key => $val) {
            if ($countSpamMakeTag >3) {
                $aPost[$key] =  $val;
            }
            $countSpamMakeTag++;
         }
         
        $content = $this->parse_form($aPost, $sort);
        
        /**
         * attachment : Allows the user attach a file to the email sent by Formmail
         *
         * @example
         * <input type="hidden" name="MAX_FILE_SIZE" value="1000000">
         * <input type="file" name="attachment">
         */
        if ( isset($attachment_name) && $attachment_name <> '') {
            if ($attachment_size > 0) {
                if ( !isset($attachment_type)) $attachment_type =  "application/unknown";
                $content .= "Attached File: ". $attachment_name ."\n";
                $fp = fopen($attachment ,  "r");
                $attachment_chunk = fread($fp, filesize($attachment));
                $attachment_chunk = base64_encode($attachment_chunk);
                $attachment_chunk = chunk_split($attachment_chunk);
            }
        }
        
        /**
         * file : Allows the user to upload a file to a path of your specification.
         * NOTE :  If you are using the file option it is crucial to include
         * the ENCTYPE="multipart/form-data" in the form field.
         * <path_to_file> - This is the path which the file will be uploaded to.
         * Must be a direct path to your directory. ie: "/www/yourname/filedir/"
         * <MAX_FILE_SIZE> - (case sensitive) hidden field must precede the file
         * input field and it's value is the maximum filesize accepted. The value is in bytes.
         *
         * @example
         * <input type="hidden" name="MAX_FILE_SIZE" value="1000000">
         * <input type="hidden" name="path_to_file" value="/www/dir_where_file_goes/">
         * <input type="file" name="file">
         */
        if ( isset($file_name) && $file_name <> '') {
            if ( $file_size > 0) {
                if (!ereg("/$", $path_to_file)) {
                    $path_to_file = $path_to_file ."/";
                }
                $location = $path_to_file . $file_name;
                if (file_exists($path_to_file . $file_name)) {
                    $location = $path_to_file . rand(1000,3000).".". $file_name;
                }
                copy($file,$location);
                unlink($file);
                $content .= "Uploaded File: ".$location."\n";
            }
        }
        
        /**
         * file2 : I received a lot of email asking how to handle additional file uploads,
         * I added "file2" to show how easy it is: Keep the same syntax as above,
         * but append a "2" to the end of the file.
         * Advanced: to add addtional files copy the php functions (below) that handle
         * the file upload for file2 and and change the "2"s to a "3" or anything else.
         */
        if ( isset($file2_name) && $file2_name <> '') {
            if ($file_size > 0) {
                if (!ereg("/$", $path_to_file)) {
                    $path_to_file = $path_to_file . "/";
                }
                $location = $path_to_file.$file2_name;
                if (file_exists($path_to_file.$file2_name)) {
                    $location = $path_to_file . rand(1000,3000) . "." . $file2_name;
                }
                copy($file2, $location);
                unlink($file2);
                $content .= "Uploaded File: " . $location."\n";
            }
        }
        
        /**
         * env_report : Allows you to have Environment variables included in the e-mail message
         * you receive after a user has filled out your form.
         * Useful if you wish to know what browser they were using,
         * what domain they were coming from or any other attributes associated
         * with environment variables.
         * The following is a short list of valid environment variables that might be useful:
         * <REMOTE_HOST> - Sends the hostname making the request.
         * <REMOTE_ADDR> - Sends the IP address of the remote host making the request.
         * <HTTP_USER_AGENT> - The browser the client is using to send the request.
         *
         * @example If you wanted to find the remote host and browser sending the request,
         * you would put the following into your form:
         * <input type=hidden name="env_report" value="REMOTE_HOST, HTTP_USER_AGENT">
         *  Seperate by commas ",".
         */
        if ( isset($env_report) and $env_report <>'') {
            $env_report = ereg_replace( " +", "", $env_report);
            $env_reports = split(",",$env_report);
            $content .= "\n------ eviromental variables ------\n";
            for ($i=0;$i<count($env_reports);$i++) {
                $string = trim($env_reports[$i]);
                if ($env_reports[$i] == "REMOTE_HOST") {
                    $content .= "REMOTE HOST: ".$REMOTE_HOST."\n";
                }
                if ($env_reports[$i] == "REMOTE_USER") {
                    $content .= "REMOTE USER: ". $REMOTE_USER."\n";
                }
                if ($env_reports[$i] == "REMOTE_ADDR") {
                    $content .= "REMOTE ADDR: ". $REMOTE_ADDR."\n";
                }
                if ($env_reports[$i] == "HTTP_USER_AGENT") {
                    $content .= "BROWSER: ". $HTTP_USER_AGENT."\n";
                }
            }
        }
        return $content;
    }
    
    // mail the content we figure out in the following steps
    function mail_it($content, $subject, $email, $recipient)
    {
        global $attachment_chunk, $attachment_name, $attachment_type, $attachment_sent, $bcc,$charset;
    
        $ob = "----=_OuterBoundary_000";
        $ib = "----=_InnerBoundery_001";
    
        $charset = isset($charset) ? $charset : 'iso-8859-1';
         
        $headers  = "MIME-Version: 1.0\r\n";
        $headers .= "From: " . $this->formMailFilter($email) . "\n";
        
        $suhosin = ini_get('suhosin.mail.protect');
        /*
         * suhosin.mail.protect
         * This directive controls if the mail() header protection is activated or not and to what degree it is activated. 
         * The appended table lists the possible activation levels.
         * 
         *  0    mail() header protection is disabled
         *  1    Disallows newlines in Subject:, To: headers and double newlines in additional headers
         *  2    Additionally disallows To:, CC:, BCC: in additional headers
         */
        switch ($suhosin){
            case 1:
                break;
            case 2:
                break;
            default:
                $headers .= "To: " . $this->formMailFilter($recipient[0]) . "\n";
        }
        $headers .= "Reply-To: ". $this->formMailFilter($email) . "\n";
        if ($bcc) {
            //$headers .= "Bcc: " .    $email = formMailFilter($bcc) . "\n";
        }
        $headers .= "X-Mailer: DT Formmail". VERSION ."\n";
        $headers .= "Content-Type: multipart/mixed;\n\tboundary=\"".$ob."\"\n";
         
    
        $message  = "This is a multi-part message in MIME format.\n";
        $message .= "\n--".$ob."\n";
        $message .= "Content-Type: multipart/alternative;\n\tboundary=\"".$ib."\"\n\n";
        $message .= "\n--".$ib."\n";
        $message .= "Content-Type: text/plain;\n\tcharset=\"" . $this->formMailFilter($charset) . "\"\n";
        $message .= "Content-Transfer-Encoding: quoted-printable\n\n";
        $message .= $content . "\n\n";
        $message .= "\n--".$ib."--\n";
        if ($attachment_name && !$attachment_sent) {
            $message .= "\n--".$ob."\n";
            $message .= "Content-Type: " . $this->formMailFilter($attachment_type) . ";\n\tname=\"" . $this->formMailFilter($attachment_name) . "\"\n";
            $message .= "Content-Transfer-Encoding: base64\n";
            $message .= "Content-Disposition: attachment;\n\tfilename=\"" . $this->formMailFilter($attachment_name) . "\"\n\n";
            $message .= $attachment_chunk;
            $message .= "\n\n";
            $attachment_sent = 1;
        }
        $message .= "\n--".$ob."--\n";
             
        if(!mail($recipient[0], $subject, $message, $headers)) {
            $sendmailFalse = "<b>" . $this->aLang["Cannot connect to sendmail server"] .  ' ' . $this->aLang["Sending email from"] . ' ' . $email . ' ' . $this->aLang["to"] . ' ' . $recipient[0] . ' ' .  $this->aLang["failed"] . ".</b>";
            return $sendmailFalse;
        }
        return 1;    
    }

    function tranferHash($Hash)
    {
        $aValue = array();
        foreach ($Hash as $hashKey => $hashValue) {
            array_push($aValue,$hashValue);
        }
        return $aValue;
    }
    
    // function to check the referer for security reasons.
    // contributed by some one who's name got lost.. Thanks
    // goes out to him any way.
    function check_referer($referers)
    {

         
        if (count($referers)) {
            $found = false;
    
            $temp = explode("/",getenv("HTTP_REFERER"));
            $referer = $temp[2];
    
            if ($referer=="") {
                $referer = $_SERVER['HTTP_REFERER'];
                list($remove,$stuff)=split('//',$referer,2);
                list($home,$stuff)=split('/',$stuff,2);
                $referer = $home;
            }
    
            for ($x=0; $x < count($referers); $x++) {
                if (eregi ($referers[$x], $referer)) {
                    $found = true;
                }
            }
            if ($referer =="") $found = false;
            if (!$found) {
                return false;
            }
            return $found;
        }
        else{
            return true;
        }
    }

    // function to check the banlist
    // suggested by a whole lot of people.. Thanks
    function check_banlist($banlist = array(), $email)
    {

        $allow = true;
        if (count($banlist)) {
            foreach($banlist as $banned) {
                $temp = explode("@", $banned);
                if ($temp[0] == "*") {
                    $temp2 = explode("@", $email);
                    if ( trim(strtolower($temp2[1])) == trim(strtolower($temp[1])) ) {
                        $allow = false;
                    }
                }
                else {
                    if ( trim(strtolower($email)) == trim(strtolower($banned)) ) {
                        $allow = false;
                    }
                }
            }
        }
        if (!$allow) {
            return false;
        }
        return true;
    }    
    
// This function takes the sorts, excludes certain keys and
// makes a pretty content string.
    function parse_form($array, $sort = "")
    {
        // build reserved keyword array
        $reserved_keys[] = "MAX_FILE_SIZE";
        $reserved_keys[] = "required";
        $reserved_keys[] = "redirect";
        $reserved_keys[] = "require";
        $reserved_keys[] = "path_to_file";
        $reserved_keys[] = "recipient";
        $reserved_keys[] = "subject";
        $reserved_keys[] = "sort";
        $reserved_keys[] = "style_sheet";
        $reserved_keys[] = "bgcolor";
        $reserved_keys[] = "text_color";
        $reserved_keys[] = "link_color";
        $reserved_keys[] = "vlink_color";
        $reserved_keys[] = "alink_color";
        $reserved_keys[] = "title";
        $reserved_keys[] = "missing_fields_redirect";
        $reserved_keys[] = "missing_field_redirect";
        $reserved_keys[] = "env_report";
        $reserved_keys[] = "submit";
        $reserved_keys[] = "rvformid";
        $reserved_keys[] = "charset";
        $reserved_keys[] = "validated";
    
        $content ='';
        if (count($array)) {
            if (is_array($sort)) {
                foreach ($sort as $field) {
                    $reserved_violation = 0;
                    for ($ri=0; $ri<count($reserved_keys); $ri++)
                    if ($array[$field] == $reserved_keys[$ri]) $reserved_violation = 1;
    
                    if ($reserved_violation != 1) {
                        if (is_array($array[$field])) {
                            for ($z=0;$z<count($array[$field]);$z++)
                            $content .= $field.SEPARATOR.$array[$field][$z].NEWLINE;
                        } else
                        $content .= $field.SEPARATOR.$array[$field].NEWLINE;
                    }
                }
            }
    
            while (list($key, $val) = each($array)) {
                $reserved_violation = 0;
                for ($ri=0; $ri<count($reserved_keys); $ri++)
                if ($key == $reserved_keys[$ri]) $reserved_violation = 1;
    
                for ($ri=0; $ri<count($sort); $ri++)
                if (is_array($sort)) {
                    if ($key == $sort[$ri]) $reserved_violation = 1;
                }
    
                // prepare content
                if ($reserved_violation != 1) {
                    if (is_array($val)) {
                        for ($z=0;$z<count($val);$z++)
                        $content .= $key.SEPARATOR.$val[$z].NEWLINE;
                    } else
                    $content .= $key.SEPARATOR.$val.NEWLINE;
                }
            }
        }
        return $content;
    }    
    
    
/**
 * Filter input going to insert in email header
 *
 * Function to filter the variables to add in the email header.
 * Provide to protect unexpected arbitrary code.
 *
 * @author Pairote Manunphol <pairote@rvsitebuilder.com>
 * @license    http://www.opensource.org/licenses/bsd-license.php  New BSD License
 * @param string $item
 * @return $item if all test passed, redirect to error page if the spam sign detected
 **/    
    
    function formMailFilter($item)
    {

        $bad = 0;
    
        // remove the ending \n
        $item=ereg_replace("[\r\n]","",$item);
    
        // Check if there is the bcc: included in the string
        $bad = eregi('bcc:', $item)?1:0 ;
        $bad = eregi('cc:', $item)?1:0 ;
    
        // Check if there is Content-Type included in the string
        $bad = eregi('Content-Type', $item)?1:0 ;
    
        if ($bad) {
            //print_error("<b>" . $this->aLang["Spam mail detected."] .  $this->aLang["Your message never be sent."] .  $this->aLang["If you accidentally get this error, please contact us for the resolution."] ."</b>");
        }
        return $item;
    }
    
    
    /**
     * Determines the name of the INI file, based on the host name.
     *
     * If PHP is being run interactively (CLI) where no $_SERVER vars
     * are available, a default 'localhost' is supplied.
     *
     * @return  string  the name of the host
     */    
    
    function hostnameToFilename()
    {
        //  start with a default
        $hostName = 'localhost';
            // Determine the host name
            if (!empty($_SERVER['SERVER_NAME'])) {
                $hostName = $_SERVER['SERVER_NAME'];

            } elseif (!empty($_SERVER['HTTP_HOST'])) {
                //  do some spoof checking here, like
                //  if (gethostbyname($_SERVER['HTTP_HOST']) != $_SERVER['SERVER_ADDR'])
                $hostName = $_SERVER['HTTP_HOST'];
            } else {
                //  if neither of these variables are set
                //  we're going to have a hard time setting up
                die('Could not determine your server name');
            }
            // Determine if the port number needs to be added onto the end
            if (!empty($_SERVER['SERVER_PORT'])
                    && $_SERVER['SERVER_PORT'] != 80
                    && $_SERVER['SERVER_PORT'] != 443) {
                $hostName .= '_' . $_SERVER['SERVER_PORT'];
            }
        return $hostName;
    }    
    
/**
 * redirect : If you wish to redirect the user to a different URL,
 * rather than having them see the default response to the fill-out form,
 * you can use this hidden variable to send them to a pre-made HTML page
 * or as another form type to let the user decide.
 *
 * @example
 * <input type=hidden name="redirect" value="http://your.host.com/to/ file.html">
 */

    function redirectToPage($redirect)
    {

        if ($redirect) {
            header("Location: ".$redirect);
            exit;
        }
        else {
            echo $this->aLang["Thank you for your submission"] . "'\n";
            echo "<br><br>\n";
            echo "<small>" . $this->aLang["This form is powered by "] . "<a href=\"http://www.dtheatre.com/scripts/\">Jack's Formmail.php ".VERSION."!</a></small>\n\n";
            exit;
        }
    }
    
    function javaRedirect($page)
    {
        print "<script language=\"JavaScript\" type=\"text/JavaScript\">\n";
        print "<!--\n";
        print "location = '$page'; \n";
        print "//-->\n";
        print "</script>\n";
    }
    
    
}    

?>