<?php

/* Reminder: always indent with 4 spaces (no tabs). */
// +---------------------------------------------------------------------------+
// WebSite:  http://www.webexperts.co.th
// Unauthorized copying is strictly forbidden and may result in severe legal action.
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// 
// =====YOU MUST KEEP THIS COPYRIGHTS NOTICE INTACT AND CAN NOT BE REMOVE =======
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// This Agreement is a legal contract, which specifies the terms of the license
// and warranty limitation between you and Web Experts Co.,Ltd. and RV Site Builder.
// You should carefully read the following terms and conditions before
// installing or using this software.  Unless you have a different license
// agreement obtained from Web Experts Co.,Ltd., installation or use of this software
// indicates your acceptance of the license and warranty limitation terms
// contained in this Agreement. If you do not agree to the terms of this
// Agreement, promptly delete and destroy all copies of the Software.
//
// =====  Grant of License =======
// The Software may only be installed and used on a single host machine.
//
// =====  Disclaimer of Warranty =======
// THIS SOFTWARE AND ACCOMPANYING DOCUMENTATION ARE PROVIDED "AS IS" AND
// WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR ANY OTHER
// WARRANTIES WHETHER EXPRESSED OR IMPLIED.   BECAUSE OF THE VARIOUS HARDWARE
// AND SOFTWARE ENVIRONMENTS INTO WHICH RV SITE BUILDER MAY BE USED, NO WARRANTY OF
// FITNESS FOR A PARTICULAR PURPOSE IS OFFERED.  THE USER MUST ASSUME THE
// ENTIRE RISK OF USING THIS PROGRAM.  ANY LIABILITY OF Web Experts Co.,Ltd. WILL BE
// LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT OR REFUND OF PURCHASE PRICE.
// IN NO CASE SHALL Web Experts Co.,Ltd. BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
// CONSEQUENTIAL DAMAGES OR LOSS, INCLUDING, WITHOUT LIMITATION, LOST PROFITS
// OR THE INABILITY TO USE EQUIPMENT OR ACCESS DATA, WHETHER SUCH DAMAGES ARE
// BASED UPON A BREACH OF EXPRESS OR IMPLIED WARRANTIES, BREACH OF CONTRACT,
// NEGLIGENCE, STRICT TORT, OR ANY OTHER LEGAL THEORY. THIS IS TRUE EVEN IF
// Web Experts Co.,Ltd. IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. IN NO CASE WILL
// Web Experts Co.,Ltd.'S LIABILITY EXCEED THE AMOUNT OF THE LICENSE FEE ACTUALLY PAID
// BY LICENSEE TO Web Experts Co.,Ltd.

require_once 'DB/DataObject.php';

/**
 * WebFormMgr
 *
 * @package seagull
 * @author  RV Global Soft Team <bus@webexperts.co.th>
 */
class WebFormMgr extends SGL_Manager
{
    function WebFormMgr()
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        parent::SGL_Manager();

        $this->_aActionsMapping =  array(
            'view'          => array('view'),
            'send'          => array('send')
        );
    }

    function validate($req, &$input)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $this->validated    = true;
        $input->error       = array();
        $input->masterTemplate = $this->masterTemplate;
        $input->action      = ($req->get('action')) ? $req->get('action') : 'view';
        $input->pageTitle   = $this->pageTitle . ' :: ' . $input->action;
        $input->formError = $req->get('error');
        
        $input->name      = $req->get('name');
        $input->email      = $req->get('email');
        $input->subject      = $req->get('Subject');
        $input->message      = $req->get('message');
        $input->required      = $req->get('required');
        
        $input->redirect      = $req->get('redirect');
        $input->charset      = $req->get('charset');
        
        if ($req->get('submit')) {
            $input->action = 'send';
        }
        
        $input->page      = $req->get('page');
        
        include_once('WebFormMail.php');
        $this->oWebFormMail = new WebFormMail();

        $input->sendSuccess = $req->get('success');

        
        
        if ($this->_loadTemplate($input) === true) { 
            $input->pageTitle = $this->pageTitle . ' :: ' . $input->page;
            $input->template = $input->fullPage;
        } else {
            SGL::raiseError('Cannot find page file! ' . $input->page);
            $input->pageTitle = 'Error :: ' . $input->page;
            $input->template = 'formMail.html';
        }   
      
    ################ Start validate ###############
        $aErrors = array();
        
        switch ($input->action) {
            case "send":
                $this->_validateSend($input, &$aErrors);
                break;                
        }

        //  if errors have occured
         if (count($aErrors) > 0) {
            $input->error = $aErrors;
            
            SGL::raiseMsg(SGL_Output::translate('Validation Failed.') . '<br /><br />' . join('<br/>', $input->error),false);
            
            $this->validated = false;
        }        
    }
    
    function display(&$output)
    {
        include_once('fsbb.php');        
        $rvSpamBot = new formSpamBotBlocker();
        //$rvSpamBot->setTimeWindow(2,14400);
        $rvSpamBot->setTrap(true, "spambot");
        
        $output->spamBotTags = $rvSpamBot->makeTags();        
        $c = &SGL_Config::singleton();
        $conf = $c->getAll();    
        $output->redirectURL = $conf['site']['baseUrl'] . '/' . $conf['site']['frontScriptName'] . '/main/webform/action/view/success/send/';
        $output->currentCharset = SGL::getCurrentCharset();
    }

    function _cmd_view(&$input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);        
    }
    
    function _validateSend($input, &$aErrors)
    {
        
        $aMailVars['require'] = '';
        $aMailVars['name'] = isset($input->name) ? $input->name : '';
        $aMailVars['email'] = isset($input->email) ? $input->email : '';
        $aMailVars['subject'] = isset($input->subject) ? $input->subject : '';
        $aMailVars['required'] = isset($input->required) ? $input->required : '';
        
        $aMailVars['charset'] = isset($input->charset) ? $input->charset : '';
                
        $aMailVars['zip_code'] = '';
        $aMailVars['ZIP_CODE'] = '';
        $aMailVars['phone_no'] = '';
        $aMailVars['PHONE_NO'] = '';
        $aMailVars['fax_no'] = '';
        $aMailVars['FAX_NO'] = '';
        $aMailVars['sort'] = '';
        $aMailVars['attachment'] = '';
        $aMailVars['attachment']['name'] = '';
        $aMailVars['attachment']['size'] = '';
        $aMailVars['attachment']['type'] = '';
        $aMailVars['file'] = '';
        $aMailVars['file']['name'] = '';
        $aMailVars['file_size'] = '';
        $aMailVars['path_to_file'] = '';
        $aMailVars['file2'] = '';
        $aMailVars['file2']['name'] = '';
        $aMailVars['file2_size'] = '';
        $aMailVars['env_report'] = '';
        $aMailVars['ar_file'] = '';
        $aMailVars['redirect'] = '';
        
        $aMailVars['title'] = '';
        $aMailVars['bgcolor'] = '';
        $aMailVars['text_color'] = '';
        $aMailVars['link_color'] = '';
        $aMailVars['vlink_color'] = '';
        $aMailVars['alink_color'] = '';
        $aMailVars['style_sheet'] = '';
        $aMailVars['background'] = '';
        $aMailVars['missing_fields_redirect'] = '';
        
        
        $CONF = array();
        
        if (isset($this->conf['cookie']['name'])) {
    
            $CONF['recipient'] = Array();
            $CONF['recipient']['1'] = $this->conf['email']['support'];
        
            if (isset($CONF['referers']) === false) {
                $CONF['referers'] = Array();
                $CONF['referers']['1'] = 'localhost';
                $CONF['referers']['2'] = '127.0.0.1';
                $CONF['referers']['2'] = $this->oWebFormMail->hostnameToFilename();
                $CONF['referers']['3'] = 'www.' . $CONF['referers']['2'];
            }
        
            if (isset($CONF['banlist']) === false) {
                $CONF['banlist'] = Array();
            }
        }
        $aLangs = $GLOBALS['_SGL']['TRANSLATION'];
        $this->oWebFormMail->prepare($aMailVars, $aLangs);
        $aErrors = array();
        
        /*
         * SGL not have $_GET or $_POST
         */
        $this->request = $input->aProps['request']->aProps;

        $this->oWebFormMail->validate($aMailVars, $CONF, $this->request, &$aErrors);
        return true;
    }
    
    function _cmd_send(&$input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $subject = $input->subject;
        $content = $this->oWebFormMail->buildMail();
        $currentTime = time();
        
        $result = $this->oWebFormMail->sendmail();
        if ($result != 1){
            SGL::raiseMsg($result, false);    
        } else {
            $this->logMail($subject, $content, $currentTime);
            $this->oWebFormMail->redirectToPage($input->redirect);
        }
        
    }
    
    function logMail($subject = '', $content = '', $currentTime= '')
    {
        $mailID = $this->dbh->nextId($this->conf['table']['formmail_log']);
        $query = sprintf("
            INSERT INTO {$this->conf['table']['formmail_log']} ( `mail_id` , `subject` , `message` , `date` )
            VALUES (
                '%s', '%s', '%s', '%s'
            );
        ", $mailID, $subject, $content, $currentTime);
        $this->dbh->query($query);
        return 1;
    }
    
    function _loadTemplate(&$input)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
//        $input->page = trim(strtolower($input->page));
        $input->fullPage = $input->page . '.html';

        $defaultTheme = 'rvtheme';

        if (isset($_SESSION['aPrefs']['theme'])) {
            $defaultTheme = $_SESSION['aPrefs']['theme'];
        }
        
        if (file_exists(SGL_THEME_DIR . '/' . $defaultTheme .'/main/' . $input->fullPage)) {
            return true;
        } else if (file_exists(SGL_MOD_DIR . '/main/templates/' . $input->fullPage)) {
            return true;
        }
        return false;
    }
    
}
?>
