<?php

/* Reminder: always indent with 4 spaces (no tabs). */
// +---------------------------------------------------------------------------+
// WebSite:  http://www.webexperts.co.th
// Unauthorized copying is strictly forbidden and may result in severe legal action.
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// 
// =====YOU MUST KEEP THIS COPYRIGHTS NOTICE INTACT AND CAN NOT BE REMOVE =======
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// This Agreement is a legal contract, which specifies the terms of the license
// and warranty limitation between you and Web Experts Co.,Ltd. and RV Site Builder.
// You should carefully read the following terms and conditions before
// installing or using this software.  Unless you have a different license
// agreement obtained from Web Experts Co.,Ltd., installation or use of this software
// indicates your acceptance of the license and warranty limitation terms
// contained in this Agreement. If you do not agree to the terms of this
// Agreement, promptly delete and destroy all copies of the Software.
//
// =====  Grant of License =======
// The Software may only be installed and used on a single host machine.
//
// =====  Disclaimer of Warranty =======
// THIS SOFTWARE AND ACCOMPANYING DOCUMENTATION ARE PROVIDED "AS IS" AND
// WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR ANY OTHER
// WARRANTIES WHETHER EXPRESSED OR IMPLIED.   BECAUSE OF THE VARIOUS HARDWARE
// AND SOFTWARE ENVIRONMENTS INTO WHICH RV SITE BUILDER MAY BE USED, NO WARRANTY OF
// FITNESS FOR A PARTICULAR PURPOSE IS OFFERED.  THE USER MUST ASSUME THE
// ENTIRE RISK OF USING THIS PROGRAM.  ANY LIABILITY OF Web Experts Co.,Ltd. WILL BE
// LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT OR REFUND OF PURCHASE PRICE.
// IN NO CASE SHALL Web Experts Co.,Ltd. BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
// CONSEQUENTIAL DAMAGES OR LOSS, INCLUDING, WITHOUT LIMITATION, LOST PROFITS
// OR THE INABILITY TO USE EQUIPMENT OR ACCESS DATA, WHETHER SUCH DAMAGES ARE
// BASED UPON A BREACH OF EXPRESS OR IMPLIED WARRANTIES, BREACH OF CONTRACT,
// NEGLIGENCE, STRICT TORT, OR ANY OTHER LEGAL THEORY. THIS IS TRUE EVEN IF
// Web Experts Co.,Ltd. IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. IN NO CASE WILL
// Web Experts Co.,Ltd.'S LIABILITY EXCEED THE AMOUNT OF THE LICENSE FEE ACTUALLY PAID
// BY LICENSEE TO Web Experts Co.,Ltd.

require_once dirname(__FILE__) . '/../classes/AdminArticleTypeWebMgr.php';
require_once dirname(__FILE__) . '/../../main/classes/Main.php';

class AdminArticleTypeWebMgrTest extends UnitTestCase
{
    
    function AdminArticleTypeWebMgrTest()
    {        
        $this->UnitTestCase('AdminArticleTypeWebMgrTest Tests');
        $c = &SGL_Config::singleton();
        $this->conf = $c->ensureModuleConfigLoaded('article');
    }

    function setup()
    {                    
        $sqlTask = new SGL_Task_SyncSequences();
        $sqlTask->run();
    }

    function teardown()
    {
    }
    
    function test_cmd_view()
    {

    }
    
    function test_cmd_addview()
    {
        
        
        $oTest = new AdminArticleTypeWebMgr();
        $input = new stdClass();
        $output = new stdClass();
        
        $oTest->_cmd_addview($input, $output);
        
        $this->assertIsA($output->frmTypeLang, 'array');
        $this->assertIsA($output->aRoles, 'array');
        
    }
    
    function test_cmd_add()
    {
        $oTest = new AdminArticleTypeWebMgr();
        $input = new stdClass();
        $output = new stdClass();
        
                
        // Add record using function from Mgr
        $input->assetFileName = '4465464.gif';
        $input->assetFileTmpName = 'd78973f1g1er84.gif';
        $input->iconWidth = 32;
        $input->iconHeigh = 32;
        
        $input->frmAutoResizeIcon = true;
        
        $input->frmPerms = array(1, 2);
        $input->frmTypeLang = array ( 
                                            '1' => array ( 
                                                'name' => 'Type1(eng)', 
                                                'description' => 'Description1(eng)' 
                                            ),
                                            '2' => array ( 
                                                'name' => 'Type2(thai)', 
                                                'description' => 'Description2(thai)' 
                                            ) 
                                            ); 
        $oTest->_cmd_add($input, $output);
        
        $query = "SELECT *
						FROM {$this->conf['table']['article_type']}
						WHERE 1
						";
        $result = $oTest->dbh->getRow($query);
        $this->assertNotEqual($result->type_icon, '4465464.gif');
        
        $query = "SELECT *
						FROM {$this->conf['table']['article_type_role']}
						WHERE 1
						";
        $result = $oTest->dbh->getAll($query);
        $this->assertEqual($result[1]->role_id, 2);
        
        $query = "SELECT *
						FROM {$this->conf['table']['article_type_message']}
						WHERE article_type_id=1 AND article_lang_id=2
						";
        $result = $oTest->dbh->getRow($query);

        $this->assertEqual($result->type_name, 'Type2(thai)');
        
        // Delete record using function from Mgr
        $input->frmDelete[0] = 1;
        $oTest->_cmd_delete($input, $output);
    }
    
    function test_cmd_editview()
    {

    }
    
    function test_cmd_edit()
    {
        $oTest = new AdminArticleTypeWebMgr();
        $input = new stdClass();
        $output = new stdClass();
        
                
        // Add record using function from Mgr
        $input->assetFileName = '4465464.gif';
        $input->assetFileTmpName = 'd78973f1g1er84.gif';
        $input->frmTypeIcon = '';
        $input->frmAutoResizeIcon = true;
        $input->iconWidth = 32;
        $input->iconHeigh = 32;

        $input->frmPerms = array(1, 2);
        $input->frmTypeLang = array ( 
                                                       '1' => array ( 
                                                                           'name' => 'Type1(eng)', 
                                                                           'description' => 'Description1(eng)' 
                                                                           ),
                                                       '2' => array ( 
                                                                          'name' => 'Type2(thai)', 
                                                                          'description' => 'Description2(thai)'
                                                                          )
                                                     ); 
        $oTest->_cmd_add($input, $output);
        
        $query = "SELECT *
						FROM {$this->conf['table']['article_type']}
						WHERE 1
						";
        $result = $oTest->dbh->getRow($query);
        $firstIcon = $result->type_icon;
        
        // Edit
        $input->frmTypeID = 1;
        $input->assetFileName = '9999999.gif';
        
        $input->frmPerms = array(0,2);
        $input->frmTypeLang = array ( 
                                                        '1' => array (             
                                                                           'name' => 'Type1(eng) edit',  
                                                                           'description' => 'Description1(eng) edit'
                                                                           ),
                                                        '2' => array (
                                                                          'name' => 'Type2(thai) edit',
                                                                          'description' => 'Description2(thai) edit'
                                                                           )
                                                      );
        $oTest->_cmd_edit($input, $output);
        
        $query = "SELECT *
						FROM {$this->conf['table']['article_type']}
						WHERE 1
						";
        $result = $oTest->dbh->getRow($query);
        $this->assertNotEqual($result->type_icon, $firstIcon);
        
        $query = "SELECT *
						FROM {$this->conf['table']['article_type_role']}
						WHERE article_type_id=1 AND role_id=0
						";
        $result = $oTest->dbh->getAll($query);
        $this->assertEqual($result[0]->role_id, 0);

        $query = "SELECT *
						FROM {$this->conf['table']['article_type_message']}
						WHERE article_type_id=1 AND article_lang_id=2
						";
        $result = $oTest->dbh->getRow($query);
        $this->assertEqual($result->type_name, 'Type2(thai) edit');
        
          // Delete record using function from Mgr
        $input->frmDelete[0] = 1;
        $oTest->_cmd_delete($input, $output);        
    }
    
    function test_cmd_delete()
    {
        $oTest = new AdminArticleTypeWebMgr();
        $input = new stdClass();
        $output = new stdClass();
        
                
        // Add record using function from Mgr
        $input->assetFileName = '4465464.gif';
        $input->assetFileTmpName = 'd78973f1g1er84.gif';
        $input->iconWidth = 32;
        $input->iconHeigh = 32;
        $input->frmAutoResizeIcon = true;
        $input->frmPerms = array(1, 2);
        $input->frmTypeLang = array ( 
                                                       '1' => array ( 
                                                                           'name' => 'Type1(eng)',
                                                                           'description' => 'Description1(eng)'
                                                                           ),
                                                       '2' => array (
                                                                          'name' => 'Type2(thai)',
                                                                          'description' => 'Description2(thai)'
                                                                           )
                                                    );
        $oTest->_cmd_add($input, $output);
        
        // Delete record using function from Mgr
        $input->frmDelete[0] = 1;
        $oTest->_cmd_delete($input, $output);

        $query = "SELECT *
						FROM {$this->conf['table']['article_type']}
						WHERE 1
						";
        $result = $oTest->dbh->getRow($query);
        $this->assertNull($result);
        
        $query = "SELECT *
						FROM {$this->conf['table']['article_type_role']}
						WHERE 1
						";
        $result = $oTest->dbh->getAll($query);
        $this->assertTrue(empty($result));

        $query = "SELECT *
						FROM {$this->conf['table']['article_type_message']}
						WHERE article_type_id=1 AND article_lang_id=2
						";
        $result = $oTest->dbh->getRow($query);
        $this->assertNull($result);
    }
    
}    
    
?>    