<?php

/* Reminder: always indent with 4 spaces (no tabs). */
// +---------------------------------------------------------------------------+
// WebSite:  http://www.webexperts.co.th
// Unauthorized copying is strictly forbidden and may result in severe legal action.
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// 
// =====YOU MUST KEEP THIS COPYRIGHTS NOTICE INTACT AND CAN NOT BE REMOVE =======
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// This Agreement is a legal contract, which specifies the terms of the license
// and warranty limitation between you and Web Experts Co.,Ltd. and RV Site Builder.
// You should carefully read the following terms and conditions before
// installing or using this software.  Unless you have a different license
// agreement obtained from Web Experts Co.,Ltd., installation or use of this software
// indicates your acceptance of the license and warranty limitation terms
// contained in this Agreement. If you do not agree to the terms of this
// Agreement, promptly delete and destroy all copies of the Software.
//
// =====  Grant of License =======
// The Software may only be installed and used on a single host machine.
//
// =====  Disclaimer of Warranty =======
// THIS SOFTWARE AND ACCOMPANYING DOCUMENTATION ARE PROVIDED "AS IS" AND
// WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR ANY OTHER
// WARRANTIES WHETHER EXPRESSED OR IMPLIED.   BECAUSE OF THE VARIOUS HARDWARE
// AND SOFTWARE ENVIRONMENTS INTO WHICH RV SITE BUILDER MAY BE USED, NO WARRANTY OF
// FITNESS FOR A PARTICULAR PURPOSE IS OFFERED.  THE USER MUST ASSUME THE
// ENTIRE RISK OF USING THIS PROGRAM.  ANY LIABILITY OF Web Experts Co.,Ltd. WILL BE
// LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT OR REFUND OF PURCHASE PRICE.
// IN NO CASE SHALL Web Experts Co.,Ltd. BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
// CONSEQUENTIAL DAMAGES OR LOSS, INCLUDING, WITHOUT LIMITATION, LOST PROFITS
// OR THE INABILITY TO USE EQUIPMENT OR ACCESS DATA, WHETHER SUCH DAMAGES ARE
// BASED UPON A BREACH OF EXPRESS OR IMPLIED WARRANTIES, BREACH OF CONTRACT,
// NEGLIGENCE, STRICT TORT, OR ANY OTHER LEGAL THEORY. THIS IS TRUE EVEN IF
// Web Experts Co.,Ltd. IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. IN NO CASE WILL
// Web Experts Co.,Ltd.'S LIABILITY EXCEED THE AMOUNT OF THE LICENSE FEE ACTUALLY PAID
// BY LICENSEE TO Web Experts Co.,Ltd.

require_once dirname(__FILE__) . '/../classes/AdminArticleWebMgr.php';
require_once dirname(__FILE__) . '/../../main/classes/Main.php';

class AdminArticleWebMgrTest extends UnitTestCase
{
    function AdminArticleWebMgrTest()
    {
        $this->UnitTestCase('AdminArticleWebMgr Tests');
        $c = &SGL_Config::singleton();
        $blockConf->conf = $c->ensureModuleConfigLoaded('articleweb');
    }

    function setup()
    {
        $oTest = new AdminArticleWebMgr();
        $sql = "INSERT INTO `article_type_message` ( `article_type_message_id` , `article_type_id` , `web_lang_id` , `type_name` , `description` )
                    VALUES ('1', '1', '2', 'type_name 1', 'description type_name 1')";
        $oTest->dbh->query($sql);
        
        $sql = "INSERT INTO `article_type` ( `article_type_id` , `type_icon` )
                    VALUES ('1', '11111111111111.jpg')";
        $oTest->dbh->query($sql);
        
        $sql = "INSERT INTO `article_message` ( `article_message_id` , `web_lang_id` , `article_id` , `title` , `message` )
                    VALUES ('1', '2', '1', 'title article_message_id 1', 'message title article_message_id 1')";
        $oTest->dbh->query($sql);
        
        $sql = "INSERT INTO `article` ( `article_id` , `article_type_id` , `date_start` , `date_end` , `article_icon` , `skip_default_lang` , `publish` , `never_expired`, `user_id` )
                    VALUES ('1', '1', '1102012113', '1021012321', 'test.gif', '1' , '1' , '1' , '1')";
        $oTest->dbh->query($sql);
        
        $sql = "INSERT INTO `article_role` ( `article_id` , `role_id`)
                    VALUES ('1', '1')";
        $oTest->dbh->query($sql);
        
        $sql = "INSERT INTO `article_role` ( `article_id` , `role_id`)
                    VALUES ('1', '2')";
        $oTest->dbh->query($sql);
        
        $sql = "INSERT INTO `article_type_role` ( `article_type_id` , `role_id`)
                    VALUES ('1', '1')";
        $oTest->dbh->query($sql);
        
        $sql = "INSERT INTO `article_type_role` ( `article_type_id` , `role_id`)
                    VALUES ('1', '2')";
        $oTest->dbh->query($sql);

        $sqlTask = new SGL_Task_SyncSequences();
        $sqlTask->run();
    }

    function teardown()
    {
        $oTest = new AdminArticleWebMgr();
        $sql = "DELETE FROM article_type_message WHERE article_type_message_id = '1'";
        $oTest->dbh->query($sql);
        
        $sql = "DELETE FROM article_type WHERE article_type_id = '1'";
        $oTest->dbh->query($sql);
        
        $sql = "DELETE FROM article_message WHERE article_message_id = '1'";
        $oTest->dbh->query($sql);
        
        $sql = "DELETE FROM article WHERE article_id = '1'";
        $oTest->dbh->query($sql);
        
        $sql = "DELETE FROM article_role WHERE role_id = '1'";
        $oTest->dbh->query($sql);
        
        $sql = "DELETE FROM article_role WHERE role_id = '2'";
        $oTest->dbh->query($sql);
        
        $sql = "DELETE FROM article_type_role WHERE role_id = '1'";
        $oTest->dbh->query($sql);
        
        $sql = "DELETE FROM article_type_role WHERE role_id = '2'";
        $oTest->dbh->query($sql);
    }
    
    function teardownDB(&$sql)
    {
        $oTest = new AdminArticleWebMgr();
        $oTest->dbh->query($sql);
    }
    
    function _tableProjectInfoSelect($table,$id,$and = '')
    {
        $oTest = new AdminArticleWebMgr();
        $query = "SELECT
                                    *
                        FROM
                                   " . $table . "
                        WHERE
                                   $id $and ";
        $res = $oTest->dbh->getRow($query);
        return $res;
    }
    
    function test_cmd_view()
    {
        $oTest = new AdminArticleWebMgr();
        $input = new stdClass();
        $output = new stdClass();
        /*
        $dataStart = "1102012113";
        $dataEnd = "1021012321";

        $oTest->_cmd_view($input, $output);
        $countData = count($output->aPagedData['data']);

        $this->assertNotNull($countData);
        $this->assertEqual($output->aPagedData['data'][0]['date_start'], $dataStart);
        $this->assertEqual($output->aPagedData['data'][0]['date_end'], $dataEnd);
        $this->assertEqual($output->aPagedData['data'][0]['web_lang_id'], 2);
        $this->assertEqual($output->aPagedData['data'][0]['perm'], "root,member");
        $this->assertEqual($output->typeIdSelect[0]->web_lang_id, '2');
        $this->assertEqual($output->typeIdSelect[0]->article_type_id, '1');
        */
    }

    function test_cmd_addview()
    {
        $oTest = new AdminArticleWebMgr();
        $input = new stdClass();
        $output = new stdClass();

        $input->frmAdd['articleTypeId'] = "1";

        $oTest->_cmd_addview($input, $output);
        $countRoles = count($output->aRoles);

        $this->assertEqual($output->articleAdd, 'add');
        $this->assertEqual($output->articleTypeId, '1');
        $this->assertEqual($output->template, 'articleAdd.html');
        $this->assertNotNull($output->typeName);
        $this->assertEqual(count($output->aRoles), '2');
        $this->assertEqual($output->aRoles[2], 'member');
        $this->assertEqual($countRoles,2);
    }
    
    function test_cmd_add()
    {
        $oTest = new AdminArticleWebMgr();
        $input = new stdClass();
        $output = new stdClass();

        $input->frmAutoResizeIcon = '1';
        $input->assetFileName = 'a.jpg';
        $input->assetFileTmpName = '10c1fn3w6f5f5s4da266038e4d243b9d';
        $input->iconWidth = 32;
        $input->iconHeight = 32;
        $input->frmAdd = array(
                                    'dateStart' => '2007-08-07 09:58:05',
                                    'dateEnd' => '2007-08-25 09:58:05',
                                    'articleTypeId' => '1',
                                    'neverExpired' => '0',
                                    'defaultLang' => '1',
                                    'publish' => '1',
                                    'author' => '1'
                                    );

        $input->frmData = array(
                                            '1' => array(
                                                                'subject' => 'Test add Or create SubJect Font for Lang Eng',
                                                                'textData' => 'Test add TextData For Create New Article For Lang Eng',
                                                            ),
                                            '2' => array(
                                                                'subject' => 'test test test thai ทดสอบภาษาไทย',
                                                                'textData' => 'test test test thai ทดสอบภาษาไทย for Article',
                                                            )
                                    );
        $input->frmPerms = array(
                                            '0' => '1',
                                            '1' => '2',
                                    );

        $checkAddData = $oTest->_cmd_add($input, $output);

        $sql = "SELECT * FROM `article` LIMIT 0 , 30";
        $selectData = $oTest->dbh->getAll($sql , DB_FETCHMODE_ASSOC);
        $exDateStart =  strftime("%Y-%m-%d %H:%i:%s",$selectData[1]['date_start']);

        $this->assertTrue($checkAddData);
        $this->assertEqual($selectData[1]['publish'],'1');
        $this->assertEqual($selectData[1]['never_expired'], '0');
        $this->assertEqual($selectData[1]['article_type_id'], '1');
        $this->assertEqual($exDateStart,$input->frmAdd['dateStart']);
        
        $sql = "DELETE FROM `article` WHERE `article_icon` = 'a.jpg'";
        $this->teardownDB($sql);
    }
    
    function test_cmd_editview()
    {
        $oTest = new AdminArticleWebMgr();
        $input = new stdClass();
        $output = new stdClass();
        $input->frmEditArticleID = '2';
        
        $sql = "INSERT INTO `role` ( `role_id` , `name` , `description` , `date_created` , `created_by` , `last_updated` , `updated_by` )
                    VALUES ('2', 'member' , '' , '' , '' , '' , '')";
        $oTest->dbh->query($sql);
        
        $sql = "INSERT INTO `role` ( `role_id` , `name` , `description` , `date_created` , `created_by` , `last_updated` , `updated_by` )
                    VALUES ('1', 'root' , '' , '' , '' , '' , '')";
        $oTest->dbh->query($sql);
        
        $sql = "INSERT INTO `article_role` ( `article_id` , `role_id`)
                    VALUES ('2', '1')";
        $oTest->dbh->query($sql);
        
        $sql = "INSERT INTO `article_role` ( `article_id` , `role_id`)
                    VALUES ('2', '2')";
        $oTest->dbh->query($sql);
        
        $checkEditData = $oTest->_cmd_editview($input, $output);
        
        $sql = "DELETE FROM `role` WHERE `role_id` = '1'";
        $this->teardownDB($sql);
        
        $sql = "DELETE FROM `role` WHERE `role_id` = '2'";
        $this->teardownDB($sql);

        $sql = "DELETE FROM `article_role` WHERE `role_id` = '1'";
        $this->teardownDB($sql);
        
        $sql = "DELETE FROM `article_role` WHERE `role_id` = '2'";
        $this->teardownDB($sql);
    }
    
    function test_cmd_edit()
    {
        $oTest = new AdminArticleWebMgr();
        $input = new stdClass();
        $output = new stdClass();
        // insert into data simpletest for test edit data
        $sql = "INSERT INTO `article_role` ( `article_id` , `role_id`)
                    VALUES ('2', '1')";
        $oTest->dbh->query($sql);
        
        $sql = "INSERT INTO `article_message` ( `article_message_id` , `web_lang_id` , `article_id` , `title` , `message` )
                    VALUES ('3', '2', '2', 'title article_message_id 1', 'message title article_message_id 1')";
        $oTest->dbh->query($sql);
        
        $sql = "INSERT INTO `article` ( `article_id` , `article_type_id` , `date_start` , `date_end` , `article_icon` , `skip_default_lang` , `publish` , `never_expired` , `user_id`)
                    VALUES ('2', '1', '1102523113', '1021524321', 'test.gif', '0' , '0' , '0' , '1')";
        $oTest->dbh->query($sql);

        $input->frmAutoResizeIcon = '1';
        $input->assetFileName = 'abc.jpg';
        $input->assetFileTmpName = '';
        $input->frmEdit = array ( 
                                    'articleId' => '2' ,
                                    'iconArticle' => 'abc.jpg'
                                        );

        $input->frmAdd = array(
                                    'dateStart' => '2007-07-07 09:58:05',
                                    'dateEnd' => '2007-09-25 09:58:05',
                                    'articleTypeId' => '1',
                                    'neverExpired' => '1',
                                    'defaultLang' => '1',
                                    'publish' => '1'
                                    );

        $input->frmData = array(
                                            '1' => array(
                                                                'subject' => 'Test add Or create SubJect Font for Lang Eng',
                                                                'textData' => 'Test add TextData For Create New Article For Lang Eng'
                                                                
                                                            ),
                                            '2' => array(
                                                                'subject' => 'test',
                                                                'textData' => 'test thai article'
                                                            )
                                    );
        $input->frmPerms = array(
                                            '0' => '1',
                                            '1' => '2',
                                    );
                                    
        $oTest->_cmd_edit($input, $output);
        
        $aRetData =  $this->_tableProjectInfoSelect("article","article_id = '2'");

        $this->assertEqual($aRetData->date_start, '1183777085');
        $this->assertEqual($aRetData->date_end, '1190689085');
        $this->assertEqual($aRetData->publish, '1');
        $this->assertEqual($aRetData->never_expired, '1');
        $this->assertEqual($aRetData->skip_default_lang, '1');
        $this->assertNotEqual($aRetData->article_icon, 'abc.jpg');
        
    }
    
    function test_cmd_delete()
    {
        $oTest = new AdminArticleWebMgr();
        $input->frmDelete = array ( '1' => '2' , '2' => '3' );
        
        $sql = "INSERT INTO `article_message` ( `article_message_id` , `web_lang_id` , `article_id` , `title` , `message` )
                    VALUES ('3', '2', '1', 'title article_message_id 1', 'message title article_message_id 1')";
        $oTest->dbh->query($sql);
        
        $sql = "INSERT INTO `article_message` ( `article_message_id` , `web_lang_id` , `article_id` , `title` , `message` )
                    VALUES ('3', '2', '3', 'title article_message_id 1', 'message title article_message_id 1')";
        $oTest->dbh->query($sql);
        
        $sql = "INSERT INTO `article` ( `article_id` , `article_type_id` , `date_start` , `date_end` , `article_icon` , `skip_default_lang` , `publish` , `never_expired` )
                    VALUES ('2', '1', '1102523113', '1021524321', 'test.gif', '1' , '1' , '1')";
        $oTest->dbh->query($sql);
        
        $sql = "INSERT INTO `article` ( `article_id` , `article_type_id` , `date_start` , `date_end` , `article_icon` , `skip_default_lang` , `publish` , `never_expired` )
                    VALUES ('3', '1', '1253012113', '1021586321', 'test.gif', '1' , '1' , '1')";
        $oTest->dbh->query($sql);
        
        $sql = "INSERT INTO `article_role` ( `article_id` , `role_id`)
                    VALUES ('2', '1')";
        $oTest->dbh->query($sql);
        
        $sql = "INSERT INTO `article_role` ( `article_id` , `role_id`)
                    VALUES ('2', '2')";
        $oTest->dbh->query($sql);
        
        $sql = "INSERT INTO `article_role` ( `article_id` , `role_id`)
                    VALUES ('3', '2')";
        $oTest->dbh->query($sql);
        
        $checkDelete = $oTest->_cmd_delete($input, $output);
        $aRetData =  $this->_tableProjectInfoSelect("article","article_id = '2'");

        $this->assertTrue($checkDelete);
        $this->assertEqual(count($aRetData), '0');
        
    }
    
    function testgetTimeStamp()
    {
        $oTest = new AdminArticleWebMgr();
        $dateString = "2007-08-07 09:58:05";

        $timeStamp = $oTest->getTimeStamp($dateString);

        $exDate =  strftime("%Y-%m-%d %H:%i:%s",$timeStamp);

        $this->assertEqual($timeStamp, '1186455485');
        $this->assertEqual($exDate,$dateString);
    }
    
    function test_uploadImage()
    {
        $oTest = new AdminArticleWebMgr();
    }
    
    function test_detectGd()
    {
        $oTest = new AdminArticleWebMgr();
    }
    
    function test_resizeImageAndSave()
    {
        $oTest = new AdminArticleWebMgr();
    }
}

?> 