<?php

/* Reminder: always indent with 4 spaces (no tabs). */
// +---------------------------------------------------------------------------+
// WebSite:  http://www.webexperts.co.th
// Unauthorized copying is strictly forbidden and may result in severe legal action.
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// 
// =====YOU MUST KEEP THIS COPYRIGHTS NOTICE INTACT AND CAN NOT BE REMOVE =======
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// This Agreement is a legal contract, which specifies the terms of the license
// and warranty limitation between you and Web Experts Co.,Ltd. and RV Site Builder.
// You should carefully read the following terms and conditions before
// installing or using this software.  Unless you have a different license
// agreement obtained from Web Experts Co.,Ltd., installation or use of this software
// indicates your acceptance of the license and warranty limitation terms
// contained in this Agreement. If you do not agree to the terms of this
// Agreement, promptly delete and destroy all copies of the Software.
//
// =====  Grant of License =======
// The Software may only be installed and used on a single host machine.
//
// =====  Disclaimer of Warranty =======
// THIS SOFTWARE AND ACCOMPANYING DOCUMENTATION ARE PROVIDED "AS IS" AND
// WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR ANY OTHER
// WARRANTIES WHETHER EXPRESSED OR IMPLIED.   BECAUSE OF THE VARIOUS HARDWARE
// AND SOFTWARE ENVIRONMENTS INTO WHICH RV SITE BUILDER MAY BE USED, NO WARRANTY OF
// FITNESS FOR A PARTICULAR PURPOSE IS OFFERED.  THE USER MUST ASSUME THE
// ENTIRE RISK OF USING THIS PROGRAM.  ANY LIABILITY OF Web Experts Co.,Ltd. WILL BE
// LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT OR REFUND OF PURCHASE PRICE.
// IN NO CASE SHALL Web Experts Co.,Ltd. BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
// CONSEQUENTIAL DAMAGES OR LOSS, INCLUDING, WITHOUT LIMITATION, LOST PROFITS
// OR THE INABILITY TO USE EQUIPMENT OR ACCESS DATA, WHETHER SUCH DAMAGES ARE
// BASED UPON A BREACH OF EXPRESS OR IMPLIED WARRANTIES, BREACH OF CONTRACT,
// NEGLIGENCE, STRICT TORT, OR ANY OTHER LEGAL THEORY. THIS IS TRUE EVEN IF
// Web Experts Co.,Ltd. IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. IN NO CASE WILL
// Web Experts Co.,Ltd.'S LIABILITY EXCEED THE AMOUNT OF THE LICENSE FEE ACTUALLY PAID
// BY LICENSEE TO Web Experts Co.,Ltd.

require_once dirname(__FILE__) . '/../classes/ArticleViewWebMgr.php';
require_once dirname(__FILE__) . '/../../main/classes/Main.php';

class ArticleViewWebMgrTest extends UnitTestCase
{
    
    function ArticleViewWebMgrTest()
    {        
        $this->UnitTestCase('ArticleViewWebMgrTest Tests');
        $c = &SGL_Config::singleton();
        $this->conf = $c->ensureModuleConfigLoaded('articleweb');
    }

    function setup()
    {
        $oTest = new ArticleViewWebMgr();
        $sql = "INSERT INTO `web_article` ( `article_id` , `article_type_id` , `date_start` , `date_end` , `article_icon` , `skip_default_lang` , `publish` , `never_expired` , `user_id` )
                    VALUES 
                    ('1', '1', '1253636252', '1253263526', 'a.jpg', '1', '1', '1', '1'),
                    ('2', '1', '1212022532', '1313256241', 'b.jpg', '0', '1', '1', '1')";
        $oTest->dbh->query($sql);
        
        $sql = "INSERT INTO `web_article_message` ( `article_message_id` , `web_lang_id` , `article_id` , `title` , `message` , `extra_field1` , `extra_field2` , `extra_field3` , `extra_field4` , `extra_field5` )
                    VALUES 
                    ('1', '1', '1', 'title lang 1 for message', 'pppppppppppppppppppppppppppp', '555555555555', '3333333333333', '99999999666666', '999999999999999', '888888888888888888'),
                    ('2', '2', '1', 'title lang 2 for message', 'pppppppppppppppppppppppppcvccccccccccccccc', '1111111111111111', '52222222222222222222', '23333333333333333', '5555555555555555555555', '144444444444444444444')";
        $oTest->dbh->query($sql);
        
        $sql = "INSERT INTO `web_article_role` ( `article_id` , `role_id` )
                    VALUES 
                    ('1', '1'),
                    ('2', '1')";
        $oTest->dbh->query($sql);
        
        $sql = "INSERT INTO `web_article_type` ( `article_type_id` , `type_icon` )
                    VALUES 
                    ('1', 'ta.jpg'),
                    ('2', 'tb.jpg')";
        $oTest->dbh->query($sql);
        
        $sql = "INSERT INTO `web_article_type_message` ( `article_type_message_id` , `article_type_id` , `web_lang_id` , `type_name` , `description` )
                    VALUES 
                    ('1', '1', '1', 'xxxxxxxxxxxxxxxxxxxxxxxx1', 'xxxxxxxxxxxxxxxxxxxxxxxx2'),
                    ('2', '1', '2', 'xxxxxxxxxxxxxxxxxxxxxx3', 'xxxxxxxxxxxxxxxxxxxxxxx4')";
        $oTest->dbh->query($sql);
        
        $sql = "INSERT INTO `web_article_type_role` ( `article_type_id` , `role_id` )
                    VALUES ('1', '1'),('1','2'),('1','3')";
        $oTest->dbh->query($sql);        

        $sqlTask = new SGL_Task_SyncSequences();
        $sqlTask->run();
    }

    function teardown()
    {
        $oTest = new ArticleViewWebMgr();
        $sql = "DELETE FROM `web_article` WHERE `article_id` = 1 LIMIT 1";
        $oTest->dbh->query($sql);
        $sql = "DELETE FROM `web_article` WHERE `article_id` = 2 LIMIT 1";
        $oTest->dbh->query($sql);
        $sql = "DELETE FROM `web_article_message` WHERE `article_message_id` = 1 LIMIT 1";
        $oTest->dbh->query($sql);
        $sql = "DELETE FROM `web_article_message` WHERE `article_message_id` = 2 LIMIT 1";
        $oTest->dbh->query($sql);
        $sql = "DELETE FROM `web_article_role` WHERE `article_id` = 1 AND `role_id` = 1 LIMIT 1";
        $oTest->dbh->query($sql);
        $sql = "DELETE FROM `web_article_role` WHERE `article_id` = 2 AND `role_id` = 1 LIMIT 1";
        $oTest->dbh->query($sql);
        $sql = "DELETE FROM `web_article_type` WHERE `article_type_id` = 1 LIMIT 1";
        $oTest->dbh->query($sql);
        $sql = "DELETE FROM `web_article_type` WHERE `article_type_id` = 2 LIMIT 1";
        $oTest->dbh->query($sql);
        $sql = "DELETE FROM `web_article_type_role` WHERE `article_type_id` = 1 AND `role_id` = 1 LIMIT 1";
        $oTest->dbh->query($sql);
        $sql = "DELETE FROM `web_article_type_role` WHERE `article_type_id` = 1 AND `role_id` = 2 LIMIT 1";
        $oTest->dbh->query($sql);
        $sql = "DELETE FROM `web_article_type_role` WHERE `article_type_id` = 1 AND `role_id` = 3 LIMIT 1";
        $oTest->dbh->query($sql);
    }

    function test_cmd_viewArticle()
    {
        $oTest = new ArticleViewWebMgr();
    }
    
    function test_cmd_viewArticleType()
    {
        $oTest = new ArticleViewWebMgr();
    }
    
    function test_cmd_viewArticleAllType()
    {
        $oTest = new ArticleViewWebMgr();
        $input = new stdClass();
        $output = new stdClass();
        
        $oTest->_cmd_viewArticleAllType($input, $output);

        $aTypeData = $output->aTypeData;
        //echo $aTypeData[1]['type_name'];
                //echo "<pre>";
        //print_r($output->aTypeData);
        $this->assertNotNull(count($aTypeData));
        $this->assertNotNull($aTypeData[1]['type_name']);
        $this->assertEqual($aTypeData[1]['type_name'], 'xxxxxxxxxxxxxxxxxxxxxx3');
        //$this->assertTrue($checkAddData);
        //$this->assertNotEqual($aRetData->article_icon, 'abc.jpg');

    }
}    
    
?>    