<?php

/* Reminder: always indent with 4 spaces (no tabs). */
// +---------------------------------------------------------------------------+
// WebSite:  http://www.webexperts.co.th
// Unauthorized copying is strictly forbidden and may result in severe legal action.
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// 
// =====YOU MUST KEEP THIS COPYRIGHTS NOTICE INTACT AND CAN NOT BE REMOVE =======
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// This Agreement is a legal contract, which specifies the terms of the license
// and warranty limitation between you and Web Experts Co.,Ltd. and RV Site Builder.
// You should carefully read the following terms and conditions before
// installing or using this software.  Unless you have a different license
// agreement obtained from Web Experts Co.,Ltd., installation or use of this software
// indicates your acceptance of the license and warranty limitation terms
// contained in this Agreement. If you do not agree to the terms of this
// Agreement, promptly delete and destroy all copies of the Software.
//
// =====  Grant of License =======
// The Software may only be installed and used on a single host machine.
//
// =====  Disclaimer of Warranty =======
// THIS SOFTWARE AND ACCOMPANYING DOCUMENTATION ARE PROVIDED "AS IS" AND
// WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR ANY OTHER
// WARRANTIES WHETHER EXPRESSED OR IMPLIED.   BECAUSE OF THE VARIOUS HARDWARE
// AND SOFTWARE ENVIRONMENTS INTO WHICH RV SITE BUILDER MAY BE USED, NO WARRANTY OF
// FITNESS FOR A PARTICULAR PURPOSE IS OFFERED.  THE USER MUST ASSUME THE
// ENTIRE RISK OF USING THIS PROGRAM.  ANY LIABILITY OF Web Experts Co.,Ltd. WILL BE
// LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT OR REFUND OF PURCHASE PRICE.
// IN NO CASE SHALL Web Experts Co.,Ltd. BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
// CONSEQUENTIAL DAMAGES OR LOSS, INCLUDING, WITHOUT LIMITATION, LOST PROFITS
// OR THE INABILITY TO USE EQUIPMENT OR ACCESS DATA, WHETHER SUCH DAMAGES ARE
// BASED UPON A BREACH OF EXPRESS OR IMPLIED WARRANTIES, BREACH OF CONTRACT,
// NEGLIGENCE, STRICT TORT, OR ANY OTHER LEGAL THEORY. THIS IS TRUE EVEN IF
// Web Experts Co.,Ltd. IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. IN NO CASE WILL
// Web Experts Co.,Ltd.'S LIABILITY EXCEED THE AMOUNT OF THE LICENSE FEE ACTUALLY PAID
// BY LICENSEE TO Web Experts Co.,Ltd.

require_once SGL_MOD_DIR . '/articleweb/classes/AdminArticleWebMgr.php';

class AdminProductMgr extends AdminArticleWebMgr
{
    function AdminProductMgr()
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        parent::AdminArticleWebMgr();
        $this->template     = 'productManager.html';
        $this->pageTitle = 'Admin Product';
        
    }
    
    function validate($req, &$input)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        parent::validate($req, $input);
        $input->productTypeId = $req->get('productTypeId');
    }
    
    function _customInputByAction($action, $req, &$input) {
        $input->frmProperty = $req->get('frmProperty');
    }
    
    function _cmd_view($input, &$output)
    {
        parent::_cmd_view($input, $output);
    }
    
    //------------------------------ custom manage -----------------------------------------
    
    function _customUseTemplatebyAction(&$template, $action)
    {
          switch ($action) {
            case "view":
                $template     = 'productManager.html';
              break;
            case "addview":
                $template = 'productEdit.html';
              break;
            case "editview":
                $template = 'productEdit.html'; 
              break;
            case "delete":
              break;
        }
    }
    

    
    
    

    
    function _insertProductProperty($articleID, $input)
    {
        
        if ($articleID) { 
            $query = "INSERT INTO {$this->conf['table']['product_property']} ( `article_id` , `property1` , `property2` , `property3` , `property4` , `property5` , `property6` )
                            VALUES (
                                '$articleID', '{$input->frmProperty['1']}', '{$input->frmProperty['2']}', '{$input->frmProperty['3']}', '{$input->frmProperty['4']}', '{$input->frmProperty['5']}', '{$input->frmProperty['6']}'
                            );";
            $ok = $this->dbh->query($query);
        }
    }
    
    function _updateProductProperty($articleId, $input)
    {
        if ($articleId) {
            $query = "UPDATE {$this->conf['table']['product_property']} SET `article_id` = '{$articleId}',
                `property1` = '{$input->frmProperty['1']}',
                `property2` = '{$input->frmProperty['2']}',
                `property3` = '{$input->frmProperty['3']}',
                `property4` = '{$input->frmProperty['4']}',
                `property5` = '{$input->frmProperty['5']}',
                `property6` = '{$input->frmProperty['6']}' 
                    WHERE `article_id` = {$articleId} LIMIT 1 ;";
            $ok = $this->dbh->query($query);
            SGL::logMessage($query, PEAR_LOG_DEBUG);
        }                
    
    }
    /*
    function _getProductByType($input)
    {
        ########################3
    
        
        return $output;        
        ################33
    }
    */
    function _getProductProperty($articleId = '') 
    {
        if ($articleId) {
            $query = "SELECT `article_id` , `property1` , `property2` , `property3` , `property4` , `property5` , `property6`
                        FROM {$this->conf['table']['product_property']}
                        WHERE `article_id` = {$articleId} ;"; 
            $frmProperty = $this->dbh->getRow($query);
            
            $aFrmProperty['1'] = $frmProperty->property1;
            $aFrmProperty['2'] = $frmProperty->property2;
            $aFrmProperty['3'] = $frmProperty->property3;
            $aFrmProperty['4'] = $frmProperty->property4;
            $aFrmProperty['5'] = $frmProperty->property5;
            $aFrmProperty['6'] = $frmProperty->property6;
            return $aFrmProperty;
        }
    }        
    
    function _deleteProductProperty($frmDelete = '') 
    {
        if (is_array($frmDelete)) {
            foreach ($frmDelete as $k => $v) {
                $this->_deleteProductPropertyInDB( $v);
            }
        } else if (is_string($frmDelete)){
            $this->_deleteProductPropertyInDB($frmDelete);
        }
    }
    
    function _deleteProductPropertyInDB($articleId = '')
    {
        if ($articleId) {
            $query = "DELETE FROM {$this->conf['table']['product_property']} WHERE `article_id` = {$articleId} LIMIT 1;";
            $ok = $this->dbh->query($query);
        } 
    }
    
    function  _customOutputCMD($action, $input, &$output) {
        
        switch ($action) {
            case 'editview' :
                $output->frmProperty = $this->_getProductProperty($output->articleId);
                break;  
            case 'view' :
                
                foreach ($output->aPagedData['data'] as $k => $v) {
                    $output->aPagedData['data'][$k]['aProperty'] = $this->getProductPropertyByProductID($v['article_id']);
                }
                break;                  
            case 'delete' :
                $output = $this->_deleteProductProperty($input->frmDelete);
                break;                
                
        }            
    }
    
    
    function _customAfterInsertDB($action, $queryNumber, $aDataQuery,  $input) 
    {
        switch ($action) {
            case 'add' :
                switch ($queryNumber) {
                    case 1:
                        $this->_insertProductProperty($aDataQuery['article_id'], $input);
                        break;  
                }
            break;
            case 'edit' :
                switch ($queryNumber) {
                    case 1:
                            $this->_updateProductProperty($aDataQuery['article_id'], $input);
                        break;  
                }
            break;
        }

    
    }
    
    function _customQueryData($action, $input, $queryNumber, &$aDataQuery)
    {
        switch ($action) {
            case 'view' :
                switch ($queryNumber) {
                    case 1:
                        $aDataQuery[$queryNumber]['adjustWhere'] = "AND a.article_type_id = {$input->productTypeId}";
                        break;  
                }
            break;
        } 
    }
    
    function _customCommondInput($req, &$input)
    {
         switch ($input->action) {
            case "add":
                $input->frmPerms = $this->getAllPerms();
                break;
            case "edit":
                $input->frmPerms = $this->getAllPerms();
                break;
         }
    }
    
    
    function _cmd_redirectToDefault($input, $output)
    {
        //  must not logmessage here

        //  if no errors have occured, redirect
        
        $input->frmAdd['articleTypeId'] = $input->frmAdd['articleTypeId'] ? $input->frmAdd['articleTypeId'] : '1';
        
        if (!SGL_Error::count()) {
            SGL_HTTP::redirect(array(
                    'moduleName' => 'productweb',
                    'managerName' => 'adminproduct',
                    'action' => 'view',
                    'productTypeId' => $input->frmAdd['articleTypeId']
                    )
                );

        //  else display error with blank template
        } else {
            $output->template = 'error.html';
        }
    }

    //--------------------------------------- function -----------------------------------------
    function getProductPropertyByProductID($productID)
    {
        $aProperty = array();
        $query = "SELECT 
                                `property1`
                                ,`property2`
                                ,`property3`
                                ,`property4`
                                ,`property5`
                                ,`property6`
                            FROM `{$this->conf['table']['product_property']}`
                            WHERE `article_id` ='{$productID}'
                            ;";
        $aProperty = $this->dbh->getRow($query, DB_FETCHMODE_ASSOC);
        return $aProperty;
    }
    
    
    //--------------------------------------- function -----------------------------------------
    
}
?>