<?php

/* Reminder: always indent with 4 spaces (no tabs). */
// +---------------------------------------------------------------------------+
// WebSite:  http://www.webexperts.co.th
// Unauthorized copying is strictly forbidden and may result in severe legal action.
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// 
// =====YOU MUST KEEP THIS COPYRIGHTS NOTICE INTACT AND CAN NOT BE REMOVE =======
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// This Agreement is a legal contract, which specifies the terms of the license
// and warranty limitation between you and Web Experts Co.,Ltd. and RV Site Builder.
// You should carefully read the following terms and conditions before
// installing or using this software.  Unless you have a different license
// agreement obtained from Web Experts Co.,Ltd., installation or use of this software
// indicates your acceptance of the license and warranty limitation terms
// contained in this Agreement. If you do not agree to the terms of this
// Agreement, promptly delete and destroy all copies of the Software.
//
// =====  Grant of License =======
// The Software may only be installed and used on a single host machine.
//
// =====  Disclaimer of Warranty =======
// THIS SOFTWARE AND ACCOMPANYING DOCUMENTATION ARE PROVIDED "AS IS" AND
// WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR ANY OTHER
// WARRANTIES WHETHER EXPRESSED OR IMPLIED.   BECAUSE OF THE VARIOUS HARDWARE
// AND SOFTWARE ENVIRONMENTS INTO WHICH RV SITE BUILDER MAY BE USED, NO WARRANTY OF
// FITNESS FOR A PARTICULAR PURPOSE IS OFFERED.  THE USER MUST ASSUME THE
// ENTIRE RISK OF USING THIS PROGRAM.  ANY LIABILITY OF Web Experts Co.,Ltd. WILL BE
// LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT OR REFUND OF PURCHASE PRICE.
// IN NO CASE SHALL Web Experts Co.,Ltd. BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
// CONSEQUENTIAL DAMAGES OR LOSS, INCLUDING, WITHOUT LIMITATION, LOST PROFITS
// OR THE INABILITY TO USE EQUIPMENT OR ACCESS DATA, WHETHER SUCH DAMAGES ARE
// BASED UPON A BREACH OF EXPRESS OR IMPLIED WARRANTIES, BREACH OF CONTRACT,
// NEGLIGENCE, STRICT TORT, OR ANY OTHER LEGAL THEORY. THIS IS TRUE EVEN IF
// Web Experts Co.,Ltd. IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. IN NO CASE WILL
// Web Experts Co.,Ltd.'S LIABILITY EXCEED THE AMOUNT OF THE LICENSE FEE ACTUALLY PAID
// BY LICENSEE TO Web Experts Co.,Ltd.

require_once SGL_MOD_DIR . '/articleweb/classes/ArticleViewWebMgr.php';

class ProductViewMgr extends ArticleViewWebMgr
{
    function ProductViewMgr()
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        parent::ArticleViewWebMgr();
    }
    
    function validate($req, &$input)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        parent::validate($req, $input);
        
        $this->conf['ArticleViewWebMgr']['maxLastArticleForType'] = '5';
    }

    function display(&$output)
    {        
        $output->addJavascriptFile('js/preLoadImage.js');
        $output->addJavascriptFile('js/tooltip.js');  
        if (is_array( $output->preLoadImag)) {
            $image = join( "','", $output->preLoadImage);
        } else {
             $image = $output->preLoadImage;
        }
        if (isset($image) || $image != '') {
            $output->addOnLoadEvent("PreLoadImage(['" . $image . "'])");
        }    
    }
    
    function _customUseTemplatebyAction(&$template, $action)
    {
          switch ($action) {
            case "view":
                break;
            case "viewArticle":
                $template    = 'viewProduct.html';
                break;
            case "viewArticleType":
                $template    = 'viewProductType.html';
                break;
        }
        
    }
    
    function _getProductImage($articleId = '') 
    {
        $aFrmProductImage = array();
        if ($articleId) {
            $query = "SELECT `image_id`, `article_id`, `image_name`, `image_path`, `oldfilename`
                        FROM {$this->conf['table']['product_images']}
                        WHERE `article_id` = {$articleId} ;"; 
            $aFrmProductImage = $this->dbh->getRow($query);
            
        }
        return $aFrmProductImage;
    }
    
    function _getProductProperty($articleId = '') 
    {
        if ($articleId) {
            $query = "SELECT `article_id` , `property1` , `property2` , `property3` , `property4` , `property5` , `property6`
                        FROM {$this->conf['table']['product_property']}
                        WHERE `article_id` = {$articleId} ;"; 
            $frmProperty = $this->dbh->getRow($query);
            
            $aFrmProperty['1'] = $frmProperty->property1;
            $aFrmProperty['2'] = $frmProperty->property2;
            $aFrmProperty['3'] = $frmProperty->property3;
            $aFrmProperty['4'] = $frmProperty->property4;
            $aFrmProperty['5'] = $frmProperty->property5;
            $aFrmProperty['6'] = $frmProperty->property6;
            
            return $aFrmProperty;
        }
    }
    
    function _getTypeName($typeID = '')
    {
        $typeName = '';
        if ($typeID) {
            $query = "
                    SELECT 
                        atm.type_name
                    FROM 
                        {$this->conf['table']['product_type']} a
                        , {$this->conf['table']['product_type_message']} atm
                    WHERE 
                        a.article_type_id = atm.article_type_id
                        AND atm.article_type_id ='{$typeID}'
                        AND atm.web_lang_id ='1'
                    ";
            
            $typeName = $this->dbh->getOne($query);
        }   
        return $typeName;             
    }
    
    function _getProductAdjustFieldByType($aPagedData)
    {
         foreach ($aPagedData['data'] as $key=>$val) {
            
            $aFrmProperty = $this->_getProductProperty($aPagedData['data'][$key]['article_id']);
            
            $aPagedData['data'][$key]['property1'] = $aFrmProperty['1'];
            $aPagedData['data'][$key]['property2'] = $aFrmProperty['2'];
            $aPagedData['data'][$key]['property3'] = $aFrmProperty['3'];
            $aPagedData['data'][$key]['property4'] = $aFrmProperty['4'];
            $aPagedData['data'][$key]['property5'] = $aFrmProperty['5'];
            $aPagedData['data'][$key]['property6'] = $aFrmProperty['6'];
            
            $aFrmProductImage = $this->_getProductImage($aPagedData['data'][$key]['article_id']);
            $aPagedData['images'][$key] = $aFrmProductImage->image_path . $aFrmProductImage->image_name;
            $aPagedData['data'][$key]['image_name'] = isset($aFrmProductImage->image_name) ? $aFrmProductImage->image_name : '';
            
        }
        return $aPagedData;
    }
    
     function _customOutputDisplay(&$output)
    {
        switch ($output->action) {
            case 'viewArticleType' :
                $output->preLoadImage = array();                 
                $output->aPagedData = $this->_getProductAdjustFieldByType($output->aPagedData);
                $output->preLoadImage = isset($output->aPagedData['images']) ? $output->aPagedData['images'] : '';
                break;  
            case 'viewArticle' :
                $output->frmProperty = $this->_getProductProperty($output->frmArticleID);
                $aFrmProductImage = $this->_getProductImage($output->frmArticleID);
                if (isset($aFrmProductImage->image_name)) {
                    $output->m_image_name = 'm_' . $aFrmProductImage->image_name;                    
                }
                $output->typeName = $this->_getTypeName($output->frmArticleTypeID);
                
        }            
    }
}

?>