<?php

require_once 'Date/TimeZone.php';
require_once 'DB/DataObject.php';
require_once(SGL_WEB_ROOT . '/smfweb/smf_api.php');
SGL_Session::set('smfCookiename', $cookiename);

class SmfApi {
    
    function verifyAccount()
    {
        $dbh = & SGL_DB::singleton();    
        
        // รับค่า config
        $c = &SGL_Config::singleton();
        $conf = $c->getAll();    
    
        // รับค่า input
        $req = &SGL_Request::singleton();
        $frm = $req->getAll();
        
        $sglUserName = SGL_Session::getUsername();
    
        $query = "
            SELECT ID_MEMBER 
            FROM " . $conf['table']['smfweb_members'] . " 
            WHERE memberName = '{$sglUserName}'
            LIMIT 0,1
        ";
        $res = $dbh->getAll($query, DB_FETCHMODE_ASSOC);
        
        if (count($res) < 1) {
            $oUser = DB_DataObject::factory($conf['table']['user']);
            $oUser->get(SGL_Session::getUid());
            $input->username = $oUser->username;
            $input->email = $oUser->email;
            $input->password = $frm['frmPassword'];
            $this->registerUser($input);
        }
        return true;
    }
    
    function addUser($input)
    {
        
        $input->username = $input->user->username;
        $input->password = $input->user->passwd;
        $input->email =  $input->user->email;
        
         $this->registerUser($input);
        return true;
    }
    
    function registerUser($input)
    {
        smf_registerMember($input->username, $input->email, $input->password);
    
        return true;    
    }
    
    
    function login($password, $encrypted = false)
    {
        // รับค่า config
        $c = &SGL_Config::singleton();
        $conf = $c->getAll();
    
        $sglUserName = SGL_Session::getUsername();
        $sglUserId = SGL_Session::getUid();
        require_once SGL_MOD_DIR . '/user/classes/UserDAO.php';
        $daUser    = &UserDAO::singleton();
        $aPref=$daUser->getPrefsByUserId($sglUserId);
        $sglSessionTimeout = $aPref['sessionTimeout'];
        
        if ($encrypted === false) {
            $this->_resetPassword($sglUserName, $password);
        }
        smf_setLoginCookie($sglSessionTimeout, $sglUserName, $password, $encrypted);
        
        return true;
    }
    
    
    function logout()
    {
        $smfCookiename = SGL_Session::get('smfCookiename');
        $encrypted = true;
        list($smfUserId, $smfUserPassword) = unserialize(stripslashes($_COOKIE[$smfCookiename]));
        smf_setLoginCookie(-1, $smfUserId, $smfUserPassword, $encrypted);
    
        return true;
    }
    
    
    function changePassword($password, $relogin = true)
    {
        $dbh = & SGL_DB::singleton();  
        $sglUserName = SGL_Session::getUsername();
        
        $newPassword = sha1(strtolower($sglUserName) . $password);
        $this->_resetPassword($sglUserName, $newPassword);
    
        if ($relogin === true) {
            $this->logout();
            $this->login($password);
        }
        
        return true;
    }
    
    function _resetPassword($username, $password)
    {
        $dbh = & SGL_DB::singleton();    
        
        // รับค่า config
        $c = &SGL_Config::singleton();
        $conf = $c->getAll();      
        
        $newPassword = sha1(strtolower($username) . $password);
    
        $query = "
            UPDATE " . $conf['table']['smfweb_members'] . " 
            SET passwd = '$newPassword'
            WHERE memberName = '{$username}'
        ";
        $dbh->query($query);
    
        return true;
    }
    
    
    // การเปลี่ยน Username ทำให้รหัสผ่านเดิมใช้ไม่ได้ ต้อง reset รหัสผ่าน
    function changeUsername($currentUsername, $newUsername, $email)
    {
        $dbh = & SGL_DB::singleton();    
        
        // รับค่า config
        $c = &SGL_Config::singleton();
        $conf = $c->getAll();      
        
        $query = "
            UPDATE " . $conf['table']['smfweb_members'] . " 
            SET memberName = '$newUsername',
            realName = '$newUsername', 
            emailAddress = '$email' 
            WHERE memberName = '{$currentUsername}'
        ";
        $dbh->query($query);
    
        return true;
    }
    
    function deleteUser($aUserId)
    {

        global $smf_connection, $smf_settings;
        
        $dbh = & SGL_DB::singleton();
        $c = &SGL_Config::singleton();
        $conf = $c->getAll();
        
        if (!is_array($aUserId)) {
            $aUserId = array($aUserId);
        } else {
            $aUserId = array_unique($aUserId);
        }

        $userIdQuery = implode(',', $aUserId);

        $query = "
            SELECT username
            FROM " . $conf['table']['user'] . "
            WHERE usr_id IN (" . $userIdQuery . ")
                ";
        
        $aSglUserName = $dbh->getCol($query);
        $memberList = '';
        foreach ($aSglUserName as $key) {
            $memberList .= '\'' .$key . '\',';
        }
       $memberList .= '\' \'';
        
        $query = "SELECT ID_MEMBER
                        FROM {$conf['table']['smfweb_members']}
                        WHERE memberName IN ({$memberList})
                                ";

        $aSmfUserId = $dbh->getCol($query);

        if (!is_array($aSmfUserId)) {
            $aSmfUserId = array($aSmfUserId);
        } else {
            $aSmfUserId = array_unique($aSmfUserId);
        }
        
        $this->smf_deleteMembers($aSmfUserId);    
        $this->smf_deleteLog($aSmfUserId);
                
    }



    
    function changeUserPreference($input)
    {
        // รับค่า config
        $c = &SGL_Config::singleton();
        $conf = $c->getAll();
        $sglUserName = SGL_Session::getUsername();
        
        $dbh = & SGL_DB::singleton();  
    
    // ค้นหาค่า Offset
        $timezone = $input->aPrefs['timezone'];
        $offset = $GLOBALS['_DATE_TIMEZONE_DATA'][$timezone]['offset'] / 1000 / 60 / 60;
        
        $url = SGL_BASE_URL . '/offset.php';
        
        $curlContent = file_get_contents($url);    
        
        $timeOffset = $offset - $curlContent;
    // สิ้นสุดการ ค้นหาค่า Offset       
        
        require_once(SGL_MOD_DIR . '/main/classes/Main.php');
        $oMain = new Main;
        $setSmfLang = $oMain->languageMap('smfweb', $input->aPrefs['language']);
        
        $query = "
            UPDATE " . $conf['table']['smfweb_members'] . "
            SET lngfile = '{$setSmfLang}',
               timeOffset = '{$timeOffset}' 
            WHERE memberName = '{$sglUserName}' 
        ";
    
        $dbh->query($query);
        
        $smfCookiename = SGL_Session::get('smfCookiename');
        list($smfUserId, $smfUserPassword) = unserialize(stripslashes($_COOKIE[$smfCookiename]));
        
        $this->logout();
        $this->login($smfUserPassword, true);
        
    }
    
    
    function changeDefaultPreference($input)
    {
        // รับค่า config
        $c = &SGL_Config::singleton();
        $conf = $c->getAll();
        $dbh = & SGL_DB::singleton();  
    
        if ($input->pref->name == 'timezone') {
            $timezone = $input->pref->default_value;
            $timeOffset = 0;
            if (isset($GLOBALS['_DATE_TIMEZONE_DATA'][$timezone]['offset'])) {
                $offset = $GLOBALS['_DATE_TIMEZONE_DATA'][$timezone]['offset'] / 1000 / 60 / 60;
    
                $url = SGL_BASE_URL . '/offset.php';

                $curlContent = file_get_contents($url);
    
                $timeOffset = $offset - $curlContent;
            }
            
            $query = "
                    UPDATE " . $conf['table']['smfweb_settings'] . "
                    SET `value` = '{$timeOffset}' 
                    WHERE `variable` = 'time_offset' 
                ";
            $dbh->query($query);
    
    
        } elseif ($input->pref->name == 'language') {
            
            require_once(SGL_MOD_DIR . '/main/classes/Main.php');
            $oMain = new Main;
            $setSmfLang = $oMain->languageMap('smfweb', $input->pref->default_value);
            changeSetting('language', $setSmfLang);
    
        }
        
    }
    
    function smf_deleteMembers($aUserId)
    {
        // โปรแกรมจะไม่ลบ Buddy List
        $dbh = & SGL_DB::singleton();  
      
        $c = &SGL_Config::singleton();
        $conf = $c->getAll();
        
        if (count($aUserId) > 0) {
            $smfMemberId = implode(',', $aUserId);
             $query = "
                UPDATE {$conf['table']['smfweb_messages']}
                SET ID_MEMBER = 0
                WHERE ID_MEMBER IN ({$smfMemberId}) 
            ";
             $dbh->query($query);
        
             $query = "
                UPDATE {$conf['table']['smfweb_polls']}
                SET ID_MEMBER = 0
                WHERE ID_MEMBER IN ({$smfMemberId}) 
            ";
             $dbh->query($query);
                
            // Make these peoples' posts guest first posts and last posts.
             $query = "
                UPDATE {$conf['table']['smfweb_topics']}
                SET ID_MEMBER_STARTED = 0
                WHERE ID_MEMBER_STARTED IN ({$smfMemberId}) 
            ";
             $dbh->query($query);
             
             $query = "
                UPDATE {$conf['table']['smfweb_topics']}
                SET ID_MEMBER_UPDATED = 0
                WHERE ID_MEMBER_UPDATED IN ({$smfMemberId}) 
            ";
             $dbh->query($query);
        
             $query = "
                DELETE FROM {$conf['table']['smfweb_collapsed_categories']}
                WHERE ID_MEMBER IN ({$smfMemberId}) 
            ";
             $dbh->query($query);
                
             $query = "
                UPDATE {$conf['table']['smfweb_personal_messages']}
                SET ID_MEMBER_FROM = 0
                WHERE ID_MEMBER_FROM IN ({$smfMemberId}) 
            ";
             $dbh->query($query);
             
             $query = "
                DELETE FROM {$conf['table']['smfweb_moderators']}
                WHERE ID_MEMBER IN ({$smfMemberId}) 
            ";
             $dbh->query($query);
                
            // If you don't exist we can't ban you.
             $query = "
                DELETE FROM {$conf['table']['smfweb_ban_items']}
                WHERE ID_MEMBER IN ({$smfMemberId}) 
            ";
             $dbh->query($query);
                
            // Remove individual theme settings.
             $query = "
                DELETE FROM {$conf['table']['smfweb_themes']}
                WHERE ID_MEMBER IN ({$smfMemberId}) 
            ";
             $dbh->query($query);
        
            $query = "
                DELETE FROM {$conf['table']['smfweb_members']} 
               WHERE ID_MEMBER IN ({$smfMemberId}) 
            ";
            $dbh->query($query);
    
        }
        
        return true;
    
    }
    
    function smf_deleteLog($aUserId)
    {
        $dbh = & SGL_DB::singleton();  
      
        $c = &SGL_Config::singleton();
        $conf = $c->getAll();
            // Delete the logs...
            
        $smfMemberId = implode(',', $aUserId);
        $condition = "IN ({$smfMemberId})";
        
        $query = "
            DELETE FROM {$conf['table']['smfweb_log_boards']}
            WHERE ID_MEMBER $condition
            ";
        $dbh->query($query);
                    
        $query = "
            DELETE FROM {$conf['table']['smfweb_log_karma']}
            WHERE ID_TARGET $condition
                OR ID_EXECUTOR $condition            
            ";
        $dbh->query($query);
        
        $query = "
            DELETE FROM {$conf['table']['smfweb_log_mark_read']}
            WHERE ID_MEMBER $condition
            ";
        $dbh->query($query);
        
        $query = "
            DELETE FROM {$conf['table']['smfweb_log_notify']}
            WHERE ID_MEMBER $condition
            ";
        $dbh->query($query);
        
        $query = "
            DELETE FROM {$conf['table']['smfweb_log_online']}
            WHERE ID_MEMBER $condition
            ";
        $dbh->query($query);
                    
        $query = "            
            DELETE FROM {$conf['table']['smfweb_log_polls']}
            WHERE ID_MEMBER $condition
            ";
        $dbh->query($query);
                    
        $query = "
            DELETE FROM {$conf['table']['smfweb_log_topics']}
            WHERE ID_MEMBER $condition
                ";
        $dbh->query($query);            
        
        $query = "
            DELETE FROM {$conf['table']['smfweb_collapsed_categories']}
            WHERE ID_MEMBER $condition
        ";
        $dbh->query($query);            
    }
    
    /*
     * กรณี ใน Admin เปิด custom_avatar_dir อาจจะต้องลบตัวนี้ด้วย
     */
    
    function smf_removeAttachments($condition, $query_type = '', $return_affected_messages = false, $autoThumbRemoval = true)
    {

    }    
    
    function _getPersonalMessage()
    {
        // รับค่า config
        $c = &SGL_Config::singleton();
        $conf = $c->getAll();
    
        $sglUserName = SGL_Session::getUsername();
            
        $dbh = & SGL_DB::singleton();  
        
        $query = "
            SELECT instantMessages, unreadMessages
            FROM " . $conf['table']['smfweb_members'] . "
            WHERE memberName = '$sglUserName' 
        ";
        
        $res = $dbh->getRow($query);
        if (isset($res->instantMessages) === false) {
            $res->instantMessages = 0;
            $res->unreadMessages = 0;
        }
    
        return $res;
        
    }
    
}

?>