
CREATE TABLE IF NOT EXISTS `smfweb_attachments` (
  `ID_ATTACH` int(10) unsigned NOT NULL auto_increment,
  `ID_THUMB` int(10) unsigned NOT NULL default '0',
  `ID_MSG` int(10) unsigned NOT NULL default '0',
  `ID_MEMBER` mediumint(8) unsigned NOT NULL default '0',
  `attachmentType` tinyint(3) unsigned NOT NULL default '0',
  `filename` tinytext NOT NULL,
  `size` int(10) unsigned NOT NULL default '0',
  `downloads` mediumint(8) unsigned NOT NULL default '0',
  `width` mediumint(8) unsigned NOT NULL default '0',
  `height` mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID_ATTACH`),
  UNIQUE KEY `ID_MEMBER` (`ID_MEMBER`,`ID_ATTACH`),
  KEY `ID_MSG` (`ID_MSG`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



CREATE TABLE IF NOT EXISTS `smfweb_ban_groups` (
  `ID_BAN_GROUP` mediumint(8) unsigned NOT NULL auto_increment,
  `name` varchar(20) NOT NULL default '',
  `ban_time` int(10) unsigned NOT NULL default '0',
  `expire_time` int(10) unsigned default NULL,
  `cannot_access` tinyint(3) unsigned NOT NULL default '0',
  `cannot_register` tinyint(3) unsigned NOT NULL default '0',
  `cannot_post` tinyint(3) unsigned NOT NULL default '0',
  `cannot_login` tinyint(3) unsigned NOT NULL default '0',
  `reason` tinytext NOT NULL,
  `notes` text NOT NULL,
  PRIMARY KEY  (`ID_BAN_GROUP`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


-- --------------------------------------------------------


CREATE TABLE IF NOT EXISTS `smfweb_ban_items` (
  `ID_BAN` mediumint(8) unsigned NOT NULL auto_increment,
  `ID_BAN_GROUP` smallint(5) unsigned NOT NULL default '0',
  `ip_low1` tinyint(3) unsigned NOT NULL default '0',
  `ip_high1` tinyint(3) unsigned NOT NULL default '0',
  `ip_low2` tinyint(3) unsigned NOT NULL default '0',
  `ip_high2` tinyint(3) unsigned NOT NULL default '0',
  `ip_low3` tinyint(3) unsigned NOT NULL default '0',
  `ip_high3` tinyint(3) unsigned NOT NULL default '0',
  `ip_low4` tinyint(3) unsigned NOT NULL default '0',
  `ip_high4` tinyint(3) unsigned NOT NULL default '0',
  `hostname` tinytext NOT NULL,
  `email_address` tinytext NOT NULL,
  `ID_MEMBER` mediumint(8) unsigned NOT NULL default '0',
  `hits` mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID_BAN`),
  KEY `ID_BAN_GROUP` (`ID_BAN_GROUP`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


-- --------------------------------------------------------


CREATE TABLE IF NOT EXISTS `smfweb_board_permissions` (
  `ID_GROUP` smallint(5) NOT NULL default '0',
  `ID_BOARD` smallint(5) unsigned NOT NULL default '0',
  `permission` varchar(30) NOT NULL default '',
  `addDeny` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`ID_GROUP`,`ID_BOARD`,`permission`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


-- --------------------------------------------------------


CREATE TABLE IF NOT EXISTS `smfweb_boards` (
  `ID_BOARD` smallint(5) unsigned NOT NULL auto_increment,
  `ID_CAT` tinyint(4) unsigned NOT NULL default '0',
  `childLevel` tinyint(4) unsigned NOT NULL default '0',
  `ID_PARENT` smallint(5) unsigned NOT NULL default '0',
  `boardOrder` smallint(5) NOT NULL default '0',
  `ID_LAST_MSG` int(10) unsigned NOT NULL default '0',
  `ID_MSG_UPDATED` int(10) unsigned NOT NULL default '0',
  `memberGroups` varchar(255) NOT NULL default '-1,0',
  `name` tinytext NOT NULL,
  `description` text NOT NULL,
  `numTopics` mediumint(8) unsigned NOT NULL default '0',
  `numPosts` mediumint(8) unsigned NOT NULL default '0',
  `countPosts` tinyint(4) NOT NULL default '0',
  `ID_THEME` tinyint(4) unsigned NOT NULL default '0',
  `permission_mode` tinyint(4) unsigned NOT NULL default '0',
  `override_theme` tinyint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID_BOARD`),
  UNIQUE KEY `categories` (`ID_CAT`,`ID_BOARD`),
  KEY `ID_PARENT` (`ID_PARENT`),
  KEY `ID_MSG_UPDATED` (`ID_MSG_UPDATED`),
  KEY `memberGroups` (`memberGroups`(48))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;


-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `smfweb_calendar` (
  `ID_EVENT` smallint(5) unsigned NOT NULL auto_increment,
  `startDate` date NOT NULL default '0001-01-01',
  `endDate` date NOT NULL default '0001-01-01',
  `ID_BOARD` smallint(5) unsigned NOT NULL default '0',
  `ID_TOPIC` mediumint(8) unsigned NOT NULL default '0',
  `title` varchar(48) NOT NULL default '',
  `ID_MEMBER` mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID_EVENT`),
  KEY `startDate` (`startDate`),
  KEY `endDate` (`endDate`),
  KEY `topic` (`ID_TOPIC`,`ID_MEMBER`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `smfweb_calendar_holidays` (
  `ID_HOLIDAY` smallint(5) unsigned NOT NULL auto_increment,
  `eventDate` date NOT NULL default '0001-01-01',
  `title` varchar(30) NOT NULL default '',
  PRIMARY KEY  (`ID_HOLIDAY`),
  KEY `eventDate` (`eventDate`)
) ENGINE=MyISAM AUTO_INCREMENT=168 DEFAULT CHARSET=latin1 AUTO_INCREMENT=168 ;


-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `smfweb_categories` (
  `ID_CAT` tinyint(4) unsigned NOT NULL auto_increment,
  `catOrder` tinyint(4) NOT NULL default '0',
  `name` tinytext NOT NULL,
  `canCollapse` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`ID_CAT`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;




-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `smfweb_collapsed_categories` (
  `ID_CAT` tinyint(4) unsigned NOT NULL default '0',
  `ID_MEMBER` mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID_CAT`,`ID_MEMBER`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `smfweb_log_actions` (
  `ID_ACTION` int(10) unsigned NOT NULL auto_increment,
  `logTime` int(10) unsigned NOT NULL default '0',
  `ID_MEMBER` mediumint(8) unsigned NOT NULL default '0',
  `ip` char(16) NOT NULL default '',
  `action` varchar(30) NOT NULL default '',
  `extra` text NOT NULL,
  PRIMARY KEY  (`ID_ACTION`),
  KEY `logTime` (`logTime`),
  KEY `ID_MEMBER` (`ID_MEMBER`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



-- --------------------------------------------------------


CREATE TABLE IF NOT EXISTS `smfweb_log_activity` (
  `date` date NOT NULL default '0001-01-01',
  `hits` mediumint(8) unsigned NOT NULL default '0',
  `topics` smallint(5) unsigned NOT NULL default '0',
  `posts` smallint(5) unsigned NOT NULL default '0',
  `registers` smallint(5) unsigned NOT NULL default '0',
  `mostOn` smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`date`),
  KEY `hits` (`hits`),
  KEY `mostOn` (`mostOn`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `smfweb_log_banned` (
  `ID_BAN_LOG` mediumint(8) unsigned NOT NULL auto_increment,
  `ID_MEMBER` mediumint(8) unsigned NOT NULL default '0',
  `ip` char(16) NOT NULL default '',
  `email` tinytext NOT NULL,
  `logTime` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID_BAN_LOG`),
  KEY `logTime` (`logTime`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



-- --------------------------------------------------------


CREATE TABLE IF NOT EXISTS `smfweb_log_boards` (
  `ID_MEMBER` mediumint(8) unsigned NOT NULL default '0',
  `ID_BOARD` smallint(5) unsigned NOT NULL default '0',
  `ID_MSG` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID_MEMBER`,`ID_BOARD`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `smfweb_log_errors` (
  `ID_ERROR` mediumint(8) unsigned NOT NULL auto_increment,
  `logTime` int(10) unsigned NOT NULL default '0',
  `ID_MEMBER` mediumint(8) unsigned NOT NULL default '0',
  `ip` char(16) NOT NULL default '',
  `url` text NOT NULL,
  `message` text NOT NULL,
  `session` char(32) NOT NULL default '',
  PRIMARY KEY  (`ID_ERROR`),
  KEY `logTime` (`logTime`),
  KEY `ID_MEMBER` (`ID_MEMBER`),
  KEY `ip` (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `smfweb_log_floodcontrol` (
  `ip` char(16) NOT NULL default '',
  `logTime` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `smfweb_log_karma` (
  `ID_TARGET` mediumint(8) unsigned NOT NULL default '0',
  `ID_EXECUTOR` mediumint(8) unsigned NOT NULL default '0',
  `logTime` int(10) unsigned NOT NULL default '0',
  `action` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`ID_TARGET`,`ID_EXECUTOR`),
  KEY `logTime` (`logTime`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `smfweb_log_mark_read` (
  `ID_MEMBER` mediumint(8) unsigned NOT NULL default '0',
  `ID_BOARD` smallint(5) unsigned NOT NULL default '0',
  `ID_MSG` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID_MEMBER`,`ID_BOARD`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `smfweb_log_notify` (
  `ID_MEMBER` mediumint(8) unsigned NOT NULL default '0',
  `ID_TOPIC` mediumint(8) unsigned NOT NULL default '0',
  `ID_BOARD` smallint(5) unsigned NOT NULL default '0',
  `sent` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID_MEMBER`,`ID_TOPIC`,`ID_BOARD`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


-- --------------------------------------------------------


CREATE TABLE IF NOT EXISTS `smfweb_log_online` (
  `session` varchar(32) NOT NULL default '',
  `logTime` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `ID_MEMBER` mediumint(8) unsigned NOT NULL default '0',
  `ip` int(10) unsigned NOT NULL default '0',
  `url` text NOT NULL,
  PRIMARY KEY  (`session`),
  KEY `logTime` (`logTime`),
  KEY `ID_MEMBER` (`ID_MEMBER`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



-- --------------------------------------------------------


CREATE TABLE IF NOT EXISTS `smfweb_log_polls` (
  `ID_POLL` mediumint(8) unsigned NOT NULL default '0',
  `ID_MEMBER` mediumint(8) unsigned NOT NULL default '0',
  `ID_CHOICE` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID_POLL`,`ID_MEMBER`,`ID_CHOICE`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------


CREATE TABLE IF NOT EXISTS `smfweb_log_search_messages` (
  `ID_SEARCH` tinyint(3) unsigned NOT NULL default '0',
  `ID_MSG` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID_SEARCH`,`ID_MSG`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- dump ตาราง `smfweb_log_search_messages`
-- 


-- --------------------------------------------------------

-- 
-- โครงสร้างตาราง `smfweb_log_search_results`
-- 

CREATE TABLE IF NOT EXISTS `smfweb_log_search_results` (
  `ID_SEARCH` tinyint(3) unsigned NOT NULL default '0',
  `ID_TOPIC` mediumint(8) unsigned NOT NULL default '0',
  `ID_MSG` int(10) unsigned NOT NULL default '0',
  `relevance` smallint(5) unsigned NOT NULL default '0',
  `num_matches` smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID_SEARCH`,`ID_TOPIC`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `smfweb_log_search_subjects` (
  `word` varchar(20) NOT NULL default '',
  `ID_TOPIC` mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (`word`,`ID_TOPIC`),
  KEY `ID_TOPIC` (`ID_TOPIC`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

REPLACE INTO `smfweb_log_search_subjects` (`word`, `ID_TOPIC`) VALUES ('??????', 1);
REPLACE INTO `smfweb_log_search_subjects` (`word`, `ID_TOPIC`) VALUES ('SMF', 1);

-- --------------------------------------------------------


CREATE TABLE IF NOT EXISTS `smfweb_log_search_topics` (
  `ID_SEARCH` tinyint(3) unsigned NOT NULL default '0',
  `ID_TOPIC` mediumint(9) NOT NULL default '0',
  PRIMARY KEY  (`ID_SEARCH`,`ID_TOPIC`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `smfweb_log_topics` (
  `ID_MEMBER` mediumint(8) unsigned NOT NULL default '0',
  `ID_TOPIC` mediumint(8) unsigned NOT NULL default '0',
  `ID_MSG` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID_MEMBER`,`ID_TOPIC`),
  KEY `ID_TOPIC` (`ID_TOPIC`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `smfweb_membergroups` (
  `ID_GROUP` smallint(5) unsigned NOT NULL auto_increment,
  `groupName` varchar(80) NOT NULL default '',
  `onlineColor` varchar(20) NOT NULL default '',
  `minPosts` mediumint(9) NOT NULL default '-1',
  `maxMessages` smallint(5) unsigned NOT NULL default '0',
  `stars` tinytext NOT NULL,
  PRIMARY KEY  (`ID_GROUP`),
  KEY `minPosts` (`minPosts`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=latin1 AUTO_INCREMENT=9 ;


-- --------------------------------------------------------


CREATE TABLE IF NOT EXISTS `smfweb_members` (
  `ID_MEMBER` mediumint(8) unsigned NOT NULL auto_increment,
  `memberName` varchar(80) NOT NULL default '',
  `dateRegistered` int(10) unsigned NOT NULL default '0',
  `posts` mediumint(8) unsigned NOT NULL default '0',
  `ID_GROUP` smallint(5) unsigned NOT NULL default '0',
  `lngfile` tinytext NOT NULL,
  `lastLogin` int(10) unsigned NOT NULL default '0',
  `realName` tinytext NOT NULL,
  `instantMessages` smallint(5) NOT NULL default '0',
  `unreadMessages` smallint(5) NOT NULL default '0',
  `buddy_list` text NOT NULL,
  `pm_ignore_list` tinytext NOT NULL,
  `messageLabels` text NOT NULL,
  `passwd` varchar(64) NOT NULL default '',
  `emailAddress` tinytext NOT NULL,
  `personalText` tinytext NOT NULL,
  `gender` tinyint(4) unsigned NOT NULL default '0',
  `birthdate` date NOT NULL default '0001-01-01',
  `websiteTitle` tinytext NOT NULL,
  `websiteUrl` tinytext NOT NULL,
  `location` tinytext NOT NULL,
  `ICQ` tinytext NOT NULL,
  `AIM` varchar(16) NOT NULL default '',
  `YIM` varchar(32) NOT NULL default '',
  `MSN` tinytext NOT NULL,
  `hideEmail` tinyint(4) NOT NULL default '0',
  `showOnline` tinyint(4) NOT NULL default '1',
  `timeFormat` varchar(80) NOT NULL default '',
  `signature` text NOT NULL,
  `timeOffset` float NOT NULL default '0',
  `avatar` tinytext NOT NULL,
  `pm_email_notify` tinyint(4) NOT NULL default '0',
  `karmaBad` smallint(5) unsigned NOT NULL default '0',
  `karmaGood` smallint(5) unsigned NOT NULL default '0',
  `usertitle` tinytext NOT NULL,
  `notifyAnnouncements` tinyint(4) NOT NULL default '1',
  `notifyOnce` tinyint(4) NOT NULL default '1',
  `notifySendBody` tinyint(4) NOT NULL default '0',
  `notifyTypes` tinyint(4) NOT NULL default '2',
  `memberIP` tinytext NOT NULL,
  `memberIP2` tinytext NOT NULL,
  `secretQuestion` tinytext NOT NULL,
  `secretAnswer` varchar(64) NOT NULL default '',
  `ID_THEME` tinyint(4) unsigned NOT NULL default '0',
  `is_activated` tinyint(3) unsigned NOT NULL default '1',
  `validation_code` varchar(10) NOT NULL default '',
  `ID_MSG_LAST_VISIT` int(10) unsigned NOT NULL default '0',
  `additionalGroups` tinytext NOT NULL,
  `smileySet` varchar(48) NOT NULL default '',
  `ID_POST_GROUP` smallint(5) unsigned NOT NULL default '0',
  `totalTimeLoggedIn` int(10) unsigned NOT NULL default '0',
  `passwordSalt` varchar(5) NOT NULL default '',
  PRIMARY KEY  (`ID_MEMBER`),
  KEY `memberName` (`memberName`(30)),
  KEY `dateRegistered` (`dateRegistered`),
  KEY `ID_GROUP` (`ID_GROUP`),
  KEY `birthdate` (`birthdate`),
  KEY `posts` (`posts`),
  KEY `lastLogin` (`lastLogin`),
  KEY `lngfile` (`lngfile`(30)),
  KEY `ID_POST_GROUP` (`ID_POST_GROUP`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;



-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `smfweb_message_icons` (
  `ID_ICON` smallint(5) unsigned NOT NULL auto_increment,
  `title` varchar(80) NOT NULL default '',
  `filename` varchar(80) NOT NULL default '',
  `ID_BOARD` mediumint(8) unsigned NOT NULL default '0',
  `iconOrder` smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID_ICON`),
  KEY `ID_BOARD` (`ID_BOARD`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=latin1 AUTO_INCREMENT=13 ;


-- --------------------------------------------------------


CREATE TABLE IF NOT EXISTS `smfweb_messages` (
  `ID_MSG` int(10) unsigned NOT NULL auto_increment,
  `ID_TOPIC` mediumint(8) unsigned NOT NULL default '0',
  `ID_BOARD` smallint(5) unsigned NOT NULL default '0',
  `posterTime` int(10) unsigned NOT NULL default '0',
  `ID_MEMBER` mediumint(8) unsigned NOT NULL default '0',
  `ID_MSG_MODIFIED` int(10) unsigned NOT NULL default '0',
  `subject` tinytext NOT NULL,
  `posterName` tinytext NOT NULL,
  `posterEmail` tinytext NOT NULL,
  `posterIP` tinytext NOT NULL,
  `smileysEnabled` tinyint(4) NOT NULL default '1',
  `modifiedTime` int(10) unsigned NOT NULL default '0',
  `modifiedName` tinytext NOT NULL,
  `body` text NOT NULL,
  `icon` varchar(16) NOT NULL default 'xx',
  PRIMARY KEY  (`ID_MSG`),
  UNIQUE KEY `topic` (`ID_TOPIC`,`ID_MSG`),
  UNIQUE KEY `ID_BOARD` (`ID_BOARD`,`ID_MSG`),
  UNIQUE KEY `ID_MEMBER` (`ID_MEMBER`,`ID_MSG`),
  KEY `ipIndex` (`posterIP`(15),`ID_TOPIC`),
  KEY `participation` (`ID_MEMBER`,`ID_TOPIC`),
  KEY `showPosts` (`ID_MEMBER`,`ID_BOARD`),
  KEY `ID_TOPIC` (`ID_TOPIC`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;




-- --------------------------------------------------------


CREATE TABLE IF NOT EXISTS `smfweb_moderators` (
  `ID_BOARD` smallint(5) unsigned NOT NULL default '0',
  `ID_MEMBER` mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID_BOARD`,`ID_MEMBER`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



-- --------------------------------------------------------


CREATE TABLE IF NOT EXISTS `smfweb_package_servers` (
  `ID_SERVER` smallint(5) unsigned NOT NULL auto_increment,
  `name` tinytext NOT NULL,
  `url` tinytext NOT NULL,
  PRIMARY KEY  (`ID_SERVER`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;




-- --------------------------------------------------------


CREATE TABLE IF NOT EXISTS `smfweb_permissions` (
  `ID_GROUP` smallint(5) NOT NULL default '0',
  `permission` varchar(30) NOT NULL default '',
  `addDeny` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`ID_GROUP`,`permission`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `smfweb_personal_messages` (
  `ID_PM` int(10) unsigned NOT NULL auto_increment,
  `ID_MEMBER_FROM` mediumint(8) unsigned NOT NULL default '0',
  `deletedBySender` tinyint(3) unsigned NOT NULL default '0',
  `fromName` tinytext NOT NULL,
  `msgtime` int(10) unsigned NOT NULL default '0',
  `subject` tinytext NOT NULL,
  `body` text NOT NULL,
  PRIMARY KEY  (`ID_PM`),
  KEY `ID_MEMBER` (`ID_MEMBER_FROM`,`deletedBySender`),
  KEY `msgtime` (`msgtime`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `smfweb_pm_recipients` (
  `ID_PM` int(10) unsigned NOT NULL default '0',
  `ID_MEMBER` mediumint(8) unsigned NOT NULL default '0',
  `labels` varchar(60) NOT NULL default '-1',
  `bcc` tinyint(3) unsigned NOT NULL default '0',
  `is_read` tinyint(3) unsigned NOT NULL default '0',
  `deleted` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID_PM`,`ID_MEMBER`),
  UNIQUE KEY `ID_MEMBER` (`ID_MEMBER`,`deleted`,`ID_PM`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `smfweb_poll_choices` (
  `ID_POLL` mediumint(8) unsigned NOT NULL default '0',
  `ID_CHOICE` tinyint(3) unsigned NOT NULL default '0',
  `label` tinytext NOT NULL,
  `votes` smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID_POLL`,`ID_CHOICE`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


-- --------------------------------------------------------


CREATE TABLE IF NOT EXISTS `smfweb_polls` (
  `ID_POLL` mediumint(8) unsigned NOT NULL auto_increment,
  `question` tinytext NOT NULL,
  `votingLocked` tinyint(1) NOT NULL default '0',
  `maxVotes` tinyint(3) unsigned NOT NULL default '1',
  `expireTime` int(10) unsigned NOT NULL default '0',
  `hideResults` tinyint(3) unsigned NOT NULL default '0',
  `changeVote` tinyint(3) unsigned NOT NULL default '0',
  `ID_MEMBER` mediumint(8) unsigned NOT NULL default '0',
  `posterName` tinytext NOT NULL,
  PRIMARY KEY  (`ID_POLL`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



-- --------------------------------------------------------


CREATE TABLE IF NOT EXISTS `smfweb_sessions` (
  `session_id` char(32) NOT NULL,
  `last_update` int(10) unsigned NOT NULL,
  `data` text NOT NULL,
  PRIMARY KEY  (`session_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




-- --------------------------------------------------------


CREATE TABLE IF NOT EXISTS `smfweb_settings` (
  `variable` tinytext NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY  (`variable`(30))
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



-- --------------------------------------------------------


CREATE TABLE IF NOT EXISTS `smfweb_smileys` (
  `ID_SMILEY` smallint(5) unsigned NOT NULL auto_increment,
  `code` varchar(30) NOT NULL default '',
  `filename` varchar(48) NOT NULL default '',
  `description` varchar(80) NOT NULL default '',
  `smileyRow` tinyint(4) unsigned NOT NULL default '0',
  `smileyOrder` smallint(5) unsigned NOT NULL default '0',
  `hidden` tinyint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID_SMILEY`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=latin1 AUTO_INCREMENT=20 ;



-- --------------------------------------------------------


CREATE TABLE IF NOT EXISTS `smfweb_themes` (
  `ID_MEMBER` mediumint(8) NOT NULL default '0',
  `ID_THEME` tinyint(4) unsigned NOT NULL default '1',
  `variable` tinytext NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY  (`ID_THEME`,`ID_MEMBER`,`variable`(30)),
  KEY `ID_MEMBER` (`ID_MEMBER`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `smfweb_topics` (
  `ID_TOPIC` mediumint(8) unsigned NOT NULL auto_increment,
  `isSticky` tinyint(4) NOT NULL default '0',
  `ID_BOARD` smallint(5) unsigned NOT NULL default '0',
  `ID_FIRST_MSG` int(10) unsigned NOT NULL default '0',
  `ID_LAST_MSG` int(10) unsigned NOT NULL default '0',
  `ID_MEMBER_STARTED` mediumint(8) unsigned NOT NULL default '0',
  `ID_MEMBER_UPDATED` mediumint(8) unsigned NOT NULL default '0',
  `ID_POLL` mediumint(8) unsigned NOT NULL default '0',
  `numReplies` int(10) unsigned NOT NULL default '0',
  `numViews` int(10) unsigned NOT NULL default '0',
  `locked` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`ID_TOPIC`),
  UNIQUE KEY `lastMessage` (`ID_LAST_MSG`,`ID_BOARD`),
  UNIQUE KEY `firstMessage` (`ID_FIRST_MSG`,`ID_BOARD`),
  UNIQUE KEY `poll` (`ID_POLL`,`ID_TOPIC`),
  KEY `isSticky` (`isSticky`),
  KEY `ID_BOARD` (`ID_BOARD`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

