<?php

/* Reminder: always indent with 4 spaces (no tabs). */
// +---------------------------------------------------------------------------+
// WebSite:  http://www.webexperts.co.th
// Unauthorized copying is strictly forbidden and may result in severe legal action.
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// 
// =====YOU MUST KEEP THIS COPYRIGHTS NOTICE INTACT AND CAN NOT BE REMOVE =======
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// This Agreement is a legal contract, which specifies the terms of the license
// and warranty limitation between you and Web Experts Co.,Ltd. and RV Site Builder.
// You should carefully read the following terms and conditions before
// installing or using this software.  Unless you have a different license
// agreement obtained from Web Experts Co.,Ltd., installation or use of this software
// indicates your acceptance of the license and warranty limitation terms
// contained in this Agreement. If you do not agree to the terms of this
// Agreement, promptly delete and destroy all copies of the Software.
//
// =====  Grant of License =======
// The Software may only be installed and used on a single host machine.
//
// =====  Disclaimer of Warranty =======
// THIS SOFTWARE AND ACCOMPANYING DOCUMENTATION ARE PROVIDED "AS IS" AND
// WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR ANY OTHER
// WARRANTIES WHETHER EXPRESSED OR IMPLIED.   BECAUSE OF THE VARIOUS HARDWARE
// AND SOFTWARE ENVIRONMENTS INTO WHICH RV SITE BUILDER MAY BE USED, NO WARRANTY OF
// FITNESS FOR A PARTICULAR PURPOSE IS OFFERED.  THE USER MUST ASSUME THE
// ENTIRE RISK OF USING THIS PROGRAM.  ANY LIABILITY OF Web Experts Co.,Ltd. WILL BE
// LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT OR REFUND OF PURCHASE PRICE.
// IN NO CASE SHALL Web Experts Co.,Ltd. BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
// CONSEQUENTIAL DAMAGES OR LOSS, INCLUDING, WITHOUT LIMITATION, LOST PROFITS
// OR THE INABILITY TO USE EQUIPMENT OR ACCESS DATA, WHETHER SUCH DAMAGES ARE
// BASED UPON A BREACH OF EXPRESS OR IMPLIED WARRANTIES, BREACH OF CONTRACT,
// NEGLIGENCE, STRICT TORT, OR ANY OTHER LEGAL THEORY. THIS IS TRUE EVEN IF
// Web Experts Co.,Ltd. IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. IN NO CASE WILL
// Web Experts Co.,Ltd.'S LIABILITY EXCEED THE AMOUNT OF THE LICENSE FEE ACTUALLY PAID
// BY LICENSEE TO Web Experts Co.,Ltd.

class stereomicroscope_Block_StereoLatestBlock
{
    var $template     = 'blockLatestStereo.html';
    var $templatePath = 'stereomicroscope';
    var $webRoot = SGL_BASE_URL;

    function stereomicroscope_Block_StereoLatestBlock()
    {
        $c = &SGL_Config::singleton();
        $this->dbh = & SGL_DB::singleton();
        $this->roleID = SGL_Session::getRoleId();
        $this->blockConf = $c->ensureModuleConfigLoaded('stereomicroscope'); 
    }
    
    function init(&$output, &$blockID, &$aParams)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        return $this->getBlockContent($output, &$aParams);
    }

    function getBlockContent($output, &$aParams)
    {
        return $this->process($output, &$aParams);
    }
    
    function process($output, &$aParams)
    {
        $output->moduleName     = $this->templatePath;
        $output->masterTemplate = $this->template;
        $output->webRoot = $this->webRoot;
        
         
        $output->aStereo = $this->retrieveAll($output);
        $view = new SGL_HtmlSimpleView($output);
        return $view->render();
    }
    
    function retrieveAll($output)
    {
        $langID = 1;
        $limit = 1;
        $aData = array();
        $query = "SELECT 
                                p.article_id
                                , p.article_type_id
                                , m.title
                                , m.message
                                , m.extra_field1
                            FROM 
                                {$this->blockConf['table']['product']} p
                                , {$this->blockConf['table']['product_type']} t
                                , {$this->blockConf['table']['product_message']} m
                            WHERE t.type_icon = ''
                            AND t.article_type_id != '1'
                            AND t.article_type_id != '2'
                            AND t.article_type_id != '3'
                            AND t.article_type_id != '4'
                            AND p.article_type_id = t.article_type_id
                            AND m.web_lang_id = '{$langID}'
                            AND m.article_id = p.article_id
                            ORDER BY
                                 p.article_id DESC
                           LIMIT 0 , {$limit}";
        $aData = $this->dbh->getRow($query, DB_FETCHMODE_ASSOC);
        
        if (count($aData) > 0) {
            $aData['imgDetail'] = $this->getImageProduct($aData['article_id']);
        }
        
        return $aData;
    }
    
    function getImageProduct($productID)
    {
        $aImg = array();
        $query = "SELECT *
                           FROM {$this->blockConf['table']['product_images']} 
                           WHERE article_id = '{$productID}'";
         $aImg = $this->dbh->getRow($query, DB_FETCHMODE_ASSOC);
        return $aImg;
    }
}
?>