<?php

/* Reminder: always indent with 4 spaces (no tabs). */
// +---------------------------------------------------------------------------+
// WebSite:  http://www.webexperts.co.th
// Unauthorized copying is strictly forbidden and may result in severe legal action.
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// 
// =====YOU MUST KEEP THIS COPYRIGHTS NOTICE INTACT AND CAN NOT BE REMOVE =======
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// This Agreement is a legal contract, which specifies the terms of the license
// and warranty limitation between you and Web Experts Co.,Ltd. and RV Site Builder.
// You should carefully read the following terms and conditions before
// installing or using this software.  Unless you have a different license
// agreement obtained from Web Experts Co.,Ltd., installation or use of this software
// indicates your acceptance of the license and warranty limitation terms
// contained in this Agreement. If you do not agree to the terms of this
// Agreement, promptly delete and destroy all copies of the Software.
//
// =====  Grant of License =======
// The Software may only be installed and used on a single host machine.
//
// =====  Disclaimer of Warranty =======
// THIS SOFTWARE AND ACCOMPANYING DOCUMENTATION ARE PROVIDED "AS IS" AND
// WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR ANY OTHER
// WARRANTIES WHETHER EXPRESSED OR IMPLIED.   BECAUSE OF THE VARIOUS HARDWARE
// AND SOFTWARE ENVIRONMENTS INTO WHICH RV SITE BUILDER MAY BE USED, NO WARRANTY OF
// FITNESS FOR A PARTICULAR PURPOSE IS OFFERED.  THE USER MUST ASSUME THE
// ENTIRE RISK OF USING THIS PROGRAM.  ANY LIABILITY OF Web Experts Co.,Ltd. WILL BE
// LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT OR REFUND OF PURCHASE PRICE.
// IN NO CASE SHALL Web Experts Co.,Ltd. BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
// CONSEQUENTIAL DAMAGES OR LOSS, INCLUDING, WITHOUT LIMITATION, LOST PROFITS
// OR THE INABILITY TO USE EQUIPMENT OR ACCESS DATA, WHETHER SUCH DAMAGES ARE
// BASED UPON A BREACH OF EXPRESS OR IMPLIED WARRANTIES, BREACH OF CONTRACT,
// NEGLIGENCE, STRICT TORT, OR ANY OTHER LEGAL THEORY. THIS IS TRUE EVEN IF
// Web Experts Co.,Ltd. IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. IN NO CASE WILL
// Web Experts Co.,Ltd.'S LIABILITY EXCEED THE AMOUNT OF THE LICENSE FEE ACTUALLY PAID
// BY LICENSEE TO Web Experts Co.,Ltd.

require_once SGL_MOD_DIR . '/articleweb/classes/AdminArticleTypeWebMgr.php';

class AdminStereoMicroscopeTypeMgr extends AdminArticleTypeWebMgr
{
    function AdminStereoMicroscopeTypeMgr()
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        parent::AdminArticleTypeWebMgr();
        
        $this->template     = 'stereoManager.html';
        $this->pageTitle = 'Admin Stereo Microsope Type';
        $this->ImagePath =  'images/stereomicroscope/';
        
        /// START aActionsMapping cmd for Stereo Microscope
        $this->_aActionsMapping['viewgroup'] = array('view');
        $this->_aActionsMapping['viewseries'] = array('viewseries');
        $this->_aActionsMapping['addSeries'] = array('addSeries','viewseries');
        $this->_aActionsMapping['editViewSeries'] = array('editViewSeries');
        $this->_aActionsMapping['editSeries'] = array('editSeries','viewseries');
        $this->_aActionsMapping['deleteSeries'] = array('deleteSeries','viewseries');
        $this->_aActionsMapping['changeStatus'] = array('changeStatus', 'view');
        /// END --------------------------------------------------------------------
    }
    
    function validate($req, &$input)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        parent::validate($req, $input);
        
        //////////////////////////////////////// req byproject ////////////////////////////////////
        $input->groupID = $req->get('groupID');
        $input->changeTo = $req->get('changeTo');
        $input->seriesName = $req->get('seriesName');
        $input->seriesID = $req->get('seriesID');
        $input->seriesStatus = $req->get('seriesStatus');
    }
    
    
    function display(&$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        parent::display($output);
    }
    
    
    function _customaErrorByAction(&$input, &$aErrors)
    {
        switch ($input->action) {
            case "deleteSeries":
                if ($aErrors['isHaveProductIDOndeleteSeries'] != '') {
                    $input->action = 'viewseries';
                    $input->template = 'seriesManager.html';
                }
                break;
        }
    }
    
    
    ////////////////////////////// CMD ///////////////////////////
    function _cmd_viewseries(&$input, &$output)
    {
        $limit = $_SESSION['aPrefs']['resPerPage'];
        $aSeriesData = array();
        if ($input->groupID == '') {
            $aSeriesData = $this->getAllSeriesData($limit);
        } else {
            $aSeriesData = $this->getAllSeriesDataByGroupID($input->groupID, 10);
            $output->groupData = $this->getGroupDataByGroupID($input->groupID);
        }

        $aGroupData = $this->getAllGroupData();
        $aGroupSelect = array();
        foreach ($aGroupData as $groupK => $groupV) {
            $id = $groupV['article_type_id'];
            $aGroupSelect[$id] = $groupV['type_name'];
        }
        
        if (isset($aSeriesData['data']) && count($aSeriesData['data']) > 0) {
            foreach ($aSeriesData['data'] as $seKey => $seVal) {
                $aSeriesData['data'][$seKey]['groupdata'] = $this->getGroupDataByGroupID($seVal['article_type_id']);
            }
        }
        
        $output->aGroupSelect = $aGroupSelect;
        $output->aGroupData = $aGroupData;
        $output->groupSeriesName = (isset($aGroupData['type_name']) && $aGroupData['type_name'] != '') ? 'View :' . $aGroupData['type_name'] : 'View : all series type';
        $output->aSeriesData = $aSeriesData;
        $output->idGroupSelected = ($input->groupID) ? $input->groupID : '';
        //--------------------------------------------------------------------------------
        
    }
    
    ////////////////////////////// CMD ///////////////////////////
    function _cmd_addSeries(&$input, &$output)
    {
        SGL::logMessage("CMD :: addSeries", PEAR_LOG_DEBUG);
        if ($input->groupID == '' || $input->seriesName == '') {
            return false;
        }
        
        $aSeriesData['groupID'] = $input->groupID;
        $aSeriesData['seriesName'] = $input->seriesName;
        $aSeriesData['status'] = '1';
        $this->changeSeriesData('add', '', $aSeriesData);
    }
    
    ////////////////////////////// CMD ///////////////////////////
    function _cmd_editSeries(&$input, &$output)
    {
        SGL::logMessage("CMD :: editSeries", PEAR_LOG_DEBUG);
        if ($input->groupID == '' && $input->seriesName == '') {
            return false;
        }
        
        $aSeriesData['groupID'] = $input->groupID;
        $aSeriesData['seriesName'] = $input->seriesName;
        $aSeriesData['status'] = $input->seriesStatus;
        $this->changeSeriesData('edit', $input->seriesID, $aSeriesData);
    }
    
    ////////////////////////////// CMD ///////////////////////////
    function _cmd_changeStatus(&$input, &$output)
    {
        SGL::logMessage("CMD :: changeStatus", PEAR_LOG_DEBUG);
        if ($input->groupID == '') {
            return false;
        }
        
        //---------------------- //// change status : enable / disable //// -------------------------
        $aGroup = $this->getGroupStatus($input->groupID);
        if (count($aGroup) > 0) {
            $this->changeGroupStatusTo('edit', $input->groupID, $input->changeTo);
        } else {
            $this->changeGroupStatusTo('add', $input->groupID, $input->changeTo);
        }
    }
    
    ////////////////////////////// CMD ///////////////////////////
    function _cmd_deleteSeries(&$input, &$output)
    {
        SGL::logMessage("CMD :: Delete Series", PEAR_LOG_DEBUG);
        if (is_array($input->frmDelete) && count($input->frmDelete) > 0) {
            foreach ($input->frmDelete as $seriesID) {
                $this->deleteSeriesData($seriesID);
            }
        } elseif (is_string($input->frmDelete) && $input->frmDelete != '') {
            $this->deleteSeriesData($input->frmDelete);
        }
    }
    
    
    //////////////////////////////// CMD //////////////////////////
    function _cmd_editViewSeries(&$input, &$output)
    {
        $output ->pageTitle = 'Admin Series Edit';
        $output->seriesID = $input->seriesID;
        $output->aSeries = $this->getSeriesDetail($input->seriesID);
        $output->seriesStatus = $output->aSeries['status'];
        $output->groupID = $output->aSeries['article_type_id'];
    }
    
    
    //------------------------------ custom manage -----------------------------------------
    ///////////////////////////// customUseTemplatebyAction /////////////////////////////
    
    function _customUseTemplatebyAction(&$template, $action)
    {
          switch ($action) {
            case "view":
                $template     = 'groupStereoManager.html';
                break;
            case "viewseries":
            case "editSeries":
            case "deleteSeries":
            case "addSeries":
                $template     = 'seriesManager.html';
                break;
            case "addview":
                $template     = 'groupStereoEdit.html';
                break;
            case "editview":
                $template     = 'groupStereoEdit.html';
                break;
            case "editViewSeries":
                $template     = 'seriesStereoEdit.html';
                break;
            case "changeStatus":
                $template     = 'groupStereoManager.html';
                break;
        }
        SGL::logMessage("Template = " . $template, PEAR_LOG_DEBUG);
    }
    
    /////////////////////////////////// customInputByAction ////////////////////////////////////
     function _customInputByAction($action, $req, &$input)
     {
         switch ($action) {
            case "viewgroup":
                $input->action = 'view';
                $input->pageTitle = 'Admin Group Manager';
                break;
            case "viewseries":
                $input->pageTitle = 'Admin Series Manager';
                break;
            case "addview":
                break;
            case "add":
                $input->frmPerms = $this->getAllPerms();
                break;
            case "edit":
                $input->frmPerms = $this->getAllPerms();
                break;
        }
     }
     
     
     ////////////////////////////////////// customQueryData //////////////////////////////////////////
     function _customQueryData($action, $input, $queryNumber, &$aDataQuery)
     {
         switch ($action) {
             case "view":
                 if ($queryNumber == 2) {
                     $aDataQuery[$queryNumber]['adjustWhere'] = " AND a.type_icon != '1'";
                     $aDataQuery[$queryNumber]['adjustWhere'] .= " AND a.article_type_id != '1'";
                     $aDataQuery[$queryNumber]['adjustWhere'] .= " AND a.article_type_id != '2'";
                     $aDataQuery[$queryNumber]['adjustWhere'] .= " AND a.article_type_id != '3'";
                     $aDataQuery[$queryNumber]['adjustWhere'] .= " AND a.article_type_id != '4'";
                 }
                 break;
             case "add":
                 if ($queryNumber == 1) {
                     $this->changeGroupStatusTo('add', $aDataQuery[$queryNumber]['article_type_id']);
                 }
                 break;
         }
     }
     
     
     ////////////////////////////////////// customOutputCMD //////////////////////////////////////
     function _customOutputCMD($action, $input, &$output)
     {
         switch ($action) {
             case "view":
                 foreach ($output->aPagedData['data'] as $k => $v) {
                    $output->aPagedData['data'][$k]['groupDetail'] = $this->getGroupStatus($v['article_type_id']);
                 }
                 break;
             case "delete":
                 if (is_array($input->frmDelete)) {
                     foreach ($input->frmDelete as $groupID) {
                        $this->deleteGroupStatus($groupID);
                     }
                     
                 } elseif (is_string($input->frmDelete)) {
                     $this->deleteGroupStatus($input->frmDelete);
                 }
                 break;
         }
     }
     
     /////////////////////////////// _customCommondInput ////////////////////////////////
     function _customCommondInput($req, &$input)
     {
         switch ($input->action) {
             case "delete":
                 if (!is_array($input->frmDelete) && $input->frmDelete != '') {
                     $id = $input->frmDelete;
                     $input->frmDelete = array();
                     $input->frmDelete[$id] = $id;
                 }
                 break;
         }
     }
     
     
     /////////////////////////////// _customCommondValidate ////////////////////////////////
     function _customCommondValidate($input, &$aErrors)
     {
         switch ($input->action) {
             case "delete":
                 $er = array();
                 foreach ($input->frmDelete as $k => $v) {
                     $aCheck = $this->validateDeleteGroup($v);
                     if ($aCheck == true) {
                         $er[] = $v;
                         
                     }
                 }
                 
                 if (count($er) > 0) {
                     $a = '';
                     foreach ($er as $erK => $erV) {
                         $a .= ($a == '') ? $erV : ',' . $erV;
                     }
                     $aErrors["aDeleteGroupError"] = SGL_Output::translate('Please move Series out category for delete.') . 'group id' .  $a . " file";
                 }
                 break;
             case "deleteSeries":
                 //---------------------------------  CHECK  DELETE SERIES ---------------------------------
                 if (is_array($input->frmDelete) && count($input->frmDelete) > 0) {
                    foreach ($input->frmDelete as $k) {
                        $checkHaveData = $this->validateDeleteSeries($k);
                        if ($checkHaveData == true) {
                            $aErrors['isHaveProductIDOndeleteSeries'] = ' Series is have product on this series!';
                        }
                    }
                 } elseif (is_string($input->frmDelete) && $input->frmDelete != '') {
                    $checkHaveData = $this->validateDeleteSeries($input->frmDelete);
                    if ($checkHaveData == true) {
                         $aErrors['isHaveProductIDOndeleteSeries'] = ' Series is have product on this series!';
                    }
                 }
                 break;
         }
     }
    // ----------------------------------- common function ----------------------------------------
    # for get all role to action add / edit
    function getAllPerms()
    {
        $aPerms = array();
        $query = "SELECT `role_id`
                            FROM `{$this->conf['table']['role']}` ";
        $aData = $this->dbh->getAll($query, DB_FETCHMODE_ASSOC);
        
        foreach ($aData as $k => $v) {
            if ($v['role_id'] != '-1') {
                $aPerms[$v['role_id']] = $v['role_id'];
            }
        }
        return $aPerms;
    }
    
    
    //---------------------------------------------- function ---------------------------------------------
    /**
     * get all data in group id
     * Query is {getRow}
     * 
     * @param <string> $typeID
     * @return <array>
     * 
     * Ex: array(
     *              status => 0 or 1,
     *              date_create => '{ time(); }'
     *          );
     * 
     */
    function getGroupStatus($typeID = '')
    {
        $aData = array();
        if ($typeID == '') {
            return array();
        }
        $query = "SELECT 
                                status
                                , date_create
                            FROM `{$this->conf['table']['product_group_status']}` 
                            WHERE article_type_id = '{$typeID}'";
        $aData = $this->dbh->getRow($query, DB_FETCHMODE_ASSOC);
        return $aData;
    }
    
    
    //---------------------------------------------- function ---------------------------------------------
    function deleteGroupStatus($groupID = '')
    {
        if ($groupID == '') {
            return false;
        }
        
        $query = "DELETE FROM `{$this->conf['table']['product_group_status']}` 
                            WHERE `article_type_id` = '{$groupID}' 
                            LIMIT 1;";
         $this->dbh->query($query);
    }
    
    
    //---------------------------------------------- function ---------------------------------------------
    function deleteSeriesData($seriesID)
    {
        if ($seriesID == '') {
            return false;
        }
        
        $query = "DELETE FROM `{$this->conf['table']['product_series']}` 
                            WHERE `series_id` = '{$seriesID}' 
                            LIMIT 1;";
        $this->dbh->query($query);
        return true;
    }
    
    
    //---------------------------------------------- function ---------------------------------------------
    function validateDeleteSeries($seriesID)
    {
        /// check product in series
        $aAllData = array();
        $query = "SELECT article_id
                           FROM `{$this->conf['table']['product_message']}` 
                           WHERE     extra_field2 = '{$seriesID}'";
        $aAllData = $this->dbh->getAll($query, DB_FETCHMODE_ASSOC);
        if (count($aAllData) > 0) {
            return true;
        } else {
            return false;
        }
    }
    
    
    function validateDeleteGroup($groupID)
    {
        $aData = array();
        $aData = $this->getAllSeriesDataByGroupID($groupID);
        if (count($aData['data']) > 0) {
            return true;
        } else {
            return false;
        }
    }
    
    //---------------------------------------------- function ---------------------------------------------
    function changeGroupStatusTo($action, $groupID, $changeTo = 1)
    {
        $time = time();
        switch ($action) {
            case "add":
                $query = "INSERT INTO `{$this->conf['table']['product_group_status']}` ( 
                                            `article_type_id` 
                                            , `status` 
                                            , `date_create` 
                                    ) VALUES (
                                            '{$groupID}'
                                            , '{$changeTo}'
                                            , '{$time}' );";
                $this->dbh->query($query);
                break;
            case "edit":
                $query = "UPDATE `{$this->conf['table']['product_group_status']}` 
                                    SET 
                                        `status` = '{$changeTo}',
                                        `date_create` = '{$time}' 
                                    WHERE `article_type_id` ='{$groupID}' 
                                    LIMIT 1 ;";
                $this->dbh->query($query);
                break;
        }
    }
    
    
    //---------------------------------------------- function ---------------------------------------------
    /**
     * Enter description here...
     *
     * @param unknown_type $limit
     * @param unknown_type $delta
     * @return unknown
     *  
     * Ex : return
     *         $aSeries = array(
                                    '1' => array(
                                                        'series_id' => '1'
                                                        ,'article_type_id' => '6'
                                                        , 'series_name' => 'xxxxx1'
                                                        , 'status' => '1'
                                                        , 'date_create' => '1231212563'
                                                    ));
     */
    function getAllSeriesData($limit = 20,$delta = 3)
    {
        $aSeries = array();
        $query = "SELECT 
                                series_id
                                , article_type_id
                                , series_name
                                , status
                                , date_create
                           FROM `{$this->conf['table']['product_series']}` ";
                           
        $pagerOptions = array(
            'mode'     => 'Sliding',
            'delta'    => $delta,
            'perPage'  => $limit,
            'spacesBeforeSeparator' => 0,
            'spacesAfterSeparator'  => 0,
            'curPageSpanPre'        => '<span class="currentPage">',
            'curPageSpanPost'       => '</span>',
        );
        
        $aSeries = SGL_DB::getPagedData($this->dbh, $query, $pagerOptions);
        return $aSeries;
    }
    
    
    //---------------------------------------------- function ---------------------------------------------
    function getAllSeriesDataByGroupID($groupID, $limit = 10, $delta = 3)
    {
        $aSeries = array();
        $query = "SELECT 
                                series_id
                                , article_type_id
                                , series_name
                                , status
                                , date_create
                           FROM `{$this->conf['table']['product_series']}` 
                           WHERE article_type_id = {$groupID}";
                           
        $pagerOptions = array(
            'mode'     => 'Sliding',
            'delta'    => $delta,
            'perPage'  => $limit,
            'spacesBeforeSeparator' => 0,
            'spacesAfterSeparator'  => 0,
            'curPageSpanPre'        => '<span class="currentPage">',
            'curPageSpanPost'       => '</span>',
        );
        
        $aSeries = SGL_DB::getPagedData($this->dbh, $query, $pagerOptions);
        return $aSeries;
    }
    
    
    //---------------------------------------------- function ---------------------------------------------
    function getAllGroupData()
    {
        $aGroupData = array();
        $webLangID = 1;//1 = en
        $query = "SELECT 
                                a.article_type_id, at.type_name, at.description, a.type_icon
                           FROM 
                                {$this->conf['table']['article_type']} a
                                , {$this->conf['table']['article_type_message']} at
                           WHERE 
                                at.web_lang_id ={$webLangID}
                           AND a.article_type_id = at.article_type_id
                           AND a.type_icon != '1'
                           AND a.article_type_id != '1'
                           AND a.article_type_id != '2'
                           AND a.article_type_id != '3'
                           AND a.article_type_id != '4'";
        $aGroupData = $this->dbh->getAll($query, DB_FETCHMODE_ASSOC);
        return $aGroupData;
    }
    
    
    //---------------------------------------------- function ---------------------------------------------
    function getGroupDataByGroupID($groupID)
    {
        $aGroupData = array();
        $webLangID = 1;//1 = en
        $query = "SELECT 
                                a.article_type_id, at.type_name, at.description, a.type_icon
                           FROM 
                                {$this->conf['table']['article_type']} a
                                , {$this->conf['table']['article_type_message']} at
                           WHERE 
                                at.web_lang_id ={$webLangID}
                           AND a.article_type_id = at.article_type_id
                           AND a.article_type_id = '{$groupID}'";
        $aGroupData = $this->dbh->getRow($query, DB_FETCHMODE_ASSOC);
        return $aGroupData;
    }
    
    
    //---------------------------------------------- function ---------------------------------------------
    function changeSeriesData($action, $seriesID, $aSeriesData)
    {
        $time = time();
        switch ($action) {
            case "add":
                $seriesID = $this->dbh->nextId($this->conf['table']['product_series']);
                $query = "INSERT INTO `{$this->conf['table']['product_series']}` ( 
                                            `series_id` 
                                            , `article_type_id` 
                                            , `series_name` 
                                            , `status` 
                                            , `date_create` 
                                    ) VALUES (
                                            '{$seriesID}'
                                            , '{$aSeriesData['groupID']}'
                                            , '{$aSeriesData['seriesName']}'
                                            , '{$aSeriesData['status']}'
                                            , '{$time}'
                                    );";
                $this->dbh->query($query);
                break;
            case "edit":
                $query = "UPDATE `web_product_series` 
                                   SET `article_type_id` = '{$aSeriesData['groupID']}',
                                             `series_name` = '{$aSeriesData['seriesName']}',
                                             `status` = '{$aSeriesData['status']}',
                                             `date_create` = '{$time}' 
                                    WHERE `series_id` = '{$seriesID}' 
                                    LIMIT 1 ;";
                $this->dbh->query($query);
                break;
        }
    }
    
    function getSeriesDetail($seriesID)
    {
         SGL::logMessage(null, PEAR_LOG_DEBUG);
        $query = "SELECT  
                                article_type_id
                                , series_name
                                , status
                                , date_create
                            FROM `{$this->conf['table']['product_series']}` 
                            WHERE series_id = '{$seriesID}'";
        $result = $this->dbh->getRow($query,DB_FETCHMODE_ASSOC);
        PEAR::isError($result);
        return $result;
    }
}
?>