<?php

/* Reminder: always indent with 4 spaces (no tabs). */
// +---------------------------------------------------------------------------+
// WebSite:  http://www.webexperts.co.th
// Unauthorized copying is strictly forbidden and may result in severe legal action.
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// 
// =====YOU MUST KEEP THIS COPYRIGHTS NOTICE INTACT AND CAN NOT BE REMOVE =======
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// This Agreement is a legal contract, which specifies the terms of the license
// and warranty limitation between you and Web Experts Co.,Ltd. and RV Site Builder.
// You should carefully read the following terms and conditions before
// installing or using this software.  Unless you have a different license
// agreement obtained from Web Experts Co.,Ltd., installation or use of this software
// indicates your acceptance of the license and warranty limitation terms
// contained in this Agreement. If you do not agree to the terms of this
// Agreement, promptly delete and destroy all copies of the Software.
//
// =====  Grant of License =======
// The Software may only be installed and used on a single host machine.
//
// =====  Disclaimer of Warranty =======
// THIS SOFTWARE AND ACCOMPANYING DOCUMENTATION ARE PROVIDED "AS IS" AND
// WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR ANY OTHER
// WARRANTIES WHETHER EXPRESSED OR IMPLIED.   BECAUSE OF THE VARIOUS HARDWARE
// AND SOFTWARE ENVIRONMENTS INTO WHICH RV SITE BUILDER MAY BE USED, NO WARRANTY OF
// FITNESS FOR A PARTICULAR PURPOSE IS OFFERED.  THE USER MUST ASSUME THE
// ENTIRE RISK OF USING THIS PROGRAM.  ANY LIABILITY OF Web Experts Co.,Ltd. WILL BE
// LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT OR REFUND OF PURCHASE PRICE.
// IN NO CASE SHALL Web Experts Co.,Ltd. BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
// CONSEQUENTIAL DAMAGES OR LOSS, INCLUDING, WITHOUT LIMITATION, LOST PROFITS
// OR THE INABILITY TO USE EQUIPMENT OR ACCESS DATA, WHETHER SUCH DAMAGES ARE
// BASED UPON A BREACH OF EXPRESS OR IMPLIED WARRANTIES, BREACH OF CONTRACT,
// NEGLIGENCE, STRICT TORT, OR ANY OTHER LEGAL THEORY. THIS IS TRUE EVEN IF
// Web Experts Co.,Ltd. IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. IN NO CASE WILL
// Web Experts Co.,Ltd.'S LIABILITY EXCEED THE AMOUNT OF THE LICENSE FEE ACTUALLY PAID
// BY LICENSEE TO Web Experts Co.,Ltd.

require_once SGL_MOD_DIR . '/articleweb/classes/ArticleViewWebMgr.php';
      
class StereoMicroscopeViewMgr extends ArticleViewWebMgr
{
    function StereoMicroscopeViewMgr()
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        parent::ArticleViewWebMgr();
    }
    
    function validate($req, &$input)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        parent::validate($req, $input);
        $input->seriesID =  $req->get('seriesID');
        $input->aticleID = $req->get('frmAticleId');
    }
    
function display(&$output)
    {
        parent:: display($output);       
       $output->addJavascriptFile('js/scriptaculous/lib/prototype.js');
       $output->addJavascriptFile('js/scriptaculous/src/effects.js');
       $output->addJavascriptFile('js/lightbox/lightbox.js');
       $output->addJavascriptFile('js/preLoadImage.js');
       $output->addJavascriptFile('js/tooltip.js');
       $output->addCssFile('js/lightbox/css/lightbox.css');
       
       //-------------- FOR IMAGESOVER ------------------
       $output->overWidth = 100;
       $output->overHeight = 150;
        
       if (is_array( $output->preLoadImag)) {
            $image = join( "','", $output->preLoadImage);
        } else {
             $image = $output->preLoadImage;
        }
       
       $output->addOnLoadEvent("PreLoadImage(['" . $image . "'])");
        
    }

    function _customCommondInput($req, &$input)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $input->newseventTypeId = 2; //case tips = 1and news & event = 2
        $this->template     = 'viewStereomicroscopeBySeries.html';
        $this->conf['Default']['defaultLang'] = 'en-utf-8';        
        $this->conf['ArticleViewWebMgr']['maxLastArticleForType'] = 5;

    }
    
    function _customUseTemplatebyAction(&$template, $action)
    {
        $template = 'viewStereomicroscopeBySeries.html';
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        /// If you want to custom validate action edit, please edit here!!
        switch ($action) {
            case "viewArticle":                
                $template = 'viewStereomicroscope.html';
                
                break;
            case "viewArticleType":
                $template = 'viewStereomicroscopeBySeries.html';
                break;
            
        }
    }
    
    function getProductImage($articleID)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $query = sprintf("
                    SELECT
                    		*
                    FROM
                    		{$this->conf['table']['product_images']}
				    WHERE
				            article_id = '%s'
                    "
				    ,$articleID );				    
	    $result = $this->dbh->getRow($query,DB_FETCHMODE_ASSOC);
	    PEAR::isError($result);	    
	    return $result;
    }
    
    function _customQueryData($action, $input, $queryNumber = null, &$aDataQuery)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        if ($queryNumber == null) {
            return ;
        }
        
        switch ($action) {
            case "viewArticle":
                break;
            case "viewArticleType":
                if($queryNumber == 4) {
                    $aDataQuery[$queryNumber]['adjustWhere'] = 'AND am.extra_field2 = '. $input->seriesID;
                }
                break;

        }
        
    }
    
    function _customOutputCMD($action, $input, &$output)
    {  
        $input->seriesID = isset($input->seriesID) ? $input->seriesID: $output->extraField2;
        if($input->seriesID) {
            $output->typeName = $this->getGroupNameBySeries($input->seriesID);
            $output->seriesName = $this->getSeriesName($input->seriesID);
        } else {
            $output->typeName = $this->getGroupNameByArticle($input->articleID);
            $output->seriesName = $this->getSeriesNameByArticle($input->articleID);
        }        
		
        switch ($action) {
            case "viewArticle":
                $aImage = $this->getProductImage($input->frmArticleID);                
                $output->imageDetail = $aImage['image_path'] . $aImage['image_name'];
                $output->imageDetailM = $aImage['image_path'] . 'm_' . $aImage['image_name'];
                $output->property = $this->getProductProperty($input->frmArticleID);
                $output->frmArticleTypeID = $this->getGroupIDByArticle($input->frmArticleID);                
                break;
            case "viewArticleType":        
                $output->preLoadImage = array();        
                $aPagedData = $output->aPagedData['data'];                
                foreach($aPagedData as $k => $v) {
                    $output->aPagedData['data'][$k]['property'] = $this->getProductProperty($v['article_id']);
                    $aImage = $this->getProductImage($v['article_id']);
                    if (count($aImage) > 0) {
                        //$img1 = $aImage['image_path'] . $aImage['image_name'];
                        $output->aPagedData['data'][$k]['imageDetail'] = (is_file($aImage['image_path'] . $aImage['image_name'])) ? 
                                $aImage['image_path'] . $aImage['image_name'] : '';//(is_file($img1)) ? $img1 : '';
                        $output->aPagedData['data'][$k]['imageDetail_s'] = (is_file($aImage['image_path'] . 's_' . $aImage['image_name'])) ? 
                                $aImage['image_path'] . 's_' . $aImage['image_name'] : $output->aPagedData['data'][$k]['imageDetail'];
                        $output->aPagedData['data'][$k]['imageDetail_m'] = (is_file($aImage['image_path'] . 'm_' . $aImage['image_name'])) ?
                                $aImage['image_path'] . 'm_' . $aImage['image_name'] : $output->aPagedData['data'][$k]['imageDetail'];
                        
                                
                        $output->preLoadImage[$k] = $output->aPagedData['data'][count($output->preLoadImage)]['imageDetail_m'];
                        $imagesSize = array();
                        $width = '';
                        $height = '';
                        
                        $imagesSize = getimagesize($aImage['image_path'] . $aImage['image_name']);
                        if ($imagesSize[0] > 600 || $imagesSize[1] > 600) {
                            $width = ($imagesSize[0] * 55) / 100;
                            $height = ($imagesSize[1] * 55) / 100;
                        } else {
                            $width = (isset($imagesSize[0]) && $imagesSize[0] != '') ? $imagesSize[0] : 100;
                            $height = (isset($imagesSize[1]) && $imagesSize[1] != '') ? $imagesSize[1] : 100;
                        }
                        $output->aPagedData['data'][$k]['width'] = $width;
                        $output->aPagedData['data'][$k]['height'] = $height;
                    }
                }

                break;

        }
    }    

    function getProductProperty($articleID)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $query = sprintf("
                    SELECT
                    		property1
                    		,property2
                    		,property3
                    		,property4
                    		,property5
                    		,property6
                    FROM
                    		{$this->conf['table']['product_property']}
				    WHERE
				            article_id = '%s'
                    "
				    ,$articleID);
	    $result = $this->dbh->getRow($query,DB_FETCHMODE_ASSOC);
	    PEAR::isError($result);	    
	    return $result;       
    }
    
    function getSeriesName($seriesID)
    {        
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $query = sprintf("
                    SELECT
                    		series_name
                    FROM
                    		{$this->conf['table']['product_series']}
				    WHERE
				            series_id = '%s'
                    "
				    ,$seriesID );
	    $result = $this->dbh->getOne($query);
        PEAR::isError($result);
        return $result;  
    }

    function getGroupNameBySeries($seriesID)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $query = sprintf("
                    SELECT
                    		pt.type_name
                    FROM
                    		{$this->conf['table']['product_series']} ps
                    		,{$this->conf['table']['product_type_message']} pt                   		
				    WHERE
				            ps.series_id = '%s'
				            AND ps.article_type_id = pt.article_type_id
                    "
				    ,$seriesID );
	    $result = $this->dbh->getOne($query);
        PEAR::isError($result);
        return $result;
    }

    function getGroupNameByArticle($articlID)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $query = sprintf("
                            SELECT
                                    pt.type_name
                            FROM
                                    {$this->conf['table']['product']} pd
                                    ,{$this->conf['table']['product_type_message']} pt
                            WHERE
                                    pd.article_id = '%s'
                                    AND pd.article_type_id = pt.article_type_id
                    		"
                            ,$articlID );
        $result = $this->dbh->getOne($query);
        PEAR::isError($result);
        return $result;
    }
    
    function getGroupIDByArticle($articlID)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $query = sprintf("
                            SELECT
                                   article_type_id
                            FROM
                                    {$this->conf['table']['product']}                                    
                            WHERE
                                    article_id = '%s'                                    
                    		"
                            ,$articlID );
        $result = $this->dbh->getOne($query);
        PEAR::isError($result);
        return $result;
    }

    function getSeriesNameByArticle($articlID)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $query = sprintf("
                        SELECT
                                ps.series_name
                        FROM
                                {$this->conf['table']['product_series']} ps
                                ,{$this->conf['table']['product_message']} pm
                        WHERE
                                ps.series_id = pm.extra_field2
                                AND pm.extra_field2 = '%s'
                        "
                        ,$articlID );
        $result = $this->dbh->getOne($query);
        PEAR::isError($result);
        return $result;
    }
}
?>