<?php

/* Reminder: always indent with 4 spaces (no tabs). */
// +---------------------------------------------------------------------------+
// WebSite:  http://www.webexperts.co.th
// Unauthorized copying is strictly forbidden and may result in severe legal action.
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// 
// =====YOU MUST KEEP THIS COPYRIGHTS NOTICE INTACT AND CAN NOT BE REMOVE =======
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// This Agreement is a legal contract, which specifies the terms of the license
// and warranty limitation between you and Web Experts Co.,Ltd. and RV Site Builder.
// You should carefully read the following terms and conditions before
// installing or using this software.  Unless you have a different license
// agreement obtained from Web Experts Co.,Ltd., installation or use of this software
// indicates your acceptance of the license and warranty limitation terms
// contained in this Agreement. If you do not agree to the terms of this
// Agreement, promptly delete and destroy all copies of the Software.
//
// =====  Grant of License =======
// The Software may only be installed and used on a single host machine.
//
// =====  Disclaimer of Warranty =======
// THIS SOFTWARE AND ACCOMPANYING DOCUMENTATION ARE PROVIDED "AS IS" AND
// WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR ANY OTHER
// WARRANTIES WHETHER EXPRESSED OR IMPLIED.   BECAUSE OF THE VARIOUS HARDWARE
// AND SOFTWARE ENVIRONMENTS INTO WHICH RV SITE BUILDER MAY BE USED, NO WARRANTY OF
// FITNESS FOR A PARTICULAR PURPOSE IS OFFERED.  THE USER MUST ASSUME THE
// ENTIRE RISK OF USING THIS PROGRAM.  ANY LIABILITY OF Web Experts Co.,Ltd. WILL BE
// LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT OR REFUND OF PURCHASE PRICE.
// IN NO CASE SHALL Web Experts Co.,Ltd. BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
// CONSEQUENTIAL DAMAGES OR LOSS, INCLUDING, WITHOUT LIMITATION, LOST PROFITS
// OR THE INABILITY TO USE EQUIPMENT OR ACCESS DATA, WHETHER SUCH DAMAGES ARE
// BASED UPON A BREACH OF EXPRESS OR IMPLIED WARRANTIES, BREACH OF CONTRACT,
// NEGLIGENCE, STRICT TORT, OR ANY OTHER LEGAL THEORY. THIS IS TRUE EVEN IF
// Web Experts Co.,Ltd. IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. IN NO CASE WILL
// Web Experts Co.,Ltd.'S LIABILITY EXCEED THE AMOUNT OF THE LICENSE FEE ACTUALLY PAID
// BY LICENSEE TO Web Experts Co.,Ltd.

require_once SGL_MOD_DIR . '/articleweb/classes/AdminArticleWebMgr.php';

class AdminSubcontractorMgr extends AdminArticleWebMgr
{
    function AdminSubcontractorMgr()
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        parent::AdminArticleWebMgr();
        
        /// START aActionsMapping cmd for Stereo Microscope
        $this->_aActionsMapping['changeStatus'] = array('changeStatus','view');
        /// END --------------------------------------------------------------------
        
        $this->template     = 'subcontractorManager.html';
        $this->pageTitle = 'Admin Subcontractor';
        $this->saveImagePath =  'images/subcontractor/';
        
        /// ----------------- config ----------------------------------------------
        $this->conf['Default']['defaultLang'] = 'en-utf-8';
    }
    
    function validate($req, &$input)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        parent::validate($req, $input);
        
        $input->frmAutoResizeImages = 1;
        /*
        $input->changeStatusForm = $req->get('changeStatusForm');
        */
    }

    ///////////////////////////////////////////// CMD /////////////////////////////////////////////////
    function _cmd_changeStatus($input, &$output)
    {
        if ($input->productChange != '' && $input->frmEditArticleID != '') {
            $statusChangeTo = (isset($input->changeStatusForm) && $input->$input->changeStatusForm != '') ? 0 : 1;
            $this->changeStatusTo($input->productChange, $statusChangeTo, $input->frmEditArticleID);
        }
    }
    
    //------------------------------ custom manage -----------------------------------------
    ///////////////////////////// customUseTemplatebyAction /////////////////////////////
    
    function _customUseTemplatebyAction(&$template, $action)
    {
          switch ($action) {
            case "view":
                $template     = 'subcontractorManager.html';
                break;
            case "addview":
                $template   = 'subcontractorEdit.html';
                break;
            case "editview":
                $template   = 'subcontractorEdit.html';
                break;
        }
    }   

    ///////////////////////////// customCommondInput ////////////////////////////////////
    function _customCommondInput($req, &$input)
    {
        switch ($input->action) {
            case "add":
                $input->frmPerms = $this->getAllPerms();
                $input->seriesID = $req->get('addSeriesID');
                $input->aProperty = (count($req->get('aProperty')) > 0) ? $req->get('aProperty') : array();
                
                foreach ($req->get('frmData') as $k => $v) {
                    $input->frmData[$k]['extraField2'] = $req->get('addSeriesID');
                }
                
                break;
            case "edit":
                $input->frmPerms = $this->getAllPerms();
                $input->seriesID = $req->get('addSeriesID');
                $input->aSeries['series_id'] = $input->seriesID;
                $input->aSeries['article_type_id'] = $input->frmAdd['articleTypeId'];
                $input->aProperty = (count($req->get('aProperty')) > 0) ? $req->get('aProperty') : array();
                
                foreach ($req->get('frmData') as $k => $v) {
                    $input->frmData[$k]['extraField2'] = $req->get('addSeriesID');
                }
                
                break;
            case "delete":
               $input->deleteStereoID = $req->get('deleteStereoID');
               if ($input->deleteStereoID != '') {
                    $input->frmDelete = array("$input->deleteStereoID");
               }
              break; 
        }
    }
    
    ///////////////////////////// customOutputAfterRunCmd ///////////////////////////////
    function _customOutputAfterRunCmd($action, &$output)
    {
        if (count($output->aPagedData['data']) > 1) {
            foreach ($output->aPagedData['data'] as $key => $val) {
                $output->aPagedData['data'][$key]['property'] = $this->getProductPropertyByProductID($val['article_id']);
            }
        }
    }
    
    ///////////////////////////////////// customOutputCMD ////////////////////////////////
    function _customOutputCMD($action, $input, &$output)
    {
        switch ($action) {
            case "view":
                foreach ($output->aPagedData['data'] as $k => $v) {
                    $output->aPagedData['data'][$k]['status'] = $this->checkProductStatus($v);
                }

                $aUnsetType = array('1', '2', '3', '4');
                foreach ($output->typeIdSelect as $typeKey => $typeValue) {
                    if (in_array($typeValue->article_type_id, $aUnsetType)) {
                        unset($output->typeIdSelect[$typeKey]);
                    }
                }

                break;
            case "addview":
                $output->groupID = $input->frmAdd['articleTypeId'];
                $output->displayGroupName = $this->getGroupNameByGroupID($input->frmAdd['articleTypeId']);
                break;
            case "editview":
                $output->groupID = $output->articleTypeId;
                $output->dateStartShow = false;
                $output->displayGroupName = $this->getGroupNameByGroupID($output->articleTypeId);
                $output->aPic = $this->getRowProductImgByProductID($output->articleId);
                break;
            case "add":
                break;
            case "edit":
                break;
            case "delete":
                break;
        }
    }
    
    /////////////////////////////////////////////////////////////////////////////////////////////////
    function _customQueryData($action, $input, $queryNumber, &$aDataQuery)
    {
        switch ($action) {
            case "view":
                if ($queryNumber == 1) {
                    $aDataQuery[$queryNumber]['adjustWhere'] = "AND atm.description = 'subcontractor' ";
                } elseif ($queryNumber == 3) {
                    $aDataQuery[$queryNumber]['adjustWhere'] = "AND am.description = 'subcontractor' ";
                }
                break;
        }
    }
    
    
    ////////////////////////////////// customOutputDisplay ////////////////////////////////
    function _customOutputDisplay(&$output)
    {
        switch ($output->action) {
            case "addview":
                break;
            case "editview":
                break;
        }
    }
    
    /////////////////////////////// customAfterInsertDB ////////////////////////////////
    function _customAfterInsertDB($action, $queryNumber, $aDataQuery,  $input)
    {
        switch ($action) {
            case "add":
                break;
            case "edit":
                break;
        }
    }
    
    //---------------------------------------- function ------------------------------------------
    function checkProductStatus($aProduct)
    {
        $dateCheck = time();
        if ($aProduct['publish'] != '') {
            if ($aProduct['never_expired'] != '') {
                return true;
            } else {
                if ($aProduct['date_start'] <=  $dateCheck && $aProduct['date_end'] >=  $dateCheck) {
                    return true;
                }
            }
        }
        return false;
    }
    
    //---------------------------------------- function ------------------------------------------
    function getRowProductImgByProductID($productID)
    {
        $aPic = array();
        $query ="SELECT *
                          FROM `{$this->conf['table']['product_images']}`
                          WHERE `article_id` = '{$productID}' ;";
        $aPic = $this->dbh->getRow($query, DB_FETCHMODE_ASSOC);
        return $aPic;
    }
    
    //--------------------------------------- function -----------------------------------------
    
    function getAllProductGroup()
    {
        $aProductGroup = array();
        $aGroupData = array();
        $webLangID = 1;//1 = en
        $query = "SELECT 
                                a.article_type_id, at.type_name, at.description, a.type_icon
                           FROM 
                                {$this->conf['table']['article_type']} a
                                , {$this->conf['table']['article_type_message']} at
                           WHERE 
                                at.web_lang_id ={$webLangID}
                           AND a.article_type_id = at.article_type_id
                           AND a.article_type_id != '1'
                           AND a.article_type_id != '2'
                           AND a.article_type_id != '3'
                           AND a.article_type_id != '4'";
        $aGroupData = $this->dbh->getAll($query, DB_FETCHMODE_ASSOC);
        
        foreach ($aGroupData as $k => $v) {
            $aProductGroup[$k]['groupID'] = $v['article_type_id'];
            $aProductGroup[$k]['groupName'] = $v['type_name'];
        }
        return $aProductGroup;
    }

    
    //--------------------------------------- function -----------------------------------------
    function getGroupNameByGroupID($groupID)
    {
        $groupName = array();
        $query = "SELECT 
                               `type_name`
                            FROM `{$this->conf['table']['article_type_message']}`
                            WHERE `article_type_id` ='{$groupID}'
                            AND `web_lang_id` = '1'
                            ;";
        $groupName = $this->dbh->getRow($query, DB_FETCHMODE_ASSOC);
        return (isset($groupName['type_name']) && $groupName['type_name'] != '') ? $groupName['type_name'] : '';
    }
}
?>