<?php

/* Reminder: always indent with 4 spaces (no tabs). */
// +---------------------------------------------------------------------------+
// WebSite:  http://www.webexperts.co.th
// Unauthorized copying is strictly forbidden and may result in severe legal action.
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// 
// =====YOU MUST KEEP THIS COPYRIGHTS NOTICE INTACT AND CAN NOT BE REMOVE =======
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// This Agreement is a legal contract, which specifies the terms of the license
// and warranty limitation between you and Web Experts Co.,Ltd. and RV Site Builder.
// You should carefully read the following terms and conditions before
// installing or using this software.  Unless you have a different license
// agreement obtained from Web Experts Co.,Ltd., installation or use of this software
// indicates your acceptance of the license and warranty limitation terms
// contained in this Agreement. If you do not agree to the terms of this
// Agreement, promptly delete and destroy all copies of the Software.
//
// =====  Grant of License =======
// The Software may only be installed and used on a single host machine.
//
// =====  Disclaimer of Warranty =======
// THIS SOFTWARE AND ACCOMPANYING DOCUMENTATION ARE PROVIDED "AS IS" AND
// WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR ANY OTHER
// WARRANTIES WHETHER EXPRESSED OR IMPLIED.   BECAUSE OF THE VARIOUS HARDWARE
// AND SOFTWARE ENVIRONMENTS INTO WHICH RV SITE BUILDER MAY BE USED, NO WARRANTY OF
// FITNESS FOR A PARTICULAR PURPOSE IS OFFERED.  THE USER MUST ASSUME THE
// ENTIRE RISK OF USING THIS PROGRAM.  ANY LIABILITY OF Web Experts Co.,Ltd. WILL BE
// LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT OR REFUND OF PURCHASE PRICE.
// IN NO CASE SHALL Web Experts Co.,Ltd. BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
// CONSEQUENTIAL DAMAGES OR LOSS, INCLUDING, WITHOUT LIMITATION, LOST PROFITS
// OR THE INABILITY TO USE EQUIPMENT OR ACCESS DATA, WHETHER SUCH DAMAGES ARE
// BASED UPON A BREACH OF EXPRESS OR IMPLIED WARRANTIES, BREACH OF CONTRACT,
// NEGLIGENCE, STRICT TORT, OR ANY OTHER LEGAL THEORY. THIS IS TRUE EVEN IF
// Web Experts Co.,Ltd. IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. IN NO CASE WILL
// Web Experts Co.,Ltd.'S LIABILITY EXCEED THE AMOUNT OF THE LICENSE FEE ACTUALLY PAID
// BY LICENSEE TO Web Experts Co.,Ltd.

require_once SGL_MOD_DIR . '/articleweb/classes/AdminArticleTypeWebMgr.php';

class AdminSubcontractorTypeMgr extends AdminArticleTypeWebMgr
{
    function AdminSubcontractorTypeMgr()
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        parent::AdminArticleTypeWebMgr();
        
        $this->template     = 'subcontractorManager.html';
        $this->pageTitle = 'Admin Subcontractor Type';
        $this->ImagePath =  'images/subcontractor/';
        
        /// START aActionsMapping cmd for Stereo Microscope
        $this->_aActionsMapping['viewgroup'] = array('view');
        $this->_aActionsMapping['changeStatus'] = array('changeStatus', 'view');
        /// END --------------------------------------------------------------------
    }
    
    function validate($req, &$input)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        parent::validate($req, $input);
        
        //////////////////////////////////////// req byproject ////////////////////////////////////
        $input->groupID = $req->get('groupID');
        $input->changeTo = $req->get('changeTo');
    }
    
    
    function display(&$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        parent::display($output);
    }
    
    ////////////////////////////// CMD ///////////////////////////
    function _cmd_changeStatus(&$input, &$output)
    {
        SGL::logMessage("CMD :: changeStatus", PEAR_LOG_DEBUG);
        if ($input->groupID == '') {
            return false;
        }
        
        //---------------------- //// change status : enable / disable //// -------------------------
        $aGroup = $this->getGroupStatus($input->groupID);
        if (count($aGroup) > 0) {
            $this->changeGroupStatusTo('edit', $input->groupID, $input->changeTo);
        } else {
            $this->changeGroupStatusTo('add', $input->groupID, $input->changeTo);
        }
    }
    
    
    //------------------------------ custom manage -----------------------------------------
    ///////////////////////////// customUseTemplatebyAction ///////////////////////////// -- Ok
    
    function _customUseTemplatebyAction(&$template, $action)
    {
          switch ($action) {
            case "view":
                $template     = 'groupSubcontractorManager.html';
                break;
            case "addview":
                $template     = 'groupSubcontractorEdit.html';
                break;
            case "editview":
                $template     = 'groupSubcontractorEdit.html';
                break;
            case "changeStatus":
                $template     = 'groupSubcontractorManager.html';
                break;
        }
        
        SGL::logMessage("Template = " . $template, PEAR_LOG_DEBUG);
    }
    
    /////////////////////////////////// customInputByAction ////////////////////////////////////
     function _customInputByAction($action, $req, &$input)
     {
         switch ($action) {
            case "viewgroup":
                $input->action = 'view';
                $input->pageTitle = 'Admin Group Manager';
                break;
            case "addview":
                break;
            case "add":
                $input->frmPerms = $this->getAllPerms();
                break;
            case "edit":
                $input->frmPerms = $this->getAllPerms();
                break;
        }
     }
     
     
     ////////////////////////////////////// customQueryData ////////////////////////////////////////// ---- Ok
     function _customQueryData($action, $input, $queryNumber, &$aDataQuery)
     {
         switch ($action) {
             case "view":
                 if ($queryNumber == 2) {
                     $aDataQuery[$queryNumber]['adjustWhere'] = "AND a.type_icon = '1'";
                     $aDataQuery[$queryNumber]['adjustWhere'] .= "AND a.article_type_id != '1'";
                     $aDataQuery[$queryNumber]['adjustWhere'] .= "AND a.article_type_id != '2'";
                     $aDataQuery[$queryNumber]['adjustWhere'] .= "AND a.article_type_id != '3'";
                     $aDataQuery[$queryNumber]['adjustWhere'] .= "AND a.article_type_id != '4'";
                 }
                 break;
             case "add":
                 if ($queryNumber == 1) {
                     $this->changeGroupStatusTo('add', $aDataQuery[$queryNumber]['article_type_id']);
                     $aDataQuery[$queryNumber]['type_icon'] = true;
                 }
                 break;
         }
     }
     
     
     ////////////////////////////////////// customOutputCMD //////////////////////////////////////
     function _customOutputCMD($action, $input, &$output)
     {
         switch ($action) {
             case "view":
                 foreach ($output->aPagedData['data'] as $k => $v) {
                    $output->aPagedData['data'][$k]['groupDetail'] = $this->getGroupStatus($v['article_type_id']);
                 }
                 break;
             case "delete":
                 if (is_array($input->frmDelete)) {
                     foreach ($input->frmDelete as $groupID) {
                        $this->deleteGroupStatus($groupID);
                     }
                     
                 } elseif (is_string($input->frmDelete)) {
                     $this->deleteGroupStatus($input->frmDelete);
                 }
                 break;
         }
     }
     
     /////////////////////////////// _customCommondInput ////////////////////////////////
     function _customCommondInput($req, &$input)
     {
         switch ($input->action) {
             case "delete":
                 if (!is_array($input->frmDelete) && $input->frmDelete != '') {
                     $id = $input->frmDelete;
                     $input->frmDelete = array();
                     $input->frmDelete[$id] = $id;
                 }
                 break;
         }
     }
     
     
     /////////////////////////////// _customCommondValidate ////////////////////////////////
     function _customCommondValidate($input, &$aErrors)
     {
         switch ($input->action) {
             case "delete":
                 $er = array();
                 foreach ($input->frmDelete as $k => $v) {
                     $aCheck = $this->validateDeleteGroup($v);
                     if ($aCheck == true) {
                         $er[] = $v;
                         
                     }
                 }
                 
                 if (count($er) > 0) {
                     $a = '';
                     foreach ($er as $erK => $erV) {
                         $a .= ($a == '') ? $erV : ',' . $erV;
                     }
                     $aErrors["aDeleteGroupError"] = SGL_Output::translate('Please move Series out category for delete.') . 'group id' .  $a . " file";
                 }
                 break;
         }
     }
    // ----------------------------------- common function ----------------------------------------
    # for get all role to action add / edit
    function getAllPerms()
    {
        $aPerms = array();
        $query = "SELECT `role_id`
                            FROM `{$this->conf['table']['role']}` ";
        $aData = $this->dbh->getAll($query, DB_FETCHMODE_ASSOC);
        
        foreach ($aData as $k => $v) {
            if ($v['role_id'] != '-1') {
                $aPerms[$v['role_id']] = $v['role_id'];
            }
        }
        return $aPerms;
    }
    
    
    //---------------------------------------------- function ---------------------------------------------
    /**
     * get all data in group id
     * Query is {getRow}
     * 
     * @param <string> $typeID
     * @return <array>
     * 
     * Ex: array(
     *              status => 0 or 1,
     *              date_create => '{ time(); }'
     *          );
     * 
     */
    function getGroupStatus($typeID = '')
    {
        $aData = array();
        if ($typeID == '') {
            return array();
        }
        $query = "SELECT 
                                status
                                , date_create
                            FROM `{$this->conf['table']['product_group_status']}` 
                            WHERE article_type_id = '{$typeID}'";
        $aData = $this->dbh->getRow($query, DB_FETCHMODE_ASSOC);
        return $aData;
    }
    
    
    //---------------------------------------------- function ---------------------------------------------
    function deleteGroupStatus($groupID = '')
    {
        if ($groupID == '') {
            return false;
        }
        
        $query = "DELETE FROM `{$this->conf['table']['product_group_status']}` 
                            WHERE `article_type_id` = '{$groupID}' 
                            LIMIT 1;";
         $this->dbh->query($query);
    }
    
    //---------------------------------------------- function ---------------------------------------------
    function validateDeleteGroup($groupID)
    {
        return false;
    }
    
    //---------------------------------------------- function ---------------------------------------------
    function changeGroupStatusTo($action, $groupID, $changeTo = 1)
    {
        $time = time();
        switch ($action) {
            case "add":
                $query = "INSERT INTO `{$this->conf['table']['product_group_status']}` ( 
                                            `article_type_id` 
                                            , `status` 
                                            , `date_create` 
                                    ) VALUES (
                                            '{$groupID}'
                                            , '{$changeTo}'
                                            , '{$time}' );";
                $this->dbh->query($query);
                break;
            case "edit":
                $query = "UPDATE `{$this->conf['table']['product_group_status']}` 
                                    SET 
                                        `status` = '{$changeTo}',
                                        `date_create` = '{$time}' 
                                    WHERE `article_type_id` ='{$groupID}' 
                                    LIMIT 1 ;";
                $this->dbh->query($query);
                break;
        }
    }
    
    
    //---------------------------------------------- function ---------------------------------------------
    function getAllGroupData()
    {
        $aGroupData = array();
        $webLangID = 1;//1 = en
        $query = "SELECT 
                                a.article_type_id, at.type_name, at.description, a.type_icon
                           FROM 
                                {$this->conf['table']['article_type']} a
                                , {$this->conf['table']['article_type_message']} at
                           WHERE 
                                at.web_lang_id ={$webLangID}
                           AND a.article_type_id = at.article_type_id
                           AND a.type_icon = '1'
                           AND a.article_type_id != '1'
                           AND a.article_type_id != '2'
                           AND a.article_type_id != '3'
                           AND a.article_type_id != '4'";
        $aGroupData = $this->dbh->getAll($query, DB_FETCHMODE_ASSOC);
        return $aGroupData;
    }
    
    
    //---------------------------------------------- function ---------------------------------------------
    function getGroupDataByGroupID($groupID)
    {
        $aGroupData = array();
        $webLangID = 1;//1 = en
        $query = "SELECT 
                                a.article_type_id, at.type_name, at.description, a.type_icon
                           FROM 
                                {$this->conf['table']['article_type']} a
                                , {$this->conf['table']['article_type_message']} at
                           WHERE 
                                at.web_lang_id ={$webLangID}
                           AND a.article_type_id = at.article_type_id
                           AND a.article_type_id = '{$groupID}'";
        $aGroupData = $this->dbh->getRow($query, DB_FETCHMODE_ASSOC);
        return $aGroupData;
    }
    
    //PEAR::isError($result);
}
?>