<?php

/* Reminder: always indent with 4 spaces (no tabs). */
// +---------------------------------------------------------------------------+
// WebSite:  http://www.webexperts.co.th
// Unauthorized copying is strictly forbidden and may result in severe legal action.
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// 
// =====YOU MUST KEEP THIS COPYRIGHTS NOTICE INTACT AND CAN NOT BE REMOVE =======
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// This Agreement is a legal contract, which specifies the terms of the license
// and warranty limitation between you and Web Experts Co.,Ltd. and RV Site Builder.
// You should carefully read the following terms and conditions before
// installing or using this software.  Unless you have a different license
// agreement obtained from Web Experts Co.,Ltd., installation or use of this software
// indicates your acceptance of the license and warranty limitation terms
// contained in this Agreement. If you do not agree to the terms of this
// Agreement, promptly delete and destroy all copies of the Software.
//
// =====  Grant of License =======
// The Software may only be installed and used on a single host machine.
//
// =====  Disclaimer of Warranty =======
// THIS SOFTWARE AND ACCOMPANYING DOCUMENTATION ARE PROVIDED "AS IS" AND
// WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR ANY OTHER
// WARRANTIES WHETHER EXPRESSED OR IMPLIED.   BECAUSE OF THE VARIOUS HARDWARE
// AND SOFTWARE ENVIRONMENTS INTO WHICH RV SITE BUILDER MAY BE USED, NO WARRANTY OF
// FITNESS FOR A PARTICULAR PURPOSE IS OFFERED.  THE USER MUST ASSUME THE
// ENTIRE RISK OF USING THIS PROGRAM.  ANY LIABILITY OF Web Experts Co.,Ltd. WILL BE
// LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT OR REFUND OF PURCHASE PRICE.
// IN NO CASE SHALL Web Experts Co.,Ltd. BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
// CONSEQUENTIAL DAMAGES OR LOSS, INCLUDING, WITHOUT LIMITATION, LOST PROFITS
// OR THE INABILITY TO USE EQUIPMENT OR ACCESS DATA, WHETHER SUCH DAMAGES ARE
// BASED UPON A BREACH OF EXPRESS OR IMPLIED WARRANTIES, BREACH OF CONTRACT,
// NEGLIGENCE, STRICT TORT, OR ANY OTHER LEGAL THEORY. THIS IS TRUE EVEN IF
// Web Experts Co.,Ltd. IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. IN NO CASE WILL
// Web Experts Co.,Ltd.'S LIABILITY EXCEED THE AMOUNT OF THE LICENSE FEE ACTUALLY PAID
// BY LICENSEE TO Web Experts Co.,Ltd.

require_once SGL_MOD_DIR . '/articleweb/classes/ArticleViewWebMgr.php';
      
class SubcontractorViewMgr extends ArticleViewWebMgr
{
    function SubcontractorViewMgr()
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        parent::ArticleViewWebMgr();
    }
    
    function validate($req, &$input)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        parent::validate($req, $input);
        $input->aticleID = $req->get('frmAticleId');
    }
    
function display(&$output)
    {
        parent:: display($output);       
       $output->addJavascriptFile('js/scriptaculous/lib/prototype.js');
       $output->addJavascriptFile('js/scriptaculous/src/effects.js');
       $output->addJavascriptFile('js/preLoadImage.js');
       $output->addJavascriptFile('js/tooltip.js');
       $output->addJavascriptFile('js/lightbox/lightbox.js');
       $output->addCssFile('js/lightbox/css/lightbox.css');   
       
        if (is_array( $output->preLoadImag)) {
            $image = join( "','", $output->preLoadImage);
        } else {
             $image = $output->preLoadImage;
        }
       
       $output->addOnLoadEvent("PreLoadImage(['" . $image . "'])");
    }

    
    //////////////////////////////// CUSTOM ////////////////////////////
    function _customCommondInput($req, &$input)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $this->template     = 'listLatestSubcontractorType.html';
        $this->conf['Default']['defaultLang'] = 'en-utf-8';
    }
    
    
    //////////////////////////////// CUSTOM ////////////////////////////
    function _customUseTemplatebyAction(&$template, $action)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        /// If you want to custom validate action edit, please edit here!!
        switch ($action) {
            case "viewArticle":                
                $template = 'viewSubcontractor.html';
                break;
            case "view":
            case "viewArticleType":
                $template = 'listLatestSubcontractorType.html';
                break;
            case "viewArticleAllType":
                $template = 'listSubcontractorAllType.html';
                break;
        }
        //echo $action . ' : ' . $template;
    }
    
    
    // ---------------------------------- FUNCTION --------------------------------
    function getProductImage($articleID)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $query = sprintf("
                    SELECT
                    		*
                    FROM
                    		{$this->conf['table']['product_images']}
				    WHERE
				            article_id = '%s'
                    "
				    ,$articleID );				    
	    $result = $this->dbh->getRow($query,DB_FETCHMODE_ASSOC);
	    PEAR::isError($result);	    
	    return $result;
    }
    
    
    //////////////////////////////// CUSTOM ////////////////////////////
    function _customQueryData($action, $input, $queryNumber = null, &$aDataQuery)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        if ($queryNumber == null) {
            return ;
        }
        
        switch ($action) {
            case "viewArticle":
                // index.php/subcontractor/subcontractorview/action/viewArticle/frmArticleID/5/
                break;
            case "viewArticleType":
                // index.php/subcontractor/subcontractorview/action/viewArticleType/frmArticleTypeID/5/
                break;
            case "viewArticleAllType":
                // index.php/subcontractor/subcontractorview/action/viewArticleAllType
                if ($queryNumber == 3) {
                    $aDataQuery[$queryNumber]['adjustWhere'] = " AND a.type_icon = '1'";
                    $aDataQuery[$queryNumber]['adjustWhere'] .= " AND a.article_type_id != '1'";
                    $aDataQuery[$queryNumber]['adjustWhere'] .= " AND a.article_type_id != '2'";
                    $aDataQuery[$queryNumber]['adjustWhere'] .= " AND a.article_type_id != '3'";
                    $aDataQuery[$queryNumber]['adjustWhere'] .= " AND a.article_type_id != '4'";
                }
                break;
        }
        
    }
    
    
    //////////////////////////////// CUSTOM ////////////////////////////
    function _customOutputCMD($action, $input, &$output)
    {
        switch ($action) {
            case "viewArticle":
                $aImage = $this->getProductImage($input->frmArticleID);                
                $output->imageDetail = $aImage['image_path'] . $aImage['image_name'];
                break;
            case "viewArticleType":
                $output->preLoadImage = array();  
                $aPagedData = $output->aPagedData['data'];                
                foreach($aPagedData as $k => $v) {
                    $aImage = $this->getProductImage($v['article_id']);
                    if (count($aImage) > 0) {
                        $output->aPagedData['data'][$k]['imageDetail'] = $aImage['image_path'] . $aImage['image_name'];
                        $output->aPagedData['data'][$k]['imageDetail_s'] = $aImage['image_path'] . 's_' . $aImage['image_name'];
                        $output->aPagedData['data'][$k]['imageDetail_m'] = $aImage['image_path'] . 'm_' . $aImage['image_name'];    
                        $output->preLoadImage[$k] = $output->aPagedData['data'][$k]['imageDetail_m'];                    
                    }
                }
                break;

        }
    }
    
    
    // ---------------------------------- FUNCTION --------------------------------
    function getGroupNameByArticle($articlID)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $query = sprintf("
                            SELECT
                                    pt.type_name
                            FROM
                                    {$this->conf['table']['product']} pd
                                    ,{$this->conf['table']['product_type_message']} pt
                            WHERE
                                    pd.article_id = '%s'
                                    AND pd.article_type_id = pt.article_type_id
                    		"
                            ,$articlID );
        $result = $this->dbh->getRow($query,DB_FETCHMODE_ASSOC);
        PEAR::isError($result);
        return $result;
    }

}
?>