<?php

/* Reminder: always indent with 4 spaces (no tabs). */
// +---------------------------------------------------------------------------+
// WebSite:  http://www.webexperts.co.th
// Unauthorized copying is strictly forbidden and may result in severe legal action.
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// 
// =====YOU MUST KEEP THIS COPYRIGHTS NOTICE INTACT AND CAN NOT BE REMOVE =======
// Copyright (c) 2006 Web Experts Co.,Ltd. All rights reserved.
// This Agreement is a legal contract, which specifies the terms of the license
// and warranty limitation between you and Web Experts Co.,Ltd. and RV Site Builder.
// You should carefully read the following terms and conditions before
// installing or using this software.  Unless you have a different license
// agreement obtained from Web Experts Co.,Ltd., installation or use of this software
// indicates your acceptance of the license and warranty limitation terms
// contained in this Agreement. If you do not agree to the terms of this
// Agreement, promptly delete and destroy all copies of the Software.
//
// =====  Grant of License =======
// The Software may only be installed and used on a single host machine.
//
// =====  Disclaimer of Warranty =======
// THIS SOFTWARE AND ACCOMPANYING DOCUMENTATION ARE PROVIDED "AS IS" AND
// WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR ANY OTHER
// WARRANTIES WHETHER EXPRESSED OR IMPLIED.   BECAUSE OF THE VARIOUS HARDWARE
// AND SOFTWARE ENVIRONMENTS INTO WHICH RV SITE BUILDER MAY BE USED, NO WARRANTY OF
// FITNESS FOR A PARTICULAR PURPOSE IS OFFERED.  THE USER MUST ASSUME THE
// ENTIRE RISK OF USING THIS PROGRAM.  ANY LIABILITY OF Web Experts Co.,Ltd. WILL BE
// LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT OR REFUND OF PURCHASE PRICE.
// IN NO CASE SHALL Web Experts Co.,Ltd. BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
// CONSEQUENTIAL DAMAGES OR LOSS, INCLUDING, WITHOUT LIMITATION, LOST PROFITS
// OR THE INABILITY TO USE EQUIPMENT OR ACCESS DATA, WHETHER SUCH DAMAGES ARE
// BASED UPON A BREACH OF EXPRESS OR IMPLIED WARRANTIES, BREACH OF CONTRACT,
// NEGLIGENCE, STRICT TORT, OR ANY OTHER LEGAL THEORY. THIS IS TRUE EVEN IF
// Web Experts Co.,Ltd. IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. IN NO CASE WILL
// Web Experts Co.,Ltd.'S LIABILITY EXCEED THE AMOUNT OF THE LICENSE FEE ACTUALLY PAID
// BY LICENSEE TO Web Experts Co.,Ltd.

class tips_Block_LatestTipsBlock
{
    var $template     = 'blocksLatestTips.html';
    var $templatePath = 'tips';
    var $webRoot = SGL_BASE_URL;
    
    function tips_Block_LatestTipsBlock()
    {
        $c = &SGL_Config::singleton();
        $this->dbh = & SGL_DB::singleton();
        $this->blockConf->conf = $c->ensureModuleConfigLoaded('tips'); 
    }
    
    function init(&$output, &$blockID, &$aParams)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        return $this->getBlockContent($output, &$aParams);
    }

    function getBlockContent(&$output, &$aParams)
    {
        return $this->process($output, &$aParams);
    }
    
    function process(&$output, &$aParams)
    {
        $output->moduleName     = $this->templatePath;
        $output->masterTemplate = $this->template;
        $output->webRoot = $this->webRoot;
        $output->conf = $this->blockConf->conf;
        
        $output->aLatestTipsDatas = $this->retrieveAll();
        
        $view = new SGL_HtmlSimpleView($output);
        return $view->render();
    }
    
    function retrieveAll()
    {
         $query = "
            SELECT
                a.article_id, a.date_start, a.publish, a.never_expired, a.date_end, atm.type_name, al.web_lang_id, am.title, am.message
            FROM 
                {$this->blockConf->conf['table']['article']} a, 
                {$this->blockConf->conf['table']['article_type_message']} atm, 
                {$this->blockConf->conf['table']['web_lang']} al, 
                {$this->blockConf->conf['table']['article_message']} am
            WHERE 
                al.lang_key = 'en-utf-8'
                AND atm.web_lang_id = al.web_lang_id
                AND atm.article_type_id = a.article_type_id
                AND am.web_lang_id = al.web_lang_id
                AND am.article_id = a.article_id
                AND a.publish = 1
                AND a.article_type_id = 1
                ORDER BY article_id  DESC
                LIMIT 0 , 1
            ";
        $aData = $this->dbh->getRow($query, DB_FETCHMODE_ASSOC);
        return $aData;
    }
}
?>