<?php

require_once 'Config.php';
require_once SGL_MOD_DIR  . '/translation/classes/Translation2.php';

class ImportExportMgr extends SGL_Manager
{

    var $masterLangFile;
    var $tempLangDir;
    var $componentDir;
    var $wysiwygDir;
    

    function ImportExportMgr()
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        parent::SGL_Manager();

        $this->pageTitle = 'Import Export Language';
        $this->template = 'export.html';

        $this->_aActionsMapping = array(
            'import'              => array('import', 'redirectToTranslationView'),
            'export'              => array('export'),
        );
        
        $this->masterLangFile = 'english-iso-8859-15.php';
        
        $this->tempLangDir = SGL_WEB_ROOT . '/rvExportLang';
        
         $this->componentDir = SGL_APP_ROOT . '/scripts';
         
         $this->wysiwygDir = SGL_WEB_ROOT . '/wysiwyg';
    }

    function validate($req, &$input)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);

        $this->validated       = true;
        $input->pageTitle      = $this->pageTitle;
        $input->template       = $this->template;

        $input->action         = $req->get('action')
            ? $req->get('action') : 'list';

            
        $input->frmAllKey         = $req->get('frmAllKey');            
        $input->frmExportLang         = $req->get('frmExportLang') ? $req->get('frmExportLang') : 'en-iso-8859-15';
        
        $input->frmLangFile         = $req->get('frmLangFile');
        
        $input->assetFileArray = $req->get('assetFile');
        
        if (count($input->assetFileArray) != 0) {
            $input->assetFileName         = $input->assetFileArray['name'];
            $input->assetFileTmpName      = $input->assetFileArray['tmp_name'];
        }
        
        if ($req->get('export')) {
            $input->action = 'export';
        }
        
        if ($req->get('import')) {
            $input->action = 'import';
        }
            
    ################ Start validate ###############
        $aErrors = array();
        
        switch ($input->action) {
            case "import":
                $this->_validateImport($input, &$aErrors);
                if (count($aErrors) > 0) { 
                    $input->template = 'import.html';
                }
                break;
            case "export":
                $this->_validateExport($input, &$aErrors);
                if (count($aErrors) > 0) {
                    $input->template = 'export.html'; 
                }
                break;

        }
        

        ################ End validate ###############            
            
        // if errors have occured
        if (!empty($aErrors)) {
            SGL::raiseMsg('Validation Failed.<br /><hr />' . join('<br />', $aErrors));
            $input->error = $aErrors;
            $this->validated = false;
        }
    }

    function display(&$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);

    }

    function _cmd_list(&$input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);

        
    }
    
    
    function _validateImport(&$input, &$aErrors)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        
        $input->template            = 'import.html';

        $tmpName = $input->assetFileTmpName;
        
        if ($tmpName == '') {
            $aErrors['uploadFileBlank'] = 'Please browse file to import';
        }
        
        if ($tmpName != '') {
            if (!is_uploaded_file($tmpName)) {
                $aErrors['uploadFileFail'] = 'Possible file upload attack:';
            }
        }
        
        /*
         * Extract lang
         */

        if (is_dir(SGL_WEB_ROOT . '/rvExportLang')) {
            $this->unlinkFiles(SGL_WEB_ROOT . '/rvExportLang/');
            rmdir(SGL_WEB_ROOT . '/rvExportLang');
        }
        
        $targetLangFile = SGL_WEB_ROOT . '/' . $input->assetFileName;
        $tmpName = $input->assetFileTmpName;
        if (is_file($targetLangFile)) {
            unlink($targetLangFile);
        }
        move_uploaded_file($tmpName, $targetLangFile);  
        $extensionName = 'zip';
        require_once SGL_LIB_PEAR_DIR . '/Archive/Zip.php';
        
        $reader = new Archive_Zip( ($targetLangFile) );
        
        $files = $reader->listContent();
        
        $aName = explode('/', $files[0]['stored_filename']);
        
        if (count($aName) > 1) {
            array_pop($aName);
            $dirName =  $aName[0];
            $files = $reader->extract();
            rename(SGL_WEB_ROOT . '/' . $dirName, SGL_WEB_ROOT . '/rvExportLang');
        } else {
            $files = $reader->extract( array( 'add_path' => 'rvExportLang' ) );
        }
        
        /*
         * Validate Syntax
         */
         
        $dh  = opendir($this->tempLangDir);
        while (false !== ($filename = readdir($dh))) {
            if ($filename == '.' || $filename == '..') {
                continue; 
            }
            if (!preg_match("/^[a-z0-9_.-]+$/i", $filename)) {
                continue;
            }
            
            $result = exec('php -l ' . $this->tempLangDir . '/' . $filename);
            if (!preg_match("/^No syntax errors detected in/",$result)) {
                if (!isset($aErrors['langSyntaxError'])) {
                    $aErrors['langSyntaxError'] = '';
                }                    
                $aErrors['langSyntaxError'] .=  $result . '<br /><hr/>';
            }

        }
        
        $filename = 'lang.conf.php';
        $langFile = $this->tempLangDir . '/' . $filename;
        
        include($langFile);

        $importLang = $conf['langkey'];
        
        
        // Import Module
        
        $aModules = SGL_Util::getAllModuleDirs(false);
        
        foreach ($aModules as $key=>$moduleName) {
            
            $aModuleLangCurrent = $this->_loadModuleLang($moduleName, $importLang, '1');
            if (count($aModuleLangCurrent)) {
            
                $aModuleLangImport = $this->_loadImportModuleLang($moduleName, $importLang);
                                      
                if (count($aModuleLangImport)) {
                    foreach ($aModuleLangCurrent as $key=>$val) {
                        
                        if (array_key_exists($key, $aModuleLangImport)) {
                            if ($aModuleLangImport[$key] !=  $aModuleLangCurrent[$key]) {
                                if (preg_match("/%/", $aModuleLangCurrent[$key],$match)) {
                                    $var = '%user';
                                    if (!$this->_validateVarInLang($aModuleLangCurrent[$key], $aModuleLangImport[$key], $var)) {
                                        if (!isset($aErrors['varInLangFail'])) {
                                            $aErrors['varInLangFail'] = '';
                                        }
                                        $aErrors['varInLangFail'] .=  "Lost var $var in $moduleName with key $key<br /><hr/>";
                                    }
                                    
                                    $var = '%date';
                                    if (!$this->_validateVarInLang($aModuleLangCurrent[$key], $aModuleLangImport[$key], $var)) {
                                        if (!isset($aErrors['varInLangFail'])) {
                                            $aErrors['varInLangFail'] = '';
                                        }
                                        $aErrors['varInLangFail'] .=  "Lost var $var in $moduleName with key $key<br /><hr/>";
                                    }
                                    
                                    $var = '%s';
                                    if (!$this->_validateVarInLang($aModuleLangCurrent[$key], $aModuleLangImport[$key], $var)) {
                                        if (!isset($aErrors['varInLangFail'])) {
                                            $aErrors['varInLangFail'] = '';
                                        }
                                        $aErrors['varInLangFail'] .=  "Lost var $var in $moduleName with key $key<br /><hr/>";
                                    }
                                    
                                    $var = '%e';
                                    if (!$this->_validateVarInLang($aModuleLangCurrent[$key], $aModuleLangImport[$key], $var)) {
                                        if (!isset($aErrors['varInLangFail'])) {
                                            $aErrors['varInLangFail'] = '';
                                        }
                                        $aErrors['varInLangFail'] .=  "Lost var $var in $moduleName with key $key<br /><hr/>";
                                    }
                                    
                                    $var = '%t';
                                    if (!$this->_validateVarInLang($aModuleLangCurrent[$key], $aModuleLangImport[$key], $var)) {
                                        if (!isset($aErrors['varInLangFail'])) {
                                            $aErrors['varInLangFail'] = '';
                                        }
                                        $aErrors['varInLangFail'] .=  "Lost var $var in $moduleName with key $key<br /><hr/>";
                                    }
                                    
                                    $var = '%1';
                                    if (!$this->_validateVarInLang($aModuleLangCurrent[$key], $aModuleLangImport[$key], $var)) {
                                        if (!isset($aErrors['varInLangFail'])) {
                                            $aErrors['varInLangFail'] = '';
                                        }
                                        $aErrors['varInLangFail'] .=  "Lost var $var in $moduleName with key $key<br /><hr/>";
                                    }
                                    
                                    $var = '%2';
                                    if (!$this->_validateVarInLang($aModuleLangCurrent[$key], $aModuleLangImport[$key], $var)) {
                                        if (!isset($aErrors['varInLangFail'])) {
                                            $aErrors['varInLangFail'] = '';
                                        }
                                        $aErrors['varInLangFail'] .=  "Lost var $var in $moduleName with key $key<br /><hr/>";
                                    }
                                }                            
                            }
                        }
                    }                
                }
            }
        }
        

    }
        
    function _validateVarInLang($msg1, $msg2, $var)
    {
        /*
            %user %date  %s  %e  %t  %1  %2 
        */
        
        if (preg_match_all("/$var/",$msg1,$match)) {
            $percentCount1 = count($match[0]);
            $percentCount2 = 0;
            if (preg_match_all("/$var/",$msg2,$match)) {
                $percentCount2 = count($match[0]);
            }
        
            if ($percentCount1 == $percentCount2) {
                return 1;
            }
            return 0;
        }
        
        return 1;
    }
    
    function _validateExport(&$input, &$aErrors)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);

        $input->template            = 'export.html';
        
        
        
    }

    function _cmd_import(&$input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        
        /*
         * Export Modules
         */

        $targetLangFile = SGL_WEB_ROOT . '/' . $input->assetFileName;
        
        $filename = 'lang.conf.php';
        $langFile = $this->tempLangDir . '/' . $filename;
        
        include($langFile);

        $importLang = $conf['langkey'];
        
        
        // Import Module
        
        $aModules = SGL_Util::getAllModuleDirs(false);
        
        foreach ($aModules as $key=>$moduleName) {
            
            $aModuleLangCurrent = $this->_loadModuleLang($moduleName, $importLang, '1');
            if (count($aModuleLangCurrent)) {
            
                $aModuleLangImport = $this->_loadImportModuleLang($moduleName, $importLang);
                
                $aModuleLang = $this->_mergeModuleLang($aModuleLangCurrent, $aModuleLangImport);
                
                $ok = SGL_Translation2::updateGuiTranslations($moduleName, $importLang, $aModuleLang);
                if (!PEAR::isError($ok)) {
                    SGL_Translation2::clearCache();
                    SGL::raiseMsg('translation successfully updated', true, SGL_MESSAGE_INFO);
                } else {
                    SGL::raiseMsg('There was a problem updating the translation', SGL_ERROR_FILEUNWRITABLE);
                }                        
            }
        }

        // Import Component
        
        if (is_dir($this->componentDir)) {         
         
            $aComponents = $this->_getAllComponents();
    
            foreach ($aComponents as $key=>$componentName) {
                $aComponentLangCurrent = $this->_loadComponentLang($componentName, $input->frmExportLang, '1');
                if (count($aComponentLangCurrent)) {
                    $aComponentLangImport = $this->_loadImportComponentLang($componentName, $importLang);
                    $aComponentLang = $this->_mergeComponentLang($aComponentLangCurrent, $aComponentLangImport);
                    $this->_updateComponentLang($componentName, $importLang, $aComponentLang);
                }
            }
        }
        //Import wysiwyg
        if (is_dir($this->wysiwygDir)) {
            $aWysiwygLangCurrent = $this->_loadWysiwygLang($importLang, '1');
            
            $aWysiwygLangImport = $this->_loadWysiwygImportLang($importLang);
            
            $aWysiwygLang = $this->_mergeWysiwygLang($aWysiwygLangCurrent, $aWysiwygLangImport);
            $this->_updateWysiwygLang($aWysiwygLang, $importLang);
        }
        
        
        
        $this->unlinkFiles(SGL_WEB_ROOT . '/rvExportLang/');
        rmdir(SGL_WEB_ROOT . '/rvExportLang');
        
        if (is_file($targetLangFile)) {
            unlink($targetLangFile);
        }

    }
    
    function _cmd_export(&$input, &$output)
    {
        SGL::logMessage(null, PEAR_LOG_DEBUG);
        $input->template  = 'export.html';
        
        require_once 'System.php';
        
        if (!is_dir($this->tempLangDir)) {
            mkdir($this->tempLangDir);
        }
        
        $aLangConfig = array();
        $aLangConfig['langkey'] = $input->frmExportLang;
                
        $filename = 'lang.conf.php';
        $langFile = $this->tempLangDir . '/' . $filename;
        $arrayName = 'conf';
        $this->_writeLangFile($aLangConfig, $langFile, $arrayName);
        
        /*
         * Export Modules
         */
        
        $aModules = SGL_Util::getAllModuleDirs(false);
        
        foreach ($aModules as $key=>$moduleName) {
            $aModuleLang = $this->_loadModuleLang($moduleName, $input->frmExportLang, $input->frmAllKey);
            if (count($aModuleLang)) {
                $this->_buildModuleLang($moduleName, $input->frmExportLang, $aModuleLang);
            }
        }

        /*
         * Export Component
         */
        if (is_dir($this->componentDir)) {
            $aComponents = $this->_getAllComponents();
            foreach ($aComponents as $key=>$componentName) {
                
                $aComponentLang = $this->_loadComponentLang($componentName, $input->frmExportLang, $input->frmAllKey);
                if (count($aComponentLang)) {
                    $this->_buildComponentLang($componentName, $input->frmExportLang, $aComponentLang);
                }
            }
        }

        /*
         * Export wysiwyg
         */
        if (is_dir($this->wysiwygDir)) {
            $aWysiwygLang = $this->_loadWysiwygLang($input->frmExportLang, $input->frmAllKey);
            $this->_buildWysiwygLang($input->frmExportLang, $aWysiwygLang);
        }
        
        $output->archiveFileName = $this->_doExport($input->frmExportLang);
        
    }
    
    function _doExport($lang)
    {

        $extensionName = 'zip';
        $downloadFileName = 'rvExportLang_' . $lang . '.' . $extensionName;
        
        $oMain = new Main();
        
        chdir($this->tempLangDir);
        $oMain->createFilesCompression(SGL_WEB_ROOT, 'rvExportLang', $extensionName);
        
        /*
         * move file
         */

        if (is_file(SGL_WEB_ROOT . '/rvExportLang.' . $extensionName)) {
            unlink(SGL_WEB_ROOT . '/rvExportLang.' . $extensionName);
        }
        
        if (is_file(SGL_WEB_ROOT . '/rvExportLang/rvExportLang.' . $extensionName)) {
            copy(SGL_WEB_ROOT . '/rvExportLang/rvExportLang.' . $extensionName, SGL_WEB_ROOT . '/rvExportLang.' . $extensionName);
        }

        if (is_file(SGL_WEB_ROOT . '/rvExportLang/rvExportLang.' . $extensionName)) {
            unlink(SGL_WEB_ROOT . '/rvExportLang/rvExportLang.' . $extensionName);
        }
        
        if (is_file(SGL_WEB_ROOT . '/rvExportLang.' . $extensionName)) {
            rename(SGL_WEB_ROOT . '/rvExportLang.' . $extensionName, SGL_WEB_ROOT . '/rvExportLang_' . $lang . '.' . $extensionName);
        }
        
        $archiveFileName = '';
        if (is_file(SGL_WEB_ROOT . '/rvExportLang.' . $extensionName)) {
            $archiveFileName = $downloadFileName;
        }
        
        $this->unlinkFiles(SGL_WEB_ROOT . '/rvExportLang/');
        rmdir(SGL_WEB_ROOT . '/rvExportLang');
        return $archiveFileName;
    }

    
    function _loadModuleLang($moduleName = '', $lang = '', $allkey = '1')
    {
        $fallbackLang = SGL_Config::get('translation.fallbackLang');
        $aTargetLang = SGL_Translation2::getTranslations($moduleName, $lang, true);
        
        // $onlyUntranslate
        $aSourceLang = SGL_Translation2::getTranslations($moduleName, SGL_Translation2::transformLangID($fallbackLang));
        
        if (count($aTargetLang)) {
            if (!$allkey) {
                foreach ($aSourceLang as $key=>$val) {
                    if (!array_key_exists($key, $aTargetLang)) {
                        $aTargetLang[$key] =  $aSourceLang[$key];
                    }
                    if ($aTargetLang[$key] !=  $aSourceLang[$key]) {
                        unset($aTargetLang[$key]);
                    }
                }
            }
            return $aTargetLang;
        } else {
            return $aSourceLang;
        }
            
    }
    
    function _mergeModuleLang($aModuleLangCurrent, $aModuleLangImport)
    {
        if (count($aModuleLangImport)) {
            foreach ($aModuleLangCurrent as $key=>$val) {
                if (array_key_exists($key, $aModuleLangImport)) {
                    if ($aModuleLangImport[$key] !=  $aModuleLangCurrent[$key]) {
                        $aModuleLangCurrent[$key] = $aModuleLangImport[$key];
                    }
                }
            }                
        }
        
        return $aModuleLangCurrent;
    }
    
    function _buildModuleLang($moduleName = '', $langId = '', $aModuleLang = array()) 
    {
        
        
        $filename = 'modules_' . $moduleName . '_' . $GLOBALS['_SGL']['LANGUAGE'][$langId][1] . '.php';
        $langFile = $this->tempLangDir . '/' . $filename;
        
        $arrayName = ($moduleName == 'default') ? 'defaultWords' : 'words';
        $this->_writeLangFile($aModuleLang, $langFile, $arrayName);
        
        
    }
    
    
    function _loadImportModuleLang($moduleName, $importLang)
    {
        $filename = 'modules_' . $moduleName . '_' . $GLOBALS['_SGL']['LANGUAGE'][$importLang][1] . '.php';
        $langFile = $this->tempLangDir . '/' . $filename;

        $aModuleLang = array();
        if (is_file($langFile)) {
            include($langFile);
            if ($moduleName == 'default') {
                $aModuleLang = $defaultWords;
            } else {
                $aModuleLang = $words;
            }
        }
        return $aModuleLang;
    }
    
    
    function _getAllComponents() 
    {
        
        $aComponents = array();
        if (!is_dir($this->componentDir)) {
             return $aComponents; 
        }

        require_once 'File/Util.php';

        //  match all folders except CVS
        $aComponents = SGL_Util::listDir($this->componentDir, FILE_LIST_DIRS, FILE_SORT_NAME,
            create_function('$a', 'return preg_match("/[^CVS]/", $a);'));
        
        foreach ($aComponents as $key=>$componentName) {
          if (!is_file($this->componentDir . '/' . $componentName . '/language/' . $this->masterLangFile)) {
                 unset($aComponents[$key]);
          }
        }
        return $aComponents;
    }
    
    function _loadComponentLang($componentName = '', $langId = '', $allkey = '1')
    {
        
        $masterLangFile = $this->componentDir . '/' . $componentName . '/language/' . $this->masterLangFile;
        $targetLangFile = $this->componentDir . '/' . $componentName . '/language/' . $GLOBALS['_SGL']['LANGUAGE'][$langId][1] . '.php';
        
        include_once($masterLangFile);
        $aMasterLang = $aLang;
        
        $aTargetLang = array();
        
        if (!is_file($targetLangFile)) {
            return $aMasterLang;
        } else {
            include_once($targetLangFile);
            if (count($aLang)) {
                $aTargetLang = $aLang;
                if (!$allkey) {
                    foreach ($aMasterLang as $key=>$val) {
                        if (!array_key_exists($key, $aTargetLang)) {
                            $aTargetLang[$key] =  $aMasterLang[$key];
                        }
                        if ($aTargetLang[$key] !=  $aMasterLang[$key]) {
                            unset($aTargetLang[$key]);
                        }
                    }
                }
            } else {
                return $aMasterLang;
            }
        }
        
        return $aTargetLang;
        
    }
    
    function _loadImportComponentLang($componentName = '', $importLang = '') 
    {
        $filename = 'components_' . $componentName . '_' . $GLOBALS['_SGL']['LANGUAGE'][$importLang][1] . '.php';
        $langFile = $this->tempLangDir . '/' . $filename;
        
        $aImportComponentLang = array();
        if (is_file($langFile)) {
            include_once($langFile);
             $aImportComponentLang = $aLang;
        }
        return $aImportComponentLang;
        
    }
    
    function _mergeComponentLang($aComponentLangCurrent, $aComponentLangImport)
    {
        if (count($aComponentLangImport)) {
            foreach ($aComponentLangCurrent as $key=>$val) {
                if (array_key_exists($key, $aComponentLangImport)) {
                    if ($aComponentLangImport[$key] !=  $aComponentLangCurrent[$key]) {
                        $aComponentLangCurrent[$key] = $aComponentLangImport[$key];
                    }
                }
            }                
        }
        
        return $aComponentLangCurrent;
    }
    
    function _updateComponentLang($componentName, $importLang, $aComponentLang)
    {
        $langFile = $this->componentDir . '/' . $componentName . '/language/' . $GLOBALS['_SGL']['LANGUAGE'][$importLang][1] . '.php';
        $arrayName = 'aLang';
        $this->_writeLangFile($aComponentLang, $langFile, $arrayName);
    }
    
    
    function _buildComponentLang($componentName = '', $langId = '', $aComponentLang = array())
    {
        $filename = 'components_' . $componentName . '_' . $GLOBALS['_SGL']['LANGUAGE'][$langId][1] . '.php';
        $langFile = $this->tempLangDir . '/' . $filename;
        
        $arrayName = 'aLang';
        $this->_writeLangFile($aComponentLang, $langFile, $arrayName);
    }        
    
    function _loadWysiwygLang($langId = '', $allkey = '1')
    {
        
        $masterId = 'en-us';
        
        $aMasterLang = array();
        $aTargetLang = array();
        
        $wyswygLangPath = $this->wysiwygDir . '/lang/' . $masterId . '/wysiwygpro';
        $wyswygLangTargetPath = $this->wysiwygDir . '/lang/' . $GLOBALS['_SGL']['LANGUAGE'][$langId][1] . '/wysiwygpro';
        
        define('IN_WPRO', TRUE);       
        $aMasterTempLang = array(); 
        if (is_file($wyswygLangPath . '/lang.inc.php')) {
             include_once($wyswygLangPath . '/lang.inc.php');
             $aMasterTempLang = $lang;
        }
        
        $aIncludeFile = array(
            'wproCore_bookmark.inc.php',
            'wproCore_codeCleanup.inc.php',
            'wproCore_colorPicker.inc.php',
            'wproCore_emoticons.inc.php',
            'wproCore_fileBrowser.inc.php',
            'wproCore_find.inc.php',
            'wproCore_list.inc.php',
            'wproCore_snippets.inc.php',
            'wproCore_specialCharacters.inc.php',
            'wproCore_spellchecker.inc.php',
            'wproCore_table.inc.php',
            'wproCore_tagEditor.inc.php');
            
        for ($i = 0; $i < count($aIncludeFile); $i++) {
            if (is_file($wyswygLangPath . '/includes/' . $aIncludeFile[$i])) {
                 include_once($wyswygLangPath . '/includes/' . $aIncludeFile[$i]);
                 $aMasterTempLang = array_merge($aMasterTempLang, $lang);
            }
                        
        }
        
        $aMasterLang = $aMasterTempLang;
        
        if (!is_dir($wyswygLangTargetPath)) {
            return $aMasterLang;
        }
        
        $aTargetTempLang = array();
        
        if (is_file($wyswygLangTargetPath . '/lang.inc.php')) {
             include_once($wyswygLangTargetPath . '/lang.inc.php');
             $aTargetTempLang = $lang;
        }
            
        for ($i = 0; $i < count($aIncludeFile); $i++) {
            if (is_file($wyswygLangTargetPath . '/includes/' . $aIncludeFile[$i])) {
                 include_once($wyswygLangTargetPath . '/includes/' . $aIncludeFile[$i]);
                 $aTargetTempLang = array_merge($aTargetTempLang, $lang);
            }
        }
        
        $aTargetLang = $aTargetTempLang;
        
        if (count($aTargetLang)) {
            if (!$allkey) {
                foreach ($aMasterLang as $key=>$val) {
                    foreach ($val as $key2=>$val2) {
                        if (!array_key_exists($key2, $aTargetLang[$key])) {
                            $aTargetLang[$key][$key2] =  $aMasterLang[$key][$key2];
                        }
                        if ($aTargetLang[$key][$key2]  !=  $aMasterLang[$key][$key2] ) {
                            unset($aTargetLang[$key][$key2] );
                        }
                    }
                }
            }
        } else {
            return $aMasterLang;
        }
        return $aTargetLang;
    }
    
    function _mergeWysiwygLang($aWysiwygLangCurrent, $aWysiwygLangImport)
    {

        if (count($aWysiwygLangCurrent)) {
            foreach ($aWysiwygLangCurrent as $key=>$val) {
                        foreach ($val as $key2=>$val2) {
                            if (array_key_exists($key2, $aWysiwygLangImport[$key])) {
                                if ($aWysiwygLangImport[$key][$key2]  !=  $aWysiwygLangCurrent[$key][$key2]) {
                                    $aWysiwygLangCurrent[$key][$key2] = $aWysiwygLangImport[$key][$key2];
                                }
                            }
                    }
            }
        }                            
        return $aWysiwygLangCurrent;
    }
    
    function _buildWysiwygLang($langId, $aLang) 
    {

        /*
         * Ignore transtation
         */
        unset($aLang['conf']['code']);
        unset($aLang['conf']['charset']);
        unset($aLang['conf']['dir']);
        unset($aLang['conf']['thousandsSeparator']);
        unset($aLang['conf']['decimalSeparator']);
        unset($aLang['conf']['dateFormat']);
        
        $aIncTemp['conf'] = $aLang['conf'];
        $aIncTemp['core'] = $aLang['core'];
        $aIncTemp['editor'] = $aLang['editor'];
        
        unset($aLang['conf']);
        unset($aLang['core']);
        unset($aLang['editor']);
        
        $arrayName = 'lang';
        
        $filename = 'wysiwyg_' . 'lang.inc' . '_' . $GLOBALS['_SGL']['LANGUAGE'][$langId][1] . '.php';
        $langFile = $this->tempLangDir . '/' . $filename;
        $this->_writeLangFile($aIncTemp, $langFile, $arrayName);
        
        $aTempLang = array();
        $aTempLang['wproCore_fileBrowser'] = $aLang['wproCore_fileBrowser'];
        $aTempLang['files'] = $aLang['files'];
        
        unset($aLang['wproCore_fileBrowser']);
        unset($aLang['files']);
        
        $filename = 'wysiwyg_' . 'wproCore_fileBrowser.inc' . '_' . $GLOBALS['_SGL']['LANGUAGE'][$langId][1] . '.php';
        $langFile = $this->tempLangDir . '/' . $filename;
        $this->_writeLangFile($aTempLang, $langFile, $arrayName);

        foreach ($aLang as $langfilename => $val ) {
            
            $aTempLang = array();
            
            $aTempLang[$langfilename] = $aLang[$langfilename];
            
            $filename = 'wysiwyg_' . $langfilename . '.inc_' . $GLOBALS['_SGL']['LANGUAGE'][$langId][1] . '.php';
            $langFile = $this->tempLangDir . '/' . $filename;
            $this->_writeLangFile($aTempLang, $langFile, $arrayName);
        }
    }

    
    function _loadWysiwygImportLang($langId = '')
    {
        
        $aWysiwygImportLang = array();
        $aIncludeFile = array(
            'lang.inc',
            'wproCore_bookmark.inc',
            'wproCore_codeCleanup.inc',
            'wproCore_colorPicker.inc',
            'wproCore_emoticons.inc',
            'wproCore_fileBrowser.inc',
            'wproCore_find.inc',
            'wproCore_list.inc',
            'wproCore_snippets.inc',
            'wproCore_specialCharacters.inc',
            'wproCore_spellchecker.inc',
            'wproCore_table.inc',
            'wproCore_tagEditor.inc');
            
        for ($i = 0; $i < count($aIncludeFile); $i++) {
            $filename = 'wysiwyg_' . $aIncludeFile[$i] . '_' . $GLOBALS['_SGL']['LANGUAGE'][$langId][1] . '.php';
            
            if (is_file($this->tempLangDir . '/' . $filename)) {
                 include_once($this->tempLangDir . '/' . $filename);
                 $aWysiwygImportLang = array_merge($aWysiwygImportLang, $lang);
            }
                        
        }
        return $aWysiwygImportLang;
    }
    
    function _updateWysiwygLang($aLang, $langId) 
    {

        $arrayName = 'lang';

        /*
         * Update lang.inc.php
         */
        $aIncTemp['conf'] = $aLang['conf'];
        $aIncTemp['core'] = $aLang['core'];
        $aIncTemp['editor'] = $aLang['editor'];
        
        unset($aLang['conf']);
        unset($aLang['core']);
        unset($aLang['editor']);
        
        $wyswygLangPath = $this->wysiwygDir . '/lang/' . $GLOBALS['_SGL']['LANGUAGE'][$langId][1] . '/wysiwygpro';
        
        $this->_writeLangFile($aIncTemp, $wyswygLangPath . '/lang.inc.php', $arrayName);
        
        /*
         * Update wproCore_fileBrowser.php
         */
        $aTempLang = array();
        $aTempLang['wproCore_fileBrowser'] = $aLang['wproCore_fileBrowser'];
        $aTempLang['files'] = $aLang['files'];
        
        unset($aLang['wproCore_fileBrowser']);
        unset($aLang['files']);
        
        $langFile = $wyswygLangPath . '/includes/' . 'wproCore_fileBrowser' . '.inc.php';
        $this->_writeLangFile($aTempLang, $langFile, $arrayName);

        foreach ($aLang as $langfilename => $val ) {
            $langFile = $wyswygLangPath . '/includes/' . $langfilename . '.inc.php';
            $aTempLang = array();
            $aTempLang[$langfilename] = $aLang[$langfilename];
            $this->_writeLangFile($aTempLang, $langFile, $arrayName);
        }
    }

    
    function _writeLangFile($aTrans, $filename, $arrayName)
    {

            //  read translation data and get reference to root
            $c = new Config();

            $aTransStrip = SGL_Translation2::escapeSingleQuoteInArrayKeys($aTrans);
            $root = & $c->parseConfig($aTransStrip, 'phparray');
            
            $result = $c->writeConfig($filename, 'phparray', array('name' => $arrayName));
            if (is_a($result, 'PEAR_Error')) {
                print_r($result);
            }
    }

    function unlinkFiles($dest)
    {   
        if ( is_file($dest) ) {
            unlink($dest);
        } elseif ( is_dir($dest) ) {
            $folder = opendir($dest);
            while ( $file = readdir($folder) ) {
                if ( $file == '.' || $file == '..' ) {
                    continue;
                }
                if ( is_dir($dest . '/' . $file) ) {
                   $this->unlinkFiles($dest . '/' . $file);
                   rmdir($dest . '/' . $file);
                } elseif ( is_link($dest . '/' . $file) ) {
                    unlink($dest . '/' . $file);
                } else {
                    unlink($dest . '/' . $file);
                } 
            }
            closedir($folder);
        }
        return 1;
    }
    
    function _cmd_redirectToTranslationView(&$input, &$output)
    {
        //  if no errors have occured, redirect
        if (!SGL_Error::count()) {
            $aParams = array(
                'managerName' => 'translation',
                
            );
            SGL_HTTP::redirect($aParams);

        //  else display error with blank template
        } else {
            $output->template = 'docBlank.html';
        }
    }

}
?>